/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.startup.TldConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.tomee.loader.EmbeddedJarScanner;

public class TomEEJarScanner
extends StandardJarScanner {
    private static final Log log = LogFactory.getLog(StandardJarScanner.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
    private static final Method tldConfigScanStream;
    private static final Field tldConfig;
    private static final Method tldLocationScanStream;
    private static final Field tldLocationCache;
    private static final Set<URL> SERVER_URLS;
    private static final Set<String> TAG_LIB_URIS;
    private static final ArrayList<String> LISTENERS;
    private static final Hashtable<String, Object> MAPPINGS;
    private static final Thread SERVER_SCANNING_THREAD;

    public void scan(ServletContext context, ClassLoader classLoader, JarScannerCallback callback, Set<String> jarsToIgnore) {
        if ("FragmentJarScannerCallback".equals(callback.getClass().getSimpleName())) {
            EmbeddedJarScanner embeddedJarScanner = new EmbeddedJarScanner();
            embeddedJarScanner.scan(context, classLoader, callback, jarsToIgnore);
        } else if ("TldJarScannerCallback".equals(callback.getClass().getSimpleName())) {
            String cbName = callback.getClass().getName();
            if (cbName.equals(tldConfig.getDeclaringClass().getName())) {
                this.ensureServerTldsScanned();
                try {
                    TldConfig config;
                    try {
                        config = (TldConfig)tldConfig.get(callback);
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBException("scan with default algo");
                    }
                    Set urls = TldScanner.scan((ClassLoader)(classLoader != null ? classLoader : context.getClassLoader()));
                    for (URL url : urls) {
                        if (SERVER_URLS.contains(url)) continue;
                        TomEEJarScanner.tldConfig(config, url);
                    }
                    for (String uri : TAG_LIB_URIS) {
                        config.addTaglibUri(uri);
                    }
                    for (String listener : LISTENERS) {
                        if ("org.apache.myfaces.webapp.StartupServletContextListener".equals(listener)) continue;
                        config.addApplicationListener(listener);
                    }
                }
                catch (OpenEJBException oe) {
                    log.error((Object)oe.getMessage(), (Throwable)oe);
                }
            } else if (cbName.equals(tldLocationCache.getDeclaringClass().getName())) {
                this.ensureServerTldsScanned();
                try {
                    Object tldLocationsCache;
                    try {
                        tldLocationsCache = tldLocationCache.get(callback);
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBException("scan with default algo");
                    }
                    Set urls = TldScanner.scan((ClassLoader)context.getClassLoader());
                    for (URL url : urls) {
                        if (SERVER_URLS.contains(url)) continue;
                        TomEEJarScanner.tldLocationCache(tldLocationsCache, url);
                    }
                    Hashtable mappings = (Hashtable)Reflections.get((Object)tldLocationsCache, (String)"mappings");
                    mappings.putAll((Map)MAPPINGS.clone());
                }
                catch (OpenEJBException oe) {
                    log.error((Object)oe.getMessage(), (Throwable)oe);
                }
            } else {
                log.debug((Object)("This callback " + callback + " is not known and perf optim will not be available"));
            }
        } else {
            log.info((Object)("Not expected scanner: " + callback));
            super.scan(context, classLoader, callback, jarsToIgnore);
        }
    }

    private void ensureServerTldsScanned() {
        if (SERVER_SCANNING_THREAD == null) {
            return;
        }
        try {
            SERVER_SCANNING_THREAD.join();
        }
        catch (InterruptedException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tldLocationCache(Object tldLocationsCache, URL url) {
        String resource = url.toString();
        String entry = null;
        if (resource.contains("!/")) {
            String path = url.getPath();
            int endIndex = path.indexOf("!/");
            resource = path.substring(0, endIndex);
            entry = path.substring(endIndex + 2, path.length());
        }
        InputStream is = null;
        try {
            is = url.openStream();
            tldLocationScanStream.invoke(tldLocationsCache, resource, entry, is);
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url.toExternalForm()}), (Throwable)e);
        }
        finally {
            IO.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tldConfig(TldConfig config, URL current) {
        InputStream is = null;
        try {
            is = current.openStream();
            XmlErrorHandler handler = (XmlErrorHandler)tldConfigScanStream.invoke((Object)config, is);
            handler.logFindings(log, current.toExternalForm());
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{current}), (Throwable)e);
        }
        finally {
            IO.close((Closeable)is);
        }
    }

    static {
        try {
            ClassLoader loader = TomEEJarScanner.class.getClassLoader();
            tldConfigScanStream = TldConfig.class.getDeclaredMethod("tldScanStream", InputStream.class);
            tldConfigScanStream.setAccessible(true);
            tldConfig = loader.loadClass("org.apache.catalina.startup.TldConfig$TldJarScannerCallback").getDeclaredFields()[0];
            tldConfig.setAccessible(true);
            Class<?> tldLocationsCache = loader.loadClass("org.apache.jasper.compiler.TldLocationsCache");
            tldLocationScanStream = tldLocationsCache.getDeclaredMethod("tldScanStream", String.class, String.class, InputStream.class);
            tldLocationScanStream.setAccessible(true);
            tldLocationCache = loader.loadClass("org.apache.jasper.compiler.TldLocationsCache$TldJarScannerCallback").getDeclaredFields()[0];
            tldLocationCache.setAccessible(true);
            SERVER_URLS = TldScanner.scan((ClassLoader)TomEEJarScanner.class.getClassLoader());
            Context fakeWebApp = (Context)Proxy.newProxyInstance(loader, new Class[]{Context.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("getTldNamespaceAware".equals(method.getName())) {
                        return Globals.STRICT_SERVLET_COMPLIANCE;
                    }
                    if ("getTldValidation".equals(method.getName())) {
                        return Globals.STRICT_SERVLET_COMPLIANCE;
                    }
                    if ("getXmlValidation".equals(method.getName())) {
                        return Globals.STRICT_SERVLET_COMPLIANCE;
                    }
                    if ("getXmlBlockExternal".equals(method.getName())) {
                        return Globals.IS_SECURITY_ENABLED;
                    }
                    return null;
                }
            });
            final TldConfig config = new TldConfig();
            config.lifecycleEvent(new LifecycleEvent((Lifecycle)fakeWebApp, "after_init", null));
            Object fakeSc = Proxy.newProxyInstance(loader, new Class[]{ServletContext.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            });
            final Object locationsCacheInstance = tldLocationsCache.getConstructor(ServletContext.class).newInstance(fakeSc);
            if (!SERVER_URLS.isEmpty()) {
                SERVER_SCANNING_THREAD = new Thread(){

                    @Override
                    public void run() {
                        for (URL current : SERVER_URLS) {
                            TomEEJarScanner.tldConfig(config, current);
                            TomEEJarScanner.tldLocationCache(locationsCacheInstance, current);
                        }
                    }
                };
                SERVER_SCANNING_THREAD.setName("TomEE-server-tld-reading");
                SERVER_SCANNING_THREAD.setDaemon(true);
                SERVER_SCANNING_THREAD.start();
            } else {
                SERVER_SCANNING_THREAD = null;
            }
            TAG_LIB_URIS = (Set)Reflections.get((Object)config, (String)"taglibUris");
            LISTENERS = (ArrayList)Reflections.get((Object)config, (String)"listeners");
            MAPPINGS = (Hashtable)Reflections.get(locationsCacheInstance, (String)"mappings");
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }
}

