/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.rest;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;

public class RsServlet
extends HttpServlet {
    private HttpListener listener;
    private ServletConfig servletConfig;

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        String listenerId = config.getInitParameter(HttpListener.class.getName());
        if (listenerId != null) {
            this.listener = (HttpListener)config.getServletContext().getAttribute(listenerId);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.listener == null) {
            throw new ServletException("RESTServiceContainer has not been set");
        }
        ServletRequestAdapter httpRequest = new ServletRequestAdapter(req, res, this.servletConfig.getServletContext());
        ServletResponseAdapter httpResponse = new ServletResponseAdapter(res);
        try {
            this.listener.onMessage((HttpRequest)httpRequest, (HttpResponse)httpResponse);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Error processing webservice request", (Throwable)e);
        }
    }
}

