/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.security;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.openejb.core.security.jaas.GroupPrincipal;
import org.apache.openejb.core.security.jaas.UserPrincipal;

public class TestLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String user;
    private Set principals = new HashSet();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new LoginException("Failed to perform emulated login: " + e.getMessage());
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.user));
        this.principals.add(new GroupPrincipal(this.user));
        this.subject.getPrincipals().addAll(this.principals);
        this.user = null;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.user = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

