/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class LocalClientRunner
extends BlockJUnit4ClassRunner {
    private final BeanContext deployment;
    private final Class<?> clazz;

    public LocalClientRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.deployment = this.createDeployment(clazz);
        this.clazz = clazz;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object instance = this.newTestInstance();
        Test test = new Test(this.clazz, method.getMethod(), instance, this.deployment);
        Statement statement = this.methodInvoker(method, instance);
        statement = this.wrap(test, statement, RunAs.class, javax.annotation.security.RunAs.class);
        statement = this.wrap(test, statement, RunTestAs.class, org.apache.openejb.junit.RunTestAs.class);
        statement = this.wrap(test, statement, Transaction.class, org.apache.openejb.junit.Transaction.class);
        statement = this.wrap(test, statement, TransactionAttribute.class, javax.ejb.TransactionAttribute.class);
        statement = this.possiblyExpectingExceptions(method, instance, statement);
        statement = this.withPotentialTimeout(method, instance, statement);
        statement = this.withBefores(method, instance, statement);
        statement = this.withAfters(method, instance, statement);
        return statement;
    }

    private Statement wrap(Test test, Statement statement, Class<? extends AnnotationStatement> clazz, Class<? extends Annotation> annotation) {
        if (test.has(annotation)) {
            try {
                Class[] types = new Class[]{annotation, Statement.class, Test.class};
                Object[] args = new Object[]{test.get(annotation), statement, test};
                return clazz.getConstructor(types).newInstance(args);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot construct " + clazz, e);
            }
        }
        return statement;
    }

    private Object newTestInstance() {
        try {
            return new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return LocalClientRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
    }

    private BeanContext createDeployment(Class<?> testClass) {
        try {
            return new BeanContext(null, (Context)new IvmContext(), new ModuleContext("", null, "", new AppContext("", SystemInstance.get(), testClass.getClassLoader(), (Context)new IvmContext(), (Context)new IvmContext(), false), (Context)new IvmContext(), null), testClass, null, null, null, null, null, null, null, null, null, BeanType.MANAGED, false);
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Interceptorss
    extends AnnotationStatement<Interceptors> {
        public Interceptorss(Interceptors annotation, Statement next, Test test) {
            super(annotation, next, test);
        }

        public void evaluate() throws Throwable {
        }
    }

    public static class Transaction
    extends AnnotationStatement<org.apache.openejb.junit.Transaction> {
        public Transaction(org.apache.openejb.junit.Transaction annotation, Statement next, Test test) {
            super(annotation, next, test);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
            JtaTransactionPolicyFactory factory = new JtaTransactionPolicyFactory(transactionManager);
            TransactionPolicy policy = factory.createTransactionPolicy(TransactionType.RequiresNew);
            try {
                this.next.evaluate();
            }
            finally {
                if (((org.apache.openejb.junit.Transaction)this.annotation).rollback()) {
                    policy.setRollbackOnly();
                }
                policy.commit();
            }
        }
    }

    public static class TransactionAttribute
    extends AnnotationStatement<javax.ejb.TransactionAttribute> {
        public TransactionAttribute(javax.ejb.TransactionAttribute annotation, Statement next, Test test) {
            super(annotation, next, test);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
            JtaTransactionPolicyFactory factory = new JtaTransactionPolicyFactory(transactionManager);
            TransactionType transactionType = TransactionType.get((TransactionAttributeType)((javax.ejb.TransactionAttribute)this.annotation).value());
            TransactionPolicy policy = factory.createTransactionPolicy(transactionType);
            try {
                this.next.evaluate();
            }
            catch (Throwable t) {
                if (!this.isApplicationException(t)) {
                    policy.setRollbackOnly();
                }
            }
            finally {
                policy.commit();
            }
        }

        private boolean isApplicationException(Throwable t) {
            if (t.getClass().isAnnotationPresent(ApplicationException.class)) {
                return true;
            }
            if (t instanceof Error) {
                return false;
            }
            return !(t instanceof RuntimeException);
        }
    }

    public static class RunTestAs
    extends AnnotationStatement<org.apache.openejb.junit.RunTestAs> {
        public RunTestAs(org.apache.openejb.junit.RunTestAs annotation, Statement next, Test test) {
            super(annotation, next, test);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            this.info.setRunAs(((org.apache.openejb.junit.RunTestAs)this.annotation).value());
            ThreadContext context = new ThreadContext(this.info, null);
            ThreadContext old = ThreadContext.enter((ThreadContext)context);
            try {
                this.next.evaluate();
            }
            finally {
                ThreadContext.exit((ThreadContext)old);
            }
        }
    }

    public static class RunAs
    extends AnnotationStatement<javax.annotation.security.RunAs> {
        public RunAs(javax.annotation.security.RunAs annotation, Statement next, Test test) {
            super(annotation, next, test);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            this.info.setRunAs(((javax.annotation.security.RunAs)this.annotation).value());
            ThreadContext context = new ThreadContext(this.info, null);
            ThreadContext old = ThreadContext.enter((ThreadContext)context);
            try {
                this.next.evaluate();
            }
            finally {
                ThreadContext.exit((ThreadContext)old);
            }
        }
    }

    private static final class Test {
        public final Class clazz;
        public final Method method;
        public final Object instance;
        public final BeanContext info;

        private Test(Class clazz, Method method, Object instance, BeanContext info) {
            this.clazz = clazz;
            this.method = method;
            this.instance = instance;
            this.info = info;
        }

        private <A extends Annotation> boolean has(Class<A> a) {
            return this.method.isAnnotationPresent(a) || this.clazz.isAnnotationPresent(a);
        }

        private <A extends Annotation> A get(Class<A> annotationClass) {
            A annotation = this.method.getAnnotation(annotationClass);
            if (annotation == null) {
                annotation = this.clazz.getAnnotation(annotationClass);
            }
            return annotation;
        }
    }

    public static abstract class AnnotationStatement<A extends Annotation>
    extends Statement {
        protected final A annotation;
        protected final Statement next;
        protected final Test test;
        protected final BeanContext info;

        protected AnnotationStatement(A annotation, Statement next, Test test) {
            this.annotation = annotation;
            this.next = next;
            this.test = test;
            this.info = test.info;
        }
    }
}

