/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.netbeans.nbm.CreateNetBeansFileStructure;
import org.apache.netbeans.nbm.CreateUpdateSiteMojo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.netbeans.nbbuild.MakeNBM;

@Mojo(name="nbm", requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class CreateNbmMojo
extends CreateNetBeansFileStructure
implements Contextualizable {
    @Parameter(property="keystore")
    private String keystore;
    @Parameter(property="keystorepass")
    private String keystorepassword;
    @Parameter(property="keystorealias")
    private String keystorealias;
    @Parameter(defaultValue="false", property="maven.nbm.skip")
    private boolean skipNbm;
    @Parameter(defaultValue="false")
    private boolean requiresRestart;
    @Parameter(defaultValue="${project.url}")
    private String homePageUrl;
    @Parameter(defaultValue="${project.organization.name}")
    private String author;
    @Parameter(property="maven.nbm.distributionURL")
    private String distributionUrl;
    @Parameter
    private String licenseName;
    @Parameter
    private File licenseFile;
    private PlexusContainer container;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private MavenProjectHelper projectHelper;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        MakeNBM.Blurb lb;
        if (this.skipNbm) {
            this.getLog().info((CharSequence)"Skipping generation of NBM file.");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping " + this.project.getId() + ", no nbm:nbm execution for 'pom' packaging"));
            return;
        }
        super.execute();
        File nbmFile = new File(this.nbmBuildDir, this.finalName + ".nbm");
        MakeNBM nbmTask = (MakeNBM)this.antProject.createTask("makenbm");
        nbmTask.setFile(nbmFile);
        nbmTask.setProductDir(this.clusterDir);
        nbmTask.setModule("modules" + File.separator + this.moduleJarName + ".jar");
        boolean reqRestart = this.requiresRestart;
        if (!reqRestart && this.module.isRequiresRestart()) {
            reqRestart = this.module.isRequiresRestart();
            this.getLog().warn((CharSequence)"Module descriptor's requiresRestart field is deprecated, use plugin's configuration in pom.xml");
        }
        nbmTask.setNeedsrestart(Boolean.toString(reqRestart));
        String moduleAuthor = this.author;
        if (this.module.getAuthor() != null) {
            moduleAuthor = this.module.getAuthor();
            this.getLog().warn((CharSequence)"Module descriptor's requiresRestart field is deprecated, use plugin's configuration in pom.xml");
        }
        nbmTask.setModuleauthor(moduleAuthor);
        if (this.keystore != null && this.keystorealias != null && this.keystorepassword != null) {
            File ks = new File(this.keystore);
            if (!ks.exists()) {
                this.getLog().warn((CharSequence)("Cannot find keystore file at " + ks.getAbsolutePath()));
            } else {
                MakeNBM.Signature sig = nbmTask.createSignature();
                sig.setKeystore(ks);
                sig.setAlias(this.keystorealias);
                sig.setStorepass(this.keystorepassword);
                this.getLog().debug((CharSequence)"Setup the Ant task to sign the NBM file.");
            }
        } else if (this.keystore != null || this.keystorepassword != null || this.keystorealias != null) {
            this.getLog().warn((CharSequence)"If you want to sign the nbm file, you need to define all three keystore related parameters.");
        }
        String licName = this.licenseName;
        File licFile = this.licenseFile;
        if (this.module.getLicenseName() != null) {
            licName = this.module.getLicenseName();
            this.getLog().warn((CharSequence)"Module descriptor's licenseName field is deprecated, use plugin's configuration in pom.xml");
        }
        if (this.module.getLicenseFile() != null) {
            File lf;
            licFile = lf = new File(this.project.getBasedir(), this.module.getLicenseFile());
            this.getLog().warn((CharSequence)"Module descriptor's licenseFile field is deprecated, use plugin's configuration in pom.xml");
        }
        if (licName != null && licFile != null) {
            if (!licFile.exists() || !licFile.isFile()) {
                this.getLog().warn((CharSequence)("Cannot find license file at " + licFile.getAbsolutePath()));
            } else {
                lb = nbmTask.createLicense();
                lb.setFile(licFile);
                lb.addText(licName);
            }
        } else if (licName != null || licFile != null) {
            this.getLog().warn((CharSequence)"To set license for the nbm, you need to specify both licenseName and licenseFile parameters.");
        } else {
            lb = nbmTask.createLicense();
            lb.addText(this.createDefaultLicenseHeader());
            lb.addText(this.createDefaultLicenseText());
        }
        String hpUrl = this.homePageUrl;
        if (this.module.getHomepageUrl() != null) {
            this.getLog().warn((CharSequence)"Module descriptor's homePageUrl field is deprecated, use plugin's configuration in pom.xml");
            hpUrl = this.module.getHomepageUrl();
        }
        if (hpUrl != null) {
            nbmTask.setHomepage(hpUrl);
        }
        String distribUrl = this.distributionUrl;
        if (this.module.getDistributionUrl() != null) {
            distribUrl = this.module.getDistributionUrl();
            this.getLog().warn((CharSequence)"Module descriptor's distributionUrl field is deprecated, use plugin's configuration in pom.xml");
        }
        if (distribUrl != null) {
            ArtifactRepository distRepository = CreateUpdateSiteMojo.getDeploymentRepository(distribUrl, this.container, this.getLog());
            String dist = null;
            if (distRepository == null) {
                if (!distribUrl.contains("::")) {
                    dist = distribUrl + (distribUrl.endsWith("/") ? "" : "/") + nbmFile.getName();
                }
            } else {
                Artifact art = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "nbm-file");
                dist = distRepository.getUrl() + (distRepository.getUrl().endsWith("/") ? "" : "/") + distRepository.pathOf(art);
            }
            nbmTask.setDistribution(dist);
        } else {
            nbmTask.setDistribution(nbmFile.getName());
        }
        if (!"extra".equals(this.cluster)) {
            nbmTask.setTargetcluster(this.cluster);
        }
        nbmTask.setReleasedate(DATE_FORMAT.format(new Date(System.currentTimeMillis())));
        try {
            nbmTask.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException("Cannot Generate nbm file:" + e.getMessage(), (Exception)((Object)e));
        }
        try {
            File nbmfile = new File(this.buildDir, nbmFile.getName());
            FileUtils.getFileUtils().copyFile(nbmFile, nbmfile);
            this.projectHelper.attachArtifact(this.project, "nbm-file", null, nbmfile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot copy nbm to build directory", (Exception)ex);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private String createDefaultLicenseHeader() {
        String year;
        List devs;
        String organization = "";
        Organization org = this.project.getOrganization();
        if (org != null) {
            organization = org.getName();
        }
        if (organization == null && (devs = this.project.getDevelopers()).size() > 0) {
            Iterator dvs = devs.iterator();
            String devsString = "";
            while (dvs.hasNext()) {
                Developer d = (Developer)dvs.next();
                devsString = devsString + "," + d.getName() != null ? d.getName() : d.getId();
            }
            organization = devsString.substring(1);
        }
        if (organization == null) {
            organization = "";
        }
        String date = "";
        if (this.project.getInceptionYear() != null) {
            date = this.project.getInceptionYear();
        }
        if (!(year = Integer.toString(Calendar.getInstance().get(1))).equals(date)) {
            date = date.length() == 0 ? year : date + "-" + year;
        }
        return "Copyright " + organization + " " + date;
    }

    private String createDefaultLicenseText() {
        String toRet = "License terms:\n";
        List licenses = this.project.getLicenses();
        if (licenses != null && licenses.size() > 0) {
            Iterator lic = licenses.iterator();
            while (lic.hasNext()) {
                License ll = (License)lic.next();
                if (ll.getName() != null) {
                    toRet = toRet + ll.getName() + " - ";
                }
                if (ll.getUrl() != null) {
                    toRet = toRet + ll.getUrl();
                }
                if (!lic.hasNext()) continue;
                toRet = toRet + ",\n";
            }
        } else {
            toRet = toRet + "Unknown";
        }
        return toRet;
    }
}

