/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.netbeans.nbm.utils.ExamineManifest;

public class CollectModuleLibrariesNodeVisitor
implements DependencyNodeVisitor {
    private final Map<String, List<Artifact>> directNodes;
    private final Map<String, List<Artifact>> transitiveNodes;
    private Map<String, Artifact> artifacts;
    private Map<Artifact, ExamineManifest> examinerCache;
    private final Log log;
    private MojoExecutionException throwable;
    private DependencyNode root;
    private Stack<String> currentModule = new Stack();
    private static final String LIB_ID = "!@#$%^&ROOT";
    private final boolean useOSGiDependencies;

    public CollectModuleLibrariesNodeVisitor(List<Artifact> runtimeArtifacts, Map<Artifact, ExamineManifest> examinerCache, Log log, DependencyNode root, boolean useOSGiDependencies) {
        this.directNodes = new HashMap<String, List<Artifact>>();
        this.transitiveNodes = new HashMap<String, List<Artifact>>();
        this.artifacts = new HashMap<String, Artifact>();
        for (Artifact a : runtimeArtifacts) {
            this.artifacts.put(a.getDependencyConflictId(), a);
        }
        this.examinerCache = examinerCache;
        this.log = log;
        this.root = root;
        this.useOSGiDependencies = useOSGiDependencies;
    }

    public boolean visit(DependencyNode node) {
        if (this.throwable != null) {
            return false;
        }
        if (this.root == node) {
            return true;
        }
        try {
            Artifact artifact = node.getArtifact();
            if (!this.artifacts.containsKey(artifact.getDependencyConflictId())) {
                return false;
            }
            ExamineManifest depExaminator = this.examinerCache.get(artifact = this.artifacts.get(artifact.getDependencyConflictId()));
            if (depExaminator == null) {
                depExaminator = new ExamineManifest(this.log);
                depExaminator.setArtifactFile(artifact.getFile());
                depExaminator.checkFile();
                this.examinerCache.put(artifact, depExaminator);
            }
            if (depExaminator.isNetBeansModule() || this.useOSGiDependencies && depExaminator.isOsgiBundle()) {
                this.currentModule.push(artifact.getDependencyConflictId());
                ArrayList<Artifact> arts = new ArrayList<Artifact>();
                arts.add(artifact);
                if (this.currentModule.size() == 1) {
                    this.directNodes.put(this.currentModule.peek(), arts);
                } else {
                    this.transitiveNodes.put(this.currentModule.peek(), arts);
                }
                return true;
            }
            if (this.currentModule.size() > 0) {
                if (!this.currentModule.peek().startsWith(LIB_ID) && AbstractNbmMojo.matchesLibrary(artifact, Collections.emptyList(), depExaminator, this.log, this.useOSGiDependencies)) {
                    if (this.currentModule.size() == 1) {
                        this.directNodes.get(this.currentModule.peek()).add(artifact);
                    } else {
                        this.transitiveNodes.get(this.currentModule.peek()).add(artifact);
                    }
                    return true;
                }
            } else {
                this.currentModule.push(LIB_ID + artifact.getDependencyConflictId());
            }
        }
        catch (MojoExecutionException mojoExecutionException) {
            this.throwable = mojoExecutionException;
        }
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        if (this.throwable != null) {
            return false;
        }
        if (!this.currentModule.empty() && (this.currentModule.peek().equals(node.getArtifact().getDependencyConflictId()) || this.currentModule.peek().equals(LIB_ID + node.getArtifact().getDependencyConflictId()))) {
            this.currentModule.pop();
        }
        return true;
    }

    public Map<String, List<Artifact>> getDeclaredArtifacts() throws MojoExecutionException {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.directNodes;
    }

    public Map<String, List<Artifact>> getTransitiveArtifacts() throws MojoExecutionException {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.transitiveNodes;
    }
}

