/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.netbeans.nbm.CollectLibrariesNodeVisitor;
import org.apache.netbeans.nbm.model.Dependency;
import org.apache.netbeans.nbm.model.NetBeansModule;
import org.apache.netbeans.nbm.model.io.xpp3.NetBeansModuleXpp3Reader;
import org.apache.netbeans.nbm.utils.AbstractNetbeansMojo;
import org.apache.netbeans.nbm.utils.ExamineManifest;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractNbmMojo
extends AbstractNetbeansMojo {
    static boolean matchesLibrary(Artifact artifact, List<String> libraries, ExamineManifest depExaminator, Log log, boolean useOsgiDependencies) {
        String artId = artifact.getArtifactId();
        String grId = artifact.getGroupId();
        String id = grId + ":" + artId;
        boolean explicit = libraries.remove(id);
        if (explicit) {
            log.debug((CharSequence)(id + " included as module library, explicitly declared in module descriptor."));
            return explicit;
        }
        if ("provided".equals(artifact.getScope()) || "system".equals(artifact.getScope())) {
            log.debug((CharSequence)(id + " omitted as module library, has scope 'provided/system'"));
            return false;
        }
        if ("nbm".equals(artifact.getType())) {
            return false;
        }
        if (depExaminator.isNetBeansModule() || useOsgiDependencies && depExaminator.isOsgiBundle()) {
            return false;
        }
        log.debug((CharSequence)(id + " included as module library, squeezed through all the filters."));
        return true;
    }

    static Dependency resolveNetBeansDependency(Artifact artifact, List<Dependency> deps, ExamineManifest manifest, Log log) {
        Dependency dep;
        String artId = artifact.getArtifactId();
        String grId = artifact.getGroupId();
        String id = grId + ":" + artId;
        for (Dependency dep2 : deps) {
            if (!id.equals(dep2.getId())) continue;
            if (manifest.isNetBeansModule()) {
                return dep2;
            }
            if (dep2.getExplicitValue() != null) {
                return dep2;
            }
            log.warn((CharSequence)(id + " declared as module dependency in descriptor, but not a NetBeans module"));
            return null;
        }
        if ("nbm".equals(artifact.getType())) {
            dep = new Dependency();
            dep.setId(id);
            dep.setType("spec");
            log.debug((CharSequence)("Adding nbm module dependency - " + id));
            return dep;
        }
        if (manifest.isNetBeansModule()) {
            dep = new Dependency();
            dep.setId(id);
            dep.setType("spec");
            log.debug((CharSequence)("Adding direct NetBeans module dependency - " + id));
            return dep;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final NetBeansModule readModuleDescriptor(File descriptor) throws MojoExecutionException {
        NetBeansModule netBeansModule;
        if (descriptor == null) {
            throw new MojoExecutionException("The module descriptor has to be configured.");
        }
        if (!descriptor.exists()) {
            throw new MojoExecutionException("The module descriptor is missing: '" + descriptor + "'.");
        }
        FileReader r = null;
        try {
            NetBeansModule module;
            r = new FileReader(descriptor);
            NetBeansModuleXpp3Reader reader = new NetBeansModuleXpp3Reader();
            netBeansModule = module = reader.read(r);
        }
        catch (IOException exc) {
            try {
                throw new MojoExecutionException("Error while reading module descriptor '" + descriptor + "'.", (Exception)exc);
                catch (XmlPullParserException xml) {
                    throw new MojoExecutionException("Error while reading module descriptor '" + descriptor + "'.", (Exception)((Object)xml));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return netBeansModule;
    }

    protected final NetBeansModule createDefaultDescriptor(MavenProject project, boolean log) {
        if (log) {
            this.getLog().info((CharSequence)"No Module Descriptor defined, trying to fallback to generated values:");
        }
        NetBeansModule module = new NetBeansModule();
        return module;
    }

    static List<Artifact> getLibraryArtifacts(DependencyNode treeRoot, NetBeansModule module, List<Artifact> runtimeArtifacts, Map<Artifact, ExamineManifest> examinerCache, Log log, boolean useOsgiDependencies) throws MojoExecutionException {
        ArrayList<Artifact> include = new ArrayList<Artifact>();
        if (module != null) {
            ArrayList<String> librList = new ArrayList<String>();
            if (module.getLibraries() != null) {
                librList.addAll(module.getLibraries());
            }
            CollectLibrariesNodeVisitor visitor = new CollectLibrariesNodeVisitor(librList, runtimeArtifacts, examinerCache, log, treeRoot, useOsgiDependencies);
            treeRoot.accept((DependencyNodeVisitor)visitor);
            include.addAll(visitor.getArtifacts());
        }
        return include;
    }

    static List<ModuleWrapper> getModuleDependencyArtifacts(DependencyNode treeRoot, NetBeansModule module, Dependency[] customDependencies, MavenProject project, Map<Artifact, ExamineManifest> examinerCache, List<Artifact> libraryArtifacts, Log log, boolean useOsgiDependencies) throws MojoExecutionException {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (customDependencies != null) {
            deps.addAll(Arrays.asList(customDependencies));
        }
        if (module != null && !module.getDependencies().isEmpty()) {
            log.warn((CharSequence)"dependencies in module descriptor are deprecated, use the plugin's parameter moduleDependencies");
            for (Dependency d : module.getDependencies()) {
                Dependency found = null;
                for (Dependency d2 : deps) {
                    if (!d2.getId().equals(d.getId())) continue;
                    found = d2;
                    break;
                }
                if (found != null) {
                    deps.remove(found);
                }
                deps.add(d);
            }
        }
        ArrayList<ModuleWrapper> include = new ArrayList<ModuleWrapper>();
        List artifacts = project.getCompileArtifacts();
        for (Artifact artifact : artifacts) {
            ModuleWrapper wr;
            Dependency dep;
            if (libraryArtifacts.contains(artifact)) continue;
            ExamineManifest depExaminator = examinerCache.get(artifact);
            if (depExaminator == null) {
                depExaminator = new ExamineManifest(log);
                depExaminator.setArtifactFile(artifact.getFile());
                depExaminator.checkFile();
                examinerCache.put(artifact, depExaminator);
            }
            if ((dep = AbstractNbmMojo.resolveNetBeansDependency(artifact, deps, depExaminator, log)) != null) {
                wr = new ModuleWrapper();
                wr.dependency = dep;
                wr.artifact = artifact;
                wr.transitive = false;
                if (depExaminator.isNetBeansModule() && artifact.getDependencyTrail().size() > 2) {
                    log.debug((CharSequence)(artifact.getId() + " omitted as NetBeans module dependency, not a direct one. Declare it in the pom for inclusion."));
                    wr.transitive = true;
                }
                include.add(wr);
                continue;
            }
            if (!useOsgiDependencies || !depExaminator.isOsgiBundle()) continue;
            wr = new ModuleWrapper();
            wr.osgi = true;
            String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
            for (Dependency depe : deps) {
                if (!id.equals(depe.getId())) continue;
                wr.dependency = depe;
            }
            boolean print = false;
            if (wr.dependency == null) {
                Dependency depe;
                depe = new Dependency();
                depe.setId(id);
                depe.setType("spec");
                wr.dependency = depe;
                print = true;
            }
            wr.artifact = artifact;
            wr.transitive = false;
            if (artifact.getDependencyTrail().size() > 2) {
                log.debug((CharSequence)(artifact.getId() + " omitted as NetBeans module OSGi dependency, not a direct one. Declare it in the pom for inclusion."));
                wr.transitive = true;
            } else if (print) {
                log.info((CharSequence)("Adding OSGi bundle dependency - " + id));
            }
            include.add(wr);
        }
        return include;
    }

    protected DependencyNode createDependencyTree(MavenProject project, DependencyGraphBuilder dependencyGraphBuilder, String scope) throws MojoExecutionException {
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter(scope);
        try {
            return dependencyGraphBuilder.buildDependencyGraph(project, artifactFilter);
        }
        catch (DependencyGraphBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)exception));
        }
    }

    private ArtifactFilter createResolvingArtifactFilter(String scope) {
        ScopeArtifactFilter filter;
        if (scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + scope + "'"));
            filter = new ScopeArtifactFilter(scope);
        } else {
            filter = null;
        }
        return filter;
    }

    protected final ArtifactResult turnJarToNbmFile(Artifact art, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, MavenProject project, ArtifactRepository localRepository) throws MojoExecutionException {
        if ("jar".equals(art.getType()) || "nbm".equals(art.getType())) {
            ExamineManifest mnf = new ExamineManifest(this.getLog());
            File jar = art.getFile();
            if (!jar.isFile()) {
                String path = localRepository.pathOf(art);
                File jar2 = new File(localRepository.getBasedir(), path.replace("/", File.separator));
                File manifest = new File(jar, "META-INF/MANIFEST.MF");
                if (!jar2.isFile() || !manifest.isFile()) {
                    this.getLog().warn((CharSequence)("MNBMODULE-131: need to at least run install phase on " + jar2));
                    return new ArtifactResult(null, null);
                }
                mnf.setManifestFile(manifest);
            } else {
                mnf.setJarFile(jar);
            }
            mnf.checkFile();
            if (mnf.isNetBeansModule()) {
                Artifact nbmArt;
                block10: {
                    nbmArt = artifactFactory.createDependencyArtifact(art.getGroupId(), art.getArtifactId(), art.getVersionRange(), "nbm-file", art.getClassifier(), art.getScope());
                    try {
                        artifactResolver.resolve(nbmArt, project.getRemoteArtifactRepositories(), localRepository);
                    }
                    catch (ArtifactResolutionException ex) {
                        this.checkReactor(art, nbmArt);
                        if (!nbmArt.isResolved()) {
                            throw new MojoExecutionException("Failed to retrieve the nbm file from repository", (Exception)((Object)ex));
                        }
                    }
                    catch (ArtifactNotFoundException ex) {
                        this.checkReactor(art, nbmArt);
                        if (nbmArt.isResolved()) break block10;
                        throw new MojoExecutionException("Failed to retrieve the nbm file from repository", (Exception)((Object)ex));
                    }
                }
                return new ArtifactResult(nbmArt, mnf);
            }
            if (mnf.isOsgiBundle()) {
                return new ArtifactResult(null, mnf);
            }
        }
        return new ArtifactResult(null, null);
    }

    private void checkReactor(Artifact art, Artifact nbmArt) {
        if (art.getFile().getName().endsWith(".jar")) {
            String name = art.getFile().getName();
            name = name.substring(0, name.length() - ".jar".length()) + ".nbm";
            File fl = new File(art.getFile().getParentFile(), name);
            if (fl.exists()) {
                nbmArt.setFile(fl);
                nbmArt.setResolved(true);
            }
        }
    }

    protected static final class ArtifactResult {
        private final Artifact converted;
        private final ExamineManifest manifest;

        ArtifactResult(Artifact conv, ExamineManifest manifest) {
            this.converted = conv;
            this.manifest = manifest;
        }

        boolean hasConvertedArtifact() {
            return this.converted != null;
        }

        Artifact getConvertedArtifact() {
            return this.converted;
        }

        public boolean isOSGiBundle() {
            return this.manifest != null && this.manifest.isOsgiBundle();
        }

        public ExamineManifest getExaminedManifest() {
            return this.manifest;
        }
    }

    static class ModuleWrapper {
        Dependency dependency;
        Artifact artifact;
        boolean transitive = true;
        boolean osgi = false;

        ModuleWrapper() {
        }
    }
}

