/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.RowKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowKeySetImpl
extends RowKeySet
implements Externalizable {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RowKeySetImpl.class);
    private boolean _default;
    private Set<Object> _set;
    private transient CollectionModel _model;
    private static final long serialVersionUID = 1L;

    public RowKeySetImpl() {
        this(false);
    }

    public RowKeySetImpl(boolean addAll) {
        this._default = addAll;
        this._set = Collections.emptySet();
        this._model = null;
    }

    @Override
    public boolean contains(Object rowKey) {
        return this._isSelected(rowKey);
    }

    @Override
    public boolean add(Object rowKey) {
        return this._setSelected(rowKey, true);
    }

    @Override
    public boolean remove(Object rowKey) {
        return this._setSelected(rowKey, false);
    }

    @Override
    public boolean invert(Object rowKey) {
        Set<Object> set = this._getSet(true);
        if (!set.add(rowKey)) {
            set.remove(rowKey);
            return this._default;
        }
        return !this._default;
    }

    @Override
    public void invertAll() {
        this._default = !this._default;
    }

    @Override
    public void addAll() {
        this._selectAll(true);
    }

    @Override
    public boolean isContainedByDefault() {
        return this._default;
    }

    @Override
    public void clear() {
        this._selectAll(false);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof RowKeySetImpl) {
            RowKeySetImpl other = (RowKeySetImpl)c;
            if (other._default) {
                return this._processAll(other, false);
            }
        }
        return super.removeAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        if (c instanceof RowKeySetImpl) {
            RowKeySetImpl other = (RowKeySetImpl)c;
            if (other._default) {
                return this._processAll(other, true);
            }
        }
        return super.addAll(c);
    }

    private boolean _processAll(RowKeySetImpl other, boolean addAll) {
        Set<Object> set = this._getSet(false);
        Set<Object> otherSet = other._getSet(false);
        if (this._default == addAll) {
            return set.retainAll(otherSet);
        }
        this._default = addAll;
        otherSet = this._clone(otherSet);
        otherSet.removeAll(set);
        this._set = otherSet;
        return true;
    }

    @Override
    public final void setCollectionModel(CollectionModel model) {
        this._model = model;
        if (model == null) {
            _LOG.fine("COLLECTIONMODEL_SET_NULL");
        }
    }

    @Override
    public int getSize() {
        return this._getSize(false);
    }

    @Override
    public int size() {
        return this._getSize(true);
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public Iterator<Object> iterator() {
        return this._default ? this._getNotInSetRowKeyIterator() : this._getInSetRowKeyIterator();
    }

    private int _getSize(boolean fetchAll) {
        int setSize = this._getSet(false).size();
        if (this._default) {
            CollectionModel model = this.getCollectionModel();
            int total = model.getRowCount();
            if (total < 0) {
                if (fetchAll) {
                    total = ModelUtils.getRowCount(model);
                } else {
                    return -1;
                }
            }
            return total - setSize;
        }
        return setSize;
    }

    private boolean _setSelected(Object rowKey, boolean isSelected) {
        if (isSelected == this._default) {
            if (!this._set.isEmpty()) {
                return this._set.remove(rowKey);
            }
            return false;
        }
        return this._getSet(true).add(rowKey);
    }

    private Iterator<Object> _getNotInSetRowKeyIterator() {
        CollectionModel table = this.getCollectionModel();
        final Iterator<Object> rowKeyIterator = ModelUtils.getRowKeyIterator(table);
        final Set<Object> set = this._getSet(false);
        Iterator<Object> iter = new Iterator<Object>(){
            private boolean _first = true;
            private Object _next = null;
            private Object _current = null;

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this._current = this._next;
                this._next = this._next();
                this._first = false;
                return this._current;
            }

            @Override
            public void remove() {
                if (this._current == null) {
                    throw new IllegalStateException(_LOG.getMessage("NO_ELEMENT_TO_REMOVE"));
                }
                Set mutable = RowKeySetImpl.this._getSet(true);
                mutable.add(this._current);
                this._current = null;
            }

            @Override
            public boolean hasNext() {
                return this._next != null || this._first;
            }

            private Object _next() {
                while (rowKeyIterator.hasNext()) {
                    Object rowKey = rowKeyIterator.next();
                    if (set.contains(rowKey)) continue;
                    return rowKey;
                }
                return null;
            }
        };
        iter.next();
        return iter;
    }

    private Iterator<Object> _getInSetRowKeyIterator() {
        return this._getSet(false).iterator();
    }

    private void _selectAll(boolean isSelected) {
        this._default = isSelected;
        this._set = Collections.emptySet();
    }

    private Set<Object> _getSet(boolean create) {
        if (create && this._set == Collections.emptySet()) {
            this._set = this._createSet(10);
        }
        return this._set;
    }

    private Set<Object> _createSet(int sz) {
        return new HashSet<Object>(sz);
    }

    private boolean _isSelected(Object rowKey) {
        Set<Object> set = this._getSet(false);
        boolean isInSet = set.contains(rowKey);
        return isInSet ^ this._default;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._default);
        Set<Object> set = this._getSet(false);
        int sz = set.size();
        out.writeInt(sz);
        Iterator<Object> iter = set.iterator();
        for (int i = 0; i < sz; ++i) {
            out.writeObject(iter.next());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._default = in.readBoolean();
        int sz = in.readInt();
        if (sz > 0) {
            this._set = this._createSet(sz);
            for (int i = 0; i < sz; ++i) {
                this._set.add(in.readObject());
            }
        } else {
            this._set = Collections.emptySet();
        }
    }

    @Override
    public RowKeySetImpl clone() {
        RowKeySetImpl clone = (RowKeySetImpl)super.clone();
        Set<Object> set = this._getSet(false);
        clone._set = this._clone(set);
        return clone;
    }

    private <T> Set<T> _clone(Set<T> other) {
        if (other.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)((HashSet)other).clone();
    }

    @Override
    protected CollectionModel getCollectionModel() {
        return this._model;
    }
}

