/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.jmock;

import java.net.URL;
import java.net.URLClassLoader;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIViewRoot;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.myfaces.test.config.ResourceBundleVarNames;
import org.apache.myfaces.test.mock.MockApplication;
import org.apache.myfaces.test.mock.MockExternalContext;
import org.apache.myfaces.test.mock.MockFacesContext;
import org.apache.myfaces.test.mock.MockFacesContextFactory;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpServletResponse;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockRenderKit;
import org.apache.myfaces.test.mock.MockServletConfig;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.lifecycle.MockLifecycle;
import org.apache.myfaces.test.mock.lifecycle.MockLifecycleFactory;
import org.jmock.cglib.MockObjectTestCase;

public abstract class AbstractJmockJsfTestCase
extends MockObjectTestCase {
    protected MockApplication application = null;
    protected MockServletConfig config = null;
    protected MockExternalContext externalContext = null;
    protected MockFacesContext facesContext = null;
    protected MockFacesContextFactory facesContextFactory = null;
    protected MockLifecycle lifecycle = null;
    protected MockLifecycleFactory lifecycleFactory = null;
    protected MockRenderKit renderKit = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpServletResponse response = null;
    protected MockServletContext servletContext = null;
    protected MockHttpSession session = null;
    private ClassLoader threadContextClassLoader = null;

    public AbstractJmockJsfTestCase(String name) {
        this.setName(name);
    }

    protected void setUp() throws Exception {
        this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], ((Object)((Object)this)).getClass().getClassLoader()));
        this.setUpServletObjects();
        FactoryFinder.releaseFactories();
        this.setFactories();
        this.setUpJSFObjects();
    }

    protected void setUpJSFObjects() throws Exception {
        this.setUpExternalContext();
        this.setUpLifecycle();
        this.setUpFacesContext();
        this.setUpView();
        this.setUpApplication();
        this.setUpRenderKit();
    }

    protected void setUpServletObjects() throws Exception {
        this.servletContext = new MockServletContext();
        this.config = new MockServletConfig(this.servletContext);
        this.session = new MockHttpSession();
        this.session.setServletContext(this.servletContext);
        this.request = new MockHttpServletRequest(this.session);
        this.request.setServletContext(this.servletContext);
        this.response = new MockHttpServletResponse();
    }

    protected void setFactories() throws Exception {
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)"org.apache.myfaces.test.mock.MockApplicationFactory");
        FactoryFinder.setFactory((String)"javax.faces.context.FacesContextFactory", (String)"org.apache.myfaces.test.mock.MockFacesContextFactory");
        FactoryFinder.setFactory((String)"javax.faces.lifecycle.LifecycleFactory", (String)"org.apache.myfaces.test.mock.lifecycle.MockLifecycleFactory");
        FactoryFinder.setFactory((String)"javax.faces.render.RenderKitFactory", (String)"org.apache.myfaces.test.mock.MockRenderKitFactory");
    }

    protected void setUpExternalContext() throws Exception {
        this.externalContext = new MockExternalContext(this.servletContext, this.request, this.response);
    }

    protected void setUpLifecycle() throws Exception {
        this.lifecycleFactory = (MockLifecycleFactory)((Object)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory"));
        this.lifecycle = (MockLifecycle)this.lifecycleFactory.getLifecycle("DEFAULT");
    }

    protected void setUpFacesContext() throws Exception {
        this.facesContextFactory = (MockFacesContextFactory)((Object)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory"));
        this.facesContext = (MockFacesContext)this.facesContextFactory.getFacesContext(this.servletContext, this.request, this.response, this.lifecycle);
        if (this.facesContext.getExternalContext() != null) {
            this.externalContext = (MockExternalContext)this.facesContext.getExternalContext();
        }
    }

    protected void setUpView() throws Exception {
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/viewId");
        root.setRenderKitId("HTML_BASIC");
        this.facesContext.setViewRoot(root);
    }

    protected void setUpApplication() throws Exception {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = (MockApplication)applicationFactory.getApplication();
        this.facesContext.setApplication(this.application);
    }

    protected void setUpRenderKit() throws Exception {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.renderKit = new MockRenderKit();
        renderKitFactory.addRenderKit("HTML_BASIC", (RenderKit)this.renderKit);
    }

    protected void tearDown() throws Exception {
        this.application = null;
        this.config = null;
        this.externalContext = null;
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        this.facesContext = null;
        this.lifecycle = null;
        this.lifecycleFactory = null;
        this.renderKit = null;
        this.request = null;
        this.response = null;
        this.servletContext = null;
        this.session = null;
        FactoryFinder.releaseFactories();
        ResourceBundleVarNames.resetNames();
        Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
        this.threadContextClassLoader = null;
    }
}

