/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.util.internal.ObjectUtils;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.report.ClassMethodIndexer;

@Deprecated
public class TestSet {
    private static final InheritableThreadLocal<TestSet> TEST_SET = new InheritableThreadLocal();
    private final String testClassName;
    private final Collection<TestMethod> testMethods = new ConcurrentLinkedQueue<TestMethod>();
    private final AtomicBoolean played = new AtomicBoolean();
    private final AtomicInteger numberOfCompletedChildren = new AtomicInteger();
    private final AtomicInteger numberOfTests = new AtomicInteger();
    private final RunMode runMode;
    private final ClassMethodIndexer classMethodIndexer;
    private volatile boolean allScheduled;

    public TestSet(String testClassName, RunMode runMode, ClassMethodIndexer classMethodIndexer) {
        this.testClassName = testClassName;
        this.runMode = runMode;
        this.classMethodIndexer = classMethodIndexer;
    }

    final RunMode getRunMode() {
        return this.runMode;
    }

    final ClassMethodIndexer getClassMethodIndexer() {
        return this.classMethodIndexer;
    }

    public void replay(TestReportListener<TestOutputReportEntry> target) {
        if (this.played.compareAndSet(false, true)) {
            try {
                TestSetReportEntry report = this.createReportEntryStarted();
                target.testSetStarting(report);
                long startTime = 0L;
                long endTime = 0L;
                for (TestMethod testMethod : this.testMethods) {
                    if (startTime == 0L || testMethod.getStartTime() < startTime) {
                        startTime = testMethod.getStartTime();
                    }
                    if (endTime == 0L || testMethod.getEndTime() > endTime) {
                        endTime = testMethod.getEndTime();
                    }
                    testMethod.replay(target);
                }
                int elapsed = (int)(endTime - startTime);
                report = this.createReportEntryCompleted(elapsed);
                target.testSetCompleted(report);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public TestMethod createThreadAttachedTestMethod(ReportEntry description) {
        TestMethod testMethod = new TestMethod(description, this);
        this.addTestMethod(testMethod);
        testMethod.attachToThread();
        return testMethod;
    }

    private TestSetReportEntry createReportEntryStarted() {
        return this.createReportEntry(null, Collections.emptyMap());
    }

    private TestSetReportEntry createReportEntryCompleted(int elapsed) {
        return this.createReportEntry(elapsed, ObjectUtils.systemProps());
    }

    private TestSetReportEntry createReportEntry(Integer elapsed, Map<String, String> systemProps) {
        return new SimpleReportEntry(this.runMode, Long.valueOf(this.classMethodIndexer.indexClass(this.testClassName)), this.testClassName, null, this.testClassName, null, null, elapsed, systemProps);
    }

    public void incrementTestMethodCount() {
        this.numberOfTests.incrementAndGet();
    }

    private void addTestMethod(TestMethod testMethod) {
        this.testMethods.add(testMethod);
    }

    public void incrementFinishedTests(TestReportListener reporterManager, boolean reportImmediately) {
        this.numberOfCompletedChildren.incrementAndGet();
        if (this.allScheduled && this.isAllTestsDone() && reportImmediately) {
            this.replay((TestReportListener<TestOutputReportEntry>)reporterManager);
        }
    }

    public void setAllScheduled(TestReportListener reporterManager) {
        this.allScheduled = true;
        if (this.isAllTestsDone()) {
            this.replay((TestReportListener<TestOutputReportEntry>)reporterManager);
        }
    }

    private boolean isAllTestsDone() {
        return this.numberOfTests.get() == this.numberOfCompletedChildren.get();
    }

    public void attachToThread() {
        TEST_SET.set(this);
    }

    public static TestSet getThreadTestSet() {
        return (TestSet)TEST_SET.get();
    }
}

