/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StarteamDiffConsumer
implements StreamConsumer {
    private static final String WORKING_DIR_TOKEN = "(working dir: ";
    private static final String PATCH_SEPARATOR_TOKEN = "--------------";
    private static final String REVISION_TOKEN = " Revision: ";
    private static final String ONDISK_TOKEN = " (on disk)";
    private static final String ADDED_LINE_TOKEN = "+";
    private static final String REMOVED_LINE_TOKEN = "-";
    private static final String UNCHANGED_LINE_TOKEN = " ";
    private ScmLogger logger;
    private String currentDir = "";
    private boolean diffBlockProcessingStarted = false;
    private boolean revisionBlockStarted = false;
    private String currentFile;
    private StringBuilder currentDifference;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private Map<String, CharSequence> differences = new HashMap<String, CharSequence>();
    private StringBuilder patch = new StringBuilder();

    public StarteamDiffConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
    }

    public void consumeLine(String line) {
        int pos = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        this.patch.append(line).append("\n");
        if (line.trim().length() == 0) {
            return;
        }
        pos = line.indexOf(WORKING_DIR_TOKEN);
        if (pos != -1) {
            this.processGetDir(line, pos);
            return;
        }
        if (line.startsWith(PATCH_SEPARATOR_TOKEN)) {
            boolean bl = this.diffBlockProcessingStarted = !this.diffBlockProcessingStarted;
            if (this.diffBlockProcessingStarted && this.revisionBlockStarted) {
                throw new IllegalStateException("Missing second Revision line or local copy line ");
            }
            return;
        }
        pos = line.indexOf(REVISION_TOKEN);
        if (pos != -1) {
            if (this.revisionBlockStarted) {
                this.revisionBlockStarted = false;
            } else {
                this.extractCurrentFile(line, pos);
                this.revisionBlockStarted = true;
            }
            return;
        }
        pos = line.indexOf(ONDISK_TOKEN);
        if (pos != -1) {
            if (!this.revisionBlockStarted) {
                throw new IllegalStateException("Working copy line found at the wrong state ");
            }
            this.revisionBlockStarted = false;
            return;
        }
        if (!this.diffBlockProcessingStarted) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unparseable line: '" + line + "'");
            }
            return;
        }
        if (line.startsWith(ADDED_LINE_TOKEN) || line.startsWith(REMOVED_LINE_TOKEN) || line.startsWith(UNCHANGED_LINE_TOKEN)) {
            this.currentDifference.append(line).append("\n");
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Unparseable line: '" + line + "'");
        }
    }

    private void processGetDir(String line, int pos) {
        String dirPath;
        this.currentDir = dirPath = line.substring(pos + WORKING_DIR_TOKEN.length(), line.length() - 1).replace('\\', '/');
    }

    private void extractCurrentFile(String line, int pos) {
        this.currentFile = line.substring(0, pos);
        this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.MODIFIED));
        this.currentDifference = new StringBuilder();
        this.differences.put(this.currentFile, this.currentDifference);
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, CharSequence> getDifferences() {
        return this.differences;
    }

    public String getPatch() {
        return this.patch.toString();
    }
}

