/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

public class BazaarConsumer
extends AbstractConsumer {
    private static final Map<String, ScmFileStatus> IDENTIFIERS = new HashMap<String, ScmFileStatus>();
    private static final Map<String, String> MESSAGES = new HashMap<String, String>();
    private static final int MAX_STDERR_SIZE = 10;
    private final List<String> stderr = new ArrayList<String>();

    public BazaarConsumer(ScmLogger logger) {
        super(logger);
    }

    public void doConsume(ScmFileStatus status, String trimmedLine) {
    }

    public void consumeLine(String line) {
        String trimmedLine;
        String statusStr;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(line);
        }
        if ((statusStr = BazaarConsumer.processInputForKnownIdentifiers(trimmedLine = line.trim())) == null) {
            boolean isMessage = this.processInputForKnownMessages(trimmedLine);
            if (isMessage) {
                return;
            }
        } else {
            trimmedLine = trimmedLine.substring(statusStr.length());
            trimmedLine = trimmedLine.trim();
        }
        ScmFileStatus status = statusStr != null ? IDENTIFIERS.get(statusStr.intern()) : null;
        this.doConsume(status, trimmedLine);
    }

    public String getStdErr() {
        StringBuilder str = new StringBuilder();
        Iterator<String> it = this.stderr.iterator();
        while (it.hasNext()) {
            str.append(it.next());
        }
        return str.toString();
    }

    private static String processInputForKnownIdentifiers(String line) {
        for (String id : IDENTIFIERS.keySet()) {
            if (!line.startsWith(id)) continue;
            return id;
        }
        return null;
    }

    private boolean processInputForKnownMessages(String line) {
        for (String prefix : MESSAGES.keySet()) {
            if (!line.startsWith(prefix)) continue;
            this.stderr.add(line);
            if (this.stderr.size() > 10) {
                this.stderr.remove(0);
            }
            String message = line.substring(prefix.length());
            if (MESSAGES.get(prefix).equals("WARNING")) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(message);
                }
            } else if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message);
            }
            return true;
        }
        return false;
    }

    static {
        IDENTIFIERS.put("added", ScmFileStatus.ADDED);
        IDENTIFIERS.put("adding", ScmFileStatus.ADDED);
        IDENTIFIERS.put("unknown", ScmFileStatus.UNKNOWN);
        IDENTIFIERS.put("modified", ScmFileStatus.MODIFIED);
        IDENTIFIERS.put("removed", ScmFileStatus.DELETED);
        IDENTIFIERS.put("renamed", ScmFileStatus.RENAMED);
        MESSAGES.put("bzr: WARNING:", "WARNING");
        MESSAGES.put("bzr: ERROR:", "ERROR");
        MESSAGES.put("'bzr' ", "ERROR");
    }
}

