/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="check-local-modification")
public class CheckLocalModificationsMojo
extends AbstractScmMojo {
    @Parameter(property="scm.checkLocalModification.errorMessage", defaultValue="The build will stop as there is local modifications")
    private String errorMessage;
    @Parameter(property="scm.checkLocalModification.skip", defaultValue="false")
    private boolean skip;

    @Inject
    public CheckLocalModificationsMojo(ScmManager manager, SettingsDecrypter settingsDecrypter) {
        super(manager, settingsDecrypter);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"check-local-modification execution has been skipped");
            return;
        }
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            StatusScmResult result = this.getScmManager().status(repository, this.getFileSet());
            if (!result.isSuccess()) {
                throw new MojoExecutionException("Unable to check for local modifications : " + result.getProviderMessage());
            }
            if (!result.getChangedFiles().isEmpty()) {
                throw new MojoExecutionException(this.errorMessage);
            }
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

