/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="checkout", requiresProject=false)
public class CheckoutMojo
extends AbstractScmMojo {
    @Parameter(property="useExport", defaultValue="false")
    private boolean useExport;
    @Parameter(property="checkoutDirectory", defaultValue="${project.build.directory}/checkout")
    private File checkoutDirectory;
    @Parameter(property="skipCheckoutIfExists", defaultValue="false")
    private boolean skipCheckoutIfExists = false;
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    private ScmResult checkoutResult;

    public void execute() throws MojoExecutionException {
        super.execute();
        this.checkoutResult = null;
        if (!this.getCheckoutDirectory().isDirectory() || !this.skipCheckoutIfExists) {
            this.checkoutResult = this.checkout();
        }
    }

    protected File getCheckoutDirectory() {
        if (this.checkoutDirectory.getPath().contains("${project.basedir}")) {
            this.checkoutDirectory = new File(this.getBasedir(), "target/checkout");
        }
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(File checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    protected ScmResult checkout() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            this.prepareOutputDirectory(this.getCheckoutDirectory());
            Object result = null;
            ScmFileSet fileSet = new ScmFileSet(this.getCheckoutDirectory().getAbsoluteFile());
            result = this.useExport ? this.getScmManager().export(repository, fileSet, this.getScmVersion(this.scmVersionType, this.scmVersion)) : this.getScmManager().checkOut(repository, fileSet, this.getScmVersion(this.scmVersionType, this.scmVersion));
            this.checkResult((ScmResult)result);
            this.handleExcludesIncludesAfterCheckoutAndExport(this.checkoutDirectory);
            return result;
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)((Object)e));
        }
    }

    private void prepareOutputDirectory(File ouputDirectory) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Removing " + ouputDirectory));
            FileUtils.deleteDirectory((File)this.getCheckoutDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot remove " + ouputDirectory);
        }
        if (!this.getCheckoutDirectory().mkdirs()) {
            throw new MojoExecutionException("Cannot create " + ouputDirectory);
        }
    }

    protected ScmResult getCheckoutResult() {
        return this.checkoutResult;
    }
}

