/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.sonatype.plexus.build.incremental.BuildContext;

@Named
@Singleton
public class UnpackUtil {
    private final ArchiverManager archiverManager;
    private final BuildContext buildContext;

    @Inject
    public UnpackUtil(ArchiverManager archiverManager, BuildContext buildContext) {
        this.archiverManager = archiverManager;
        this.buildContext = buildContext;
    }

    public void unpack(File file, String type, File location, String includes, String excludes, String encoding, boolean ignorePermissions, FileMapper[] fileMappers, Log logger) throws MojoExecutionException {
        try {
            UnArchiver unArchiver;
            this.logUnpack(logger, file, location, includes, excludes);
            location.mkdirs();
            if (!location.exists()) {
                throw new MojoExecutionException("Location to write unpacked files to could not be created: " + location);
            }
            if (file.isDirectory()) {
                throw new MojoExecutionException("Artifact has not been packaged yet. When used on reactor artifact, unpack should be executed after packaging: see MDEP-98.");
            }
            try {
                unArchiver = this.archiverManager.getUnArchiver(type);
                logger.debug((CharSequence)("Found unArchiver: " + unArchiver.getClass().getName() + " by type: " + type));
            }
            catch (NoSuchArchiverException e) {
                unArchiver = this.archiverManager.getUnArchiver(file);
                logger.debug((CharSequence)("Found unArchiver: " + unArchiver.getClass().getName() + " by file extension: " + file));
            }
            if (encoding != null && unArchiver instanceof ZipUnArchiver) {
                ((ZipUnArchiver)unArchiver).setEncoding(encoding);
                logger.info((CharSequence)("Unpacks '" + type + "' with encoding '" + encoding + "'."));
            }
            unArchiver.setIgnorePermissions(ignorePermissions);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (excludes != null && !excludes.isEmpty() || includes != null && !includes.isEmpty()) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (excludes != null && !excludes.isEmpty()) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (includes != null && !includes.isEmpty()) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.setFileMappers(fileMappers);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location, (Exception)((Object)e));
        }
        this.buildContext.refresh(location);
    }

    private void logUnpack(Log logger, File file, File location, String includes, String excludes) {
        if (logger.isInfoEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        logger.info((CharSequence)msg.toString());
    }
}

