/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.latex;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Locale;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.sink.AbstractTextSink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.LineBreaker;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class LatexSink
extends AbstractTextSink {
    private final boolean fragmentDocument;
    private boolean ignoreText;
    private final LineBreaker out;
    private final String sinkCommands;
    private final String preamble;
    private boolean titleFlag;
    private int numberedListNesting;
    private boolean verbatimFlag;
    private boolean figureFlag;
    private boolean tableFlag;
    private boolean gridFlag;
    private int[] cellJustif;
    private int cellCount;
    private boolean isTitle;
    private String title;
    private boolean lastCellWasHeader = false;

    protected LatexSink(Writer out) {
        this(out, null, null);
    }

    protected LatexSink(Writer out, String sinkCommands, String preamble) {
        this(out, sinkCommands, preamble, false);
    }

    protected LatexSink(Writer out, String sinkCommands, String preamble, boolean fragmentDocument) {
        this.out = new LineBreaker(out);
        if (sinkCommands == null) {
            sinkCommands = this.defaultSinkCommands();
        }
        if (preamble == null) {
            preamble = this.defaultPreamble();
        }
        this.sinkCommands = sinkCommands;
        this.preamble = preamble;
        this.fragmentDocument = fragmentDocument;
        this.init();
    }

    protected String getDocumentStart() {
        return "\\documentclass[a4paper]{article}" + EOL + EOL;
    }

    protected String getDocumentBegin() {
        return "\\begin{document}" + EOL + EOL;
    }

    protected String getDocumentEnd() {
        return "\\end{document}" + EOL;
    }

    public void head() {
        this.head(null);
    }

    public void head(SinkEventAttributes attributes) {
        this.init();
        if (!this.fragmentDocument) {
            this.markup(this.sinkCommands);
            this.markup(this.getDocumentStart());
            this.markup(this.preamble);
            this.markup(this.getDocumentBegin());
        }
    }

    public void body() {
        this.body(null);
    }

    public void body(SinkEventAttributes attributes) {
        if (this.titleFlag) {
            if (this.fragmentDocument) {
                this.markup("\\section");
            } else {
                this.titleFlag = false;
                this.markup("\\maketitle" + EOL + EOL);
            }
        }
    }

    public void body_() {
        if (!this.fragmentDocument) {
            this.markup(this.getDocumentEnd());
        }
        this.flush();
    }

    public void title() {
        this.title(null);
    }

    public void title(SinkEventAttributes attributes) {
        if (!this.fragmentDocument) {
            this.titleFlag = true;
            this.markup("\\title{");
        } else {
            this.ignoreText = true;
        }
    }

    public void title_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void author() {
        this.author(null);
    }

    public void author(SinkEventAttributes attributes) {
        if (!this.fragmentDocument) {
            this.markup("\\author{");
        } else {
            this.ignoreText = true;
        }
    }

    public void author_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void date() {
        this.date(null);
    }

    public void date(SinkEventAttributes attributes) {
        if (!this.fragmentDocument) {
            this.markup("\\date{");
        } else {
            this.ignoreText = true;
        }
    }

    public void date_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.isTitle = true;
    }

    public void sectionTitle_(int level) {
        String command = "";
        switch (level) {
            case 1: {
                command = "section";
                break;
            }
            case 2: {
                command = "subsection";
                break;
            }
            case 3: {
                command = "subsubsection";
                break;
            }
            case 4: {
                command = "paragraph";
                break;
            }
            case 5: {
                command = "subparagraph";
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a section level: " + level);
            }
        }
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup(EOL + "\\" + command + "{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle1() {
        this.sectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.sectionTitle_(1);
    }

    public void sectionTitle2() {
        this.sectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.sectionTitle_(2);
    }

    public void sectionTitle3() {
        this.sectionTitle(3, null);
    }

    public void sectionTitle3_() {
        this.sectionTitle_(3);
    }

    public void sectionTitle4() {
        this.sectionTitle(4, null);
    }

    public void sectionTitle4_() {
        this.sectionTitle_(4);
    }

    public void sectionTitle5() {
        this.sectionTitle(5, null);
    }

    public void sectionTitle5_() {
        this.sectionTitle_(5);
    }

    public void list() {
        this.list(null);
    }

    public void list(SinkEventAttributes attributes) {
        this.markup(EOL + "\\begin{itemize}");
    }

    public void list_() {
        this.markup(EOL + "\\end{itemize}" + EOL);
    }

    public void listItem() {
        this.listItem(null);
    }

    public void listItem(SinkEventAttributes attributes) {
        this.markup(EOL + "\\item ");
    }

    public void numberedList(int numbering) {
        this.numberedList(numbering, null);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        String style;
        String counter;
        ++this.numberedListNesting;
        switch (this.numberedListNesting) {
            case 1: {
                counter = "enumi";
                break;
            }
            case 2: {
                counter = "enumii";
                break;
            }
            case 3: {
                counter = "enumiii";
                break;
            }
            default: {
                counter = "enumiv";
            }
        }
        switch (numbering) {
            case 2: {
                style = "Alph";
                break;
            }
            case 1: {
                style = "alph";
                break;
            }
            case 4: {
                style = "Roman";
                break;
            }
            case 3: {
                style = "roman";
                break;
            }
            default: {
                style = "arabic";
            }
        }
        this.markup(EOL + "\\begin{enumerate}" + EOL);
        this.markup("\\renewcommand{\\the" + counter + "}{\\" + style + "{" + counter + "}}" + EOL);
    }

    public void numberedList_() {
        this.markup(EOL + "\\end{enumerate}" + EOL);
        --this.numberedListNesting;
    }

    public void numberedListItem() {
        this.numberedListItem(null);
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.markup("\\item ");
    }

    public void definitionList() {
        this.definitionList(null);
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.markup(EOL + "\\begin{description}");
    }

    public void definitionList_() {
        this.markup(EOL + "\\end{description}" + EOL);
    }

    public void definedTerm() {
        this.definedTerm(null);
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.markup(EOL + "\\item[\\mbox{");
    }

    public void definedTerm_() {
        this.markup("}] ");
    }

    public void definitionListItem() {
        this.definitionListItem(null);
    }

    public void definitionListItem(SinkEventAttributes attributes) {
    }

    public void definitionListItem_() {
    }

    public void definition() {
        this.definition(null);
    }

    public void definition(SinkEventAttributes attributes) {
    }

    public void definition_() {
    }

    public void figure() {
        this.figure(null);
    }

    public void figure(SinkEventAttributes attributes) {
        this.figureFlag = true;
        this.markup(EOL + "\\begin{figure}[htb]" + EOL);
    }

    public void figure_() {
        this.markup("\\end{figure}" + EOL);
        this.figureFlag = false;
    }

    public void figureGraphics(String name) {
        this.figureGraphics(name, null);
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        if (!src.toLowerCase(Locale.ENGLISH).endsWith(".eps")) {
            this.getLog().warn((CharSequence)"[Latex Sink] Found non-eps figure graphics!");
        }
        this.markup("\\begin{center}" + EOL);
        this.markup("\\includegraphics{" + src + "}" + EOL);
        this.markup("\\end{center}" + EOL);
    }

    public void figureCaption() {
        this.figureCaption(null);
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.markup("\\caption{");
    }

    public void figureCaption_() {
        this.markup("}" + EOL);
    }

    public void table() {
        this.table(null);
    }

    public void table(SinkEventAttributes attributes) {
        this.tableFlag = true;
        this.markup(EOL + "\\begin{table}[htp]" + EOL);
    }

    public void table_() {
        this.markup("\\end{table}" + EOL);
        this.tableFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        StringBuffer justif = new StringBuffer();
        block5: for (int i = 0; i < justification.length; ++i) {
            if (grid) {
                justif.append('|');
            }
            switch (justification[i]) {
                case 0: {
                    justif.append('c');
                    continue block5;
                }
                case 1: {
                    justif.append('l');
                    continue block5;
                }
                case 2: {
                    justif.append('r');
                    continue block5;
                }
            }
        }
        if (grid) {
            justif.append('|');
        }
        this.markup("\\begin{center}" + EOL);
        this.markup("\\begin{tabular}{" + justif.toString() + "}" + EOL);
        if (grid) {
            this.markup("\\hline" + EOL);
        }
        this.gridFlag = grid;
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.markup("\\end{tabular}" + EOL);
        this.markup("\\end{center}" + EOL);
        this.gridFlag = false;
        this.cellJustif = null;
    }

    public void tableRow() {
        this.tableRow(null);
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.markup("\\\\" + EOL);
        if (this.gridFlag || this.lastCellWasHeader) {
            this.markup("\\hline" + EOL);
        }
        this.cellCount = 0;
        this.lastCellWasHeader = false;
    }

    public void tableCell() {
        this.tableCell((SinkEventAttributes)null);
    }

    public void tableCell(String width) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute((Object)HTML.Attribute.WIDTH, (Object)width);
        this.tableCell((SinkEventAttributes)att);
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false);
    }

    public void tableCell_() {
        this.markup("\\end{tabular}");
        ++this.cellCount;
    }

    public void tableHeaderCell() {
        this.tableCell((SinkEventAttributes)null);
    }

    public void tableHeaderCell(String width) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute((Object)HTML.Attribute.WIDTH, (Object)width);
        this.tableHeaderCell((SinkEventAttributes)att);
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true);
    }

    public void tableHeaderCell_() {
        this.tableCell_();
    }

    private void tableCell(boolean header) {
        char justif;
        this.lastCellWasHeader = header;
        if (this.cellCount > 0) {
            this.markup(" &" + EOL);
        }
        switch (this.cellJustif[this.cellCount]) {
            case 1: {
                justif = 'l';
                break;
            }
            case 2: {
                justif = 'r';
                break;
            }
            default: {
                justif = 'c';
            }
        }
        this.markup("\\begin{tabular}[t]{" + justif + "}");
    }

    public void tableCaption() {
        this.tableCaption(null);
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.markup("\\caption{");
    }

    public void tableCaption_() {
        this.markup("}" + EOL);
    }

    public void paragraph() {
        this.paragraph(null);
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.markup(EOL + EOL);
    }

    public void paragraph_() {
        this.markup(EOL);
    }

    public void verbatim(boolean boxed) {
        this.verbatim((SinkEventAttributes)(boxed ? SinkEventAttributeSet.BOXED : null));
    }

    public void verbatim(SinkEventAttributes attributes) {
        boolean boxed = false;
        if (attributes != null && attributes.isDefined((Object)"decoration")) {
            boxed = "boxed".equals(attributes.getAttribute((Object)"decoration"));
        }
        this.markup(EOL + "\\begin{small}" + EOL);
        if (boxed) {
            this.markup("\\begin{Verbatim}[frame=single]" + EOL);
        } else {
            this.markup("\\begin{Verbatim}" + EOL);
        }
        this.verbatimFlag = true;
    }

    public void verbatim_() {
        this.markup(EOL + "\\end{Verbatim}" + EOL);
        this.markup("\\end{small}" + EOL);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.horizontalRule(null);
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.markup(EOL + "\\begin{center}\\rule[0.5ex]{\\linewidth}{1pt}\\end{center}" + EOL);
    }

    public void pageBreak() {
        this.markup(EOL + "\\newpage" + EOL);
    }

    public void anchor(String name) {
        this.anchor(name, null);
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.markup("\\hypertarget{" + name + "}{");
    }

    public void anchor_() {
        this.markup("}");
    }

    public void link(String name) {
        this.link(name, null);
    }

    public void link(String name, SinkEventAttributes attributes) {
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.markup("\\href{" + name + "}{");
        } else {
            this.markup("\\hyperlink{" + name + "}{");
        }
    }

    public void link_() {
        this.markup("}");
    }

    public void italic() {
        this.markup("\\textit{");
    }

    public void italic_() {
        this.markup("}");
    }

    public void bold() {
        this.markup("\\textbf{");
    }

    public void bold_() {
        this.markup("}");
    }

    public void monospaced() {
        this.markup("\\texttt{\\small ");
    }

    public void monospaced_() {
        this.markup("}");
    }

    public void lineBreak() {
        this.lineBreak(null);
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.markup(this.figureFlag || this.tableFlag || this.titleFlag || this.verbatimFlag ? EOL : "\\newline" + EOL);
    }

    public void nonBreakingSpace() {
        this.markup("~");
    }

    public void text(String text) {
        this.text(text, null);
    }

    public void text(String text, SinkEventAttributes attributes) {
        if (this.ignoreText) {
            return;
        }
        if (this.isTitle) {
            this.title = text;
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void rawText(String text) {
        this.verbatimContent(text);
    }

    public void comment(String comment) {
        this.rawText(EOL + "% " + comment);
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.getLog().warn((CharSequence)("[Latex Sink] Unknown Sink event: '" + name + "', ignoring!"));
    }

    protected void markup(String text) {
        if (text != null) {
            this.out.write(text, true);
        }
    }

    protected void content(String text) {
        this.out.write(LatexSink.escaped(text), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(text, true);
    }

    public static String escaped(String text) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block14: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '-': 
                case '<': 
                case '>': {
                    buffer.append("\\symbol{").append((int)c).append("}");
                    continue block14;
                }
                case '~': {
                    buffer.append("\\textasciitilde ");
                    continue block14;
                }
                case '^': {
                    buffer.append("\\textasciicircum ");
                    continue block14;
                }
                case '|': {
                    buffer.append("\\textbar ");
                    continue block14;
                }
                case '\\': {
                    buffer.append("\\textbackslash ");
                    continue block14;
                }
                case '$': {
                    buffer.append("\\$");
                    continue block14;
                }
                case '&': {
                    buffer.append("\\&");
                    continue block14;
                }
                case '%': {
                    buffer.append("\\%");
                    continue block14;
                }
                case '#': {
                    buffer.append("\\#");
                    continue block14;
                }
                case '{': {
                    buffer.append("\\{");
                    continue block14;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block14;
                }
                case '_': {
                    buffer.append("\\_");
                    continue block14;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
        this.init();
    }

    private static InputStream getDefaultSinkCommands() throws IOException {
        return LatexSink.class.getResource("default_sink_commands.tex").openStream();
    }

    private static InputStream getDefaultPreamble() throws IOException {
        return LatexSink.class.getResource("default_preamble.tex").openStream();
    }

    protected String defaultSinkCommands() {
        try {
            return IOUtil.toString((InputStream)LatexSink.getDefaultSinkCommands());
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Could not read default LaTeX commands, the generated LaTeX file will not compile!");
            this.getLog().debug((Throwable)ioe);
            return "";
        }
    }

    protected String defaultPreamble() {
        try {
            return IOUtil.toString((InputStream)LatexSink.getDefaultPreamble());
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Could not read default LaTeX preamble, the generated LaTeX file will not compile!");
            this.getLog().debug((Throwable)ioe);
            return "";
        }
    }

    protected void init() {
        super.init();
        this.ignoreText = false;
        this.titleFlag = false;
        this.numberedListNesting = 0;
        this.verbatimFlag = false;
        this.figureFlag = false;
        this.tableFlag = false;
        this.gridFlag = false;
        this.cellJustif = null;
        this.cellCount = 0;
        this.isTitle = false;
        this.title = null;
    }
}

