/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryTestCase;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;

public abstract class BaseChunkedDirectoryTestCase
extends BaseDirectoryTestCase {
    @Override
    protected Directory getDirectory(Path path) throws IOException {
        return this.getDirectory(path, 1 << TestUtil.nextInt(BaseChunkedDirectoryTestCase.random(), 10, 20));
    }

    protected abstract Directory getDirectory(Path var1, int var2) throws IOException;

    public void testCloneClose() throws Exception {
        Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testCloneClose"));
        IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
        io.writeVInt(5);
        io.close();
        IndexInput one = dir.openInput("bytes", IOContext.DEFAULT);
        IndexInput two = one.clone();
        IndexInput three = two.clone();
        two.close();
        BaseChunkedDirectoryTestCase.assertEquals((long)5L, (long)one.readVInt());
        BaseChunkedDirectoryTestCase.expectThrows(AlreadyClosedException.class, () -> two.readVInt());
        BaseChunkedDirectoryTestCase.assertEquals((long)5L, (long)three.readVInt());
        one.close();
        three.close();
        dir.close();
    }

    public void testCloneSliceClose() throws Exception {
        Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testCloneSliceClose"));
        IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
        io.writeInt(1);
        io.writeInt(2);
        io.close();
        IndexInput slicer = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
        IndexInput one = slicer.slice("first int", 0L, 4L);
        IndexInput two = slicer.slice("second int", 4L, 4L);
        one.close();
        BaseChunkedDirectoryTestCase.expectThrows(AlreadyClosedException.class, () -> one.readInt());
        BaseChunkedDirectoryTestCase.assertEquals((long)2L, (long)two.readInt());
        IndexInput another = slicer.slice("first int", 0L, 4L);
        BaseChunkedDirectoryTestCase.assertEquals((long)1L, (long)another.readInt());
        another.close();
        two.close();
        slicer.close();
        dir.close();
    }

    public void testSeekZero() throws Exception {
        int upto = TEST_NIGHTLY ? 31 : 3;
        for (int i = 0; i < upto; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSeekZero"), 1 << i);
            IndexOutput io = dir.createOutput("zeroBytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            io.close();
            IndexInput ii = dir.openInput("zeroBytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            ii.seek(0L);
            ii.close();
            dir.close();
        }
    }

    public void testSeekSliceZero() throws Exception {
        int upto = TEST_NIGHTLY ? 31 : 3;
        for (int i = 0; i < upto; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSeekSliceZero"), 1 << i);
            IndexOutput io = dir.createOutput("zeroBytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            io.close();
            IndexInput slicer = dir.openInput("zeroBytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            IndexInput ii = slicer.slice("zero-length slice", 0L, 0L);
            ii.seek(0L);
            ii.close();
            slicer.close();
            dir.close();
        }
    }

    public void testSeekEnd() throws Exception {
        for (int i = 0; i < 17; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSeekEnd"), 1 << i);
            IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] bytes = new byte[1 << i];
            BaseChunkedDirectoryTestCase.random().nextBytes(bytes);
            io.writeBytes(bytes, bytes.length);
            io.close();
            IndexInput ii = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] actual = new byte[1 << i];
            ii.readBytes(actual, 0, actual.length);
            BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes), (Object)new BytesRef(actual));
            ii.seek((long)(1 << i));
            ii.close();
            dir.close();
        }
    }

    public void testSeekSliceEnd() throws Exception {
        for (int i = 0; i < 17; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSeekSliceEnd"), 1 << i);
            IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] bytes = new byte[1 << i];
            BaseChunkedDirectoryTestCase.random().nextBytes(bytes);
            io.writeBytes(bytes, bytes.length);
            io.close();
            IndexInput slicer = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            IndexInput ii = slicer.slice("full slice", 0L, (long)bytes.length);
            byte[] actual = new byte[1 << i];
            ii.readBytes(actual, 0, actual.length);
            BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes), (Object)new BytesRef(actual));
            ii.seek((long)(1 << i));
            ii.close();
            slicer.close();
            dir.close();
        }
    }

    public void testSeeking() throws Exception {
        int numIters = TEST_NIGHTLY ? 10 : 1;
        for (int i = 0; i < numIters; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSeeking"), 1 << i);
            IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] bytes = new byte[1 << i + 1];
            BaseChunkedDirectoryTestCase.random().nextBytes(bytes);
            io.writeBytes(bytes, bytes.length);
            io.close();
            IndexInput ii = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] actual = new byte[1 << i + 1];
            ii.readBytes(actual, 0, actual.length);
            BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes), (Object)new BytesRef(actual));
            for (int sliceStart = 0; sliceStart < bytes.length; ++sliceStart) {
                for (int sliceLength = 0; sliceLength < bytes.length - sliceStart; ++sliceLength) {
                    byte[] slice = new byte[sliceLength];
                    ii.seek((long)sliceStart);
                    ii.readBytes(slice, 0, slice.length);
                    BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes, sliceStart, sliceLength), (Object)new BytesRef(slice));
                }
            }
            ii.close();
            dir.close();
        }
    }

    public void testSlicedSeeking() throws Exception {
        int numIters = TEST_NIGHTLY ? 10 : 1;
        for (int i = 0; i < numIters; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSlicedSeeking"), 1 << i);
            IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] bytes = new byte[1 << i + 1];
            BaseChunkedDirectoryTestCase.random().nextBytes(bytes);
            io.writeBytes(bytes, bytes.length);
            io.close();
            IndexInput ii = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] actual = new byte[1 << i + 1];
            ii.readBytes(actual, 0, actual.length);
            ii.close();
            BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes), (Object)new BytesRef(actual));
            IndexInput slicer = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            for (int sliceStart = 0; sliceStart < bytes.length; ++sliceStart) {
                for (int sliceLength = 0; sliceLength < bytes.length - sliceStart; ++sliceLength) {
                    this.assertSlice(bytes, slicer, 0, sliceStart, sliceLength);
                }
            }
            slicer.close();
            dir.close();
        }
    }

    @Override
    public void testSliceOfSlice() throws Exception {
        int upto = TEST_NIGHTLY ? 10 : 8;
        for (int i = 0; i < upto; ++i) {
            Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testSliceOfSlice"), 1 << i);
            IndexOutput io = dir.createOutput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] bytes = new byte[1 << i + 1];
            BaseChunkedDirectoryTestCase.random().nextBytes(bytes);
            io.writeBytes(bytes, bytes.length);
            io.close();
            IndexInput ii = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            byte[] actual = new byte[1 << i + 1];
            ii.readBytes(actual, 0, actual.length);
            ii.close();
            BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes), (Object)new BytesRef(actual));
            IndexInput outerSlicer = dir.openInput("bytes", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));
            int outerSliceStart = BaseChunkedDirectoryTestCase.random().nextInt(bytes.length / 2);
            int outerSliceLength = BaseChunkedDirectoryTestCase.random().nextInt(bytes.length - outerSliceStart);
            IndexInput innerSlicer = outerSlicer.slice("parentBytesSlice", (long)outerSliceStart, (long)outerSliceLength);
            for (int sliceStart = 0; sliceStart < outerSliceLength; ++sliceStart) {
                for (int sliceLength = 0; sliceLength < outerSliceLength - sliceStart; ++sliceLength) {
                    this.assertSlice(bytes, innerSlicer, outerSliceStart, sliceStart, sliceLength);
                }
            }
            innerSlicer.close();
            outerSlicer.close();
            dir.close();
        }
    }

    private void assertSlice(byte[] bytes, IndexInput slicer, int outerSliceStart, int sliceStart, int sliceLength) throws IOException {
        byte[] slice = new byte[sliceLength];
        IndexInput input = slicer.slice("bytesSlice", (long)sliceStart, (long)slice.length);
        input.readBytes(slice, 0, slice.length);
        input.close();
        BaseChunkedDirectoryTestCase.assertEquals((Object)new BytesRef(bytes, outerSliceStart + sliceStart, sliceLength), (Object)new BytesRef(slice));
    }

    public void testRandomChunkSizes() throws Exception {
        int num = TEST_NIGHTLY ? BaseChunkedDirectoryTestCase.atLeast(10) : 3;
        for (int i = 0; i < num; ++i) {
            this.assertChunking(BaseChunkedDirectoryTestCase.random(), TestUtil.nextInt(BaseChunkedDirectoryTestCase.random(), 20, 100));
        }
    }

    private void assertChunking(Random random, int chunkSize) throws Exception {
        Path path = BaseChunkedDirectoryTestCase.createTempDir("mmap" + chunkSize);
        Directory chunkedDir = this.getDirectory(path, chunkSize);
        MockDirectoryWrapper dir = new MockDirectoryWrapper(random, chunkedDir);
        RandomIndexWriter writer = new RandomIndexWriter(random, (Directory)dir, BaseChunkedDirectoryTestCase.newIndexWriterConfig(new MockAnalyzer(random)).setMergePolicy((MergePolicy)BaseChunkedDirectoryTestCase.newLogMergePolicy()));
        Document doc = new Document();
        Field docid = BaseChunkedDirectoryTestCase.newStringField("docid", "0", Field.Store.YES);
        Field junk = BaseChunkedDirectoryTestCase.newStringField("junk", "", Field.Store.YES);
        doc.add((IndexableField)docid);
        doc.add((IndexableField)junk);
        int numDocs = 100;
        for (int i = 0; i < numDocs; ++i) {
            docid.setStringValue("" + i);
            junk.setStringValue(TestUtil.randomUnicodeString(random));
            writer.addDocument(doc);
        }
        DirectoryReader reader = writer.getReader();
        writer.close();
        StoredFields storedFields = reader.storedFields();
        int numAsserts = BaseChunkedDirectoryTestCase.atLeast(100);
        for (int i = 0; i < numAsserts; ++i) {
            int docID = random.nextInt(numDocs);
            BaseChunkedDirectoryTestCase.assertEquals((Object)("" + docID), (Object)storedFields.document(docID).get("docid"));
        }
        reader.close();
        dir.close();
    }

    public void testLittleEndianLongsCrossBoundary() throws Exception {
        try (Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testLittleEndianLongsCrossBoundary"), 16);){
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));){
                out.writeByte((byte)2);
                out.writeLong(3L);
                out.writeLong(Long.MAX_VALUE);
                out.writeLong(-3L);
            }
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));){
                BaseChunkedDirectoryTestCase.assertEquals((long)25L, (long)input.length());
                BaseChunkedDirectoryTestCase.assertEquals((long)2L, (long)input.readByte());
                long[] l = new long[4];
                input.readLongs(l, 1, 3);
                BaseChunkedDirectoryTestCase.assertArrayEquals((long[])new long[]{0L, 3L, Long.MAX_VALUE, -3L}, (long[])l);
                BaseChunkedDirectoryTestCase.assertEquals((long)25L, (long)input.getFilePointer());
            }
        }
    }

    public void testLittleEndianFloatsCrossBoundary() throws Exception {
        try (Directory dir = this.getDirectory(BaseChunkedDirectoryTestCase.createTempDir("testFloatsCrossBoundary"), 8);){
            try (IndexOutput out = dir.createOutput("Floats", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));){
                out.writeByte((byte)2);
                out.writeInt(Float.floatToIntBits(3.0f));
                out.writeInt(Float.floatToIntBits(Float.MAX_VALUE));
                out.writeInt(Float.floatToIntBits(-3.0f));
            }
            try (IndexInput input = dir.openInput("Floats", BaseChunkedDirectoryTestCase.newIOContext(BaseChunkedDirectoryTestCase.random()));){
                BaseChunkedDirectoryTestCase.assertEquals((long)13L, (long)input.length());
                BaseChunkedDirectoryTestCase.assertEquals((long)2L, (long)input.readByte());
                float[] ff = new float[4];
                input.readFloats(ff, 1, 3);
                BaseChunkedDirectoryTestCase.assertArrayEquals((float[])new float[]{0.0f, 3.0f, Float.MAX_VALUE, -3.0f}, (float[])ff, (float)0.0f);
                BaseChunkedDirectoryTestCase.assertEquals((long)13L, (long)input.getFilePointer());
            }
        }
    }
}

