/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.apache.lucene.search.suggest.document.CompletionFieldsProducer;
import org.apache.lucene.search.suggest.document.NRTSuggester;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.util.automaton.Automaton;

public class SuggestIndexSearcher
extends IndexSearcher {
    private final Analyzer queryAnalyzer;

    public SuggestIndexSearcher(IndexReader reader, Analyzer queryAnalyzer) {
        super(reader);
        this.queryAnalyzer = queryAnalyzer;
    }

    public TopSuggestDocs suggest(String field, CharSequence key, int num) throws IOException {
        return this.suggest(field, key, num, (Filter)null);
    }

    public void suggest(String field, CharSequence key, int num, TopSuggestDocsCollector collector) throws IOException {
        this.suggest(field, key, num, null, collector);
    }

    public TopSuggestDocs suggest(String field, CharSequence key, int num, Filter filter) throws IOException {
        TopSuggestDocsCollector collector = new TopSuggestDocsCollector(num);
        this.suggest(field, key, num, filter, collector);
        return collector.get();
    }

    public void suggest(String field, CharSequence key, int num, Filter filter, TopSuggestDocsCollector collector) throws IOException {
        if (field == null) {
            throw new IllegalArgumentException("'field' can not be null");
        }
        if (num <= 0) {
            throw new IllegalArgumentException("'num' should be > 0");
        }
        if (collector == null) {
            throw new IllegalArgumentException("'collector' can not be null");
        }
        CompletionAnalyzer analyzer = this.queryAnalyzer instanceof CompletionAnalyzer ? (CompletionAnalyzer)this.queryAnalyzer : new CompletionAnalyzer(this.queryAnalyzer);
        Automaton automaton = analyzer.toAutomaton(field, key);
        for (LeafReaderContext context : this.getIndexReader().leaves()) {
            TopSuggestDocsCollector leafCollector = (TopSuggestDocsCollector)collector.getLeafCollector(context);
            LeafReader reader = context.reader();
            Terms terms = reader.terms(field);
            if (terms == null) continue;
            if (!(terms instanceof CompletionFieldsProducer.CompletionTerms)) {
                throw new IllegalArgumentException(field + " is not a SuggestField");
            }
            CompletionFieldsProducer.CompletionTerms completionTerms = (CompletionFieldsProducer.CompletionTerms)terms;
            NRTSuggester suggester = completionTerms.suggester();
            if (suggester == null) continue;
            DocIdSet docIdSet = null;
            if (filter != null && (docIdSet = filter.getDocIdSet(context, reader.getLiveDocs())) == null) continue;
            suggester.lookup(reader, automaton, num, docIdSet, leafCollector);
        }
    }
}

