/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.suggest.document.CompletionTokenStream;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;

public class SuggestField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private final BytesRef surfaceForm;
    private final long weight;

    public SuggestField(String name, String value, long weight) {
        super(name, value, FIELD_TYPE);
        if (weight < 0L) {
            throw new IllegalArgumentException("weight must be >= 0");
        }
        this.surfaceForm = new BytesRef((CharSequence)value);
        this.weight = weight;
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) throws IOException {
        TokenStream stream = super.tokenStream(analyzer, reuse);
        CompletionTokenStream completionStream = stream instanceof CompletionTokenStream ? (CompletionTokenStream)stream : new CompletionTokenStream(stream);
        BytesRef suggestPayload = this.buildSuggestPayload(this.surfaceForm, this.weight, (char)completionStream.sepLabel());
        completionStream.setPayload(suggestPayload);
        return completionStream;
    }

    private BytesRef buildSuggestPayload(BytesRef surfaceForm, long weight, char sepLabel) throws IOException {
        for (int i = 0; i < surfaceForm.length; ++i) {
            if (surfaceForm.bytes[i] != sepLabel) continue;
            assert (sepLabel == '\u001f');
            throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (OutputStreamDataOutput output = new OutputStreamDataOutput((OutputStream)byteArrayOutputStream);){
            output.writeVInt(surfaceForm.length);
            output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
            output.writeVLong(weight + 1L);
        }
        return new BytesRef(byteArrayOutputStream.toByteArray());
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setStoreTermVectors(false);
        FIELD_TYPE.setOmitNorms(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        FIELD_TYPE.freeze();
    }
}

