/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalQuery;
import org.apache.lucene.search.intervals.IntervalsSource;

abstract class DifferenceIntervalsSource
extends IntervalsSource {
    final IntervalsSource minuend;
    final IntervalsSource subtrahend;

    DifferenceIntervalsSource(IntervalsSource minuend, IntervalsSource subtrahend) {
        this.minuend = minuend;
        this.subtrahend = subtrahend;
    }

    protected abstract IntervalIterator combine(IntervalIterator var1, IntervalIterator var2);

    @Override
    public final IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator minIt = this.minuend.intervals(field, ctx);
        if (minIt == null) {
            return null;
        }
        IntervalIterator subIt = this.subtrahend.intervals(field, ctx);
        if (subIt == null) {
            return minIt;
        }
        return this.combine(minIt, subIt);
    }

    @Override
    public final MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator minIt = this.minuend.matches(field, ctx, doc);
        if (minIt == null) {
            return null;
        }
        MatchesIterator subIt = this.subtrahend.matches(field, ctx, doc);
        if (subIt == null) {
            return minIt;
        }
        IntervalIterator difference = this.combine(IntervalMatches.wrapMatches(minIt, doc), IntervalMatches.wrapMatches(subIt, doc));
        return IntervalMatches.asMatches(difference, minIt, doc);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery q = new IntervalQuery(field, this);
        this.minuend.visit(field, visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)q));
        this.subtrahend.visit(field, visitor.getSubVisitor(BooleanClause.Occur.MUST_NOT, (Query)q));
    }

    @Override
    public int minExtent() {
        return this.minuend.minExtent();
    }
}

