/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.io.InputStream;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsReader;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.script.ScriptFsReader;
import org.apache.linkis.storage.script.ScriptFsReader$;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSplit;
import org.apache.linkis.storage.source.FileSplit$;
import org.apache.linkis.storage.source.ResultsetFileSource;
import org.apache.linkis.storage.source.TextFileSource;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FileSource$ {
    public static final FileSource$ MODULE$;
    private final String[] fileType;
    private final Function2<String, String, Object> org$apache$linkis$storage$source$FileSource$$suffixPredicate;

    static {
        new FileSource$();
    }

    private String[] fileType() {
        return this.fileType;
    }

    public Function2<String, String, Object> org$apache$linkis$storage$source$FileSource$$suffixPredicate() {
        return this.org$apache$linkis$storage$source$FileSource$$suffixPredicate;
    }

    public boolean isResultSet(String path) {
        return BoxesRunTime.unboxToBoolean((Object)this.org$apache$linkis$storage$source$FileSource$$suffixPredicate().apply((Object)path, Predef$.MODULE$.refArrayOps((Object[])this.fileType()).head()));
    }

    public boolean isResultSet(FsPath fsPath) {
        return this.isResultSet(fsPath.getPath());
    }

    public FileSource create(FsPath[] fsPaths, Fs fs) {
        FileSplit[] fileSplits = (FileSplit[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fsPaths).map((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final Fs fs$1;

            public final FileSplit apply(FsPath x$1) {
                return FileSource$.MODULE$.org$apache$linkis$storage$source$FileSource$$createResultSetFileSplit(x$1, this.fs$1);
            }
            {
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileSplit.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileSplit fileSplit) {
                return FileSource$.MODULE$.org$apache$linkis$storage$source$FileSource$$isTableResultSet(fileSplit);
            }
        });
        return new ResultsetFileSource(fileSplits);
    }

    public boolean org$apache$linkis$storage$source$FileSource$$isTableResultSet(FileSplit fileSplit) {
        return fileSplit.type().equals(ResultSetFactory$.MODULE$.TABLE_TYPE());
    }

    public boolean isTableResultSet(FileSource fileSource) {
        return Predef$.MODULE$.refArrayOps((Object[])fileSource.getFileSplits()).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileSplit fileSplit) {
                return FileSource$.MODULE$.org$apache$linkis$storage$source$FileSource$$isTableResultSet(fileSplit);
            }
        });
    }

    public FileSource create(FsPath fsPath, Fs fs) {
        if (this.canRead(fsPath.getPath())) {
            return this.isResultSet(fsPath) ? new ResultsetFileSource((FileSplit[])((Object[])new FileSplit[]{this.org$apache$linkis$storage$source$FileSource$$createResultSetFileSplit(fsPath, fs)})) : new TextFileSource((FileSplit[])((Object[])new FileSplit[]{this.createTextFileSplit(fsPath, fs)}));
        }
        throw new StorageErrorException(54001, "Unsupported open file type(\u4e0d\u652f\u6301\u6253\u5f00\u7684\u6587\u4ef6\u7c7b\u578b)");
    }

    public FileSource create(FsPath fsPath, InputStream is) {
        if (this.canRead(fsPath.getPath())) {
            return this.isResultSet(fsPath) ? new ResultsetFileSource((FileSplit[])((Object[])new FileSplit[]{this.createResultSetFileSplit(fsPath, is)})) : new TextFileSource((FileSplit[])((Object[])new FileSplit[]{this.createTextFileSplit(fsPath, is)}));
        }
        throw new StorageErrorException(54001, "Unsupported open file type(\u4e0d\u652f\u6301\u6253\u5f00\u7684\u6587\u4ef6\u7c7b\u578b)");
    }

    private FileSplit createResultSetFileSplit(FsPath fsPath, InputStream is) {
        ResultSet<? extends MetaData, ? extends Record> resultset = ResultSetFactory$.MODULE$.getInstance().getResultSetByPath(fsPath);
        ResultSetReader<? extends MetaData, ? extends Record> resultsetReader = ResultSetReader$.MODULE$.getResultSetReader(resultset, is);
        return new FileSplit((FsReader<? extends MetaData, ? extends Record>)resultsetReader, resultset.resultSetType());
    }

    public FileSplit org$apache$linkis$storage$source$FileSource$$createResultSetFileSplit(FsPath fsPath, Fs fs) {
        ResultSet<? extends MetaData, ? extends Record> resultset = ResultSetFactory$.MODULE$.getInstance().getResultSetByPath(fsPath, fs);
        ResultSetReader<? extends MetaData, ? extends Record> resultsetReader = ResultSetReader$.MODULE$.getResultSetReader(resultset, fs.read(fsPath));
        return new FileSplit((FsReader<? extends MetaData, ? extends Record>)resultsetReader, resultset.resultSetType());
    }

    private FileSplit createTextFileSplit(FsPath fsPath, InputStream is) {
        ScriptFsReader scriptFsReader = ScriptFsReader$.MODULE$.getScriptFsReader(fsPath, (String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue(), is);
        return new FileSplit(scriptFsReader, FileSplit$.MODULE$.$lessinit$greater$default$2());
    }

    private FileSplit createTextFileSplit(FsPath fsPath, Fs fs) {
        ScriptFsReader scriptFsReader = ScriptFsReader$.MODULE$.getScriptFsReader(fsPath, (String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue(), fs.read(fsPath));
        return new FileSplit(scriptFsReader, FileSplit$.MODULE$.$lessinit$greater$default$2());
    }

    private boolean canRead(String path) {
        return Predef$.MODULE$.refArrayOps((Object[])this.fileType()).exists((Function1)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final boolean apply(String x$2) {
                return BoxesRunTime.unboxToBoolean((Object)FileSource$.MODULE$.org$apache$linkis$storage$source$FileSource$$suffixPredicate().apply((Object)this.path$1, (Object)x$2));
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    private FileSource$() {
        MODULE$ = this;
        this.fileType = (String[])((Object[])new String[]{"dolphin", "sql", "scala", "py", "hql", "python", "out", "log", "text", "sh", "jdbc", "ngql", "psql", "fql"});
        this.org$apache$linkis$storage$source$FileSource$$suffixPredicate = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String path, String suffix) {
                return path.endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
            }
        };
    }
}

