/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.InputStream;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.StorageResultSetReader;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.linkis.storage.resultset.table.TableResultSet;
import scala.runtime.BoxedUnit;

public final class ResultSetReader$ {
    public static final ResultSetReader$ MODULE$;

    static {
        new ResultSetReader$();
    }

    public <K extends MetaData, V extends Record> ResultSetReader<K, V> getResultSetReader(ResultSet<K, V> resultSet, InputStream inputStream) {
        return new StorageResultSetReader<K, V>(resultSet, inputStream);
    }

    public <K extends MetaData, V extends Record> ResultSetReader<K, V> getResultSetReader(ResultSet<K, V> resultSet, String value) {
        return new StorageResultSetReader<K, V>(resultSet, value);
    }

    public ResultSetReader<? extends MetaData, ? extends Record> getResultSetReader(String res) {
        ResultSetReader<? extends MetaData, ? extends Record> resultSetReader;
        ResultSetFactory rsFactory = ResultSetFactory$.MODULE$.getInstance();
        if (rsFactory.isResultSet(res)) {
            ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSet(res);
            resultSetReader = this.getResultSetReader(resultSet, res);
        } else {
            ResultSetReader<? extends MetaData, ? extends Record> reader;
            FsPath resPath = new FsPath(res);
            ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSetByPath(resPath);
            Fs fs = FSFactory$.MODULE$.getFs(resPath);
            fs.init(null);
            ResultSetReader<? extends MetaData, ? extends Record> resultSetReader2 = reader = this.getResultSetReader(resultSet, fs.read(resPath));
            if (resultSetReader2 instanceof StorageResultSetReader) {
                StorageResultSetReader storageResultSetReader = (StorageResultSetReader)resultSetReader2;
                storageResultSetReader.setFs(fs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            resultSetReader = reader;
        }
        return resultSetReader;
    }

    public ResultSetReader<TableMetaData, TableRecord> getTableResultReader(String res) {
        block5: {
            ResultSetReader<TableMetaData, TableRecord> resultSetReader;
            block4: {
                ResultSetFactory rsFactory;
                block2: {
                    block3: {
                        rsFactory = ResultSetFactory$.MODULE$.getInstance();
                        if (!rsFactory.isResultSet(res)) break block2;
                        ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSet(res);
                        String string = ResultSetFactory$.MODULE$.TABLE_TYPE();
                        String string2 = resultSet.resultSetType();
                        if (string != null ? !string.equals(string2) : string2 != null) break block3;
                        resultSetReader = this.getResultSetReader((TableResultSet)resultSet, res);
                        break block4;
                    }
                    throw new StorageErrorException(52002, "Result sets that are not tables are not supported(\u4e0d\u652f\u6301\u4e0d\u662f\u8868\u683c\u7684\u7ed3\u679c\u96c6)");
                }
                FsPath resPath = new FsPath(res);
                ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSetByPath(resPath);
                String string = ResultSetFactory$.MODULE$.TABLE_TYPE();
                String string3 = resultSet.resultSetType();
                if (string != null ? !string.equals(string3) : string3 != null) break block5;
                Fs fs = FSFactory$.MODULE$.getFs(resPath);
                fs.init(null);
                resultSetReader = this.getResultSetReader((TableResultSet)resultSet, fs.read(resPath));
            }
            return resultSetReader;
        }
        throw new StorageErrorException(52002, "Result sets that are not tables are not supported(\u4e0d\u652f\u6301\u4e0d\u662f\u8868\u683c\u7684\u7ed3\u679c\u96c6)");
    }

    private ResultSetReader$() {
        MODULE$ = this;
    }
}

