/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.hadoop.common.utils.HDFSUtils;
import org.apache.linkis.storage.conf.LinkisStorageConf;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFileSystem
extends FileSystem {
    public static final String HDFS_PREFIX_WITHOUT_AUTH = "hdfs:///";
    public static final String HDFS_PREFIX_WITH_AUTH = "hdfs://";
    private org.apache.hadoop.fs.FileSystem fs = null;
    private org.apache.hadoop.conf.Configuration conf = null;
    private String label = null;
    private static final Logger logger = LoggerFactory.getLogger(HDFSFileSystem.class);

    @Override
    public String listRoot() throws IOException {
        return "/";
    }

    @Override
    public long getTotalSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getFreeSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getUsableSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public boolean canExecute(FsPath dest) throws IOException {
        return this.canAccess(dest, FsAction.EXECUTE);
    }

    @Override
    public boolean setOwner(FsPath dest, String user, String group) throws IOException {
        this.fs.setOwner(new Path(this.checkHDFSPath(dest.getPath())), user, group);
        return true;
    }

    @Override
    public boolean setOwner(FsPath dest, String user) throws IOException {
        Path path = new Path(this.checkHDFSPath(dest.getPath()));
        this.fs.setOwner(path, user, this.fs.getFileStatus(path).getGroup());
        return true;
    }

    @Override
    public boolean setGroup(FsPath dest, String group) throws IOException {
        Path path = new Path(this.checkHDFSPath(dest.getPath()));
        this.fs.setOwner(path, this.fs.getFileStatus(path).getOwner(), group);
        return true;
    }

    public boolean mkdir(FsPath dest) throws IOException {
        String path = this.checkHDFSPath(dest.getPath());
        if (!this.canExecute(this.getParentPath(path))) {
            throw new IOException("You have not permission to access path " + path);
        }
        boolean result = this.fs.mkdirs(new Path(path));
        this.setPermission(new FsPath(path), this.getDefaultFolderPerm());
        return result;
    }

    public boolean mkdirs(FsPath dest) throws IOException {
        String path = this.checkHDFSPath(dest.getPath());
        FsPath parentPath = this.getParentPath(path);
        while (!this.exists(parentPath)) {
            parentPath = this.getParentPath(parentPath.getPath());
        }
        if (!this.canExecute(parentPath)) {
            throw new IOException("You have not permission to access path " + path);
        }
        boolean result = this.fs.mkdirs(new Path(path));
        this.setPermission(new FsPath(path), this.getDefaultFolderPerm());
        return result;
    }

    @Override
    public boolean setPermission(FsPath dest, String permission) throws IOException {
        String path = this.checkHDFSPath(dest.getPath());
        if (!this.isOwner(path)) {
            throw new IOException(path + " only can be set by owner.");
        }
        FsAction u = null;
        FsAction g = null;
        FsAction o = null;
        if (StringUtils.isNumeric((String)permission) && permission.length() == 3) {
            u = FsAction.getFsAction((String)FsPath.permissionFormatted((char)permission.charAt(0)));
            g = FsAction.getFsAction((String)FsPath.permissionFormatted((char)permission.charAt(1)));
            o = FsAction.getFsAction((String)FsPath.permissionFormatted((char)permission.charAt(2)));
        } else if (!StringUtils.isNumeric((String)permission) && permission.length() == 9) {
            u = FsAction.getFsAction((String)permission.substring(0, 3));
            g = FsAction.getFsAction((String)permission.substring(3, 6));
            o = FsAction.getFsAction((String)permission.substring(6, 9));
        } else {
            throw new IOException("Incorrent permission string " + permission);
        }
        FsPermission fsPermission = new FsPermission(u, g, o);
        this.fs.setPermission(new Path(path), fsPermission);
        return true;
    }

    @Override
    public FsPathListWithError listPathWithError(FsPath path) throws IOException {
        FileStatus[] stat = this.fs.listStatus(new Path(this.checkHDFSPath(path.getPath())));
        ArrayList<FsPath> fsPaths = new ArrayList<FsPath>();
        for (FileStatus f : stat) {
            fsPaths.add(this.fillStorageFile(new FsPath(StorageUtils.HDFS_SCHEMA() + f.getPath().toUri().getPath()), f));
        }
        if (fsPaths.isEmpty()) {
            return null;
        }
        return new FsPathListWithError(fsPaths, "");
    }

    public void init(Map<String, String> properties) throws IOException {
        if (MapUtils.isNotEmpty(properties) && properties.containsKey(StorageConfiguration.PROXY_USER().key())) {
            this.user = (String)StorageConfiguration.PROXY_USER().getValue(properties);
        }
        if (this.user == null) {
            throw new IOException("User cannot be empty(\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        this.conf = HDFSUtils.getConfigurationByLabel((String)this.user, (String)this.label);
        if (MapUtils.isNotEmpty(properties)) {
            for (String key : properties.keySet()) {
                String v = properties.get(key);
                if (!StringUtils.isNotEmpty((String)v)) continue;
                this.conf.set(key, v);
            }
        }
        if (((Boolean)StorageConfiguration.FS_CACHE_DISABLE().getValue()).booleanValue()) {
            this.conf.set("fs.hdfs.impl.disable.cache", "true");
        }
        this.fs = HDFSUtils.getHDFSUserFileSystem((String)this.user, (org.apache.hadoop.conf.Configuration)this.conf);
        if (this.fs == null) {
            throw new IOException("init HDFS FileSystem failed!");
        }
    }

    public String fsName() {
        return "hdfs";
    }

    public String rootUserName() {
        return (String)StorageConfiguration.HDFS_ROOT_USER().getValue();
    }

    public FsPath get(String dest) throws IOException {
        String realPath = this.checkHDFSPath(dest);
        return this.fillStorageFile(new FsPath(realPath), this.fs.getFileStatus(new Path(realPath)));
    }

    public InputStream read(FsPath dest) throws IOException {
        if (!this.canRead(dest)) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
        return this.fs.open(new Path(dest.getPath()));
    }

    public OutputStream write(FsPath dest, boolean overwrite) throws IOException {
        String path = this.checkHDFSPath(dest.getPath());
        if (!this.exists(dest)) {
            if (!this.canWrite(dest.getParent())) {
                throw new IOException("You have not permission to access path " + dest.getParent());
            }
        } else if (!this.canWrite(dest)) {
            throw new IOException("You have not permission to access path " + path);
        }
        if (!overwrite) {
            return this.fs.append(new Path(path));
        }
        FSDataOutputStream out = this.fs.create(new Path(path), true);
        this.setPermission(dest, this.getDefaultFilePerm());
        return out;
    }

    public boolean create(String dest) throws IOException {
        if (!this.canExecute(this.getParentPath(dest))) {
            throw new IOException("You have not permission to access path " + dest);
        }
        boolean result = this.fs.createNewFile(new Path(this.checkHDFSPath(dest)));
        this.setPermission(new FsPath(dest), this.getDefaultFilePerm());
        return result;
    }

    @Override
    public boolean copy(String origin, String dest) throws IOException {
        if (!this.canExecute(this.getParentPath(dest))) {
            throw new IOException("You have not permission to access path " + dest);
        }
        boolean res = FileUtil.copy((org.apache.hadoop.fs.FileSystem)this.fs, (Path)new Path(this.checkHDFSPath(origin)), (org.apache.hadoop.fs.FileSystem)this.fs, (Path)new Path(this.checkHDFSPath(dest)), (boolean)false, (boolean)true, (org.apache.hadoop.conf.Configuration)this.fs.getConf());
        this.setPermission(new FsPath(dest), this.getDefaultFilePerm());
        return res;
    }

    public List<FsPath> list(FsPath path) throws IOException {
        FileStatus[] stat = this.fs.listStatus(new Path(this.checkHDFSPath(path.getPath())));
        ArrayList<FsPath> fsPaths = new ArrayList<FsPath>();
        for (FileStatus f : stat) {
            fsPaths.add(this.fillStorageFile(new FsPath(f.getPath().toUri().getPath()), f));
        }
        return fsPaths;
    }

    public boolean canRead(FsPath dest) throws IOException {
        return this.canAccess(dest, FsAction.READ);
    }

    public boolean canWrite(FsPath dest) throws IOException {
        return this.canAccess(dest, FsAction.WRITE);
    }

    public boolean exists(FsPath dest) throws IOException {
        try {
            return this.fs.exists(new Path(this.checkHDFSPath(dest.getPath())));
        }
        catch (IOException e) {
            String message = e.getMessage();
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (message != null && message.matches(LinkisStorageConf.HDFS_FILE_SYSTEM_REST_ERRS()) || rootCauseMessage != null && rootCauseMessage.matches(LinkisStorageConf.HDFS_FILE_SYSTEM_REST_ERRS())) {
                logger.info("Failed to execute exists, retry", (Throwable)e);
                this.resetRootHdfs();
                return this.fs.exists(new Path(this.checkHDFSPath(dest.getPath())));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRootHdfs() {
        if (this.fs != null) {
            HDFSFileSystem hDFSFileSystem = this;
            synchronized (hDFSFileSystem) {
                if (this.fs != null) {
                    if (HadoopConf.HDFS_ENABLE_CACHE()) {
                        HDFSUtils.closeHDFSFIleSystem((org.apache.hadoop.fs.FileSystem)this.fs, (String)this.user, (boolean)true);
                    } else {
                        HDFSUtils.closeHDFSFIleSystem((org.apache.hadoop.fs.FileSystem)this.fs, (String)this.user);
                    }
                    logger.warn(this.user + "FS reset close.");
                    this.fs = HDFSUtils.getHDFSUserFileSystem((String)this.user, (org.apache.hadoop.conf.Configuration)this.conf);
                }
            }
        }
    }

    public boolean delete(FsPath dest) throws IOException {
        String path = this.checkHDFSPath(dest.getPath());
        if (!this.isOwner(path)) {
            throw new IOException("You have not permission to delete path " + path);
        }
        return this.fs.delete(new Path(path), true);
    }

    public boolean renameTo(FsPath oldDest, FsPath newDest) throws IOException {
        if (!this.isOwner(this.checkHDFSPath(oldDest.getPath()))) {
            throw new IOException("You have not permission to rename path " + oldDest.getPath());
        }
        return this.fs.rename(new Path(this.checkHDFSPath(oldDest.getPath())), new Path(this.checkHDFSPath(newDest.getPath())));
    }

    public void close() throws IOException {
        if (null != this.fs) {
            HDFSUtils.closeHDFSFIleSystem((org.apache.hadoop.fs.FileSystem)this.fs, (String)this.user);
        } else {
            logger.warn("FS was null, cannot close.");
        }
    }

    private FsPath fillStorageFile(FsPath fsPath, FileStatus fileStatus) throws IOException {
        fsPath.setAccess_time(fileStatus.getAccessTime());
        fsPath.setModification_time(fileStatus.getModificationTime());
        fsPath.setOwner(fileStatus.getOwner());
        fsPath.setGroup(fileStatus.getGroup());
        fsPath.setIsdir(fileStatus.isDirectory());
        try {
            if (fsPath.isdir()) {
                fsPath.setLength(this.fs.getContentSummary(fileStatus.getPath()).getLength());
            } else {
                fsPath.setLength(fileStatus.getLen());
            }
            fsPath.setPermissionString(fileStatus.getPermission().toString());
        }
        catch (Throwable e) {
            logger.error("Failed to fill storage file\uff1a" + fileStatus.getPath(), e);
        }
        return fsPath;
    }

    private boolean canAccess(FsPath fsPath, FsAction access) throws IOException {
        Object[] groupNames;
        String path = this.checkHDFSPath(fsPath.getPath());
        if (!this.exists(fsPath)) {
            throw new IOException("directory or file not exists: " + path);
        }
        FileStatus f = this.fs.getFileStatus(new Path(path));
        FsPermission permission = f.getPermission();
        UserGroupInformation ugi = HDFSUtils.getUserGroupInformation((String)this.user);
        try {
            groupNames = ugi.getGroupNames();
        }
        catch (NullPointerException e) {
            if (((Boolean)Configuration.IS_TEST_MODE().getValue()).booleanValue()) {
                groupNames = new String[]{"hadoop"};
            }
            throw e;
        }
        return this.user.equals(f.getOwner()) || this.user.equals(this.rootUserName()) ? permission.getUserAction().implies(access) : (ArrayUtils.contains((Object[])groupNames, (Object)f.getGroup()) ? permission.getGroupAction().implies(access) : permission.getOtherAction().implies(access));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private String checkHDFSPath(String path) {
        try {
            boolean rmHdfsPrefix;
            boolean checkHdfsPath = (Boolean)StorageConfiguration.HDFS_PATH_PREFIX_CHECK_ON().getValue();
            if (checkHdfsPath && (rmHdfsPrefix = ((Boolean)StorageConfiguration.HDFS_PATH_PREFIX_REMOVE().getValue()).booleanValue())) {
                if (StringUtils.isBlank((String)path)) {
                    return path;
                }
                if (path.startsWith(HDFS_PREFIX_WITHOUT_AUTH)) {
                    int remainIndex = HDFS_PREFIX_WITHOUT_AUTH.length() - 1;
                    if (logger.isDebugEnabled()) {
                        logger.debug("checkHDFSPath  ori path : {}, after path : {}", (Object)path, (Object)path.substring(remainIndex));
                    }
                    return path.substring(remainIndex);
                }
                if (path.startsWith(HDFS_PREFIX_WITH_AUTH)) {
                    int remainIndex = HDFS_PREFIX_WITH_AUTH.length();
                    String[] t1 = path.substring(remainIndex).split("/", 2);
                    if (t1.length != 2) {
                        logger.error("checkHDFSPath Invalid path: " + path);
                        return path;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("checkHDFSPath  ori path : {}, after path : {}", (Object)path, (Object)("/" + t1[1]));
                    }
                    return "/" + t1[1];
                }
                return path;
            }
        }
        catch (Exception e) {
            logger.error("checkHDFSPath error. msg : " + e.getMessage() + " ", (Throwable)e);
        }
        return path;
    }
}

