/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.linkis.storage.excel.ExcelXlsReader;
import org.apache.linkis.storage.excel.FirstRowDeal;
import org.apache.linkis.storage.excel.RowToCsvDeal;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XlsUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<String>> getBasicInfo(InputStream inputStream) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        FirstRowDeal firstRowDeal = new FirstRowDeal();
        try (ExcelXlsReader xlsReader = new ExcelXlsReader();){
            xlsReader.init(firstRowDeal, inputStream);
            xlsReader.process();
        }
        return res;
    }

    public static String excelToCsv(InputStream inputStream, FileSystem fs, Boolean hasHeader, List<String> sheetNames) throws Exception {
        String hdfsPath = "/tmp/" + StorageUtils.getJvmUser() + "/" + System.currentTimeMillis() + ".csv";
        ExcelXlsReader xlsReader = new ExcelXlsReader();
        RowToCsvDeal rowToCsvDeal = new RowToCsvDeal();
        OutputStream out = null;
        try {
            out = fs.create(new Path(hdfsPath));
            rowToCsvDeal.init(hasHeader, sheetNames, out);
            xlsReader.init(rowToCsvDeal, inputStream);
            xlsReader.process();
        }
        catch (IOException e) {
            LOG.error("Failed to excel to csv", (Throwable)e);
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            xlsReader.close();
        }
        return hdfsPath;
    }
}

