/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.linkis.storage.excel.IExcelRowDeal;
import org.apache.poi.hssf.record.BoundSheetRecord;

class RowToCsvDeal
implements IExcelRowDeal {
    private Map<String, Object> params;
    private List<String> sheetNames;
    private OutputStream outputStream;
    private Boolean hasHeader;
    private Boolean fisrtRow = true;

    RowToCsvDeal() {
    }

    public void init(Boolean hasHeader, List<String> sheetNames, OutputStream outputStream) {
        this.hasHeader = hasHeader;
        this.sheetNames = sheetNames;
        this.outputStream = outputStream;
    }

    @Override
    public void dealRow(BoundSheetRecord[] orderedBSRs, int sheetIndex, int curRow, List<String> rowlist) {
        String sheetName = orderedBSRs[sheetIndex].getSheetname();
        if (!(this.sheetNames != null && !this.sheetNames.isEmpty() && !this.sheetNames.contains(sheetName) || curRow == 0 && this.hasHeader.booleanValue())) {
            try {
                if (this.fisrtRow.booleanValue()) {
                    this.fisrtRow = false;
                } else {
                    this.outputStream.write("\n".getBytes());
                }
                int len = rowlist.size();
                for (int i = 0; i < len; ++i) {
                    this.outputStream.write(rowlist.get(i).replaceAll("\n|\t", " ").getBytes("utf-8"));
                    if (i >= len - 1) continue;
                    this.outputStream.write("\t".getBytes());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

