/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label.restful;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.instance.label.entity.InstanceInfo;
import org.apache.linkis.instance.label.service.conf.InstanceConfigration;
import org.apache.linkis.instance.label.service.impl.DefaultInsLabelService;
import org.apache.linkis.instance.label.utils.EntityParser;
import org.apache.linkis.instance.label.vo.InstanceInfoVo;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.UserModifiable;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/microservice"})
public class InstanceRestful {
    private static final Log logger = LogFactory.getLog(InstanceRestful.class);
    private LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    @Autowired
    private DefaultInsLabelService insLabelService;

    @RequestMapping(path={"/allInstance"}, method={RequestMethod.GET})
    public Message listAllInstanceWithLabel(HttpServletRequest req) {
        logger.info((Object)"start to get all instance informations.....");
        List<InstanceInfo> instances = this.insLabelService.listAllInstanceWithLabel();
        this.insLabelService.markInstanceLabel(instances);
        List<InstanceInfoVo> instanceVos = EntityParser.parseToInstanceVo(instances);
        logger.info((Object)("Done, all instance:" + instances));
        return Message.ok().data("instances", instanceVos);
    }

    @RequestMapping(path={"/instanceLabel"}, method={RequestMethod.PUT})
    public Message upDateInstanceLabel(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws Exception {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req);
        String[] adminArray = ((String)InstanceConfigration.GOVERNANCE_STATION_ADMIN().getValue()).split(",");
        if (adminArray != null && !Arrays.asList(adminArray).contains(username)) {
            throw new Exception("only admin can modify instance label(\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u6807\u7b7e)");
        }
        String instanceName = jsonNode.get("instance").asText();
        String instanceType = jsonNode.get("applicationName").asText();
        if (StringUtils.isEmpty((String)instanceName)) {
            return Message.error((String)"instance cannot be empty(\u5b9e\u4f8b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)instanceType)) {
            return Message.error((String)"instance cannot be empty(\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JsonNode labelsNode = jsonNode.get("labels");
        Iterator labelKeyIterator = labelsNode.iterator();
        ServiceInstance instance = ServiceInstance.apply((String)instanceType, (String)instanceName);
        ArrayList<Label> labels = new ArrayList<Label>();
        Set keyList = LabelUtils.listAllUserModifiableLabel();
        HashSet<String> labelKeySet = new HashSet<String>();
        while (labelKeyIterator.hasNext()) {
            JsonNode label = (JsonNode)labelKeyIterator.next();
            String labelKey = label.get("labelKey").asText();
            String labelStringValue = label.get("stringValue").asText();
            if (labelStringValue == null || !keyList.contains(labelKey)) continue;
            Label realLabel = this.labelBuilderFactory.createLabel(labelKey, (Object)labelStringValue);
            if (realLabel instanceof UserModifiable) {
                ((UserModifiable)realLabel).valueCheck(labelStringValue);
            }
            labelKeySet.add(labelKey);
            labels.add(realLabel);
        }
        if (labelKeySet.size() != labels.size()) {
            throw new Exception("Failed to update label, include repeat label(\u66f4\u65b0label\u5931\u8d25\uff0c\u5305\u542b\u91cd\u590dlabel)");
        }
        this.insLabelService.refreshLabelsToInstance(labels, instance);
        InstanceInfo instanceInfo = this.insLabelService.getInstanceInfoByServiceInstance(instance);
        instanceInfo.setUpdateTime(new Date());
        this.insLabelService.updateInstance(instanceInfo);
        return Message.ok((String)"success").data("labels", labels);
    }

    @RequestMapping(path={"/modifiableLabelKey"}, method={RequestMethod.GET})
    public Message listAllModifiableLabelKey(HttpServletRequest req) {
        Set keyList = LabelUtils.listAllUserModifiableLabel();
        return Message.ok().data("keyList", (Object)keyList);
    }

    @RequestMapping(path={"/eurekaURL"}, method={RequestMethod.GET})
    public Message getEurekaURL(HttpServletRequest request) throws Exception {
        String eurekaURL = this.insLabelService.getEurekaURL();
        return Message.ok().data("url", (Object)eurekaURL);
    }
}

