/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient.dws.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.httpclient.authentication.AbstractAuthenticationStrategy;
import org.apache.linkis.httpclient.authentication.Authentication;
import org.apache.linkis.httpclient.authentication.AuthenticationAction;
import org.apache.linkis.httpclient.authentication.AuthenticationResult;
import org.apache.linkis.httpclient.dws.exception.AuthenticationFailedException;
import org.apache.linkis.httpclient.dws.request.DWSAuthenticationAction;
import org.apache.linkis.httpclient.dws.response.DWSAuthenticationResult;
import org.apache.linkis.httpclient.errorcode.LinkisGwHttpclientSupportErrorCodeSummary;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.request.UserAction;
import org.apache.linkis.httpclient.request.UserPwdAction;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001f\ta2\u000b^1uS\u000e\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL(BA\u0002\u0005\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!!\u0002\u0004\u0002\u0007\u0011<8O\u0003\u0002\b\u0011\u0005Q\u0001\u000e\u001e;qG2LWM\u001c;\u000b\u0005%Q\u0011A\u00027j].L7O\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!E\n\u000e\u0003IQ!a\u0001\u0004\n\u0005Q\u0011\"AH!cgR\u0014\u0018m\u0019;BkRDWM\u001c;jG\u0006$\u0018n\u001c8TiJ\fG/Z4z\u0011!1\u0002A!b\u0001\n#:\u0012aE:fgNLwN\\'bq\u0006c\u0017N^3US6,W#\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\t1{gn\u001a\u0005\t?\u0001\u0011\t\u0011)A\u00051\u0005!2/Z:tS>tW*\u0019=BY&4X\rV5nK\u0002BQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012&!\t!\u0003!D\u0001\u0003\u0011\u00151\u0002\u00051\u0001\u0019\u0011\u0015\t\u0003\u0001\"\u0001()\u0005\u0019\u0003bB\u0015\u0001\u0001\u0004%IaF\u0001\u0015g\u0016\u0014h/\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;\t\u000f-\u0002\u0001\u0019!C\u0005Y\u0005A2/\u001a:wKJ\u001cVm]:j_:$\u0016.\\3pkR|F%Z9\u0015\u00055\u0002\u0004CA\r/\u0013\ty#D\u0001\u0003V]&$\bbB\u0019+\u0003\u0003\u0005\r\u0001G\u0001\u0004q\u0012\n\u0004BB\u001a\u0001A\u0003&\u0001$A\u000btKJ4XM]*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000bU\u0002A\u0011\u0001\u001c\u0002/M,GoU3sm\u0016\u00148+Z:tS>tG+[7f_V$HCA\u00178\u0011\u0015IC\u00071\u0001\u0019\u0011\u0015I\u0004\u0001\"\u0001\u0018\u0003]9W\r^*feZ,'oU3tg&|g\u000eV5nK>+H\u000fC\u0003<\u0001\u0011EC(A\u0004hKR,6/\u001a:\u0015\u0005u\"\u0005C\u0001 B\u001d\tIr(\u0003\u0002A5\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001%\u0004C\u0003Fu\u0001\u0007a)A\u0007sKF,Xm\u001d;BGRLwN\u001c\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u001a\tqA]3rk\u0016\u001cH/\u0003\u0002L\u0011\n1\u0011i\u0019;j_:DQ!\u0014\u0001\u0005R9\u000bqcZ3u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0003\u000e$\u0018n\u001c8\u0015\u0007=\u00136\u000b\u0005\u0002\u0012!&\u0011\u0011K\u0005\u0002\u0015\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0003\u000e$\u0018n\u001c8\t\u000b\u0015c\u0005\u0019\u0001$\t\u000bQc\u0005\u0019A\u001f\u0002\u0013M,'O^3s+Jd\u0007\"\u0002,\u0001\t\u0003:\u0016aF4fi\u0006+H\u000f[3oi&\u001c\u0017\r^5p]J+7/\u001e7u)\rA6l\u0019\t\u0003#eK!A\u0017\n\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^5p]J+7/\u001e7u\u0011\u0015aV\u000b1\u0001^\u0003!\u0011Xm\u001d9p]N,\u0007C\u00010b\u001b\u0005y&B\u00011\u000b\u0003\u0011AG\u000f\u001e9\n\u0005\t|&\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0007\"B#V\u0001\u0004y\u0005\"B3\u0001\t\u00032\u0017!C5t)&lWm\\;u)\t9'\u000e\u0005\u0002\u001aQ&\u0011\u0011N\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019A\r1\u0001l!\t\tB.\u0003\u0002n%\tq\u0011)\u001e;iK:$\u0018nY1uS>t\u0007\"B8\u0001\t\u0003\u0002\u0018\u0001D3oM>\u00148-\u001a'pO&tGcA6re\")QI\u001ca\u0001\r\")AK\u001ca\u0001{\u0001")
public class StaticAuthenticationStrategy
extends AbstractAuthenticationStrategy {
    private final long sessionMaxAliveTime;
    private long serverSessionTimeout;

    public long sessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    private long serverSessionTimeout() {
        return this.serverSessionTimeout;
    }

    private void serverSessionTimeout_$eq(long x$1) {
        this.serverSessionTimeout = x$1;
    }

    public void setServerSessionTimeout(long serverSessionTimeout) {
        this.serverSessionTimeout_$eq(serverSessionTimeout);
    }

    public long getServerSessionTimeOut() {
        return this.serverSessionTimeout();
    }

    public String getUser(Action requestAction) {
        Action action;
        Action action2 = requestAction;
        String string = action2 instanceof AuthenticationAction ? null : (action2 instanceof UserAction ? (StringUtils.isBlank((CharSequence)((UserAction)(action = action2)).getUser()) ? this.getClientConfig().getAuthTokenKey() : ((UserAction)action).getUser()) : (StringUtils.isNotBlank((CharSequence)this.getClientConfig().getAuthTokenKey()) ? this.getClientConfig().getAuthTokenKey() : null));
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationAction getAuthenticationAction(Action requestAction, String serverUrl) {
        void var3_3;
        DWSAuthenticationAction action = new DWSAuthenticationAction(serverUrl);
        Action action2 = requestAction;
        if (action2 instanceof UserPwdAction) {
            Action action3 = action2;
            action.addRequestPayload("userName", ((UserAction)action3).getUser());
            action.addRequestPayload("password", ((UserPwdAction)action3).getPassword().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StaticAuthenticationStrategy $outer;

                public final String apply() {
                    return this.$outer.org$apache$linkis$httpclient$dws$authentication$StaticAuthenticationStrategy$$pwd$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (action2 instanceof UserAction) {
            Action action4 = action2;
            action.addRequestPayload("userName", ((UserAction)action4).getUser());
            action.addRequestPayload("password", this.org$apache$linkis$httpclient$dws$authentication$StaticAuthenticationStrategy$$pwd$1());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (StringUtils.isBlank((CharSequence)this.getClientConfig().getAuthTokenKey())) {
                throw new AuthenticationFailedException(LinkisGwHttpclientSupportErrorCodeSummary.AUTHTOKENVALUE_BE_EXISTS.getErrorDesc());
            }
            action.addRequestPayload("userName", this.getClientConfig().getAuthTokenKey());
            action.addRequestPayload("password", this.org$apache$linkis$httpclient$dws$authentication$StaticAuthenticationStrategy$$pwd$1());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationResult getAuthenticationResult(HttpResponse response, AuthenticationAction requestAction) {
        void var3_3;
        DWSAuthenticationResult result = new DWSAuthenticationResult(response, requestAction.serverUrl());
        Object timeout = result.getData().get("sessionTimeOut");
        if (timeout != null) {
            this.setServerSessionTimeout(new StringOps(Predef$.MODULE$.augmentString(timeout.toString())).toLong());
        }
        return var3_3;
    }

    public boolean isTimeout(Authentication authentication) {
        return System.currentTimeMillis() - authentication.getLastAccessTime() >= this.serverSessionTimeout();
    }

    public Authentication enforceLogin(Action requestAction, String serverUrl) {
        String key = this.getKey(requestAction, serverUrl);
        if (key == null) {
            return null;
        }
        String string = key.intern();
        synchronized (string) {
            Authentication authentication = this.tryLogin(requestAction, serverUrl);
            this.putSession(key, authentication);
            Authentication authentication2 = authentication;
            return authentication2;
        }
    }

    public final String org$apache$linkis$httpclient$dws$authentication$StaticAuthenticationStrategy$$pwd$1() {
        if (StringUtils.isNotBlank((CharSequence)this.getClientConfig().getAuthTokenValue())) {
            return this.getClientConfig().getAuthTokenValue();
        }
        throw new AuthenticationFailedException(LinkisGwHttpclientSupportErrorCodeSummary.AUTHTOKENVALUE_BE_EXISTS.getErrorDesc());
    }

    public StaticAuthenticationStrategy(long sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
        this.serverSessionTimeout = sessionMaxAliveTime;
    }

    public StaticAuthenticationStrategy() {
        this(ByteTimeUtils.timeStringAsMs((String)"1h"));
    }
}

