/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"}, ignoreUnknown=true)
public class DataSourceEnv {
    private Long id;
    @NotNull
    private String envName;
    @Size(min=0, max=200)
    private @Size(min=0, max=200) String envDesc;
    @NotNull
    private Long dataSourceTypeId;
    private DataSourceType dataSourceType;
    private Map<String, Object> connectParams = new HashMap<String, Object>();
    @JsonIgnore
    private String parameter;
    private Date createTime;
    private String createUser;
    private Date modifyTime;
    private String modifyUser;
    @JsonIgnore
    private List<DataSourceParamKeyDefinition> keyDefinitions = new ArrayList<DataSourceParamKeyDefinition>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getEnvDesc() {
        return this.envDesc;
    }

    public void setEnvDesc(String envDesc) {
        this.envDesc = envDesc;
    }

    public Map<String, Object> getConnectParams() {
        if (this.connectParams.isEmpty() && StringUtils.isNotBlank((String)this.parameter)) {
            try {
                this.connectParams.putAll((Map)Objects.requireNonNull(Json.fromJson(this.parameter, Map.class, new Class[0])));
            }
            catch (JsonErrorException jsonErrorException) {
                // empty catch block
            }
        }
        return this.connectParams;
    }

    public void setConnectParams(Map<String, Object> connectParams) {
        this.connectParams = connectParams;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Long getDataSourceTypeId() {
        return this.dataSourceTypeId;
    }

    public void setDataSourceTypeId(Long dataSourceTypeId) {
        this.dataSourceTypeId = dataSourceTypeId;
    }

    public List<DataSourceParamKeyDefinition> getKeyDefinitions() {
        return this.keyDefinitions;
    }

    public void setKeyDefinitions(List<DataSourceParamKeyDefinition> keyDefinitions) {
        this.keyDefinitions = keyDefinitions;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }
}

