/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceEnv;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;
import org.apache.linkis.datasourcemanager.common.domain.DatasourceVersion;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"}, ignoreUnknown=true)
public class DataSource {
    private Long id;
    @NotNull
    @Pattern(regexp="^[\\w\\u4e00-\\u9fa5_-]+$")
    private @NotNull @Pattern(regexp="^[\\w\\u4e00-\\u9fa5_-]+$") String dataSourceName;
    @Size(min=0, max=200)
    private @Size(min=0, max=200) String dataSourceDesc;
    @NotNull
    private Long dataSourceTypeId;
    private String createIdentify;
    @NotNull
    private String createSystem;
    private Map<String, Object> connectParams = new HashMap<String, Object>();
    @JsonIgnore
    private String parameter;
    private Long dataSourceEnvId;
    private Date createTime;
    private Date modifyTime;
    private String modifyUser;
    private String createUser;
    private String labels;
    private Long versionId;
    private List<DatasourceVersion> versions = new ArrayList<DatasourceVersion>();
    private Long publishedVersionId;
    private boolean expire;
    private DataSourceType dataSourceType;
    private DataSourceEnv dataSourceEnv;
    @JsonIgnore
    private List<DataSourceParamKeyDefinition> keyDefinitions = new ArrayList<DataSourceParamKeyDefinition>();

    public DataSource() {
        this.createTime = Calendar.getInstance().getTime();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceDesc() {
        return this.dataSourceDesc;
    }

    public void setDataSourceDesc(String dataSourceDesc) {
        this.dataSourceDesc = dataSourceDesc;
    }

    public Long getDataSourceTypeId() {
        return this.dataSourceTypeId;
    }

    public void setDataSourceTypeId(Long dataSourceTypeId) {
        this.dataSourceTypeId = dataSourceTypeId;
    }

    public String getCreateIdentify() {
        return this.createIdentify;
    }

    public void setCreateIdentify(String createIdentify) {
        this.createIdentify = createIdentify;
    }

    public String getCreateSystem() {
        return this.createSystem;
    }

    public void setCreateSystem(String createSystem) {
        this.createSystem = createSystem;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Long getDataSourceEnvId() {
        return this.dataSourceEnvId;
    }

    public void setDataSourceEnvId(Long dataSourceEnvId) {
        this.dataSourceEnvId = dataSourceEnvId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public DataSourceEnv getDataSourceEnv() {
        return this.dataSourceEnv;
    }

    public void setDataSourceEnv(DataSourceEnv dataSourceEnv) {
        this.dataSourceEnv = dataSourceEnv;
    }

    public List<DataSourceParamKeyDefinition> getKeyDefinitions() {
        return this.keyDefinitions;
    }

    public void setKeyDefinitions(List<DataSourceParamKeyDefinition> keyDefinitions) {
        this.keyDefinitions = keyDefinitions;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public Map<String, Object> getConnectParams() {
        if (this.connectParams.isEmpty() && StringUtils.isNotBlank((String)this.parameter)) {
            try {
                this.connectParams.putAll((Map)Objects.requireNonNull(Json.fromJson(this.parameter, Map.class, new Class[0])));
            }
            catch (JsonErrorException jsonErrorException) {
                // empty catch block
            }
        }
        return this.connectParams;
    }

    public void setConnectParams(Map<String, Object> connectParams) {
        this.connectParams = connectParams;
    }

    public List<DatasourceVersion> getVersion() {
        return this.versions;
    }

    public boolean isExpire() {
        return this.expire;
    }

    public void setExpire(boolean expire) {
        this.expire = expire;
    }

    public void setVersions(List<DatasourceVersion> versions) {
        this.versions = versions;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getPublishedVersionId() {
        return this.publishedVersionId;
    }

    public void setPublishedVersionId(Long publishedVersionId) {
        this.publishedVersionId = publishedVersionId;
    }
}

