/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.server.security.SecurityFilter;

public class AuthContext {
    public static CommonVars<String> AUTH_ADMINISTRATOR = CommonVars.apply((String)"wds.linkis.server.dsm.auth.admin", (Object)"hadoop");
    public static final String AUTH_SEPARATOR = ",";
    private static List<String> administrators = new ArrayList<String>();

    public static boolean hasPermission(DataSource dataSource, HttpServletRequest request) {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)request);
        return AuthContext.hasPermission(dataSource, username);
    }

    public static boolean hasPermission(DataSource dataSource, String username) {
        if (Objects.nonNull(dataSource)) {
            String creator = dataSource.getCreateUser();
            return administrators.contains(username) || StringUtils.isNotBlank((String)creator) && username.equals(creator);
        }
        return false;
    }

    public static boolean isAdministrator(String username) {
        return administrators.contains(username);
    }

    static {
        String adminStr = (String)AUTH_ADMINISTRATOR.getValue();
        if (StringUtils.isNotBlank((String)adminStr)) {
            for (String admin : adminStr.split(AUTH_SEPARATOR)) {
                if (!StringUtils.isNotBlank((String)admin)) continue;
                administrators.add(admin);
            }
        }
    }
}

