/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.command;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.admin.InstanceSettings;
import org.apache.karaf.admin.command.AdminCommandSupport;

@Command(scope="admin", name="create", description="Creates a new container instance.")
public class CreateCommand
extends AdminCommandSupport {
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("([a-zA-Z0-9_.-]+[/\\\\]*)");
    @Option(name="-s", aliases={"--ssh-port"}, description="Port number for remote secure shell connection", required=false, multiValued=false)
    int sshPort = 0;
    @Option(name="-r", aliases={"-rr", "--rmi-port", "--rmi-registry-port"}, description="Port number for RMI registry connection", required=false, multiValued=false)
    int rmiRegistryPort = 0;
    @Option(name="-rs", aliases={"--rmi-server-port"}, description="Port number for RMI server connection", required=false, multiValued=false)
    int rmiServerPort = 0;
    @Option(name="-l", aliases={"--location"}, description="Location of the new container instance in the file system", required=false, multiValued=false)
    String location;
    @Option(name="-o", aliases={"--java-opts"}, description="JVM options to use when launching the instance", required=false, multiValued=false)
    String javaOpts;
    @Option(name="-f", aliases={"--feature"}, description="Initial features. This option can be specified multiple times to enable multiple initial features", required=false, multiValued=true)
    List<String> features;
    @Option(name="-furl", aliases={"--featureURL"}, description="Additional feature descriptor URLs. This option can be specified multiple times to add multiple URLs", required=false, multiValued=true)
    List<String> featureURLs;
    @Option(name="-tr", aliases={"--text-resource"}, description="Add a text resource to the instance", required=false, multiValued=true)
    List<String> textResourceLocation;
    @Option(name="-br", aliases={"--binary-resource"}, description="Add a text resource to the instance", required=false, multiValued=true)
    List<String> binaryResourceLocations;
    @Option(name="-a", aliases={"--adderss"}, description="IP address of the new container instance running on(When Virtual IP is used)", required=false, multiValued=false)
    String address = "0.0.0.0";
    @Argument(index=0, name="name", description="The name of the new container instance", required=true, multiValued=false)
    String instance = null;

    protected Object doExecute() throws Exception {
        Map<String, URL> textResources = CreateCommand.getResources(this.textResourceLocation);
        Map<String, URL> binaryResources = CreateCommand.getResources(this.binaryResourceLocations);
        InstanceSettings settings = new InstanceSettings(this.sshPort, this.rmiRegistryPort, this.rmiServerPort, this.location, this.javaOpts, this.featureURLs, this.features, textResources, binaryResources, this.address);
        this.getAdminService().createInstance(this.instance, settings);
        return null;
    }
}

