/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.tools.MessageInfo;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\u0012%\t%B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0001\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007]\u0002\u0001\u000b\u0011\u00022\t\u000f=\u0004!\u0019!C\u0005a\"9\u00111\u0001\u0001!\u0002\u0013\t\b\u0002CA\u0003\u0001\t\u0007I\u0011\u00029\t\u000f\u0005\u001d\u0001\u0001)A\u0005c\"I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001fAq!a\u0007\u0001A\u0003&Q\nC\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002\f!I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011\u0006\u0005\b\u0003[\u0001\u0001\u0015)\u0003N\u0011%\ty\u0003\u0001a\u0001\n\u0013\tY\u0001C\u0005\u00022\u0001\u0001\r\u0011\"\u0003\u00024!9\u0011q\u0007\u0001!B\u0013i\u0005\"CA\u001d\u0001\u0001\u0007I\u0011BA\u001e\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0004\u0002D\u0001\u0001\u000b\u0015B\u001f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA'\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u001f\u0002A\u0011AA&\u0011\u001d\t\t\u0006\u0001C\u0005\u0003\u000fBq!a\u0015\u0001\t\u0013\t9\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u00111\u000e\u0001\u0005\u0002\u00055$!\u0004*fa2L7-\u0019\"vM\u001a,'O\u0003\u0002&M\u0005)Ao\\8mg*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cQj\u0011A\r\u0006\u0003g\u0019\nQ!\u001e;jYNL!!\u000e\u001a\u0003\u000f1{wmZ5oO\u0006\tS\r\u001f9fGR,GMU3qY&\u001c\u0017m\u001d)feR{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0001hO\u001fI\u001b\u0005I$B\u0001\u001e-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003ye\u00121!T1q!\tqd)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003O\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011qi\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tY\u0013*\u0003\u0002KY\t\u0019\u0011J\u001c;\u0002\u001d%t\u0017\u000e^5bY>3gm]3ugB!\u0001hO\u001fN!\tYc*\u0003\u0002PY\t!Aj\u001c8h\u0003M)\u0007\u0010]3di\u0016$g*^7GKR\u001c\u0007.\u001a:t\u00039\u0011X\r]8si&sG/\u001a:wC2\fa\u0001P5oSRtD#\u0002+W/bK\u0006CA+\u0001\u001b\u0005!\u0003\"\u0002\u001c\u0006\u0001\u00049\u0004\"B&\u0006\u0001\u0004a\u0005\"\u0002)\u0006\u0001\u0004A\u0005\"B)\u0006\u0001\u0004i\u0015A\u00044fi\u000eDwJ\u001a4tKRl\u0015\r]\u000b\u00029B!\u0011'X\u001fN\u0013\tq&G\u0001\u0003Q_>d\u0017a\u00044fi\u000eDwJ\u001a4tKRl\u0015\r\u001d\u0011\u0002\u0019I,7m\u001c:eg\u000e\u000b7\r[3\u0016\u0003\t\u0004B!M/>GB!\u0011'\u0018%e!\t)7N\u0004\u0002gS6\tqM\u0003\u0002i\u007f\u00059Q.Z:tC\u001e,\u0017B\u00016h\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0003Y6\u0014Q\u0002U1si&$\u0018n\u001c8ECR\f'B\u00016h\u00035\u0011XmY8sIN\u001c\u0015m\u00195fA\u0005qa-\u001a;dQ\u0016\u0014()\u0019:sS\u0016\u0014X#A9\u0011\u0007I\\X0D\u0001t\u0015\t!X/\u0001\u0004bi>l\u0017n\u0019\u0006\u0003m^\f!bY8oGV\u0014(/\u001a8u\u0015\tA\u00180\u0001\u0003vi&d'\"\u0001>\u0002\t)\fg/Y\u0005\u0003yN\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0003}~l\u0011!^\u0005\u0004\u0003\u0003)(AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u0010M\u0016$8\r[3s\u0005\u0006\u0014(/[3sA\u0005\u0019b/\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\u0006!b/\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\u0002\na\u0002\\1tiJ+\u0007o\u001c:u)&lW-F\u0001N\u0003Ia\u0017m\u001d;SKB|'\u000f\u001e+j[\u0016|F%Z9\u0015\t\u0005E\u0011q\u0003\t\u0004W\u0005M\u0011bAA\u000bY\t!QK\\5u\u0011!\tIbDA\u0001\u0002\u0004i\u0015a\u0001=%c\u0005yA.Y:u%\u0016\u0004xN\u001d;US6,\u0007\u0005K\u0002\u0011\u0003?\u00012aKA\u0011\u0013\r\t\u0019\u0003\f\u0002\tm>d\u0017\r^5mK\u00061Q.\u0019=MC\u001e\f!\"\\1y\u0019\u0006<w\fJ3r)\u0011\t\t\"a\u000b\t\u0011\u0005e!#!AA\u00025\u000bq!\\1y\u0019\u0006<\u0007%\u0001\tpM\u001a\u001cX\r^,ji\"l\u0015\r\u001f'bO\u0006!rN\u001a4tKR<\u0016\u000e\u001e5NCbd\u0015mZ0%KF$B!!\u0005\u00026!A\u0011\u0011D\u000b\u0002\u0002\u0003\u0007Q*A\tpM\u001a\u001cX\r^,ji\"l\u0015\r\u001f'bO\u0002\nq#\\1y\u0019\u0006<Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0016\u0003u\n1$\\1y\u0019\u0006<Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\t\u0003\u0003B\u0001\"!\u0007\u0019\u0003\u0003\u0005\r!P\u0001\u0019[\u0006DH*Y4U_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\u0013aF2sK\u0006$XMT3x\r\u0016$8\r[3s\u0005\u0006\u0014(/[3s)\t\t\t\"A\thKR4U\r^2iKJ\u0014\u0015M\u001d:jKJ$\u0012!`\u0001\u001dGJ,\u0017\r^3OK^4VM]5gS\u000e\fG/[8o\u0005\u0006\u0014(/[3s\u0003Y9W\r\u001e,fe&4\u0017nY1uS>t')\u0019:sS\u0016\u0014\u0018AC5oSRL\u0017\r\\5{K\u0006\t2/\u001a;J]&$\u0018.\u00197PM\u001a\u001cX\r^:\u0002\u001d\u0005$GMR3uG\",G\rR1uCRA\u0011\u0011CA-\u0003;\n\t\u0007\u0003\u0004\u0002\\\u0001\u0002\r!P\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007BBA0A\u0001\u0007\u0001*A\u0005sKBd\u0017nY1JI\"1\u00111\r\u0011A\u0002\u0011\fQ\u0002]1si&$\u0018n\u001c8ECR\f\u0017!C4fi>3gm]3u)\ri\u0015\u0011\u000e\u0005\u0007\u00037\n\u0003\u0019A\u001f\u0002\u001dY,'/\u001b4z\u0007\",7m[*v[R!\u0011\u0011CA8\u0011\u001d\t\tH\ta\u0001\u0003g\nq\u0001\u001d:j]Rdg\u000eE\u0004,\u0003k\nI(!\u0005\n\u0007\u0005]DFA\u0005Gk:\u001cG/[8ocA!\u00111PAE\u001d\u0011\ti(!\"\u0011\u0007\u0005}D&\u0004\u0002\u0002\u0002*\u0019\u00111\u0011\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\t9\tL\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0015Q\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dE\u0006")
public class ReplicaBuffer
implements Logging {
    private final Map<TopicPartition, Object> expectedReplicasPerTopicPartition;
    private final Map<TopicPartition, Object> initialOffsets;
    private final int expectedNumFetchers;
    private final long reportInterval;
    private final Pool<TopicPartition, Object> fetchOffsetMap;
    private final Pool<TopicPartition, Pool<Object, FetchResponseData.PartitionData>> recordsCache;
    private final AtomicReference<CountDownLatch> fetcherBarrier;
    private final AtomicReference<CountDownLatch> verificationBarrier;
    private volatile long lastReportTime;
    private long maxLag;
    private long offsetWithMaxLag;
    private TopicPartition maxLagTopicAndPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Pool<TopicPartition, Object> fetchOffsetMap() {
        return this.fetchOffsetMap;
    }

    private Pool<TopicPartition, Pool<Object, FetchResponseData.PartitionData>> recordsCache() {
        return this.recordsCache;
    }

    private AtomicReference<CountDownLatch> fetcherBarrier() {
        return this.fetcherBarrier;
    }

    private AtomicReference<CountDownLatch> verificationBarrier() {
        return this.verificationBarrier;
    }

    private long lastReportTime() {
        return this.lastReportTime;
    }

    private void lastReportTime_$eq(long x$1) {
        this.lastReportTime = x$1;
    }

    private long maxLag() {
        return this.maxLag;
    }

    private void maxLag_$eq(long x$1) {
        this.maxLag = x$1;
    }

    private long offsetWithMaxLag() {
        return this.offsetWithMaxLag;
    }

    private void offsetWithMaxLag_$eq(long x$1) {
        this.offsetWithMaxLag = x$1;
    }

    private TopicPartition maxLagTopicAndPartition() {
        return this.maxLagTopicAndPartition;
    }

    private void maxLagTopicAndPartition_$eq(TopicPartition x$1) {
        this.maxLagTopicAndPartition = x$1;
    }

    public void createNewFetcherBarrier() {
        this.fetcherBarrier().set(new CountDownLatch(this.expectedNumFetchers));
    }

    public CountDownLatch getFetcherBarrier() {
        return this.fetcherBarrier().get();
    }

    public void createNewVerificationBarrier() {
        this.verificationBarrier().set(new CountDownLatch(1));
    }

    public CountDownLatch getVerificationBarrier() {
        return this.verificationBarrier().get();
    }

    private void initialize() {
        this.expectedReplicasPerTopicPartition.keySet().foreach((Function1 & Serializable)topicPartition -> this.recordsCache().put((TopicPartition)topicPartition, new Pool(None$.MODULE$)));
        this.setInitialOffsets();
    }

    private void setInitialOffsets() {
        this.initialOffsets.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaBuffer.$anonfun$setInitialOffsets$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)ReplicaBuffer.$anonfun$setInitialOffsets$2(this, x$5)));
    }

    public void addFetchedData(TopicPartition topicAndPartition, int replicaId, FetchResponseData.PartitionData partitionData) {
        this.recordsCache().get(topicAndPartition).put(BoxesRunTime.boxToInteger((int)replicaId), partitionData);
    }

    public long getOffset(TopicPartition topicAndPartition) {
        return BoxesRunTime.unboxToLong((Object)this.fetchOffsetMap().get(topicAndPartition));
    }

    public void verifyCheckSum(Function1<String, BoxedUnit> println) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Begin verification");
        this.maxLag_$eq(-1L);
        this.recordsCache().withFilter((Function1<Tuple2<TopicPartition, Pool<Object, FetchResponseData.PartitionData>>, Object>)(Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaBuffer.$anonfun$verifyCheckSum$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$8 -> {
            ReplicaBuffer.$anonfun$verifyCheckSum$3(this, println, x$8);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = Time.SYSTEM.milliseconds();
        if (currentTimeMs - this.lastReportTime() > this.reportInterval) {
            println.apply((Object)new StringBuilder(57).append(ReplicaVerificationTool$.MODULE$.dateFormat().format(new Date(currentTimeMs))).append(": max lag is ").append(this.maxLag()).append(" for partition ").append(this.maxLagTopicAndPartition()).append(" at offset ").append(this.offsetWithMaxLag()).append(" among ").append(this.recordsCache().size()).append(" partitions").toString());
            this.lastReportTime_$eq(currentTimeMs);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$setInitialOffsets$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ long $anonfun$setInitialOffsets$2(ReplicaBuffer $this, Tuple2 x$5) {
        if (x$5 != null) {
            TopicPartition tp = (TopicPartition)x$5._1();
            long offset = x$5._2$mcJ$sp();
            return BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().put(tp, BoxesRunTime.boxToLong((long)offset)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyCheckSum$2(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$verifyCheckSum$8(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$verifyCheckSum$9(ReplicaBuffer $this, Pool fetchResponsePerReplica$1, BooleanRef isMessageInAllReplicas$1, ObjectRef messageInfoFromFirstReplicaOpt$1, Function1 println$1, TopicPartition topicPartition$1, Tuple2 x$7) {
        if (x$7 != null) {
            block9: {
                int replicaId = x$7._1$mcI$sp();
                Iterator recordBatchIterator = (Iterator)x$7._2();
                try {
                    if (recordBatchIterator.hasNext()) {
                        RecordBatch batch = (RecordBatch)recordBatchIterator.next();
                        if (batch.lastOffset() >= ((FetchResponseData.PartitionData)fetchResponsePerReplica$1.get(BoxesRunTime.boxToInteger((int)replicaId))).highWatermark()) {
                            isMessageInAllReplicas$1.elem = false;
                            break block9;
                        }
                        Option option = (Option)messageInfoFromFirstReplicaOpt$1.elem;
                        if (None$.MODULE$.equals(option)) {
                            messageInfoFromFirstReplicaOpt$1.elem = new Some((Object)new MessageInfo(replicaId, batch.lastOffset(), batch.nextOffset(), batch.checksum()));
                            break block9;
                        }
                        if (option instanceof Some) {
                            MessageInfo messageInfoFromFirstReplica = (MessageInfo)((Some)option).value();
                            if (messageInfoFromFirstReplica.offset() != batch.lastOffset()) {
                                println$1.apply((Object)new StringBuilder(65).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(": replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s offset ").append(messageInfoFromFirstReplica.offset()).append(" doesn't match replica ").append(replicaId).append("'s offset ").append(batch.lastOffset()).toString());
                                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
                            }
                            if (messageInfoFromFirstReplica.checksum() != batch.checksum()) {
                                BoxedUnit cfr_ignored_0 = (BoxedUnit)println$1.apply((Object)new StringBuilder(90).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(" has unmatched checksum at offset ").append(batch.lastOffset()).append("; replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s checksum ").append(messageInfoFromFirstReplica.checksum()).append("; replica ").append(replicaId).append("'s checksum ").append(batch.checksum()).toString());
                            }
                            break block9;
                        }
                        throw new MatchError((Object)option);
                    }
                    isMessageInAllReplicas$1.elem = false;
                    return;
                }
                catch (Throwable t) {
                    throw new RuntimeException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error in processing replica %d in partition %s at offset %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicPartition$1, $this.fetchOffsetMap().get(topicPartition$1)})), t);
                }
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckSum$3(ReplicaBuffer $this, Function1 println$1, Tuple2 x$8) {
        if (x$8 != null) {
            TopicPartition topicPartition = (TopicPartition)x$8._1();
            Pool fetchResponsePerReplica = (Pool)x$8._2();
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Verifying ").append(topicPartition).toString());
            Predef$.MODULE$.assert(fetchResponsePerReplica.size() == BoxesRunTime.unboxToInt((Object)$this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)), (Function0 & Serializable)() -> new StringBuilder(46).append("fetched ").append(fetchResponsePerReplica.size()).append(" replicas for ").append(topicPartition).append(", but expected ").append($this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)).append(" replicas").toString());
            Iterable recordBatchIteratorMap = (Iterable)fetchResponsePerReplica.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int replicaId = x0$1._1$mcI$sp();
                    FetchResponseData.PartitionData fetchResponse = (FetchResponseData.PartitionData)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId)), FetchResponse.recordsOrFail((FetchResponseData.PartitionData)fetchResponse).batches().iterator());
                }
                throw new MatchError(null);
            });
            long maxHw = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)fetchResponsePerReplica.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.highWatermark()))).max((Ordering)Ordering.Long$.MODULE$));
            BooleanRef isMessageInAllReplicas = BooleanRef.create((boolean)true);
            while (isMessageInAllReplicas.elem) {
                ObjectRef messageInfoFromFirstReplicaOpt = ObjectRef.create((Object)None$.MODULE$);
                recordBatchIteratorMap.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaBuffer.$anonfun$verifyCheckSum$8(check$ifrefutable$3))).foreach((Function1 & Serializable)x$7 -> {
                    ReplicaBuffer.$anonfun$verifyCheckSum$9($this, fetchResponsePerReplica, isMessageInAllReplicas, messageInfoFromFirstReplicaOpt, println$1, topicPartition, x$7);
                    return BoxedUnit.UNIT;
                });
                if (!isMessageInAllReplicas.elem) continue;
                long nextOffset = ((MessageInfo)((Option)messageInfoFromFirstReplicaOpt.elem).get()).nextOffset();
                $this.fetchOffsetMap().put(topicPartition, BoxesRunTime.boxToLong((long)nextOffset));
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append($this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)).append(" replicas match at offset ").append(nextOffset).append(" for ").append(topicPartition).toString());
            }
            if (maxHw - BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)) > $this.maxLag()) {
                $this.offsetWithMaxLag_$eq(BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)));
                $this.maxLag_$eq(maxHw - $this.offsetWithMaxLag());
                $this.maxLagTopicAndPartition_$eq(topicPartition);
            }
            fetchResponsePerReplica.clear();
            return;
        }
        throw new MatchError(null);
    }

    public ReplicaBuffer(Map<TopicPartition, Object> expectedReplicasPerTopicPartition, Map<TopicPartition, Object> initialOffsets, int expectedNumFetchers, long reportInterval) {
        this.expectedReplicasPerTopicPartition = expectedReplicasPerTopicPartition;
        this.initialOffsets = initialOffsets;
        this.expectedNumFetchers = expectedNumFetchers;
        this.reportInterval = reportInterval;
        this.fetchOffsetMap = new Pool(None$.MODULE$);
        this.recordsCache = new Pool(None$.MODULE$);
        this.fetcherBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(expectedNumFetchers));
        this.verificationBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.lastReportTime = Time.SYSTEM.milliseconds();
        this.maxLag = -1L;
        this.offsetWithMaxLag = -1L;
        this.maxLagTopicAndPartition = null;
        this.initialize();
    }
}

