/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t=r!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"B1\u0002\t\u0003\u0011g!\u0002\u0016\"\u0001\u0005-\u0001BCA\n\u000b\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011QD\u0003\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u0015RA!A!\u0002\u0013\t9\u0003\u0003\u0006\u0002.\u0015\u0011\t\u0011)A\u0005\u0003_A!\"!\u000e\u0006\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\t9%\u0002B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003+*!\u0011!Q\u0001\n\u0005]\u0003BCA/\u000b\t\u0005\t\u0015!\u0003\u0002`!Q\u00111N\u0003\u0003\u0006\u0004%I!!\u001c\t\u0015\u0005}TA!A!\u0002\u0013\ty\u0007\u0003\u0006\u0002\u0002\u0016\u0011\t\u0011)A\u0005\u0003\u0007C!\"a$\u0006\u0005\u0003\u0005\u000b\u0011BAB\u0011\u0019AT\u0001\"\u0001\u0002\u0012\"A1/\u0002b\u0001\n\u0003\tY\u000bC\u0004\u0002.\u0016\u0001\u000b\u0011\u0002;\t\u0013\u0005=V\u00011A\u0005\u0002\u0005E\u0006\"CA]\u000b\u0001\u0007I\u0011AA^\u0011!\t9-\u0002Q!\n\u0005M\u0006\"CAe\u000b\t\u0007I\u0011AAf\u0011!\t)/\u0002Q\u0001\n\u00055\u0007bBAt\u000b\u0011\u0005\u0013\u0011\u001e\u0005\b\u0003_,A\u0011IAy\u0011\u001d\tI0\u0002C\u0001\u0003wDqA!\u0003\u0006\t\u0003\u0011Y\u0001C\u0004\u0003&\u0015!IAa\n\t\u000f\t%R\u0001\"\u0003\u0003,\u00059\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d\u0006\u0003E\r\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003I\u0015\naa]3sm\u0016\u0014(\"\u0001\u0014\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0011&A\u0007\u0002C\t9\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM]\n\u0004\u00031\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024m5\tAG\u0003\u00026K\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001&A\u0007hKR$v\u000e]5d\t\u0016dG/\u0019\u000b\u0005y);F\fE\u0002.{}J!A\u0010\u0018\u0003\r=\u0003H/[8o!\t\u0001\u0005*D\u0001B\u0015\t\u00115)A\u0003j[\u0006<WM\u0003\u0002'\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tI\u0015I\u0001\u0006U_BL7\rR3mi\u0006DQaS\u0002A\u00021\u000b\u0011\u0002^8qS\u000et\u0015-\\3\u0011\u00055#fB\u0001(S!\tye&D\u0001Q\u0015\t\tv%\u0001\u0004=e>|GOP\u0005\u0003':\na\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111K\f\u0005\u00061\u000e\u0001\r!W\u0001\t]\u0016<\u0018*\\1hKB\u0011\u0001IW\u0005\u00037\u0006\u0013Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007\"B/\u0004\u0001\u0004q\u0016!\u00023fYR\f\u0007C\u0001!`\u0013\t\u0001\u0017IA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u0014M&tGm\u0015;sCf\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005GJ<H\u0010E\u0002eS2t!!Z4\u000f\u0005=3\u0017\"A\u0018\n\u0005!t\u0013a\u00029bG.\fw-Z\u0005\u0003U.\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003Q:\u0002\"!\u001c9\u000e\u00039T!a\\\"\u0002\r\r|W.\\8o\u0013\t\thN\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000bM$\u0001\u0019\u0001;\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"!L;\n\u0005Yt#aA%oi\")\u0001\u0010\u0002a\u0001s\u0006qa.Z<U_BL7m]%nC\u001e,\u0007C\u0001!{\u0013\tY\u0018IA\u0006U_BL7m]%nC\u001e,\u0007\"B?\u0005\u0001\u0004q\u0018\u0001\u00027pON\u00042\u0001Z5\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003K\u0005\u0019An\\4\n\t\u0005%\u00111\u0001\u0002\u000b+:Lg-[3e\u0019><7#B\u0003-\u0003\u001b\u0011\u0004cA\u0015\u0002\u0010%\u0019\u0011\u0011C\u0011\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/\u0001\u0003d_:4\u0007\u0003BA\f\u00033i\u0011aI\u0005\u0004\u00037\u0019#aC&bM.\f7i\u001c8gS\u001e\fQ\"\\3uC\u0012\fG/Y\"bG\",\u0007cA\u0015\u0002\"%\u0019\u00111E\u0011\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000bY><W*\u00198bO\u0016\u0014\b\u0003BA\u0001\u0003SIA!a\u000b\u0002\u0004\tQAj\\4NC:\fw-\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011qCA\u0019\u0013\r\t\u0019d\t\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u0005\u0005S%A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA#\u0003w\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB!\u00111JA)\u001b\t\tiE\u0003\u0003\u0002P\u0005}\u0012a\u0003;sC:\u001c\u0018m\u0019;j_:LA!a\u0015\u0002N\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\u000edY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fE\u0002*\u00033J1!a\u0017\"\u0005i\u0019E.[3oiF+x\u000e^1NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003U!\u0017P\\1nS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7feN\u0004b!TA1\u0019\u0006\u0015\u0014bAA2-\n\u0019Q*\u00199\u0011\t\u0005]\u0011qM\u0005\u0004\u0003S\u001a#!D\"p]\u001aLw\rS1oI2,'/A\u0006`CV$\bn\u001c:ju\u0016\u0014XCAA8!\u0011iS(!\u001d\u0011\t\u0005M\u00141P\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005\u0011\u001a\u0015\u0002BA?\u0003k\u0012!\"Q;uQ>\u0014\u0018N_3s\u00031y\u0016-\u001e;i_JL'0\u001a:!\u0003E1\u0017\r^1m\r\u0006,H\u000e\u001e%b]\u0012dWM\u001d\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*!\u0011\u0011RA=\u0003\u00151\u0017-\u001e7u\u0013\u0011\ti)a\"\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0002=5,G/\u00193bi\u0006\u0004VO\u00197jg\"Lgn\u001a$bk2$\b*\u00198eY\u0016\u0014H\u0003GAJ\u0003+\u000b9*!'\u0002\u001c\u0006u\u0015qTAQ\u0003G\u000b)+a*\u0002*B\u0011\u0011&\u0002\u0005\b\u0003'\u0011\u0002\u0019AA\u000b\u0011\u001d\tiB\u0005a\u0001\u0003?Aq!!\n\u0013\u0001\u0004\t9\u0003C\u0004\u0002.I\u0001\r!a\f\t\u000f\u0005U\"\u00031\u0001\u00028!9\u0011q\t\nA\u0002\u0005%\u0003bBA+%\u0001\u0007\u0011q\u000b\u0005\b\u0003;\u0012\u0002\u0019AA0\u0011\u001d\tYG\u0005a\u0001\u0003_Bq!!!\u0013\u0001\u0004\t\u0019\tC\u0004\u0002\u0010J\u0001\r!a!\u0016\u0003Q\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001b}3\u0017N]:u!V\u0014G.[:i+\t\t\u0019\fE\u0002.\u0003kK1!a./\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u00184jeN$\b+\u001e2mSNDw\fJ3r)\u0011\ti,a1\u0011\u00075\ny,C\u0002\u0002B:\u0012A!\u00168ji\"I\u0011Q\u0019\f\u0002\u0002\u0003\u0007\u00111W\u0001\u0004q\u0012\n\u0014AD0gSJ\u001cH\u000fU;cY&\u001c\b\u000eI\u0001\u0016aV\u0014G.[:iK\u0012|eMZ:fi\u0006#x.\\5d+\t\ti\r\u0005\u0003\u0002P\u0006\u0005XBAAi\u0015\u0011\t\u0019.!6\u0002\r\u0005$x.\\5d\u0015\u0011\t9.!7\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\\\u0006u\u0017\u0001B;uS2T!!a8\u0002\t)\fg/Y\u0005\u0005\u0003G\f\tN\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fa\u0003];cY&\u001c\b.\u001a3PM\u001a\u001cX\r^!u_6L7\rI\u0001\baV\u0014G.[:i)\u0019\ti,a;\u0002n\")QL\u0007a\u0001=\")\u0001L\u0007a\u00013\u0006y\u0001/\u001e2mSNDW\rZ(gMN,G/\u0006\u0002\u0002tB\u0019Q&!>\n\u0007\u0005]hF\u0001\u0003M_:<\u0017!\n:fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0011\ti,!@\t\u000f\u0005}H\u00041\u0001\u0003\u0002\u0005)\u0001O]8qgB!!1\u0001B\u0003\u001b\t\tI.\u0003\u0003\u0003\b\u0005e'A\u0003)s_B,'\u000f^5fg\u0006\tR\u000f\u001d3bi\u0016\u001cun\u001c:eS:\fGo\u001c:\u0015\u0019\u0005u&Q\u0002B\b\u0005#\u0011\u0019B!\b\t\u000b\tk\u0002\u0019A-\t\u000buk\u0002\u0019\u00010\t\u000b-k\u0002\u0019\u0001'\t\u000f\tUQ\u00041\u0001\u0003\u0018\u0005AQ\r\\3di&|g\u000eE\u0004.\u00053!H/!0\n\u0007\tmaFA\u0005Gk:\u001cG/[8oe!9!qD\u000fA\u0002\t\u0005\u0012a\u0003:fg&<g.\u0019;j_:\u0004\u0002\"\fB\ri\n\r\u0012Q\u0018\t\u0004[u\"\u0018AE5oSRL\u0017\r\\5{K6\u000bg.Y4feN$\"!!0\u0002A\u0019Lg.[:i\u0013:LG/[1mSjLgn\u001a*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0005\u0003{\u0013i\u0003C\u0003Y?\u0001\u0007\u0011\f")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final Option<Authorizer> _authorizer;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final int brokerId;
    private boolean _firstPublish;
    private final AtomicLong publishedOffsetAtomic;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<UnifiedLog> logs) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, newTopicsImage, logs);
    }

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public AtomicLong publishedOffsetAtomic() {
        return this.publishedOffsetAtomic;
    }

    @Override
    public void publish(MetadataDelta delta, MetadataImage newImage) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$4(this, highestOffsetAndEpoch, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> $this.groupCoordinator.onElection(offsetTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)offsetTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable)configsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$14(this, newImage, deltaName, configsDelta);
                    return BoxedUnit.UNIT;
                });
                try {
                    Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                        this.clientQuotaMetadataManager.update(clientQuotasDelta);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(32).append("Error updating client ").append("quotas in ").append(deltaName).toString(), t);
                }
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable)aclsDelta -> {
                    Authorizer authorizer;
                    Option<Authorizer> option = this._authorizer();
                    if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
                        ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
                        if (aclsDelta.isSnapshotDelta()) {
                            try {
                                clusterMetadataAuthorizer.loadSnapshot(newImage.acls().acls());
                                return BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                return $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(37).append("Error loading ").append("authorizer snapshot in ").append(deltaName).toString(), t);
                            }
                        }
                        try {
                            aclsDelta.changes().entrySet().forEach(e -> {
                                if (((Optional)e.getValue()).isPresent()) {
                                    clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (StandardAcl)((Optional)e.getValue()).get());
                                    return;
                                }
                                clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
                            });
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(36).append("Error loading ").append("authorizer changes in ").append(deltaName).toString(), t);
                        }
                    }
                    return BoxedUnit.UNIT;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
                this.publishedOffsetAtomic().set(newImage.highestOffsetAndEpoch().offset);
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    @Override
    public long publishedOffset() {
        return this.publishedOffsetAtomic().get();
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        try {
            Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
            if (strayPartitions.nonEmpty()) {
                this.replicaManager.deleteStrayReplicas(strayPartitions);
            }
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error deleting stray partitions during startup", t);
        }
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$publish$4(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion.featureLevel()).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString()));
    }

    public static final /* synthetic */ void $anonfun$publish$14(BrokerMetadataPublisher $this, MetadataImage newImage$1, String deltaName$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            block13: {
                block16: {
                    Properties props;
                    block15: {
                        String string;
                        String string2;
                        block14: {
                            props = newImage$1.configs().configProperties(resource);
                            ConfigResource.Type type = resource.type();
                            if (ConfigResource.Type.TOPIC.equals(type)) {
                                try {
                                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Updating topic ").append(resource.name()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                                    ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Topic())).processConfigChanges(resource.name(), props);
                                    return;
                                }
                                catch (Throwable t) {
                                    $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(50).append("Error updating topic ").append(resource.name()).append(" with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                                    return;
                                }
                            }
                            if (!ConfigResource.Type.BROKER.equals(type)) break block13;
                            if (resource.name().isEmpty()) {
                                try {
                                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Updating cluster configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                                    ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
                                    return;
                                }
                                catch (Throwable t) {
                                    $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(51).append("Error updating ").append("cluster with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                                    return;
                                }
                            }
                            string2 = resource.name();
                            string = Integer.toString($this.brokerId());
                            if (string2 != null) break block14;
                            if (string != null) {
                                return;
                            }
                            break block15;
                        }
                        if (!string2.equals(string)) break block16;
                    }
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Updating broker ").append($this.brokerId()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                        ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(resource.name(), props);
                        $this.reloadUpdatedFilesWithoutConfigChange(props);
                        return;
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(50).append("Error updating ").append("broker with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                        return;
                    }
                }
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, Map<String, ConfigHandler> dynamicConfigHandlers, Option<Authorizer> _authorizer, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this._authorizer = _authorizer;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.publishedOffsetAtomic = new AtomicLong(-1L);
    }
}

