/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.admin.BrokerMetadata;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001B\u0016-\u0001MB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0015\")a\n\u0001C\u0001\u001f\"9!\u000b\u0001a\u0001\n\u0013\u0019\u0006bB0\u0001\u0001\u0004%I\u0001\u0019\u0005\u0007M\u0002\u0001\u000b\u0015\u0002+\t\u000f-\u0004!\u0019!C\u0005Y\"11\u000f\u0001Q\u0001\n5DQ\u0001\u001e\u0001\u0005\nUDq!a\r\u0001\t\u0003\t)\u0004C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\n\u0003c\u0004\u0011\u0013!C\u0001\u0003gD\u0011B!\u0003\u0001#\u0003%\t!a=\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\u000f\u0001\u0011\u0005#q\u0004\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005kAqA!\u000f\u0001\t\u0003\u0012Y\u0004C\u0004\u0003:\u0001!IAa\u0014\t\u000f\tM\u0003\u0001\"\u0011\u0003V!9!1\f\u0001\u0005B\tu\u0003b\u0002B2\u0001\u0011\u0005#Q\r\u0005\b\u0005{\u0002A\u0011\tB@\u0011\u001d\u0011)\t\u0001C!\u0005\u000fCqAa$\u0001\t\u0003\u0012\t\nC\u0004\u0003\u0016\u0002!\tEa&\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\"9!\u0011\u0016\u0001\u0005B\t-\u0006b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\b\u0005w\u0003A\u0011\u0002B_\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007DqA!5\u0001\t\u0003\u0011\u0019\u000eC\u0004\u0003V\u0002!\tAa6\t\u000f\tu\u0007\u0001\"\u0011\u0003`\"9!Q\u001c\u0001\u0005B\t\r\bb\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005_\u0004A\u0011\tBy\u0011\u001d\u00199\u0001\u0001C\u0001\u0007\u0013\u0011!c\u0013*bMRlU\r^1eCR\f7)Y2iK*\u0011QFL\u0001\t[\u0016$\u0018\rZ1uC*\u0011q\u0006M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\nQa[1gW\u0006\u001c\u0001aE\u0003\u0001iirD\t\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003wqj\u0011AL\u0005\u0003{9\u0012Q\"T3uC\u0012\fG/Y\"bG\",\u0007CA C\u001b\u0005\u0001%BA!1\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u00153U\"\u0001\u0017\n\u0005\u001dc#\u0001E\"p]\u001aLwMU3q_NLGo\u001c:z\u0003!\u0011'o\\6fe&#W#\u0001&\u0011\u0005UZ\u0015B\u0001'7\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\na\u0001P5oSRtDC\u0001)R!\t)\u0005\u0001C\u0003I\u0007\u0001\u0007!*A\u0007`GV\u0014(/\u001a8u\u00136\fw-Z\u000b\u0002)B\u0011Q+X\u0007\u0002-*\u0011q\u000bW\u0001\u0006S6\fw-\u001a\u0006\u0003ceS!AW.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0016aA8sO&\u0011aL\u0016\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002#}\u001bWO\u001d:f]RLU.Y4f?\u0012*\u0017\u000f\u0006\u0002bIB\u0011QGY\u0005\u0003GZ\u0012A!\u00168ji\"9Q-BA\u0001\u0002\u0004!\u0016a\u0001=%c\u0005qqlY;se\u0016tG/S7bO\u0016\u0004\u0003F\u0001\u0004i!\t)\u0014.\u0003\u0002km\tAao\u001c7bi&dW-A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003aB\n!bY8oiJ|G\u000e\\3s\u0013\t\u0011xNA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA\u0005AR.Y=cK\u001aKG\u000e^3s\u00032Lg/\u001a*fa2L7-Y:\u0015\u0013Y\fI!a\u0003\u0002\u0016\u0005%\u0002cA<}}6\t\u0001P\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\t1K7\u000f\u001e\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019A_\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\b\u0005\u0005!aB%oi\u0016<WM\u001d\u0005\u0006/&\u0001\r\u0001\u0016\u0005\b\u0003\u001bI\u0001\u0019AA\b\u0003\u001d\u0011'o\\6feN\u0004B!NA\t\u0015&\u0019\u00111\u0003\u001c\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005]\u0011\u00021\u0001\u0002\u001a\u0005aA.[:uK:,'OT1nKB!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012a\u00028fi^|'o\u001b\u0006\u0004\u0003GA\u0016AB2p[6|g.\u0003\u0003\u0002(\u0005u!\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBA\u0016\u0013\u0001\u0007\u0011QF\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\t\u0004k\u0005=\u0012bAA\u0019m\t9!i\\8mK\u0006t\u0017\u0001D2veJ,g\u000e^%nC\u001e,G#\u0001+\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8NKR\fG-\u0019;b)1\tY$a \u0002\u0002\u0006U\u0015qSAN!\u0015)\u0014QHA!\u0013\r\tyD\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005\r\u00131KA-\u001d\u0011\t)%a\u0014\u000f\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u00133\u0003\u0019a$o\\8u}%\tq'C\u0002\u0002RY\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002V\u0005]#\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005Ec\u0007\u0005\u0003\u0002\\\u0005ed\u0002BA/\u0003grA!a\u0018\u0002p9!\u0011\u0011MA7\u001d\u0011\t\u0019'a\u001b\u000f\t\u0005\u0015\u0014\u0011\u000e\b\u0005\u0003\u000f\n9'C\u0001]\u0013\tQ6,\u0003\u000223&\u0019\u00111\u0005-\n\t\u0005E\u0014\u0011E\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t)(a\u001e\u0002)5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,G)\u0019;b\u0015\u0011\t\t(!\t\n\t\u0005m\u0014Q\u0010\u0002\u001a\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u0002v\u0005]\u0004\"B,\f\u0001\u0004!\u0006bBAB\u0017\u0001\u0007\u0011QQ\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004B!a\"\u0002\u0010:!\u0011\u0011RAF!\r\t9EN\u0005\u0004\u0003\u001b3\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\u0006M%AB*ue&twMC\u0002\u0002\u000eZBq!a\u0006\f\u0001\u0004\tI\u0002C\u0004\u0002\u001a.\u0001\r!!\f\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\b\u0003;[\u0001\u0019AA\u0017\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0002%\u001d,Go\u00144gY&tWMU3qY&\u001c\u0017m\u001d\u000b\bm\u0006\r\u0016QUAZ\u0011\u00159F\u00021\u0001U\u0011\u001d\t9\u000b\u0004a\u0001\u0003S\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\u0005-\u0016qV\u0007\u0003\u0003[S!!\f-\n\t\u0005E\u0016Q\u0016\u0002\u0016!\u0006\u0014H/\u001b;j_:\u0014VmZ5tiJ\fG/[8o\u0011\u001d\t9\u0002\u0004a\u0001\u00033\t\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\u0005e\u00161YAc\u0003\u0013\u0004R!NA\u001f\u0003w\u0003B!!0\u0002@6\u0011\u0011\u0011E\u0005\u0005\u0003\u0003\f\tC\u0001\u0003O_\u0012,\u0007\"B,\u000e\u0001\u0004!\u0006BBAd\u001b\u0001\u0007!*\u0001\u0002jI\"9\u0011qC\u0007A\u0002\u0005e\u0011\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\ty-!9\u0002l\u00065\u0018q\u001e\t\u0007\u0003#\f9.a7\u000e\u0005\u0005M'bAAkm\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00171\u001b\u0002\u0004'\u0016\f\b\u0003BA.\u0003;LA!a8\u0002~\t)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c\u0007bBAr\u001d\u0001\u0007\u0011Q]\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005E\u0017q]AC\u0013\u0011\tI/a5\u0003\u0007M+G\u000fC\u0004\u0002\u00189\u0001\r!!\u0007\t\u0013\u0005ee\u0002%AA\u0002\u00055\u0002\"CAO\u001dA\u0005\t\u0019AA\u0017\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t)P\u000b\u0003\u0002.\u0005]8FAA}!\u0011\tYP!\u0002\u000e\u0005\u0005u(\u0002BA\u0000\u0005\u0003\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\ra'\u0001\u0006b]:|G/\u0019;j_:LAAa\u0002\u0002~\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\u0005\u0015\u0018AE4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N$BAa\u0005\u0003\u001cA1\u0011\u0011[At\u0005+\u0001B!!0\u0003\u0018%!!\u0011DA\u0011\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a!\u0013\u0001\u0004\t))\u0001\u0006hKR$v\u000e]5d\u0013\u0012$BA!\t\u0003(A!\u0011Q\u0018B\u0012\u0013\u0011\u0011)#!\t\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003\u0007\u001b\u0002\u0019AAC\u000319W\r\u001e+pa&\u001cg*Y7f)\u0011\u0011iCa\f\u0011\u000bU\ni$!\"\t\u000f\tEB\u00031\u0001\u0003\"\u00059Ao\u001c9jG&#\u0017A\u00045bg\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u0003[\u00119\u0004C\u0003I+\u0001\u0007!*A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t)\t\u0011i\u0004\u0005\u0004\u0002D\t}\"1I\u0005\u0005\u0005\u0003\n9F\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\u0011)Ea\u0013\u000e\u0005\t\u001d#b\u0001B%a\u0005)\u0011\rZ7j]&!!Q\nB$\u00059\u0011%o\\6fe6+G/\u00193bi\u0006$BA!\u0010\u0003R!)qk\u0006a\u0001)\u0006\u0011r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3f)\u0019\tILa\u0016\u0003Z!)\u0001\n\u0007a\u0001\u0015\"9\u0011q\u0003\rA\u0002\u0005e\u0011aE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016\u001cH\u0003\u0002B0\u0005C\u0002b!!5\u0002X\u0006m\u0006bBA\f3\u0001\u0007\u0011\u0011D\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$bAa\u001a\u0003x\te\u0004#B\u001b\u0002>\t%\u0004\u0003\u0002B6\u0005crA!!\u0018\u0003n%!!qNA<\u0003e)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR$\u0015\r^1\n\t\tM$Q\u000f\u0002\u001d+B$\u0017\r^3NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\u0011y'a\u001e\t\u000f\u0005\r%\u00041\u0001\u0002\u0006\"1!1\u0010\u000eA\u0002)\u000b1\u0002]1si&$\u0018n\u001c8JI\u0006ia.^7QCJ$\u0018\u000e^5p]N$BA!!\u0003\u0004B!Q'!\u0010K\u0011\u001d\t\u0019i\u0007a\u0001\u0003\u000b\u000bq\u0002^8qS\u000et\u0015-\\3t)>LEm\u001d\u000b\u0003\u0005\u0013\u0003ra\u001eBF\u0003\u000b\u0013\t#C\u0002\u0003\u000eb\u00141!T1q\u0003=!x\u000e]5d\u0013\u0012\u001cHk\u001c(b[\u0016\u001cHC\u0001BJ!\u001d9(1\u0012B\u0011\u0003\u000b\u000b1\u0002^8qS\u000eLE-\u00138g_R\u0011!\u0011\u0014\t\bk\tm%\u0011\u0012BJ\u0013\r\u0011iJ\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\u0005e&1\u0015BS\u0005OCq!a! \u0001\u0004\t)\t\u0003\u0004\u0003|}\u0001\rA\u0013\u0005\b\u0003/y\u0002\u0019AA\r\u0003q9W\r\u001e)beRLG/[8o%\u0016\u0004H.[2b\u000b:$\u0007o\\5oiN$bA!,\u00032\nU\u0006cBAD\u0005_S\u00151X\u0005\u0005\u0005\u001b\u000b\u0019\nC\u0004\u00034\u0002\u0002\rA!\u0006\u0002\u0005Q\u0004\bbBA\fA\u0001\u0007\u0011\u0011D\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JIV\u0011!\u0011Q\u0001\u0015O\u0016$(+\u00198e_6\fE.\u001b<f\u0005J|7.\u001a:\u0015\t\t\u0005%q\u0018\u0005\u0006/\n\u0002\r\u0001V\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003F\n-'q\u001a\t\u0005\u0003{\u00139-\u0003\u0003\u0003J\u0006\u0005\"aB\"mkN$XM\u001d\u0005\b\u0005\u001b\u001c\u0003\u0019AAC\u0003%\u0019G.^:uKJLE\rC\u0004\u0002\u0018\r\u0002\r!!\u0007\u0002/M$\u0018\r^3DQ\u0006tw-\u001a+sC\u000e,WI\\1cY\u0016$GCAA\u0017\u0003MawnZ*uCR,7\t[1oO\u0016$&/Y2f)\r\t'\u0011\u001c\u0005\b\u00057,\u0003\u0019AAC\u0003\r\u0019HO]\u0001\tG>tG/Y5ogR!\u0011Q\u0006Bq\u0011\u001d\t\u0019I\na\u0001\u0003\u000b#B!!\f\u0003f\"9!1W\u0014A\u0002\tU\u0011\u0001C:fi&k\u0017mZ3\u0015\u0007\u0005\u0014Y\u000f\u0003\u0004\u0003n\"\u0002\r\u0001V\u0001\t]\u0016<\u0018*\\1hK\u000611m\u001c8gS\u001e$BAa=\u0003zB\u0019qO!>\n\u0007\t]\bP\u0001\u0006Qe>\u0004XM\u001d;jKNDqAa?*\u0001\u0004\u0011i0\u0001\bd_:4\u0017n\u001a*fg>,(oY3\u0011\t\t}81A\u0007\u0003\u0007\u0003QAAa<\u0002\"%!1QAB\u0001\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\fA\u0003Z3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cH\u0003BB\u0006\u0007'\u0001Ba!\u0004\u0004\u00105\u0011\u0011qO\u0005\u0005\u0007#\t9H\u0001\u0011EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fgB|gn]3ECR\f\u0007bBB\u000bU\u0001\u00071qC\u0001\be\u0016\fX/Z:u!\u0011\u0019ia!\u0007\n\t\rm\u0011q\u000f\u0002 \t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;ECR\f\u0007")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.intArrayOps(partition.replicas))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.intArrayOps(partition.isr))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$3 -> x$3.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$4 -> x$4.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getAliveBrokers$1(x$6)))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(b.rack()))));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).flatMap((Function1 & Serializable)x$7 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$7.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getAliveBrokerNodes$1(x$8)))).flatMap((Function1 & Serializable)x$9 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$9.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> new Some(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch)));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<Map<String, Uuid>, Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(result, image, listenerName, topic);
            return BoxedUnit.UNIT;
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.size() == 0) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$3, ArrayList offlineReplicas$1, ListenerName listenerName$3, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if (broker.fenced() || !broker.listeners().containsKey(listenerName$3.value())) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokers$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokerNodes$1(BrokerRegistration x$8) {
        return !x$8.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ Option $anonfun$getPartitionReplicaEndpoints$3(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, int x0$2) {
        Node node;
        Integer n = BoxesRunTime.boxToInteger((int)x0$2);
        Option option = Option$.MODULE$.apply((Object)image$5.cluster().broker(x0$2));
        if (None$.MODULE$.equals(option)) {
            node = Node.noNode();
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            node = (Node)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName$8.value()))).getOrElse((Function0 & Serializable)() -> Node.noNode());
        } else {
            throw new MatchError((Object)option);
        }
        return result$1.put((Object)n, (Object)node);
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, TopicImage topic) {
        topic.partitions().values().forEach(x0$1 -> ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x0$1.replicas), (Function1 & Serializable)x0$2 -> KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$3(result$1, image$5, listenerName$8, BoxesRunTime.unboxToInt((Object)x0$2)), ClassTag$.MODULE$.apply(Option.class)));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

