/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.api.KAFKA_2_8_IV0$;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.api.KAFKA_3_1_IV0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005b\u0001\u0002\u001f>\u0001\tC\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"I!\f\u0001B\u0001B\u0003%1,\u0019\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aa\r\u0001B\u0001B\u0003%q\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011!q\u0007A!A!\u0002\u0013y\u0007\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u0003\u001fAq!a\u0007\u0001\t\u0003\ti\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!9\u0011\u0011\b\u0001!\u0002\u00131\u0006\"CA\u001e\u0001\t\u0007I\u0011BA\u001f\u0011!\t)\u0005\u0001Q\u0001\n\u0005}\u0002\"CA$\u0001\t\u0007I\u0011BA%\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0001BCA'\u0001\t\u0007I\u0011A\u001f\u0002P!A\u0011q\u000b\u0001!\u0002\u0013\t\t\u0006\u0003\u0006\u0002Z\u0001\u0011\r\u0011\"\u0001>\u0003\u001fB\u0001\"a\u0017\u0001A\u0003%\u0011\u0011\u000b\u0005\u000b\u0003;\u0002!\u0019!C\u0001{\u0005=\u0003\u0002CA0\u0001\u0001\u0006I!!\u0015\t\u0013\u0005\u0005\u0004A1A\u0005\n\u0005\r\u0004\u0002CA;\u0001\u0001\u0006I!!\u001a\t\u0013\u0005]\u0004A1A\u0005\n\u0005\r\u0004\u0002CA=\u0001\u0001\u0006I!!\u001a\t\u0013\u0005m\u0004A1A\u0005\n\u0005\r\u0004\u0002CA?\u0001\u0001\u0006I!!\u001a\t\u0013\u0005}\u0004A1A\u0005\n\u0005\r\u0004\u0002CAA\u0001\u0001\u0006I!!\u001a\t\u0013\u0005\r\u0005A1A\u0005R\u0005\u0015\u0005\u0002CAG\u0001\u0001\u0006I!a\"\t\u0013\u0005=\u0005A1A\u0005R\u0005\u0015\u0005\u0002CAI\u0001\u0001\u0006I!a\"\t\u0013\u0005M\u0005A1A\u0005\u0002\u0005U\u0005\u0002CAR\u0001\u0001\u0006I!a&\t\u000f\u0005\u0015\u0006\u0001\"\u0015\u0002(\"9\u0011q\u0017\u0001\u0005R\u0005e\u0006bBAb\u0001\u0011E\u0013Q\u0019\u0005\b\u0003\u0013\u0004A\u0011KAf\u0011\u001d\tY\u000e\u0001C!\u0003;Dq!a8\u0001\t\u0003\n\t\u000fC\u0004\u0002j\u0002!\t%a;\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!1\u0005\u0001\u0005R\t\u0015\u0002b\u0002B&\u0001\u0011E#Q\n\u0005\b\u0005+\u0002A\u0011\u000bB,\u0011\u001d\u0011i\u0006\u0001C\u0005\u0005?BqA!\u001b\u0001\t\u0003\u0012Y\u0007C\u0004\u0003\u0018\u0002!\tE!'\t\u000f\t%\u0006\u0001\"\u0015\u0003,\"9!1\u0017\u0001\u0005B\tU\u0006b\u0002Bv\u0001\u0011%!Q\u001e\u0005\u000e\u0005o\u0004\u0001\u0013aA\u0001\u0002\u0013%!\u0011`1\b\u0013\tmX(!A\t\u0002\tuh\u0001\u0003\u001f>\u0003\u0003E\tAa@\t\u000f\u0005m\u0011\b\"\u0001\u0004\b!I1\u0011B\u001d\u0012\u0002\u0013\u000511\u0002\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u000b\u0005yz\u0014AB:feZ,'OC\u0001A\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\"\u0011\u0005\u0011+U\"A\u001f\n\u0005\u0019k$!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\r\u0005\u0002J%:\u0011!\n\u0015\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u0006\u000ba\u0001\u0010:p_Rt$\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es\u0015A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015(\u0002\u0013\u0019,Go\u00195fe&#\u0007CA,Y\u001b\u0005q\u0015BA-O\u0005\rIe\u000e^\u0001\rg>,(oY3Ce>\\WM\u001d\t\u00039~k\u0011!\u0018\u0006\u0003=~\nqa\u00197vgR,'/\u0003\u0002a;\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018B\u0001.F\u00031\u0011'o\\6fe\u000e{gNZ5h!\t!E-\u0003\u0002f{\tY1*\u00194lC\u000e{gNZ5h\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000f\u0005\u0002EQ&\u0011\u0011.\u0010\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f!B]3qY&\u001c\u0017-T4s!\t!E.\u0003\u0002n{\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018aB7fiJL7m\u001d\t\u0003afl\u0011!\u001d\u0006\u0003]JT!a\u001d;\u0002\r\r|W.\\8o\u0015\t\u0001UO\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>r\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u0019Q0!\u0001\u000e\u0003yT!a :\u0002\u000bU$\u0018\u000e\\:\n\u0007\u0005\raP\u0001\u0003US6,\u0017!B9v_R\f\u0007c\u0001#\u0002\n%\u0019\u00111B\u001f\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u000251,\u0017\rZ3s\u000b:$\u0007o\\5oi\ncwnY6j]\u001e\u001cVM\u001c3\u0011\u000b]\u000b\t\"!\u0006\n\u0007\u0005MaJ\u0001\u0004PaRLwN\u001c\t\u0004\t\u0006]\u0011bAA\r{\ta!\t\\8dW&twmU3oI\u00061A(\u001b8jiz\"b#a\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\tY#!\f\u00020\u0005E\u00121\u0007\t\u0003\t\u0002AQaR\u0006A\u0002!CQ!V\u0006A\u0002YCQAW\u0006A\u0002mCQAY\u0006A\u0002\rDQAZ\u0006A\u0002\u001dDQA[\u0006A\u0002-DQA\\\u0006A\u0002=DQa_\u0006A\u0002qDq!!\u0002\f\u0001\u0004\t9\u0001C\u0005\u0002\u000e-\u0001\n\u00111\u0001\u0002\u0010\u0005I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002-\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0002@A\u0019Q0!\u0011\n\u0007\u0005\rcP\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005qA.Z1eKJ,e\u000e\u001a9pS:$XCAA\u000b\u0003=aW-\u00193fe\u0016sG\r]8j]R\u0004\u0013a\u00054fi\u000eD'+Z9vKN$h+\u001a:tS>tWCAA)!\r9\u00161K\u0005\u0004\u0003+r%!B*i_J$\u0018\u0001\u00064fi\u000eD'+Z9vKN$h+\u001a:tS>t\u0007%\u0001\u0012pM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e,feNLwN\\\u0001$_\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8!\u0003aa\u0017n\u001d;PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e,feNLwN\\\u0001\u001aY&\u001cHo\u00144gg\u0016$(+Z9vKN$h+\u001a:tS>t\u0007%A\u0004nCb<\u0016-\u001b;\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0005Y\u0006twM\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\u0011\t\u0019(!\u001b\u0003\u000f%sG/Z4fe\u0006AQ.\u0019=XC&$\b%\u0001\u0005nS:\u0014\u0015\u0010^3t\u0003%i\u0017N\u001c\"zi\u0016\u001c\b%\u0001\u0005nCb\u0014\u0015\u0010^3t\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b%A\u0005gKR\u001c\u0007nU5{K\u0006Qa-\u001a;dQNK'0\u001a\u0011\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0002\bB\u0019q+!#\n\u0007\u0005-eJA\u0004C_>dW-\u00198\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e\u0003uI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013a\u00054fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014XCAAL!\u0011\tI*a(\u000e\u0005\u0005m%bAAOi\u000691\r\\5f]R\u001c\u0018\u0002BAQ\u00037\u00131CR3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\fACZ3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\u0004\u0013a\u00037bi\u0016\u001cH/\u00129pG\"$B!!+\u0002,B!q+!\u0005W\u0011\u001d\tiK\na\u0001\u0003_\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u00022\u0006MV\"\u0001:\n\u0007\u0005U&O\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u00111XAa!\r9\u0016QX\u0005\u0004\u0003\u007fs%\u0001\u0002'p]\u001eDq!!,(\u0001\u0004\ty+\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002<\u0006\u001d\u0007bBAWQ\u0001\u0007\u0011qV\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBAg\u0003+\f9\u000eE\u0003X\u0003#\ty\rE\u0002E\u0003#L1!a5>\u00059yeMZ:fi\u0006sG-\u00129pG\"Dq!!,*\u0001\u0004\ty\u000b\u0003\u0004\u0002Z&\u0002\rAV\u0001\u0006KB|7\r[\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!a\"\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o)\t\t\u0019\u000fE\u0002X\u0003KL1!a:O\u0005\u0011)f.\u001b;\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\ti/a?\u0002~\n\u0005\u0001#B,\u0002\u0012\u0005=\b\u0003BAy\u0003ol!!a=\u000b\u0007\u0005Ux(A\u0002m_\u001eLA!!?\u0002t\niAj\\4BaB,g\u000eZ%oM>Dq!!,-\u0001\u0004\ty\u000bC\u0004\u0002\u00002\u0002\r!a/\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0005\u0007a\u0003\u0019\u0001B\u0003\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!q\u0001B\u0005\u001b\u0005\u0001\u0011b\u0001B\u0006\u000b\nIa)\u001a;dQ\u0012\u000bG/Y\u0001\u001c[\u0006L(-Z,be:Lem\u0014<feNL'0\u001a3SK\u000e|'\u000fZ:\u0015\r\u0005\r(\u0011\u0003B\u0011\u0011\u001d\u0011\u0019\"\fa\u0001\u0005+\tqA]3d_J$7\u000f\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\r\u0011YB]\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t}!\u0011\u0004\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\u00055V\u00061\u0001\u00020\u0006ya-\u001a;dQ\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0003\u0003(\tM\u0002\u0003\u0003B\u0015\u0005_\tyK!\u0002\u000e\u0005\t-\"b\u0001B\u0017\u001d\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE\"1\u0006\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u001b]\u0001\u0007!qG\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0005s\u0011)E\u0004\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\r\u0011yD]\u0001\te\u0016\fX/Z:ug&!!1\tB\u001f\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u00119E!\u0013\u0003\u000f\t+\u0018\u000e\u001c3fe*!!1\tB\u001f\u0003u1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBA^\u0005\u001f\u0012\t\u0006C\u0004\u0002.>\u0002\r!a,\t\r\tMs\u00061\u0001W\u0003I\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\tYL!\u0017\u0003\\!9\u0011Q\u0016\u0019A\u0002\u0005=\u0006B\u0002B*a\u0001\u0007a+A\u000bgKR\u001c\u0007n\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\u0011\u0005m&\u0011\rB2\u0005KBq!!,2\u0001\u0004\ty\u000b\u0003\u0004\u0003TE\u0002\rA\u0016\u0005\b\u0005O\n\u0004\u0019AA^\u0003A)\u0017M\u001d7jKN$xJ\u001d'bi\u0016\u001cH/\u0001\u0006ck&dGMR3uG\"$BA!\u001c\u0003\fB1!q\u000eB?\u0005\u0007sAA!\u001d\u0003z9!!1\u000fB<\u001d\rY%QO\u0005\u0002\u0001&\u0011ahP\u0005\u0004\u0005wj\u0014!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0005\u007f\u0012\tI\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0005wj\u0004#B,\u0002\u0012\t\u0015\u0005\u0003\u0002B8\u0005\u000fKAA!#\u0003\u0002\na!+\u001a9mS\u000e\fg)\u001a;dQ\"9!Q\u0012\u001aA\u0002\t=\u0015\u0001\u00049beRLG/[8o\u001b\u0006\u0004\b\u0003\u0003B\u0015\u0005_\tyK!%\u0011\u0007\u0011\u0013\u0019*C\u0002\u0003\u0016v\u00121\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0007\u0003G\u0014YJa(\t\u000f\tu5\u00071\u0001\u00020\u0006\u0011A\u000f\u001d\u0005\b\u0005C\u001b\u0004\u0019\u0001BR\u0003UygMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\u00042\u0001\u0012BS\u0013\r\u00119+\u0010\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002d\n5&q\u0016\u0005\b\u0003[#\u0004\u0019AAX\u0011\u001d\u0011\t\f\u000ea\u0001\u0003w\u000baa\u001c4gg\u0016$\u0018\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u00038\n}\u0007\u0003\u0003B\u0015\u0005_\tyK!/\u0011\t\tm&\u0011\u001c\b\u0005\u0005{\u0013\u0019N\u0004\u0003\u0003@\n=g\u0002\u0002Ba\u0005\u001btAAa1\u0003L:!!Q\u0019Be\u001d\rY%qY\u0005\u0002q&\u0011ao^\u0005\u0003\u0001VL!a\u001d;\n\u0007\tE'/A\u0004nKN\u001c\u0018mZ3\n\t\tU'q[\u0001!\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKN\u0004xN\\:f\t\u0006$\u0018MC\u0002\u0003RJLAAa7\u0003^\nqQ\t]8dQ\u0016sGm\u00144gg\u0016$(\u0002\u0002Bk\u0005/DqA!96\u0001\u0004\u0011\u0019/\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002B!\u000b\u00030\u0005=&Q\u001d\t\u0005\u0005\u000f\u00119/C\u0002\u0003j\u0016\u0013\u0011\"\u00129pG\"$\u0015\r^1\u0002-MDw.\u001e7e\r>dGn\\<feRC'o\u001c;uY\u0016$\u0002\"a\"\u0003p\nE(Q\u001f\u0005\b\u0003\u000b1\u0004\u0019AA\u0004\u0011\u001d\u0011\u0019P\u000ea\u0001\u0005#\u000b!BZ3uG\"\u001cF/\u0019;f\u0011\u001d\tiK\u000ea\u0001\u0003_\u000b!c];qKJ$3o\\;sG\u0016\u0014%o\\6feV\t1,\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\t\u0003\tf\u001a2!OB\u0001!\r961A\u0005\u0004\u0007\u000bq%AB!osJ+g\r\u0006\u0002\u0003~\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TCAB\u0007U\u0011\tyaa\u0004,\u0005\rE\u0001\u0003BB\n\u0007;i!a!\u0006\u000b\t\r]1\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u0007O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007?\u0019)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean isTruncationOnFetchSupported;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$10() {
        return None$.MODULE$;
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark());
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LeaderOffsetIncremented$.MODULE$);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
            return;
        }
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        FetchResponse fetchResponse = (FetchResponse)clientResponse2.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse2.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return (Map)Map$.MODULE$.empty();
        }
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse2.requestHeader().apiVersion())).asScala();
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(earliestOrLatest)));
        ListOffsetsRequest.Builder requestBuilder = ListOffsetsRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes(Collections.singletonList(topic));
        ListOffsetsResponse response = (ListOffsetsResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchOffsetFromLeader$1(topicPartition, x$1))).get()).partitions()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchOffsetFromLeader$2(topicPartition, x$2))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
            if (this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
                return responsePartition.offset();
            }
            return Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0));
        }
        throw errors.exception();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitionMap.size(), false);
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                try {
                    long logStartOffset = this.logStartOffset((TopicPartition)topicPartition);
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$3 -> ReplicaFetcherThread.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(topicPartition);
                }
            }
            return BoxedUnit.UNIT;
        };
        partitionMap.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void forReplica_fetchData;
            void forReplica_minBytes;
            void forReplica_maxWait;
            short s = this.fetchRequestVersion() >= 13 && !fetchData.canUseTopicIds() ? 12 : this.fetchRequestVersion();
            java.util.Map map = fetchData.toSend();
            int n = Predef$.MODULE$.Integer2int(this.minBytes());
            int n2 = Predef$.MODULE$.Integer2int(this.maxWait());
            int forReplica_replicaId = this.replicaId();
            map = null;
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(s, s, forReplica_replicaId, (int)forReplica_maxWait, (int)forReplica_minBytes, (java.util.Map)forReplica_fetchData).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).removed(fetchData.toForget()).replaced(fetchData.toReplace()).metadata(fetchData.metadata());
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        UnifiedLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
            return;
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, false);
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return (Map)Map$.MODULE$.empty();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchEpochEndOffsets$2(topics, topicPartition, epochData));
        partitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_3 = null;
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)topics, (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responseBody.data().topics()).asScala().flatMap((Function1 & Serializable)offsetForLeaderTopicResult -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopicResult.partitions()).asScala().map((Function1 & Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                }
                throw new MatchError(null);
            });
        }
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetFromLeader$1(TopicPartition topicPartition$3, ListOffsetsResponseData.ListOffsetsTopicResponse x$1) {
        String string = x$1.name();
        String string2 = topicPartition$3.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetFromLeader$2(TopicPartition topicPartition$3, ListOffsetsResponseData.ListOffsetsPartitionResponse x$2) {
        return x$2.partitionIndex() == topicPartition$3.partition();
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochEndOffsets$2(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats());
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").append("fetcherId=").append(fetcherId).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append(this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), this.logContext()));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_3_1_IV0$.MODULE$) ? 13 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_7_IV1$.MODULE$) ? 12 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_8_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0))));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_3_0_IV1$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_8_IV0$.MODULE$) ? 6 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.isOffsetForLeaderEpochSupported = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.isTruncationOnFetchSupported = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_7_IV1$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

