/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r%x!B)S\u0011\u00039f!B-S\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007\u0002C2\u0002\u0005\u0004%\tA\u00153\t\rU\f\u0001\u0015!\u0003f\u0011\u001d1\u0018A1A\u0005\u0002\u0011Daa^\u0001!\u0002\u0013)\u0007b\u0002=\u0002\u0005\u0004%I!\u001f\u0005\u0007{\u0006\u0001\u000b\u0011\u0002>\t\u000fy\f!\u0019!C\u0005I\"1q0\u0001Q\u0001\n\u0015D\u0001\"!\u0001\u0002\u0005\u0004%I!\u001f\u0005\b\u0003\u0007\t\u0001\u0015!\u0003{\u0011!\t)!\u0001b\u0001\n\u0013I\bbBA\u0004\u0003\u0001\u0006IA\u001f\u0005\n\u0003\u0013\t!\u0019!C\u0001\u0003\u0017A\u0001\"!\b\u0002A\u0003%\u0011Q\u0002\u0005\t\u0003?\t!\u0019!C\u0005I\"9\u0011\u0011E\u0001!\u0002\u0013)\u0007bBA\u0012\u0003\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u000b\nA\u0011AA$\u0011\u001d\t\t'\u0001C\u0001\u0003GBq!! \u0002\t\u0013\ty\bC\u0004\u0002\u0006\u0006!I!a\"\t\u000f\u0005-\u0015\u0001\"\u0003\u0002\u000e\"9\u0011\u0011S\u0001\u0005\n\u0005M\u0005\u0002CAL\u0003\u0011\u0005!+!'\t\u0011\u0005e\u0016\u0001\"\u0001S\u0003wC\u0001\"a1\u0002\t\u0003\u0011\u0016Q\u0019\u0004\u00063J\u0003\u00111\u001a\u0005\u000b\u00033l\"Q1A\u0005\n\u0005m\u0007BCAr;\t\u0005\t\u0015!\u0003\u0002^\"1\u0011-\bC\u0001\u0003KD!\"a;\u001e\u0005\u0004%\tAUAw\u0011!\t\u00190\bQ\u0001\n\u0005=\bBCA{;\t\u0007I\u0011\u0001*\u0002n\"A\u0011q_\u000f!\u0002\u0013\ty\u000fC\u0005\u0002zv\u0011\r\u0011\"\u0003\u0002|\"A\u0011q`\u000f!\u0002\u0013\ti\u0010C\u0005\u0003\u0002u\u0011\r\u0011\"\u0003\u0002|\"A!1A\u000f!\u0002\u0013\ti\u0010C\u0005\u0003\u0006u\u0011\r\u0011\"\u0003\u0003\b!A!qC\u000f!\u0002\u0013\u0011I\u0001C\u0005\u0003\u001au\u0011\r\u0011\"\u0003\u0003\u001c!A!QE\u000f!\u0002\u0013\u0011i\u0002C\u0005\u0003(u\u0011\r\u0011\"\u0003\u0003*!A!1H\u000f!\u0002\u0013\u0011Y\u0003C\u0005\u0003>u\u0001\r\u0011\"\u0003\u0002\\\"I!qH\u000fA\u0002\u0013%!\u0011\t\u0005\t\u0005\u000fj\u0002\u0015)\u0003\u0002^\"I!\u0011J\u000fC\u0002\u0013%!1\n\u0005\t\u00053j\u0002\u0015!\u0003\u0003N!A!1L\u000f\u0005\u0002I\u0013i\u0006\u0003\u0005\u0003ru!\tA\u0015B:\u0011\u001d\u0011)(\bC\u0001\u0005oBqAa!\u001e\t\u0003\u0011)\tC\u0004\u0003\fv!\tA!$\t\u000f\tEU\u0004\"\u0001\u0003\u0014\"9!qS\u000f\u0005\n\te\u0005\u0002\u0003BP;\u0011\u0005!+a7\t\u0011\t\u0005V\u0004\"\u0001S\u0005GC\u0001B!+\u001e\t\u0003\u0011&1\u0015\u0005\t\u0005WkB\u0011\u0001*\u0003.\"A!QX\u000f\u0005\u0002I\u0013y\f\u0003\u0005\u0003Dv!\tA\u0015Bc\u0011\u001d\u0011Y-\bC\u0005\u0005\u001bDqA!9\u001e\t\u0013\u0011\u0019\u000f\u0003\u0005\u0003fv!\tA\u0015Bt\u0011!\u0011y/\bC\u0001%\nE\bb\u0002B|;\u0011%!\u0011 \u0005\b\u0007\u000fiB\u0011BB\u0005\u0011!\u0019\t\"\bC\u0001%\u000eM\u0001bBB\r;\u0011%11\u0004\u0005\t\u0007CiB\u0011\u0001*\u0004$!91\u0011J\u000f\u0005\n\r-\u0003bBB<;\u0011%1\u0011\u0010\u0005\b\u0007\u007fjB\u0011\u0002B:\u0011\u001d\u0019\t)\bC\u0005\u0007\u0007Cqaa$\u001e\t\u0013\u0019\t\nC\u0004\u0004$v!Ia!*\t\u000f\r-W\u0004\"\u0003\u0004N\u0006\u0019B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jO*\u00111\u000bV\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002Y\u00035\t!KA\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwm\u0005\u0002\u00027B\u0011AlX\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A,\u0002-\u0011Kh.Y7jGN+7-\u001e:jif\u001cuN\u001c4jON,\u0012!\u001a\t\u0004M.lW\"A4\u000b\u0005!L\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003Uv\u000b!bY8mY\u0016\u001cG/[8o\u0013\tawMA\u0002TKR\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\t1\fgn\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0004TiJLgnZ\u0001\u0018\tft\u0017-\\5d'\u0016\u001cWO]5us\u000e{gNZ5hg\u0002\n\u0011#\u00117m\tft\u0017-\\5d\u0007>tg-[4t\u0003I\tE\u000e\u001c#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u0011\u00027\rcWo\u001d;fe2+g/\u001a7MSN$XM\\3s\u0007>tg-[4t+\u0005Q\bcA>}[6\t\u0011.\u0003\u0002mS\u0006a2\t\\;ti\u0016\u0014H*\u001a<fY2K7\u000f^3oKJ\u001cuN\u001c4jON\u0004\u0013\u0001\u0005)fe\n\u0013xn[3s\u0007>tg-[4t\u0003E\u0001VM\u001d\"s_.,'oQ8oM&<7\u000fI\u0001\u0019\u0019&\u001cH/\u001a8fe6+7\r[1oSNl7i\u001c8gS\u001e\u001c\u0018!\u0007'jgR,g.\u001a:NK\u000eD\u0017M\\5t[\u000e{gNZ5hg\u0002\nQCU3m_\u0006$\u0017M\u00197f\r&dWmQ8oM&<7/\u0001\fSK2|\u0017\rZ1cY\u00164\u0015\u000e\\3D_:4\u0017nZ:!\u0003Ma\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u0014VmZ3y+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u00115\fGo\u00195j]\u001eT1!a\u0006^\u0003\u0011)H/\u001b7\n\t\u0005m\u0011\u0011\u0003\u0002\u0006%\u0016<W\r_\u0001\u0015\u0019&\u001cH/\u001a8fe\u000e{gNZ5h%\u0016<W\r\u001f\u0011\u0002-\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\fq\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm\u001d\u0011\u0002!%\u001c\b+Y:to>\u0014HmQ8oM&<G\u0003BA\u0014\u0003[\u00012\u0001XA\u0015\u0013\r\tY#\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\tyc\u0005a\u0001\u0003c\tAA\\1nKB!\u00111GA!\u001d\u0011\t)$!\u0010\u0011\u0007\u0005]R,\u0004\u0002\u0002:)\u0019\u00111\b,\u0002\rq\u0012xn\u001c;?\u0013\r\ty$X\u0001\u0007!J,G-\u001a4\n\u0007Q\f\u0019EC\u0002\u0002@u\u000bAC\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0016P\\8os6\u001cHCBA%\u00037\ni\u0006\u0005\u0004\u0002L\u0005U\u0013\u0011\u0007\b\u0005\u0003\u001b\n\tF\u0004\u0003\u00028\u0005=\u0013\"\u00010\n\u0007\u0005MS,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\u0005\u0019&\u001cHOC\u0002\u0002TuCq!a\f\u0015\u0001\u0004\t\t\u0004C\u0004\u0002`Q\u0001\r!a\n\u0002+5\fGo\u00195MSN$XM\\3s\u001fZ,'O]5eK\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0004\u0002f\u0005-\u0014\u0011\u0010\t\u00049\u0006\u001d\u0014bAA5;\n!QK\\5u\u0011\u001d\ti'\u0006a\u0001\u0003_\nQ\u0001\u001d:paN\u0004B!!\u001d\u0002v5\u0011\u00111\u000f\u0006\u0004\u0003/\t\u0018\u0002BA<\u0003g\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tY(\u0006a\u0001\u0003O\tq\u0002]3s\u0005J|7.\u001a:D_:4\u0017nZ\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$B!!!\u0002\u0004B!1\u0010`A\u0019\u0011\u001d\tiG\u0006a\u0001\u0003_\n\u0011C\\8o\tft\u0017-\\5d\u0007>tg-[4t)\u0011\t\t)!#\t\u000f\u00055t\u00031\u0001\u0002p\u0005!3/Z2ve&$\u0018pQ8oM&<7oV5uQ>,H\u000fT5ti\u0016tWM\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0002\u0002\u0006=\u0005bBA71\u0001\u0007\u0011qN\u0001\u0014m\u0006d\u0017\u000eZ1uK\u000e{gNZ5h)f\u0004Xm\u001d\u000b\u0005\u0003K\n)\nC\u0004\u0002ne\u0001\r!a\u001c\u0002#\u0005$G\rR=oC6L7mQ8oM&<7\u000f\u0006\u0003\u0002f\u0005m\u0005bBAO5\u0001\u0007\u0011qT\u0001\nG>tg-[4EK\u001a\u0004B!!)\u000266\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003S\u000bY+\u0001\u0004d_6lwN\u001c\u0006\u0004+\u00065&\u0002BAX\u0003c\u000ba!\u00199bG\",'BAAZ\u0003\ry'oZ\u0005\u0005\u0003o\u000b\u0019KA\u0005D_:4\u0017n\u001a#fM\u0006AB-\u001f8b[&\u001c7i\u001c8gS\u001e,\u0006\u000fZ1uK6{G-Z:\u0016\u0005\u0005u\u0006\u0003CA9\u0003\u007f\u000b\t$!\r\n\t\u0005\u0005\u00171\u000f\u0002\u0004\u001b\u0006\u0004\u0018A\u0006:fg>dg/\u001a,be&\f'\r\\3D_:4\u0017nZ:\u0015\t\u0005=\u0014q\u0019\u0005\b\u0003\u0013d\u0002\u0019AA8\u00035\u0001(o\u001c9t\u001fJLw-\u001b8bYN!QdWAg!\u0011\ty-!6\u000e\u0005\u0005E'bAAj)\u0006)Q\u000f^5mg&!\u0011q[Ai\u0005\u001daunZ4j]\u001e\f1b[1gW\u0006\u001cuN\u001c4jOV\u0011\u0011Q\u001c\t\u00041\u0006}\u0017bAAq%\nY1*\u00194lC\u000e{gNZ5h\u00031Y\u0017MZ6b\u0007>tg-[4!)\u0011\t9/!;\u0011\u0005ak\u0002bBAmA\u0001\u0007\u0011Q\\\u0001\u0014gR\fG/[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0003_\u0004RAZAy[6L1!!1h\u0003Q\u0019H/\u0019;jG\n\u0013xn[3s\u0007>tg-[4tA\u0005!2\u000f^1uS\u000e$UMZ1vYR\u001cuN\u001c4jON\fQc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b%\u0001\u000bes:\fW.[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0003{\u0004rAZAy\u0003c\t\t$A\u000bes:\fW.[2Ce>\\WM]\"p]\u001aLwm\u001d\u0011\u0002+\u0011Lh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u00061B-\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b%A\bsK\u000e|gNZ5hkJ\f'\r\\3t+\t\u0011I\u0001E\u0003g\u0005\u0017\u0011y!C\u0002\u0003\u000e\u001d\u0014aAQ;gM\u0016\u0014\b\u0003\u0002B\t\u0005'i!!a*\n\t\tU\u0011q\u0015\u0002\u000f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003A\u0011XmY8oM&<WO]1cY\u0016\u001c\b%A\u000bce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\tu\u0001#\u00024\u0003\f\t}\u0001c\u0001-\u0003\"%\u0019!1\u0005*\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003Y\u0011'o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013\u0001\u00027pG.,\"Aa\u000b\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005)An\\2lg*!!QGA:\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005s\u0011yC\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003\u0015awnY6!\u00035\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0006\t2-\u001e:sK:$8i\u001c8gS\u001e|F%Z9\u0015\t\u0005\u0015$1\t\u0005\n\u0005\u000b\u0002\u0014\u0011!a\u0001\u0003;\f1\u0001\u001f\u00132\u00039\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0002\nA\u0004Z=oC6L7mQ8oM&<\u0007+Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003NA)ALa\u0014\u0003T%\u0019!\u0011K/\u0003\r=\u0003H/[8o!\u0011\tyM!\u0016\n\t\t]\u0013\u0011\u001b\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0006iB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!!\u001a\u0003`!9!\u0011\r\u001bA\u0002\t\r\u0014a\u0003>l\u00072LWM\u001c;PaR\u0004R\u0001\u0018B(\u0005K\u0002BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0004\u0005W\"\u0016A\u0001>l\u0013\u0011\u0011yG!\u001b\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003\u0015\u0019G.Z1s)\t\t)'\u0001\nbI\u0012\u0014VmY8oM&<WO]1cY\u0016\u001cH\u0003BA3\u0005sBqAa\u001f7\u0001\u0004\u0011i(A\u0006lC\u001a\\\u0017mU3sm\u0016\u0014\bc\u0001-\u0003\u0000%\u0019!\u0011\u0011*\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u0012C\u0012$'+Z2p]\u001aLw-\u001e:bE2,G\u0003BA3\u0005\u000fCqA!#8\u0001\u0004\u0011y!\u0001\bsK\u000e|gNZ5hkJ\f'\r\\3\u0002/\u0005$GM\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,G\u0003BA3\u0005\u001fCqA!#9\u0001\u0004\u0011y\"\u0001\u000bsK6|g/\u001a*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\u0005\u0003K\u0012)\nC\u0004\u0003\nf\u0002\rAa\u0004\u00027Y,'/\u001b4z%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\u0011\t)Ga'\t\u000f\tu%\b1\u0001\u0002\u0002\u0006Y1m\u001c8gS\u001et\u0015-\\3t\u0003I\u0019WO\u001d:f]R\\\u0015MZ6b\u0007>tg-[4\u00027\r,(O]3oi\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4t+\t\u0011)\u000bE\u0004|\u0005O\u000b\t$!\r\n\u0007\u0005\u0005\u0017.\u0001\u000fdkJ\u0014XM\u001c;Es:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002%U\u0004H-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0007\u0003K\u0012yK!/\t\u000f\tEf\b1\u0001\u00034\u0006A!M]8lKJLE\rE\u0002]\u0005kK1Aa.^\u0005\rIe\u000e\u001e\u0005\b\u0005ws\u0004\u0019AA8\u0003=\u0001XM]:jgR,g\u000e\u001e)s_B\u001c\u0018aE;qI\u0006$X\rR3gCVdGoQ8oM&<G\u0003BA3\u0005\u0003DqAa/@\u0001\u0004\ty'A\u0013sK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hKR!\u0011Q\rBd\u0011\u001d\u0011I\r\u0011a\u0001\u0003_\n\u0001B\\3x!J|\u0007o]\u0001\u001b[\u0006L(-Z\"sK\u0006$X\rU1tg^|'\u000fZ#oG>$WM\u001d\u000b\u0005\u0005\u001b\u0012y\rC\u0004\u0003R\u0006\u0003\rAa5\u0002\rM,7M]3u!\u0015a&q\nBk!\u0011\u00119N!8\u000e\u0005\te'\u0002\u0002Bn\u0003G\u000bQ\u0001^=qKNLAAa8\u0003Z\nA\u0001+Y:to>\u0014H-A\bqCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s+\t\u0011\u0019&A\tu_B+'o]5ti\u0016tG\u000f\u0015:paN$b!a\u001c\u0003j\n5\bb\u0002Bv\u0007\u0002\u0007\u0011qN\u0001\fG>tg-[4Qe>\u00048\u000fC\u0004\u0002|\r\u0003\r!a\n\u0002'\u0019\u0014x.\u001c)feNL7\u000f^3oiB\u0013x\u000e]:\u0015\r\u0005=$1\u001fB{\u0011\u001d\u0011Y\f\u0012a\u0001\u0003_Bq!a\u001fE\u0001\u0004\t9#\u0001\fnCf\u0014WMU3F]\u000e|G-\u001a)bgN<xN\u001d3t)\u0019\tyGa?\u0003~\"9!1X#A\u0002\u0005=\u0004b\u0002B\u0000\u000b\u0002\u00071\u0011A\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0011\t\t\u001d41A\u0005\u0005\u0007\u000b\u0011IGA\u0007BI6LgNW6DY&,g\u000e^\u0001\u0014m\u0006d\u0017\u000eZ1uK\u0012\\\u0015MZ6b!J|\u0007o\u001d\u000b\u0007\u0005K\u001bYaa\u0004\t\u000f\r5a\t1\u0001\u0002p\u0005i\u0001O]8qg>3XM\u001d:jI\u0016Dq!a\u001fG\u0001\u0004\t9#\u0001\u0005wC2LG-\u0019;f)\u0019\t)g!\u0006\u0004\u0018!9\u0011QN$A\u0002\u0005=\u0004bBA>\u000f\u0002\u0007\u0011qE\u0001\u0015e\u0016lwN^3J]Z\fG.\u001b3D_:4\u0017nZ:\u0015\r\u0005\u00154QDB\u0010\u0011\u001d\ti\u0007\u0013a\u0001\u0003_Bq!a\u001fI\u0001\u0004\t9#\u0001\tnCf\u0014WMU3d_:4\u0017nZ;sKRA\u0011QMB\u0013\u0007O\u0019Y\u0003C\u0004\u0003\n&\u0003\rAa\u0004\t\u000f\r%\u0012\n1\u0001\u0002^\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0007[I\u0005\u0019AB\u0018\u0003%qWm^\"p]\u001aLw\r\r\u0003\u00042\r]\u0002\u0003CA9\u0003\u007f\u000b\tda\r\u0011\t\rU2q\u0007\u0007\u0001\t1\u0019Ida\u000b\u0002\u0002\u0003\u0005)\u0011AB\u001e\u0005\ryF%M\t\u0005\u0007{\u0019\u0019\u0005E\u0002]\u0007\u007fI1a!\u0011^\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001XB#\u0013\r\u00199%\u0018\u0002\u0004\u0003:L\u0018AD;qI\u0006$X\rZ\"p]\u001aLwm\u001d\u000b\u0007\u0007\u001b\u001aif!\u001b\u0011\u000fq\u001byea\u0015\u0002\u0002&\u00191\u0011K/\u0003\rQ+\b\u000f\\33a\u0011\u0019)f!\u0017\u0011\u000f\u0019\f\t0!\r\u0004XA!1QGB-\t-\u0019YFSA\u0001\u0002\u0003\u0015\taa\u000f\u0003\u0007}#C\u0007C\u0004\u0003J*\u0003\raa\u00181\t\r\u00054Q\r\t\t\u0003c\ny,!\r\u0004dA!1QGB3\t1\u00199g!\u0018\u0002\u0002\u0003\u0005)\u0011AB\u001e\u0005\ryFE\r\u0005\b\u0007WR\u0005\u0019AB7\u00031\u0019WO\u001d:f]R\u0004&o\u001c9ta\u0011\u0019yga\u001d\u0011\u0011\u0005E\u0014qXA\u0019\u0007c\u0002Ba!\u000e\u0004t\u0011a1QOB5\u0003\u0003\u0005\tQ!\u0001\u0004<\t\u0019q\fJ\u001a\u0002\u001b=4XM\u001d:jI\u0016\u0004&o\u001c9t)\u0019\t)ga\u001f\u0004~!9\u0011QN&A\u0002\u0005u\bbBB\u0007\u0017\u0002\u0007\u0011Q`\u0001\u0014kB$\u0017\r^3DkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\u0017aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R11QQBE\u0007\u0017\u0003r\u0001XB(\u0003;\u001c9\t\u0005\u0004\u0002L\u0005U#q\u0004\u0005\b\u0005\u0013l\u0005\u0019\u0001BS\u0011\u001d\u0019i)\u0014a\u0001\u0003O\tAB^1mS\u0012\fG/Z(oYf\fAC\\3fIN\u0014VmY8oM&<WO]1uS>tG\u0003CA\u0014\u0007'\u001bYja(\t\u000f\rUe\n1\u0001\u0004\u0018\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\bCBA9\u00073\u000b\t$C\u0002m\u0003gBqa!(O\u0001\u0004\t\t)A\u0006va\u0012\fG/\u001a3LKf\u001c\bbBBQ\u001d\u0002\u0007\u0011\u0011Q\u0001\fI\u0016dW\r^3e\u0017\u0016L8/A\u000fqe>\u001cWm]:MSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)1\t)ga*\u00048\u000ee6QYBd\u0011\u001d\u0019Ik\u0014a\u0001\u0007W\u000ba\u0003\\5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0005\u0007[\u001b\u0019,\u0004\u0002\u00040*!1\u0011WAT\u0003\u001dqW\r^<pe.LAa!.\u00040\n1B*[:uK:,'OU3d_:4\u0017nZ;sC\ndW\rC\u0004\u0004.=\u0003\r!!8\t\u000f\rmv\n1\u0001\u0004>\u0006i1-^:u_6\u001cuN\u001c4jON\u0004\u0002\"!\u001d\u0002@\u0006E2q\u0018\t\u0004]\u000e\u0005\u0017bABb_\n1qJ\u00196fGRDqa!$P\u0001\u0004\t9\u0003C\u0004\u0004J>\u0003\r!a\n\u0002\u0015I,Gn\\1e\u001f:d\u00170A\u000bqe>\u001cWm]:SK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0019\u0005\u00154qZBi\u0007+\u001c\u0019oa:\t\u000f\t%\u0005\u000b1\u0001\u0003\u0010!911\u001b)A\u0002\u0005\u0005\u0015AE;qI\u0006$X\rZ\"p]\u001aLwMT1nKNDqaa6Q\u0001\u0004\u0019I.A\u0007bY2tUm^\"p]\u001aLwm\u001d\u0019\u0005\u00077\u001cy\u000e\u0005\u0005\u0002r\u0005}\u0016\u0011GBo!\u0011\u0019)da8\u0005\u0019\r\u00058Q[A\u0001\u0002\u0003\u0015\taa\u000f\u0003\u0007}#S\u0007C\u0004\u0004fB\u0003\ra!0\u0002!9,woQ;ti>l7i\u001c8gS\u001e\u001c\bbBBG!\u0002\u0007\u0011q\u0005")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(props, perBrokerConfig);
    }

    public static List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, matchListenerOverride);
    }

    public static boolean isPasswordConfig(String name) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(name);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<KafkaZkClient> zkClientOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        zkClientOpt.foreach((Function1 & Serializable)zkClient -> {
            DynamicBrokerConfig.$anonfun$initialize$1(this, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable(kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void updateDefaultConfig(Properties persistentProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        Properties props = (Properties)configProps.clone();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(configProps).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return props;
    }

    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return props;
    }

    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        Properties props = (Properties)persistentProps.clone();
        if (CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet().exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(newProps).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(currentProps).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        propsOverride.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig() {
        void var4_4;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        if (var4_4 != this.currentConfig()) {
            void var5_5;
            this.currentConfig_$eq((KafkaConfig)var4_4);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)var4_4);
            var5_5.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)var4_4, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        void var6_6;
        void var5_5;
        KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        if (var5_5.nonEmpty() || var6_6.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(x$6 -> customConfigs.remove(x$6));
                this.reconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2$adapted(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)var5_5, (Set)var6_6, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)var5_5, (Set)var6_6, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)package$.MODULE$.List().empty());
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(updatedKeys).nonEmpty() || CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(deletedKeys).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        Set updatedKeys = var10_10.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)var11_11);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initialize$1(DynamicBrokerConfig $this, KafkaZkClient zkClient) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        $this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString($this.kafkaConfig().brokerId()));
        Properties brokerConfig = $this.maybeReEncodePasswords(props, adminZkClient);
        $this.updateBrokerConfig($this.kafkaConfig().brokerId(), brokerConfig);
    }

    public static final /* synthetic */ Buffer $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable$1.reconfigurableConfigs()).asScala());
        return (Buffer)$this.reconfigurables().$plus$eq((Object)reconfigurable$1);
    }

    public static final /* synthetic */ Buffer $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return (Buffer)$this.brokerReconfigurables().$plus$eq((Object)reconfigurable$2);
    }

    public static final /* synthetic */ Buffer $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return (Buffer)$this.reconfigurables().$minus$eq((Object)reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableOnceOps)$this.reconfigurables().filter((Function1 & Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
            return;
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
            return;
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        CollectionConverters$.MODULE$.PropertiesHasAsScala(persistentProps$3).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration(CollectionConverters$.MODULE$.SetHasAsJava(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                return brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        this.staticBrokerConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(KafkaConfig$.MODULE$.defaultValues()).asJava())).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = null;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$2$adapted(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        DynamicBrokerConfig.$anonfun$processReconfiguration$2($this, newConfig$3, customConfigs$1, validateOnly$1, changeMap$1, deletedKeySet$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

