/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.CorruptIndexException;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.ProducerStateManager;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class LogLoader$
implements Logging {
    public static final LogLoader$ MODULE$ = new LogLoader$();
    private static final String CleanShutdownFile = ".kafka_cleanshutdown";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String CleanShutdownFile() {
        return CleanShutdownFile;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load(LoadLogParams params) {
        long l;
        long l2;
        Object var22_9;
        LogSegments logSegments;
        File file2;
        TopicPartition topicPartition;
        LogConfig logConfig;
        Scheduler scheduler;
        LogDirFailureChannel logDirFailureChannel;
        String string;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles(params);
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableOnceOps)swapFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$load$1(f)))).foreach((Function1 & Serializable)f -> {
            LogLoader$.$anonfun$load$2(params, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            Object object;
            block7: {
                try {
                    if (!file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = LocalLog$.MODULE$.offsetFromFile((File)file);
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            LogLoader$ info_this = MODULE$;
                            if (info_this.logger().underlying().isInfoEnabled()) {
                                String msgWithLogIdent_msg = LogLoader$.$anonfun$load$6(params, file);
                                Object var7_6 = null;
                                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                            }
                            Object var6_5 = null;
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block7;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                LogLoader$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogLoader$.$anonfun$load$9(params, file);
                    Object var3_3 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var2_2 = null;
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader$.$anonfun$load$10(params);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                void retryOnOffsetOverflow_splitOverflowedSegment_config;
                void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogLoader$.$anonfun$retryOnOffsetOverflow$1(params, retryOnOffsetOverflow_e);
                    Object var40_5 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                string = params.logIdentifier();
                logDirFailureChannel = params.logDirFailureChannel();
                scheduler = params.scheduler();
                logConfig = params.config();
                topicPartition = params.topicPartition();
                file2 = params.dir();
                logSegments = params.segments();
                LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                var22_9 = null;
                logSegments = null;
                file2 = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                SplitSegmentResult retryOnOffsetOverflow_result = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments(), params);
                continue;
            }
            break;
        }
        Object var20_7 = null;
        Object var21_8 = null;
        var22_9 = null;
        logSegments = null;
        file2 = null;
        topicPartition = null;
        logConfig = null;
        scheduler = null;
        logDirFailureChannel = null;
        string = null;
        if (!params.dir().getAbsolutePath().endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix())) {
            void var8_31;
            void var6_30;
            Object var32_20;
            LogSegments logSegments2;
            File file3;
            TopicPartition topicPartition2;
            LogConfig logConfig2;
            Scheduler scheduler2;
            LogDirFailureChannel logDirFailureChannel2;
            String string2;
            Tuple2 tuple2;
            while (true) {
                try {
                    tuple2 = LogLoader$.MODULE$.recoverLog(params);
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                    void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                    void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                    void retryOnOffsetOverflow_splitOverflowedSegment_config;
                    void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                    void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                    void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                    if (this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = LogLoader$.$anonfun$retryOnOffsetOverflow$1(params, retryOnOffsetOverflow_e);
                        Object var41_28 = null;
                        this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    string2 = params.logIdentifier();
                    logDirFailureChannel2 = params.logDirFailureChannel();
                    scheduler2 = params.scheduler();
                    logConfig2 = params.config();
                    topicPartition2 = params.topicPartition();
                    file3 = params.dir();
                    logSegments2 = params.segments();
                    LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                    var32_20 = null;
                    logSegments2 = null;
                    file3 = null;
                    topicPartition2 = null;
                    logConfig2 = null;
                    scheduler2 = null;
                    logDirFailureChannel2 = null;
                    string2 = null;
                    SplitSegmentResult retryOnOffsetOverflow_result = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments(), params);
                    continue;
                }
                break;
            }
            Object var30_18 = null;
            Object var31_19 = null;
            var32_20 = null;
            logSegments2 = null;
            file3 = null;
            topicPartition2 = null;
            logConfig2 = null;
            scheduler2 = null;
            logDirFailureChannel2 = null;
            string2 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)params.segments().lastSegment().get()).resizeIndexes(Predef$.MODULE$.Integer2int(params.config().maxIndexSize()));
            l2 = var6_30;
            l = var8_31;
        } else {
            if (params.segments().isEmpty()) {
                File x$9 = params.dir();
                LogConfig x$11 = params.config();
                Time x$12 = params.time();
                int x$13 = params.config().initFileSize();
                boolean x$14 = false;
                boolean x$15 = false;
                String x$16 = "";
                params.segments().add(LogSegment$.MODULE$.open(x$9, 0L, x$11, x$12, x$14, x$13, x$15, x$16));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        params.leaderEpochCache().foreach((Function1 & Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        long newLogStartOffset = package$.MODULE$.max(params.logStartOffsetCheckpoint(), ((LogSegment)params.segments().firstSegment().get()).baseOffset());
        params.leaderEpochCache().foreach((Function1 & Serializable)x$4 -> {
            x$4.truncateFromStart(params.logStartOffsetCheckpoint());
            return BoxedUnit.UNIT;
        });
        if (!params.producerStateManager().isEmpty()) {
            throw new IllegalStateException("Producer state must be empty during log initialization");
        }
        params.producerStateManager().removeStraySnapshots((Seq<Object>)params.segments().baseOffsets().toSeq());
        UnifiedLog$.MODULE$.rebuildProducerState(params.producerStateManager(), params.segments(), newLogStartOffset, l3, params.config().recordVersion(), params.time(), params.hadCleanShutdown(), params.logIdentifier());
        LogSegment activeSegment = (LogSegment)params.segments().lastSegment().get();
        return new LoadedLogOffsets(newLogStartOffset, l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles(LoadLogParams params) {
        void var7_7;
        void var6_6;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix())) {
                LogLoader$ debug_this = MODULE$;
                if (debug_this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$3(params, file);
                    Object var7_7 = null;
                    debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
                }
                Object var6_6 = null;
                return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(LocalLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        var6_6.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$5(params, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$7(params, file)));
        return var7_7;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T retryOnOffsetOverflow(LoadLogParams params, Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                void splitOverflowedSegment_logPrefix;
                void splitOverflowedSegment_logDirFailureChannel;
                void splitOverflowedSegment_scheduler;
                void splitOverflowedSegment_config;
                void splitOverflowedSegment_topicPartition;
                void splitOverflowedSegment_dir;
                void splitOverflowedSegment_existingSegments;
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogLoader$.$anonfun$retryOnOffsetOverflow$1(params, e);
                    Object var13_13 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                String string = params.logIdentifier();
                LogDirFailureChannel logDirFailureChannel = params.logDirFailureChannel();
                Scheduler scheduler = params.scheduler();
                LogConfig logConfig = params.config();
                TopicPartition topicPartition = params.topicPartition();
                File file = params.dir();
                LogSegments logSegments = params.segments();
                LogSegment splitOverflowedSegment_segment = e.segment();
                Object var5_5 = null;
                logSegments = null;
                file = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                SplitSegmentResult result = LocalLog$.MODULE$.splitOverflowedSegment(splitOverflowedSegment_segment, (LogSegments)splitOverflowedSegment_existingSegments, (File)splitOverflowedSegment_dir, (TopicPartition)splitOverflowedSegment_topicPartition, (LogConfig)splitOverflowedSegment_config, (Scheduler)splitOverflowedSegment_scheduler, (LogDirFailureChannel)splitOverflowedSegment_logDirFailureChannel, (String)splitOverflowedSegment_logPrefix);
                this.deleteProducerSnapshotsAsync(result.deletedSegments(), params);
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles(LoadLogParams params) {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles()), (Function1 & Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (LocalLog$.MODULE$.isIndexFile((File)file)) {
                void logFile_suffix;
                long offset = LocalLog$.MODULE$.offsetFromFile((File)file);
                String string = "";
                File logFile_dir = params.dir();
                Object var12_4 = null;
                string = null;
                if (!LocalLog$.MODULE$.logFile(logFile_dir, offset, (String)logFile_suffix).exists()) {
                    LogLoader$ warn_this = MODULE$;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        String msgWithLogIdent_msg = LogLoader$.$anonfun$loadSegmentFiles$4(params, file);
                        Object var16_6 = null;
                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                    }
                    Object var9_5 = null;
                    return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (LocalLog$.MODULE$.isLogFile((File)file)) {
                void timeIndexFile_suffix;
                long baseOffset = LocalLog$.MODULE$.offsetFromFile((File)file);
                String string = "";
                File timeIndexFile_dir = params.dir();
                Object var14_9 = null;
                string = null;
                boolean timeIndexFileNewlyCreated = !LocalLog$.MODULE$.timeIndexFile(timeIndexFile_dir, baseOffset, (String)timeIndexFile_suffix).exists();
                LogSegment segment = LogSegment$.MODULE$.open(params.dir(), baseOffset, params.config(), params.time(), true, 0, false, "");
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    LogLoader$ error_this = MODULE$;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        String msgWithLogIdent_msg = LogLoader$.$anonfun$loadSegmentFiles$5(params, segment);
                        Object var17_13 = null;
                        error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
                    }
                    Object var10_12 = null;
                    MODULE$.recoverSegment(segment, params);
                }
                catch (CorruptIndexException e) {
                    LogLoader$ warn_this = MODULE$;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        String msgWithLogIdent_msg = LogLoader$.$anonfun$loadSegmentFiles$6(params, segment, e);
                        Object var18_16 = null;
                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                    }
                    Object var11_15 = null;
                    MODULE$.recoverSegment(segment, params);
                }
                return params.segments().add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    private int recoverSegment(LogSegment segment, LoadLogParams params) {
        ProducerStateManager producerStateManager = new ProducerStateManager(params.topicPartition(), params.dir(), params.maxProducerIdExpirationMs(), params.time());
        UnifiedLog$.MODULE$.rebuildProducerState(producerStateManager, params.segments(), params.logStartOffsetCheckpoint(), segment.baseOffset(), params.config().recordVersion(), params.time(), false, params.logIdentifier());
        int bytesTruncated = segment.recover(producerStateManager, params.leaderEpochCache());
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    public Tuple2<Object, Object> recoverLog(LoadLogParams params) {
        boolean bl;
        if (!params.hadCleanShutdown()) {
            Iterator unflushed = params.segments().values(params.recoveryPointCheckpoint(), Long.MAX_VALUE).iterator();
            boolean truncated = false;
            while (unflushed.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushed.next();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogLoader$.$anonfun$recoverLog$3(params, segment);
                    Object var22_6 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                try {
                    n = this.recoverSegment(segment, params);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    if (this.logger().underlying().isWarnEnabled()) {
                        String msgWithLogIdent_msg = LogLoader$.$anonfun$recoverLog$4(params, startOffset);
                        Object var23_7 = null;
                        this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    n = segment.truncateTo(startOffset);
                }
                if (n <= 0) continue;
                if (this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = LogLoader$.$anonfun$recoverLog$5(params, segment);
                    Object var24_8 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushed.toList(), params);
                truncated = true;
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1(params);
        if (params.segments().isEmpty()) {
            File x$1 = params.dir();
            long x$2 = params.logStartOffsetCheckpoint();
            LogConfig x$3 = params.config();
            Time x$4 = params.time();
            int x$5 = params.config().initFileSize();
            boolean x$6 = Predef$.MODULE$.Boolean2boolean(params.config().preallocate());
            boolean x$7 = false;
            String x$8 = "";
            params.segments().add(LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8));
        }
        if ((bl = params.hadCleanShutdown()) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            return new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        }
        long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((LogSegment)params.segments().lastSegment().get()).readNextOffset()));
        return new Tuple2.mcJJ.sp(Math.min(params.recoveryPointCheckpoint(), logEndOffset), logEndOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete, LoadLogParams params) {
        if (segmentsToDelete.nonEmpty()) {
            void deleteSegmentFiles_logPrefix;
            void deleteSegmentFiles_logDirFailureChannel;
            void deleteSegmentFiles_scheduler;
            void deleteSegmentFiles_config;
            void deleteSegmentFiles_topicPartition;
            void deleteSegmentFiles_dir;
            List toDelete = segmentsToDelete.toList();
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = LogLoader$.$anonfun$removeAndDeleteSegmentsAsync$1(params, toDelete);
                Object var11_4 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            toDelete.foreach((Function1 & Serializable)segment -> {
                LogLoader$.$anonfun$removeAndDeleteSegmentsAsync$2(params, segment);
                return BoxedUnit.UNIT;
            });
            String string = params.logIdentifier();
            LogDirFailureChannel logDirFailureChannel = params.logDirFailureChannel();
            Scheduler scheduler = params.scheduler();
            LogConfig logConfig = params.config();
            TopicPartition topicPartition = params.topicPartition();
            File file = params.dir();
            boolean deleteSegmentFiles_asyncDelete = true;
            LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, deleteSegmentFiles_asyncDelete, (File)deleteSegmentFiles_dir, (TopicPartition)deleteSegmentFiles_topicPartition, (LogConfig)deleteSegmentFiles_config, (Scheduler)deleteSegmentFiles_scheduler, (LogDirFailureChannel)deleteSegmentFiles_logDirFailureChannel, (String)deleteSegmentFiles_logPrefix);
            file = null;
            topicPartition = null;
            logConfig = null;
            scheduler = null;
            logDirFailureChannel = null;
            string = null;
            this.deleteProducerSnapshotsAsync(segmentsToDelete, params);
            return;
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments, LoadLogParams params) {
        UnifiedLog$.MODULE$.deleteProducerSnapshots(segments, params.producerStateManager(), true, params.scheduler(), params.config(), params.logDirFailureChannel(), params.dir().getParent(), params.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        File isLogFile_file = new File(CoreUtils$.MODULE$.replaceSuffix(f.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""));
        return LocalLog$.MODULE$.isLogFile(isLogFile_file);
    }

    public static final /* synthetic */ String $anonfun$load$3(LoadLogParams params$1, File f$1) {
        return new StringBuilder(94).append(params$1.logIdentifier()).append("Found log file ").append(f$1.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString();
    }

    public static final /* synthetic */ void $anonfun$load$2(LoadLogParams params$1, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = LocalLog$.MODULE$.offsetFromFile(f);
        File x$1 = f.getParentFile();
        LogConfig x$3 = params$1.config();
        Time x$4 = params$1.time();
        String x$5 = UnifiedLog$.MODULE$.SwapFileSuffix();
        boolean x$6 = false;
        int x$7 = 0;
        boolean x$8 = false;
        LogSegment segment = LogSegment$.MODULE$.open(x$1, baseOffset, x$3, x$4, x$6, x$7, x$8, x$5);
        LogLoader$ info_this = MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = LogLoader$.$anonfun$load$3(params$1, f);
            Object var15_14 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
        }
        Object var14_13 = null;
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ String $anonfun$load$6(LoadLogParams params$1, File file$1) {
        return new StringBuilder(71).append(params$1.logIdentifier()).append("Deleting segment files ").append(file$1.getName()).append(" that is compacted but has not been deleted yet.").toString();
    }

    public static final /* synthetic */ String $anonfun$load$9(LoadLogParams params$1, File file$2) {
        return new StringBuilder(41).append(params$1.logIdentifier()).append("Recovering file ").append(file$2.getName()).append(" by renaming from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString();
    }

    public static final /* synthetic */ void $anonfun$load$10(LoadLogParams params$1) {
        params$1.segments().close();
        params$1.segments().clear();
        MODULE$.loadSegmentFiles(params$1);
    }

    public static final /* synthetic */ String $anonfun$removeTempFilesAndCollectSwapFiles$3(LoadLogParams params$2, File file$3) {
        return new StringBuilder(30).append(params$2.logIdentifier()).append("Deleting stray temporary file ").append(file$3.getAbsolutePath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return LocalLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ String $anonfun$removeTempFilesAndCollectSwapFiles$6(LoadLogParams params$2, File file$4, LongRef minCleanedFileOffset$1) {
        return new StringBuilder(50).append(params$2.logIdentifier()).append("Deleting invalid swap file ").append(file$4.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LoadLogParams params$2, LongRef minCleanedFileOffset$1, File file) {
        LogLoader$ debug_this = MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = new StringBuilder(50).append(params$2.logIdentifier()).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString();
            Object var4_4 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
        }
        Object var3_3 = null;
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ String $anonfun$removeTempFilesAndCollectSwapFiles$8(LoadLogParams params$2, File file$5) {
        return new StringBuilder(27).append(params$2.logIdentifier()).append("Deleting stray .clean file ").append(file$5.getAbsolutePath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LoadLogParams params$2, File file) {
        LogLoader$ debug_this = MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$8(params$2, file);
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
        }
        Object var2_2 = null;
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ String $anonfun$retryOnOffsetOverflow$1(LoadLogParams params$3, LogSegmentOffsetOverflowException e$1) {
        return new StringBuilder(57).append(params$3.logIdentifier()).append("Caught segment overflow error: ").append(e$1.getMessage()).append(". Split segment and retry.").toString();
    }

    public static final /* synthetic */ String $anonfun$loadSegmentFiles$4(LoadLogParams params$4, File file$6) {
        return new StringBuilder(62).append(params$4.logIdentifier()).append("Found an orphaned index file ").append(file$6.getAbsolutePath()).append(", with no corresponding log file.").toString();
    }

    public static final /* synthetic */ String $anonfun$loadSegmentFiles$5(LoadLogParams params$4, LogSegment segment$1) {
        return new StringBuilder(109).append(params$4.logIdentifier()).append("Could not find offset index file corresponding to log file").append(" ").append(segment$1.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString();
    }

    public static final /* synthetic */ String $anonfun$loadSegmentFiles$6(LoadLogParams params$4, LogSegment segment$1, CorruptIndexException e$2) {
        return new StringBuilder(114).append(params$4.logIdentifier()).append("Found a corrupted index file corresponding to log file").append(" ").append(segment$1.log().file().getAbsolutePath()).append(" due to ").append(e$2.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString();
    }

    public static final /* synthetic */ String $anonfun$recoverLog$1(LoadLogParams params$5, long logEndOffset$1) {
        return new StringBuilder(148).append(params$5.logIdentifier()).append("Deleting all segments because logEndOffset (").append(logEndOffset$1).append(") ").append("is smaller than logStartOffset ").append(params$5.logStartOffsetCheckpoint()).append(". ").append("This could happen if segment files were deleted from the file system.").toString();
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1(LoadLogParams params$5) {
        if (params$5.segments().nonEmpty()) {
            long logEndOffset = ((LogSegment)params$5.segments().lastSegment().get()).readNextOffset();
            if (logEndOffset >= params$5.logStartOffsetCheckpoint()) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogLoader$.$anonfun$recoverLog$1(params$5, logEndOffset);
                Object var4_3 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.removeAndDeleteSegmentsAsync(params$5.segments().values(), params$5);
            params$5.leaderEpochCache().foreach((Function1 & Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            params$5.producerStateManager().truncateFullyAndStartAt(params$5.logStartOffsetCheckpoint());
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$recoverLog$3(LoadLogParams params$5, LogSegment segment$2) {
        return new StringBuilder(29).append(params$5.logIdentifier()).append("Recovering unflushed segment ").append(segment$2.baseOffset()).toString();
    }

    public static final /* synthetic */ String $anonfun$recoverLog$4(LoadLogParams params$5, long startOffset$1) {
        return new StringBuilder(114).append(params$5.logIdentifier()).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset$1).toString();
    }

    public static final /* synthetic */ String $anonfun$recoverLog$5(LoadLogParams params$5, LogSegment segment$2) {
        return new StringBuilder(51).append(params$5.logIdentifier()).append("Corruption found in segment ").append(segment$2.baseOffset()).append(",").append(" truncating to offset ").append(segment$2.readNextOffset()).toString();
    }

    public static final /* synthetic */ String $anonfun$removeAndDeleteSegmentsAsync$1(LoadLogParams params$6, List toDelete$1) {
        return new StringBuilder(43).append(params$6.logIdentifier()).append("Deleting segments as part of log recovery: ").append(toDelete$1.mkString(",")).toString();
    }

    public static final /* synthetic */ void $anonfun$removeAndDeleteSegmentsAsync$2(LoadLogParams params$6, LogSegment segment) {
        params$6.segments().remove(segment.baseOffset());
    }

    private LogLoader$() {
    }
}

