/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.controller.KafkaController;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u0007\u000e\u0001IA\u0001b\t\u0001\u0003\u0006\u0004%I\u0001\n\u0005\tW\u0001\u0011\t\u0011)A\u0005K!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00051\u0001\t\u0015\r\u0011\"\u00012\u0011!\u0001\u0005A!A!\u0002\u0013\u0011\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b!\u0003A\u0011A%\t\u000b=\u0003A\u0011\u0002)\t\u000b5\u0004A\u0011\u00018\t\u000bE\u0004A\u0011\u0001:\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\t\u0011Bk\u001c9jG\u000e{gNZ5h\u0011\u0006tG\r\\3s\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00143u\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001c\u001b\u0005i\u0011B\u0001\u000f\u000e\u00055\u0019uN\u001c4jO\"\u000bg\u000e\u001a7feB\u0011a$I\u0007\u0002?)\u0011\u0001eD\u0001\u0006kRLGn]\u0005\u0003E}\u0011q\u0001T8hO&tw-\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0003Q=\t1\u0001\\8h\u0013\tQsE\u0001\u0006M_\u001el\u0015M\\1hKJ\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005Y1.\u00194lC\u000e{gNZ5h!\tQb&\u0003\u00020\u001b\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019\tXo\u001c;bgV\t!\u0007\u0005\u00024{9\u0011Ag\u000f\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001\b\u0010\u0013\taT\"\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0002?\u007f\ti\u0011+^8uC6\u000bg.Y4feNT!\u0001P\u0007\u0002\u000fE,x\u000e^1tA\u0005y1.\u00194lC\u000e{g\u000e\u001e:pY2,'\u000f\u0005\u0002D\r6\tAI\u0003\u0002F\u001f\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005\u001d#%aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\rqJg.\u001b;?)\u0015Q5\nT'O!\tQ\u0002\u0001C\u0003$\u000f\u0001\u0007Q\u0005C\u0003-\u000f\u0001\u0007Q\u0006C\u00031\u000f\u0001\u0007!\u0007C\u0003B\u000f\u0001\u0007!)A\bva\u0012\fG/\u001a'pO\u000e{gNZ5h)\u0011\tFK\u00185\u0011\u0005Q\u0011\u0016BA*\u0016\u0005\u0011)f.\u001b;\t\u000bUC\u0001\u0019\u0001,\u0002\u000bQ|\u0007/[2\u0011\u0005][fB\u0001-Z!\t1T#\u0003\u0002[+\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQV\u0003C\u0003`\u0011\u0001\u0007\u0001-A\u0006u_BL7mQ8oM&<\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B5\t\u0001\u0004Q\u0017\u0001F2p]\u001aLwMT1nKN$v.\u0012=dYV$W\rE\u0002XWZK!\u0001\\/\u0003\u0007M+G/\u0001\u000bqe>\u001cWm]:D_:4\u0017nZ\"iC:<Wm\u001d\u000b\u0004#>\u0004\b\"B+\n\u0001\u00041\u0006\"B0\n\u0001\u0004\u0001\u0017\u0001\u00079beN,G\u000b\u001b:piRdW\r\u001a)beRLG/[8ogR!1\u000f`?\u0000!\r!x/_\u0007\u0002k*\u0011a/F\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=v\u0005\r\u0019V-\u001d\t\u0003)iL!a_\u000b\u0003\u0007%sG\u000fC\u0003`\u0015\u0001\u0007\u0001\rC\u0003\u007f\u0015\u0001\u0007\u00110\u0001\u0005ce>\\WM]%e\u0011\u0019\t\tA\u0003a\u0001-\u0006!\u0001O]8q\u0003=)\u0007p\u00197vI\u0016$7i\u001c8gS\u001e\u001cH#\u00026\u0002\b\u0005%\u0001\"B+\f\u0001\u00041\u0006\"B0\f\u0001\u0004\u0001\u0007")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final KafkaController kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private void updateLogConfig(String topic, Properties topicConfig, Set<String> configNamesToExclude) {
        this.logManager().topicConfigUpdated(topic);
        Seq<Log> logs = this.logManager().logsByTopic(topic);
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfig).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
                if (!configNamesToExclude.contains(key)) {
                    return props.put(key, value);
                }
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            logs.foreach((Function1 & Serializable)x$1 -> {
                x$1.updateConfig(logConfig);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        this.updateLogConfig(topic, topicConfig, configNamesToExclude);
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            this.kafkaController.enableTopicUncleanLeaderElection(topic);
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        scala.collection.immutable.Seq seq;
        block7: {
            String configValue;
            block5: {
                block6: {
                    configValue = topicConfig.get(prop).toString().trim();
                    ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
                    switch (configValue == null ? 0 : configValue.hashCode()) {
                        case 0: {
                            if ("".equals(configValue)) {
                                break;
                            }
                            break block5;
                        }
                        case 42: {
                            if (!"*".equals(configValue)) break block5;
                            break block6;
                        }
                        default: {
                            break block5;
                        }
                    }
                    seq = Nil$.MODULE$;
                    break block7;
                }
                seq = Constants$.MODULE$.AllReplicas();
                break block7;
            }
            seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$2 -> x$2.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$3)))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
        }
        return seq;
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable)versionString -> {
            if ($this.kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply((String)versionString))) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Log configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").toString()).append(new StringBuilder(61).append("is not compatible with Kafka inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString()).toString());
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            return None$.MODULE$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$3) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3[1])) == brokerId$1;
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, KafkaController kafkaController) {
        this.logManager = logManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
    }
}

