/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r\rc!\u0002$H\u0001%[\u0005\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011}\u0003!\u0011!Q\u0001\neC\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005E\"A\u0011\u000e\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003c\u0011!Y\u0007A!A!\u0002\u0013\u0011\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\n\u0003+\u0001!\u0011!Q\u0001\nEDq!a\u0006\u0001\t\u0003\tI\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011Q\t\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0001\u0002J!A\u0011\u0011\u000b\u0001!\u0002\u0013\tY\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0006C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002r!A\u0011q\u0011\u0001!\u0002\u0013\t\u0019\bC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u00111\u0015\u0001!\u0002\u0013\ti\t\u0003\u0005\u0002&\u0002\u0001\r\u0011\"\u0003b\u0011%\t9\u000b\u0001a\u0001\n\u0013\tI\u000bC\u0004\u00026\u0002\u0001\u000b\u0015\u00022\t\u0015\u0005]\u0006A1A\u0005\u0002\u001d\u000bI\f\u0003\u0005\u0003\u0002\u0002\u0001\u000b\u0011BA^\r\u001d\t)\r\u0001!H\u0003\u000fD!\"!<\u001d\u0005+\u0007I\u0011AAx\u0011)\t9\u0010\bB\tB\u0003%\u0011\u0011\u001f\u0005\u000b\u0003sd\"Q3A\u0005\u0002\u0005m\bB\u0003B\u00029\tE\t\u0015!\u0003\u0002~\"9\u0011q\u0003\u000f\u0005\u0002\t\u0015\u0001b\u0002B\u00069\u0011\u0005#Q\u0002\u0005\n\u0005'a\u0012\u0011!C\u0001\u0005+A\u0011Ba\u0007\u001d#\u0003%\tA!\b\t\u0013\tMB$%A\u0005\u0002\tU\u0002\"\u0003B\u001d9\u0005\u0005I\u0011\tB\u001e\u0011!\u00119\u0005HA\u0001\n\u0003\t\u0007\"\u0003B%9\u0005\u0005I\u0011\u0001B&\u0011%\u0011)\u0006HA\u0001\n\u0003\u00129\u0006C\u0005\u0003bq\t\t\u0011\"\u0001\u0003d!I!Q\u000e\u000f\u0002\u0002\u0013\u0005#q\u000e\u0005\n\u0005gb\u0012\u0011!C!\u0005kB\u0011Ba\u001e\u001d\u0003\u0003%\tE!\u001f\t\u0013\tmD$!A\u0005B\tutA\u0003BB\u0001\u0005\u0005\t\u0012A$\u0003\u0006\u001aQ\u0011Q\u0019\u0001\u0002\u0002#\u0005qIa\"\t\u000f\u0005]\u0001\u0007\"\u0001\u0003 \"I!q\u000f\u0019\u0002\u0002\u0013\u0015#\u0011\u0010\u0005\n\u0005C\u0003\u0014\u0011!CA\u0005GC\u0011B!+1\u0003\u0003%\tIa+\t\u0011\tu\u0006\u0001\"\u0001H\u0005\u007fC\u0001Ba4\u0001\t\u00039%\u0011\u001b\u0005\b\u0005\u001f\u0004A\u0011\u0002Bk\u0011!\u0011\t\u000f\u0001C\u0001\u000f\n\r\bb\u0002Bz\u0001\u0011\u0005#Q\u001f\u0005\b\u0005o\u0004A\u0011\tB{\u0011\u001d\u0011I\u0010\u0001C\u0001\u0005kDqAa?\u0001\t\u0013\u0011i\u0010C\u0004\u0004\b\u0001!IA!>\t\u000f\r%\u0001\u0001\"\u0003\u0004\f!91\u0011\u0004\u0001\u0005\n\tU\bbBB\u000e\u0001\u0011%1Q\u0004\u0005\b\u0007W\u0001A\u0011\u0001B{\u000f)\u0019)dRA\u0001\u0012\u0003I5q\u0007\u0004\n\r\u001e\u000b\t\u0011#\u0001J\u0007sAq!a\u0006D\t\u0003\u0019Y\u0004C\u0005\u0004>\r\u000b\n\u0011\"\u0001\u0004@\tA\u0011iY2faR|'O\u0003\u0002I\u0013\u00069a.\u001a;x_J\\'\"\u0001&\u0002\u000b-\fgm[1\u0014\u0007\u0001a\u0005\u000b\u0005\u0002N\u001d6\tq)\u0003\u0002P\u000f\n!\u0012IY:ue\u0006\u001cGoU3sm\u0016\u0014H\u000b\u001b:fC\u0012\u0004\"!\u0015+\u000e\u0003IS!aU%\u0002\u000f5,GO]5dg&\u0011QK\u0015\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018\u0001C3oIB{\u0017N\u001c;\u0004\u0001U\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]\u0013\u000691\r\\;ti\u0016\u0014\u0018B\u00010\\\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u00039\u0019XM\u001c3Ck\u001a4WM]*ju\u0016,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0002K\u0006)1oY1mC&\u0011q\r\u001a\u0002\u0004\u0013:$\u0018aD:f]\u0012\u0014UO\u001a4feNK'0\u001a\u0011\u0002\u001dI,7M\u001e\"vM\u001a,'oU5{K\u0006y!/Z2w\u0005V4g-\u001a:TSj,\u0007%\u0001\u0004o_\u0012,\u0017\nZ\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN\u0004\"!\u00148\n\u0005=<%\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u00031iW\r\u001e:jGB\u0013XMZ5y!\t\u0011\u0018P\u0004\u0002toB\u0011A\u000fZ\u0007\u0002k*\u0011aoV\u0001\u0007yI|w\u000e\u001e \n\u0005a$\u0017A\u0002)sK\u0012,g-\u0003\u0002{w\n11\u000b\u001e:j]\u001eT!\u0001\u001f3\u0002\tQLW.\u001a\t\u0004}\u0006EQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0006kRLGn\u001d\u0006\u0005\u0003\u000b\t9!\u0001\u0004d_6lwN\u001c\u0006\u0004\u0015\u0006%!\u0002BA\u0006\u0003\u001b\ta!\u00199bG\",'BAA\b\u0003\ry'oZ\u0005\u0004\u0003'y(\u0001\u0002+j[\u0016\f\u0011\u0002\\8h!J,g-\u001b=\u0002\rqJg.\u001b;?)I\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0003O\tI#a\u000b\u0011\u00055\u0003\u0001\"\u0002,\r\u0001\u0004I\u0006\"\u00021\r\u0001\u0004\u0011\u0007\"B5\r\u0001\u0004\u0011\u0007\"B6\r\u0001\u0004\u0011\u0007\"\u00027\r\u0001\u0004i\u0007\"\u00029\r\u0001\u0004\t\b\"\u0002?\r\u0001\u0004i\b\u0002CA\u000b\u0019A\u0005\t\u0019A9\u0002\u00179LwnU3mK\u000e$xN]\u000b\u0003\u0003c\u0001B!a\r\u0002B5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\tY$!\u0010\u0002\u00079LwN\u0003\u0002\u0002@\u0005!!.\u0019<b\u0013\u0011\t\u0019%!\u000e\u0003\u0011M+G.Z2u_J\fAB\\5p'\u0016dWm\u0019;pe\u0002\nQb]3sm\u0016\u00148\t[1o]\u0016dWCAA&!\u0011\t\u0019$!\u0014\n\t\u0005=\u0013Q\u0007\u0002\u0014'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\\\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u0003/\u0002b!!\u0017\u0002d\u0005\u001dTBAA.\u0015\u0011\ti&a\u0018\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011\r3\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002f\u0005m#aC!se\u0006L()\u001e4gKJ\u00042!TA5\u0013\r\tYg\u0012\u0002\n!J|7-Z:t_J\f1\u0002\u001d:pG\u0016\u001c8o\u001c:tA\u0005\t\u0002O]8dKN\u001cxN]:Ti\u0006\u0014H/\u001a3\u0016\u0005\u0005M\u0004\u0003BA;\u0003\u0007k!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0007CR|W.[2\u000b\t\u0005u\u0014qP\u0001\u000bG>t7-\u001e:sK:$(\u0002BAA\u0003{\tA!\u001e;jY&!\u0011QQA<\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u0011\u0002O]8dKN\u001cxN]:Ti\u0006\u0014H/\u001a3!\u0003M\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3s+\t\ti\t\u0005\u0003\u0002\u0010\u0006}UBAAI\u0015\u0011\t\u0019*!&\u0002\t\r|'/\u001a\u0006\u0004'\u0006]%\u0002BAM\u00037\u000ba!_1n[\u0016\u0014(BAAO\u0003\r\u0019w.\\\u0005\u0005\u0003C\u000b\tJA\u0003NKR,'/\u0001\u000bcY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'\u000fI\u0001\u0016GV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3y\u0003e\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb|F%Z9\u0015\t\u0005-\u0016\u0011\u0017\t\u0004G\u00065\u0016bAAXI\n!QK\\5u\u0011!\t\u0019\fGA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u000512-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016D\b%\u0001\tuQJ|G\u000f\u001e7fIN{7m[3ugV\u0011\u00111\u0018\t\u0007\u00033\ni,!1\n\t\u0005}\u00161\f\u0002\u000e!JLwN]5usF+X-^3\u0011\u0007\u0005\rG$D\u0001\u0001\u0005I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0014\u0013q\tI-a4\u0002b\u0006\u001d\bcA2\u0002L&\u0019\u0011Q\u001a3\u0003\r\u0005s\u0017PU3g!\u0019\t\t.a7\u0002B:!\u00111[Al\u001d\r!\u0018Q[\u0005\u0002K&\u0019\u0011\u0011\u001c3\u0002\u000fA\f7m[1hK&!\u0011Q\\Ap\u0005\u001dy%\u000fZ3sK\u0012T1!!7e!\r\u0019\u00171]\u0005\u0004\u0003K$'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003#\fI/\u0003\u0003\u0002l\u0006}'\u0001D*fe&\fG.\u001b>bE2,\u0017AB:pG.,G/\u0006\u0002\u0002rB!\u00111GAz\u0013\u0011\t)0!\u000e\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003\u001d\u0019xnY6fi\u0002\n\u0011#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\ti\u0010E\u0002d\u0003\u007fL1A!\u0001e\u0005\u0011auN\\4\u0002%\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u000b\u0007\u0003\u0003\u00149A!\u0003\t\u000f\u00055\u0018\u00051\u0001\u0002r\"9\u0011\u0011`\u0011A\u0002\u0005u\u0018aB2p[B\f'/\u001a\u000b\u0004E\n=\u0001b\u0002B\tE\u0001\u0007\u0011\u0011Y\u0001\u0005i\"\fG/\u0001\u0003d_BLHCBAa\u0005/\u0011I\u0002C\u0005\u0002n\u000e\u0002\n\u00111\u0001\u0002r\"I\u0011\u0011`\u0012\u0011\u0002\u0003\u0007\u0011Q`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yB\u000b\u0003\u0002r\n\u00052F\u0001B\u0012!\u0011\u0011)Ca\f\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5B-\u0001\u0006b]:|G/\u0019;j_:LAA!\r\u0003(\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0007\u0016\u0005\u0003{\u0014\t#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005{\u0001BAa\u0010\u0003F5\u0011!\u0011\t\u0006\u0005\u0005\u0007\ni$\u0001\u0003mC:<\u0017b\u0001>\u0003B\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B'\u0005'\u00022a\u0019B(\u0013\r\u0011\t\u0006\u001a\u0002\u0004\u0003:L\b\u0002CAZQ\u0005\u0005\t\u0019\u00012\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0017\u0011\r\tm#Q\fB'\u001b\t\ty&\u0003\u0003\u0003`\u0005}#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u001a\u0003lA\u00191Ma\u001a\n\u0007\t%DMA\u0004C_>dW-\u00198\t\u0013\u0005M&&!AA\u0002\t5\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0010\u0003r!A\u00111W\u0016\u0002\u0002\u0003\u0007!-\u0001\u0005iCND7i\u001c3f)\u0005\u0011\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tu\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003f\t}\u0004\"CAZ]\u0005\u0005\t\u0019\u0001B'\u0003E!\bN]8ui2,GmU8dW\u0016$8\u000fI\u0001\u0013\t\u0016d\u0017-_3e\u00072|7/Z*pG.,G\u000fE\u0002\u0002DB\u001aR\u0001\rBE\u0005+\u0003\"Ba#\u0003\u0012\u0006E\u0018Q`Aa\u001b\t\u0011iIC\u0002\u0003\u0010\u0012\fqA];oi&lW-\u0003\u0003\u0003\u0014\n5%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!q\u0013BO\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\u0006u\u0012AA5p\u0013\u0011\tYO!'\u0015\u0005\t\u0015\u0015!B1qa2LHCBAa\u0005K\u00139\u000bC\u0004\u0002nN\u0002\r!!=\t\u000f\u0005e8\u00071\u0001\u0002~\u00069QO\\1qa2LH\u0003\u0002BW\u0005s\u0003Ra\u0019BX\u0005gK1A!-e\u0005\u0019y\u0005\u000f^5p]B91M!.\u0002r\u0006u\u0018b\u0001B\\I\n1A+\u001e9mKJB\u0011Ba/5\u0003\u0003\u0005\r!!1\u0002\u0007a$\u0003'A\u0007bI\u0012\u0004&o\\2fgN|'o\u001d\u000b\u0007\u0003W\u0013\tMa3\t\u000f\t\rW\u00071\u0001\u0003F\u0006ia.Z<Qe>\u001cWm]:peN\u0004b!!\u0017\u0003H\u0006\u001d\u0014\u0002\u0002Be\u00037\u0012aAQ;gM\u0016\u0014\bB\u0002Bgk\u0001\u0007\u0011/A\u000bqe>\u001cWm]:peRC'/Z1e!J,g-\u001b=\u0002\u001fM$\u0018M\u001d;Qe>\u001cWm]:peN$B!a+\u0003T\"1!Q\u001a\u001cA\u0002E$b!a+\u0003X\n}\u0007bBA*o\u0001\u0007!\u0011\u001c\t\u0007\u00057\u0012Y.a\u001a\n\t\tu\u0017q\f\u0002\u0004'\u0016\f\bB\u0002Bgo\u0001\u0007\u0011/\u0001\tsK6|g/\u001a)s_\u000e,7o]8sgR1\u00111\u0016Bs\u0005SDaAa:9\u0001\u0004\u0011\u0017a\u0003:f[>4XmQ8v]RDqAa;9\u0001\u0004\u0011i/\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u00075\u0013y/C\u0002\u0003r\u001e\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u0011\u00111V\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u0007I,h.\u0001\tpa\u0016t7+\u001a:wKJ\u001cvnY6fiR1\u00111\nB\u0000\u0007\u0007Aaa!\u0001=\u0001\u0004\t\u0018\u0001\u00025pgRDaa!\u0002=\u0001\u0004\u0011\u0017\u0001\u00029peR\fA#Y2dKB$h*Z<D_:tWm\u0019;j_:\u001c\u0018AB1dG\u0016\u0004H\u000f\u0006\u0003\u0004\u000e\r=\u0001#B2\u00030\u0006E\bbBB\t}\u0001\u000711C\u0001\u0004W\u0016L\b\u0003BA\u001a\u0007+IAaa\u0006\u00026\ta1+\u001a7fGRLwN\\&fs\u0006I2\r\\8tKRC'o\u001c;uY\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0003M\t7o]5h]:+woQ8o]\u0016\u001cG/[8o)!\u0011)ga\b\u0004$\r\u001d\u0002bBB\u0011\u0001\u0002\u0007\u0011\u0011_\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f\r\u0015\u0002\t1\u0001\u0002h\u0005I\u0001O]8dKN\u001cxN\u001d\u0005\b\u0007S\u0001\u0005\u0019\u0001B3\u0003!i\u0017-\u001f\"m_\u000e\\\u0017AB<bW\u0016,\b\u000fK\u0002B\u0007_\u0001BAa\u0010\u00042%!11\u0007B!\u0005!ye/\u001a:sS\u0012,\u0017\u0001C!dG\u0016\u0004Ho\u001c:\u0011\u00055\u001b5cA\"\u0002JR\u00111qG\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\r\u0005#fA9\u0003\"\u0001")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;

    public static String $lessinit$greater$default$8() {
        return "";
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$14 -> {
            x$14.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)x$15 -> {
            x$15.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$16 -> {
                x$16.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$17 -> {
                x$17.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$18)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").toString()).append(new StringBuilder(32).append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").toString()).append(new StringBuilder(39).append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").toString()).append(new StringBuilder(39).append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString()).toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        Object var3_3 = null;
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$18) {
        return x$18.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int nodeId, ConnectionQuotas connectionQuotas, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        super(connectionQuotas);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

