/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r\rq!\u0002\u001f>\u0011\u0003!e!\u0002$>\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005b\u0002)\u0002\u0005\u0004%\t!\u0015\u0005\u0007+\u0006\u0001\u000b\u0011\u0002*\t\u000fY\u000b!\u0019!C\u0001#\"1q+\u0001Q\u0001\nICq\u0001W\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004Z\u0003\u0001\u0006IA\u0015\u0005\b5\u0006\u0011\r\u0011\"\u0001R\u0011\u0019Y\u0016\u0001)A\u0005%\"9A,\u0001b\u0001\n\u0003i\u0006BB5\u0002A\u0003%a\fC\u0004k\u0003\t\u0007I\u0011A/\t\r-\f\u0001\u0015!\u0003_\r\u00111U\b\u00017\t\u0011M|!\u0011!Q\u0001\nIC\u0001\u0002^\b\u0003\u0002\u0003\u0006I!\u001e\u0005\tq>\u0011\t\u0011)A\u0005s\"Iqp\u0004B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u000fy!\u0011!Q\u0001\n\u0005%\u0001BCA\u0011\u001f\t\u0005\t\u0015!\u0003\u0002$!1aj\u0004C\u0001\u0003[)a!!\u0010\u0010\u0001\u0005}\u0002\"CA2\u001f\t\u0007I\u0011BA3\u0011!\tyh\u0004Q\u0001\n\u0005\u001d\u0004\"CAA\u001f\t\u0007I\u0011BAB\u0011!\t\tj\u0004Q\u0001\n\u0005\u0015\u0005BCAJ\u001f\t\u0007I\u0011A\u001f\u0002\u0016\"A\u0011QV\b!\u0002\u0013\t9\n\u0003\u0006\u00020>\u0011\r\u0011\"\u0001>\u0003cC\u0001\"a0\u0010A\u0003%\u00111\u0017\u0005\f\u0003\u0003|\u0001\u0019!a\u0001\n\u0013\t\u0019\rC\u0006\u0002L>\u0001\r\u00111A\u0005\n\u00055\u0007bCAj\u001f\u0001\u0007\t\u0011)Q\u0005\u0003\u000bD!\"!6\u0010\u0001\u0004\u0005\r\u0011\"\u0003R\u0011-\t9n\u0004a\u0001\u0002\u0004%I!!7\t\u0015\u0005uw\u00021A\u0001B\u0003&!\u000bC\u0005\u0002h>\u0011\r\u0011\"\u0003\u0002j\"A\u0011\u0011_\b!\u0002\u0013\tY\u000f\u0003\u0005\u0002t>!\t!PA{\u0011\u001d\typ\u0004C\u0001\u0005\u0003AqAa\u0007\u0010\t\u0003\u0011i\u0002C\u0004\u0003 =!\tA!\t\t\u000f\t\u0015s\u0002\"\u0001\u0003H!9!qJ\b\u0005\n\tE\u0003b\u0002B.\u001f\u0011\u0005!Q\f\u0005\b\u0005SzA\u0011\u0001B6\u0011\u001d\u0011)h\u0004C\u0001\u0005oBqAa\u001f\u0010\t\u0013\u0011i\b\u0003\u0005\u0003\u0014>!\t!\u0010BK\u0011\u001d\u0011\tk\u0004C\u0001\u0005GCqA!-\u0010\t\u0003\u0011\u0019\fC\u0004\u00032>!\tAa.\t\u000f\tuv\u0002\"\u0003\u0003\u001e!9!qX\b\u0005\u0002\t\u0005\u0007\"\u0003Bn\u001fE\u0005I\u0011\u0001Bo\u0011\u001d\u0011\u0019p\u0004C\u0001\u0005kD\u0011Ba?\u0010#\u0003%\tA!@\t\u000f\r\u0005q\u0002\"\u0001\u0003\u001e\u00059BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d\u0006\u0003}}\n1\u0002\u001e:b]N\f7\r^5p]*\u0011\u0001)Q\u0001\fG>|'\u000fZ5oCR|'OC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!R\u0001\u000e\u0003u\u0012q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0014\u0005\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\t\u0006yB)\u001a4bk2$HK]1og\u0006\u001cG/[8og6\u000b\u0007\u0010V5nK>,H/T:\u0016\u0003I\u0003\"!S*\n\u0005QS%aA%oi\u0006\u0001C)\u001a4bk2$HK]1og\u0006\u001cG/[8og6\u000b\u0007\u0010V5nK>,H/T:!\u0003\t\"UMZ1vYR$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006\u0019C)\u001a4bk2$HK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o\u001bN\u0004\u0013A\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj]\u0001,\t\u00164\u0017-\u001e7u\u0003\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7/\u00138uKJ4\u0018\r\\'tA\u0005qC)\u001a4bk2$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00138uKJ4\u0018\r\\'t\u0003=\"UMZ1vYR\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001c;feZ\fG.T:!\u00031iU\r\u001e:jGN<%o\\;q+\u0005q\u0006CA0g\u001d\t\u0001G\r\u0005\u0002b\u00156\t!M\u0003\u0002d\u0007\u00061AH]8pizJ!!\u001a&\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003K*\u000bQ\"T3ue&\u001c7o\u0012:pkB\u0004\u0013A\u0004'pC\u0012$\u0016.\\3TK:\u001cxN]\u0001\u0010\u0019>\fG\rV5nKN+gn]8sAM\u0019q\u0002S7\u0011\u00059\fX\"A8\u000b\u0005A\f\u0015!B;uS2\u001c\u0018B\u0001:p\u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\ng\u000eDW\rZ;mKJ\u0004\"A\u001c<\n\u0005]|'!C*dQ\u0016$W\u000f\\3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"A_?\u000e\u0003mT!\u0001`!\u0002\rM,'O^3s\u0013\tq8P\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\r\r|gNZ5h!\r)\u00151A\u0005\u0004\u0003\u000bi$!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006!A/[7f!\u0011\tY!!\b\u000e\u0005\u00055!b\u00019\u0002\u0010)!\u0011\u0011CA\n\u0003\u0019\u0019w.\\7p]*\u0019!)!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0011aA8sO&!\u0011qDA\u0007\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u0011QEA\u0015\u001b\t\t9C\u0003\u0003\u0002\"\u0005=\u0011\u0002BA\u0016\u0003O\u0011q!T3ue&\u001c7\u000f\u0006\b\u00020\u0005E\u00121GA\u001b\u0003o\tI$a\u000f\u0011\u0005\u0015{\u0001\"B:\u0017\u0001\u0004\u0011\u0006\"\u0002;\u0017\u0001\u0004)\b\"\u0002=\u0017\u0001\u0004I\bBB@\u0017\u0001\u0004\t\t\u0001C\u0004\u0002\bY\u0001\r!!\u0003\t\u000f\u0005\u0005b\u00031\u0001\u0002$\t12+\u001a8e)btW*\u0019:lKJ\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u0007J\u0003\u0003\u0012\u0016QIA)\u0003/\ni&C\u0002\u0002D)\u0013\u0011BR;oGRLwN\u001c\u001b\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013RA!a\u0013\u0002\u0010\u0005A!/Z9vKN$8/\u0003\u0003\u0002P\u0005%#!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];miB\u0019Q)a\u0015\n\u0007\u0005USHA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rE\u0002F\u00033J1!a\u0017>\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u0011\u0007%\u000by&C\u0002\u0002b)\u0013A!\u00168ji\u0006a1\u000f[;ui&tw\rR8x]V\u0011\u0011q\r\t\u0005\u0003S\nY(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0019\tGo\\7jG*!\u0011\u0011OA:\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003k\n9(\u0001\u0003vi&d'BAA=\u0003\u0011Q\u0017M^1\n\t\u0005u\u00141\u000e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001bMDW\u000f\u001e;j]\u001e$un\u001e8!\u0003%\u0019H/\u0019;f\u0019>\u001c7.\u0006\u0002\u0002\u0006B!\u0011qQAG\u001b\t\tII\u0003\u0003\u0002\f\u0006=\u0014!\u00027pG.\u001c\u0018\u0002BAH\u0003\u0013\u0013aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u000bgR\fG/\u001a'pG.\u0004\u0013!\u00057pC\u0012Lgn\u001a)beRLG/[8ogV\u0011\u0011q\u0013\t\u0007\u00033\u000b\u0019+a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bq!\\;uC\ndWMC\u0002\u0002\"*\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)+a'\u0003\u0007M+G\u000fE\u0002F\u0003SK1!a+>\u0005\t\"&/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]\u0006sG\rT3bI\u0016\u0014X\t]8dQ\u0006\u0011Bn\\1eS:<\u0007+\u0019:uSRLwN\\:!\u0003a!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003g\u0003r!!'\u00026J\u000bI,\u0003\u0003\u00028\u0006m%aA'baB\u0019Q)a/\n\u0007\u0005uVHA\u000bUq:lU\r^1eCR\f7)Y2iK\u0016sGO]=\u00023Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001'e\u0016$(/[3wKR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$XCAAc!\u0011I\u0015q\u0019*\n\u0007\u0005%'JA\u0005Gk:\u001cG/[8oa\u0005Q#/\u001a;sS\u00164X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;`I\u0015\fH\u0003BA/\u0003\u001fD\u0011\"!5\"\u0003\u0003\u0005\r!!2\u0002\u0007a$\u0013'A\u0014sKR\u0014\u0018.\u001a<f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0013A\b;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003\t\"(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtGo\u0018\u0013fcR!\u0011QLAn\u0011!\t\t\u000eJA\u0001\u0002\u0004\u0011\u0016a\b;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA!\u001aQ%!9\u0011\u0007%\u000b\u0019/C\u0002\u0002f*\u0013\u0001B^8mCRLG.Z\u0001\u0014a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN]\u000b\u0003\u0003W\u0004B!!\n\u0002n&!\u0011q^A\u0014\u0005\u0019\u0019VM\\:pe\u0006!\u0002/\u0019:uSRLwN\u001c'pC\u0012\u001cVM\\:pe\u0002\n1#\u00193e\u0019>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:$b!!\u0018\u0002x\u0006m\bBBA}Q\u0001\u0007!+A\u0006qCJ$\u0018\u000e^5p]&#\u0007BBA\u007fQ\u0001\u0007!+\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006!B/[7fI>+H\u000f\u0016:b]N\f7\r^5p]N$\"Aa\u0001\u0011\r\t\u0015!q\u0002B\u000b\u001d\u0011\u00119Aa\u0003\u000f\u0007\u0005\u0014I!C\u0001L\u0013\r\u0011iAS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tBa\u0005\u0003\u0011%#XM]1cY\u0016T1A!\u0004K!\r)%qC\u0005\u0004\u00053i$!\t+sC:\u001c\u0018m\u0019;j_:\fG.\u00133B]\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#q_\u000eD\u0017aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]R\u0011\u0011QL\u0001\u0014O\u0016$HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0005\u0005G\u0011\t\u0005\u0005\u0005\u0003\u0006\t\u0015\"\u0011\u0006B\u001b\u0013\u0011\u00119Ca\u0005\u0003\r\u0015KG\u000f[3s!\u0011\u0011YC!\r\u000e\u0005\t5\"\u0002\u0002B\u0018\u0003\u001f\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005g\u0011iC\u0001\u0004FeJ|'o\u001d\t\u0006\u0013\n]\"1H\u0005\u0004\u0005sQ%AB(qi&|g\u000eE\u0002F\u0005{I1Aa\u0010>\u0005y\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u00118e)btW*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0003D-\u0002\rAX\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006q\u0002/\u001e;Ue\u0006t7/Y2uS>t7\u000b^1uK&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0005\u0013\u0012Y\u0005\u0005\u0005\u0003\u0006\t\u0015\"\u0011\u0006B\u001e\u0011\u001d\u0011i\u0005\fa\u0001\u0003#\n1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uC\u0006qr-\u001a;B]\u0012l\u0015-\u001f2f\u0003\u0012$GK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0007\u0005G\u0011\u0019F!\u0016\t\r\t\rS\u00061\u0001_\u0011\u001d\u00119&\fa\u0001\u00053\nQc\u0019:fCR,G\r\u0016=o\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fE\u0003J\u0005o\t\t&\u0001\u000fwC2LG-\u0019;f)J\fgn]1di&|g\u000eV5nK>,H/T:\u0015\t\t}#Q\r\t\u0004\u0013\n\u0005\u0014b\u0001B2\u0015\n9!i\\8mK\u0006t\u0007B\u0002B4]\u0001\u0007!+\u0001\u0007uq:$\u0016.\\3pkRl5/A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u0011!Q\u000e\t\u0005\u0005_\u0012\t(\u0004\u0002\u0002t%!!1OA:\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004%\ne\u0004B\u0002B\"a\u0001\u0007a,A\fm_\u0006$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR1!q\u0010BC\u0005#\u0003bA\u001cBA=\u0006E\u0013b\u0001BB_\n!\u0001k\\8m\u0011\u001d\u00119)\ra\u0001\u0005\u0013\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003\f\n5UBAA\b\u0013\u0011\u0011y)a\u0004\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011Q`\u0019A\u0002I\u000bA$\u00193e\u0019>\fG-\u001a3Ue\u0006t7/Y2uS>t7\u000fV8DC\u000eDW\r\u0006\u0005\u0002^\t]%1\u0014BO\u0011\u0019\u0011IJ\ra\u0001%\u0006\tB\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8\t\r\u0005u(\u00071\u0001S\u0011\u001d\u0011yJ\ra\u0001\u0005\u007f\n!\u0003\\8bI\u0016$GK]1og\u0006\u001cG/[8og\u0006!Cn\\1e)J\fgn]1di&|gn\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u0002^\t\u0015&q\u0015BU\u0011\u0019\tIp\ra\u0001%\"1\u0011Q`\u001aA\u0002ICqAa+4\u0001\u0004\u0011i+\u0001\btK:$G\u000b\u001f8NCJ\\WM]:\u0011\u0007\t=v#D\u0001\u0010\u0003\u0019\u0012X-\\8wKR\u0013\u0018M\\:bGRLwN\\:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003;\u0012)\f\u0003\u0004\u0002zR\u0002\rA\u0015\u000b\u0007\u0003;\u0012ILa/\t\r\u0005eX\u00071\u0001S\u0011\u0019\ti0\u000ea\u0001%\u0006qc/\u00197jI\u0006$X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;JgN#\u0018M\u00197f\u0003Y\t\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><G\u0003DA/\u0005\u0007\u0014)Ma2\u0003L\nU\u0007B\u0002B\"o\u0001\u0007a\f\u0003\u0004\u0002~^\u0002\rA\u0015\u0005\b\u0005\u0013<\u0004\u0019AA,\u0003-qWm^'fi\u0006$\u0017\r^1\t\u000f\t5w\u00071\u0001\u0003P\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\b\u0013\nE'\u0011FA/\u0013\r\u0011\u0019N\u0013\u0002\n\rVt7\r^5p]FB\u0011Ba68!\u0003\u0005\rA!7\u0002\u0019I,GO]=P]\u0016\u0013(o\u001c:\u0011\u000f%\u0013\tN!\u000b\u0003`\u0005\u0001\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{w\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011yN\u000b\u0003\u0003Z\n\u00058F\u0001Br!\u0011\u0011)Oa<\u000e\u0005\t\u001d(\u0002\u0002Bu\u0005W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5(*\u0001\u0006b]:|G/\u0019;j_:LAA!=\u0003h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000fM$\u0018M\u001d;vaR1\u0011Q\fB|\u0005sDq!!1:\u0001\u0004\t)\rC\u0005\u0003\u001ce\u0002\n\u00111\u0001\u0003`\u0005\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}(\u0006\u0002B0\u0005C\f\u0001b\u001d5vi\u0012|wO\u001c")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            long now = $this.time.milliseconds();
            Lock inReadLock_inLock_lock = this.stateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$2(this, now);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable)x$3 -> (CoordinatorEpochAndTxnMetadata)x$3.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.config.transactionLogSegmentBytes()));
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var16_15 = null;
                    Object var17_16 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").toString()).append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var16_9 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var22_12 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        v0 = var23_14 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        var22_12 = null;
        var23_14 = null;
        v1 = var19_15 = v0;
        var19_15 = null;
        v2 = var17_16 = v1;
        var15_10 = null;
        var16_9 = null;
        var17_16 = null;
        records = v2;
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block10: {
                block9: {
                    var24_21 = false;
                    var25_22 = null;
                    var26_23 = this.getTransactionState(transactionalId);
                    if (!(var26_23 instanceof Left)) break block9;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var26_23).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block10;
                }
                if (!(var26_23 instanceof Right)) ** GOTO lbl-1000
                var24_21 = true;
                var25_22 = (Right)var26_23;
                var28_25 = (Option)var25_22.value();
                if (None$.MODULE$.equals(var28_25)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var24_21 && (var29_26 = (Option)var25_22.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var29_26).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback), this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8());
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var26_23);
                }
            }
            var25_22 = null;
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var29_26 = null;
            var30_27 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$7));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
        }
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            });
            return iterableOnce;
        });
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionState transactionState = ((TransactionMetadata)x0$2._2()).state();
            boolean bl2 = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
            bl = bl2;
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((TransactionMetadata)x0$3._2()).txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$12(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, TopicPartition topicPartition$1, ProduceResponse.PartitionResponse response$1) {
        scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition()));
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            toRemove.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch()))).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$12($this, transactionalIdByPartition$1, topicPartition, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        responses.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$2(TransactionStateManager $this, long now$2) {
        scala.collection.immutable.Map transactionalIdByPartition = ((IterableOps)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)x0$1._2();
            Iterable iterable = (Iterable)((IterableOps)((IterableOps)entry.metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5($this, now$2, x0$3)))).map((Function1 & Serializable)x0$4 -> {
                if (x0$4 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$4._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$4._2();
                TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable)() -> txnMetadata.prepareDead());
                TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                return transactionalIdCoordinatorEpochAndMetadata;
            });
            return iterable;
        })).groupBy((Function1 & Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)$this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable)x0$5 -> {
            MemoryRecords memoryRecords;
            MemoryRecords memoryRecords2;
            void withRecords_timestampType;
            MemoryRecords memoryRecords3;
            if (x0$5 == null) {
                throw new MatchError(null);
            }
            int partition = x0$5._1$mcI$sp();
            SimpleRecord[] deletes = (SimpleRecord[])((IterableOnceOps)((scala.collection.mutable.Iterable)x0$5._2()).map((Function1 & Serializable)entry -> new SimpleRecord(now$2, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            CompressionType withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
            byte withRecords_magic = 2;
            TimestampType timestampType = TimestampType.CREATE_TIME;
            long withRecords_initialOffset = 0L;
            MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])deletes);
            timestampType = null;
            memoryRecords3 = null;
            MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
            memoryRecords2 = null;
            MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
            Object var8_4 = null;
            memoryRecords = null;
            MemoryRecords records = memoryRecords6;
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)records);
            return tuple2;
        });
        $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
            return BoxedUnit.UNIT;
        }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$2, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$2);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$4)))) {
            return package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$2)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$2, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
            left = package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable)x$5 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$5)));
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                    TransactionState transactionState = txnMetadata.state();
                    Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition$3).append(" in ").toString()).append(new StringBuilder(65).append(totalLoadingTimeMs).append(" milliseconds, of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString()).toString());
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var15_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var13_10 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$6) {
        return x$6.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$6))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(0).append(new StringBuilder(63).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append(err$1).append(" error; ").toString()).append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$4).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(0).append(new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString()).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_10 = status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var16_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) break block13;
                            var17_17 = false;
                            var18_18 = null;
                            var19_19 = this.getTransactionState(transactionalId$4);
                            if (!(var19_19 instanceof Left)) break block14;
                            err = (Errors)((Left)var19_19).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            break block15;
                        }
                        if (!(var19_19 instanceof Right)) break block16;
                        var17_17 = true;
                        var18_18 = (Right)var19_19;
                        var21_21 = (Option)var18_18.value();
                        if (!(var21_21 instanceof Some)) break block16;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_21).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var17_17 || !None$.MODULE$.equals(var24_24 = (Option)var18_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_19);
            }
            var25_25 = false;
            var26_26 = null;
            var27_27 = this.getTransactionState(transactionalId$4);
            if (!(var27_27 instanceof Right)) ** GOTO lbl-1000
            var25_25 = true;
            var26_26 = (Right)var27_27;
            var28_28 = (Option)var26_26.value();
            if (var28_28 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_28).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_25 && None$.MODULE$.equals(var31_31 = (Option)var26_26.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_27 instanceof Left) {
                error = (Errors)((Left)var27_27).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_27);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$4, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$4);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$4, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$4).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$7) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

