/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.server.DelayedDeleteRecords;
import kafka.server.DelayedFetch;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedProduce;
import kafka.server.TopicPartitionOperationKey;
import kafka.server.TopicPartitionOperationKey$;
import org.apache.kafka.common.TopicPartition;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E3A!\u0004\b\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u000bi\u0002A\u0011A\u001e\t\u000b\t\u0003A\u0011A\"\t\u000b\u001d\u0003A\u0011A\"\t\u000b!\u0003A\u0011A\"\t\u000b%\u0003A\u0011A\"\t\u000b)\u0003A\u0011A&\t\u000b=\u0003A\u0011A&\t\u000bA\u0003A\u0011A&\u0003#\u0011+G.Y=fI>\u0003XM]1uS>t7O\u0003\u0002\u0010!\u000591\r\\;ti\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011A\u0004J\u0007\u0002;)\u0011adH\u0001\u0007G>lWn\u001c8\u000b\u0005E\u0001#BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001eL!!J\u000f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069\u0001O]8ek\u000e,\u0007c\u0001\u0015,[5\t\u0011F\u0003\u0002+!\u000511/\u001a:wKJL!\u0001L\u0015\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003Q9J!aL\u0015\u0003\u001d\u0011+G.Y=fIB\u0013x\u000eZ;dK\u0006)a-\u001a;dQB\u0019\u0001f\u000b\u001a\u0011\u0005!\u001a\u0014B\u0001\u001b*\u00051!U\r\\1zK\u00124U\r^2i\u00035!W\r\\3uKJ+7m\u001c:egB\u0019\u0001fK\u001c\u0011\u0005!B\u0014BA\u001d*\u0005Q!U\r\\1zK\u0012$U\r\\3uKJ+7m\u001c:eg\u00061A(\u001b8jiz\"R\u0001\u0010 @\u0001\u0006\u0003\"!\u0010\u0001\u000e\u00039AQAG\u0003A\u0002mAQAJ\u0003A\u0002\u001dBQ\u0001M\u0003A\u0002EBQ!N\u0003A\u0002Y\n1c\u00195fG.\fe\u000eZ\"p[BdW\r^3BY2$\u0012\u0001\u0012\t\u0003+\u0015K!A\u0012\f\u0003\tUs\u0017\u000e^\u0001\u0016G\",7m[!oI\u000e{W\u000e\u001d7fi\u00164U\r^2i\u0003]\u0019\u0007.Z2l\u0003:$7i\\7qY\u0016$X\r\u0015:pIV\u001cW-A\u000fdQ\u0016\u001c7.\u00118e\u0007>l\u0007\u000f\\3uK\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t\u0003AqW/\u001c#fY\u0006LX\r\u001a#fY\u0016$X-F\u0001M!\t)R*\u0003\u0002O-\t\u0019\u0011J\u001c;\u0002\u001f9,X\u000eR3mCf,GMR3uG\"\f\u0011C\\;n\t\u0016d\u0017-_3e!J|G-^2f\u0001")
public class DelayedOperations {
    private final TopicPartition topicPartition;
    private final DelayedOperationPurgatory<DelayedProduce> produce;
    private final DelayedOperationPurgatory<DelayedFetch> fetch;
    private final DelayedOperationPurgatory<DelayedDeleteRecords> deleteRecords;

    public void checkAndCompleteAll() {
        TopicPartitionOperationKey requestKey = TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition);
        this.fetch.checkAndComplete(requestKey);
        this.produce.checkAndComplete(requestKey);
        this.deleteRecords.checkAndComplete(requestKey);
    }

    public void checkAndCompleteFetch() {
        this.fetch.checkAndComplete(TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition));
    }

    public void checkAndCompleteProduce() {
        this.produce.checkAndComplete(TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition));
    }

    public void checkAndCompleteDeleteRecords() {
        this.deleteRecords.checkAndComplete(TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition));
    }

    public int numDelayedDelete() {
        return this.deleteRecords.numDelayed();
    }

    public int numDelayedFetch() {
        return this.fetch.numDelayed();
    }

    public int numDelayedProduce() {
        return this.produce.numDelayed();
    }

    public DelayedOperations(TopicPartition topicPartition, DelayedOperationPurgatory<DelayedProduce> produce, DelayedOperationPurgatory<DelayedFetch> fetch, DelayedOperationPurgatory<DelayedDeleteRecords> deleteRecords) {
        this.topicPartition = topicPartition;
        this.produce = produce;
        this.fetch = fetch;
        this.deleteRecords = deleteRecords;
    }
}

