/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import scala.Array$;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u001d4QAD\b\u0001\u001fUA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tC\u0001\u0011\t\u0011)A\u0005E!AQ\u0005\u0001B\u0001B\u0003%a\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"\u0002\u001f\u0001\t\u0003i\u0004B\u0002#\u0001A\u0003%a\u0004\u0003\u0004F\u0001\u0001\u0006IA\u0012\u0005\u0007\u0013\u0002\u0001\u000b\u0015\u0002\u0010\t\r)\u0003\u0001\u0015)\u0003?\u0011\u0019y\u0005\u0001)C\u0005!\")A\u000b\u0001C\u0001+\")a\f\u0001C\u0001?\nYA+[7j]\u001e<\u0006.Z3m\u0015\t\u0001\u0012#A\u0003uS6,'O\u0003\u0002\u0013'\u0005)Q\u000f^5mg*\tA#A\u0003lC\u001a\\\u0017m\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fa\u0001^5dW6\u001b8\u0001\u0001\t\u0003/}I!\u0001\t\r\u0003\t1{gnZ\u0001\no\",W\r\\*ju\u0016\u0004\"aF\u0012\n\u0005\u0011B\"aA%oi\u000691\u000f^1si6\u001b\u0018a\u0003;bg.\u001cu.\u001e8uKJ\u0004\"\u0001K\u0019\u000e\u0003%R!AK\u0016\u0002\r\u0005$x.\\5d\u0015\taS&\u0001\u0006d_:\u001cWO\u001d:f]RT!AL\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011\u0014FA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0006cV,W/\u001a\t\u0004kYBT\"A\u0016\n\u0005]Z#A\u0003#fY\u0006L\u0018+^3vKB\u0011\u0011HO\u0007\u0002\u001f%\u00111h\u0004\u0002\u000e)&lWM\u001d+bg.d\u0015n\u001d;\u0002\rqJg.\u001b;?)\u0019qt\bQ!C\u0007B\u0011\u0011\b\u0001\u0005\u00069\u0019\u0001\rA\b\u0005\u0006C\u0019\u0001\rA\t\u0005\u0006K\u0019\u0001\rA\b\u0005\u0006M\u0019\u0001\ra\n\u0005\u0006g\u0019\u0001\r\u0001N\u0001\tS:$XM\u001d<bY\u00069!-^2lKR\u001c\bcA\fHq%\u0011\u0001\n\u0007\u0002\u0006\u0003J\u0014\u0018-_\u0001\fGV\u0014(/\u001a8u)&lW-A\u0007pm\u0016\u0014h\r\\8x/\",W\r\u001c\u0015\u0003\u00151\u0003\"aF'\n\u00059C\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002!\u0005$Gm\u0014<fe\u001adwn^,iK\u0016dG#A)\u0011\u0005]\u0011\u0016BA*\u0019\u0005\u0011)f.\u001b;\u0002\u0007\u0005$G\r\u0006\u0002W3B\u0011qcV\u0005\u00031b\u0011qAQ8pY\u0016\fg\u000eC\u0003[\u0019\u0001\u00071,\u0001\buS6,'\u000fV1tW\u0016sGO]=\u0011\u0005eb\u0016BA/\u0010\u00059!\u0016.\\3s)\u0006\u001c8.\u00128uef\fA\"\u00193wC:\u001cWm\u00117pG.$\"!\u00151\t\u000b\u0005l\u0001\u0019\u0001\u0010\u0002\rQLW.Z'tQ\t\u00011\r\u0005\u0002eK6\t\u0011#\u0003\u0002g#\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    private final AtomicInteger taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final long interval;
    private final TimerTaskList[] buckets;
    private long currentTime;
    private volatile TimingWheel overflowWheel;

    private synchronized void addOverflowWheel() {
        if (this.overflowWheel == null) {
            this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.taskCounter, this.queue);
        }
    }

    public boolean add(TimerTaskEntry timerTaskEntry) {
        long expiration = timerTaskEntry.expirationMs();
        if (timerTaskEntry.cancelled()) {
            return false;
        }
        if (expiration < this.currentTime + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets[(int)(virtualId % (long)this.wheelSize)];
            bucket.add(timerTaskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(timerTaskEntry);
    }

    public void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTime);
                return;
            }
        }
    }

    public static final /* synthetic */ TimerTaskList $anonfun$buckets$1(TimingWheel $this, int x$1) {
        return new TimerTaskList($this.taskCounter);
    }

    public TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.buckets = (TimerTaskList[])Array$.MODULE$.tabulate(wheelSize, (Function1 & Serializable)x$1 -> TimingWheel.$anonfun$buckets$1(this, BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(TimerTaskList.class));
        this.currentTime = startMs - startMs % tickMs;
        this.overflowWheel = null;
    }
}

