/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%v!\u0002\r\u001a\u0011\u0003\u0001c!\u0002\u0012\u001a\u0011\u0003\u0019\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"B-\u0002\t\u0003Qf\u0001\u0002\u0012\u001a\u0001uD!\"a\u0001\u0006\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\ti!\u0002B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003+)!\u0011!Q\u0001\n\u0005]\u0001BCA\u000f\u000b\t\u0005\t\u0015!\u0003\u0002 !Q\u0011QE\u0003\u0003\u0002\u0003\u0006I!a\n\t\u0015\u0005]RA!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002F\u0015\u0011\t\u0011)A\u0005\u0003\u000fB!\"!\u0014\u0006\u0005\u0003\u0005\u000b\u0011BA(\u0011)\t)&\u0002B\u0001B\u0003%\u0011q\u000b\u0005\u0007a\u0015!\t!a\u0019\t\u0011-,!\u0019!C\u0001\u0003sBq!a\u001f\u0006A\u0003%A\u000eC\u0005\u0002~\u0015\u0001\r\u0011\"\u0001\u0002\u0000!I\u0011qQ\u0003A\u0002\u0013\u0005\u0011\u0011\u0012\u0005\t\u0003++\u0001\u0015)\u0003\u0002\u0002\"9\u0011qS\u0003\u0005B\u0005e\u0005bBAP\u000b\u0011%\u0011\u0011\u0015\u0005\b\u0003G+A\u0011BAS\u0003]\u0011%o\\6fe6+G/\u00193bi\u0006\u0004VO\u00197jg\",'O\u0003\u0002\u001b7\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u001d;\u000511/\u001a:wKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001!\t\t\u0013!D\u0001\u001a\u0005]\u0011%o\\6fe6+G/\u00193bi\u0006\u0004VO\u00197jg\",'oE\u0002\u0002I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001e\u0003\u0015)H/\u001b7t\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0001\u0013!D4fiR{\u0007/[2EK2$\u0018\r\u0006\u00035\u0005>#\u0006cA\u00136o%\u0011aG\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a\u0002U\"A\u001d\u000b\u0005iZ\u0014!B5nC\u001e,'B\u0001\u0010=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005K$A\u0003+pa&\u001cG)\u001a7uC\")1i\u0001a\u0001\t\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d3S\"\u0001%\u000b\u0005%{\u0012A\u0002\u001fs_>$h(\u0003\u0002LM\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tYe\u0005C\u0003Q\u0007\u0001\u0007\u0011+\u0001\u0005oK^LU.Y4f!\tA$+\u0003\u0002Ts\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016DQ!V\u0002A\u0002Y\u000bQ\u0001Z3mi\u0006\u0004\"\u0001O,\n\u0005aK$!D'fi\u0006$\u0017\r^1EK2$\u0018-A\ngS:$7\u000b\u001e:bsB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\\U>$\bc\u0001/bI:\u0011Ql\u0018\b\u0003\u000fzK\u0011aJ\u0005\u0003A\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002cG\nA\u0011\n^3sC\ndWM\u0003\u0002aMA\u0011Q\r[\u0007\u0002M*\u0011qmO\u0001\u0007G>lWn\u001c8\n\u0005%4'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006W\u0012\u0001\r\u0001\\\u0001\tEJ|7.\u001a:JIB\u0011Q%\\\u0005\u0003]\u001a\u00121!\u00138u\u0011\u0015\u0001H\u00011\u0001r\u00039qWm\u001e+pa&\u001c7/S7bO\u0016\u0004\"\u0001\u000f:\n\u0005ML$a\u0003+pa&\u001c7/S7bO\u0016DQ!\u001e\u0003A\u0002Y\fA\u0001\\8hgB\u0019A,Y<\u0011\u0005a\\X\"A=\u000b\u0005il\u0012a\u00017pO&\u0011A0\u001f\u0002\u000b+:Lg-[3e\u0019><7\u0003B\u0003%}*\u0002\"!I@\n\u0007\u0005\u0005\u0011DA\tNKR\fG-\u0019;b!V\u0014G.[:iKJ\fAaY8oMB!\u0011qAA\u0005\u001b\u0005Y\u0012bAA\u00067\tY1*\u00194lC\u000e{gNZ5h\u00035iW\r^1eCR\f7)Y2iKB\u0019\u0011%!\u0005\n\u0007\u0005M\u0011D\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017A\u00037pO6\u000bg.Y4feB\u0019\u00010!\u0007\n\u0007\u0005m\u0011P\u0001\u0006M_\u001el\u0015M\\1hKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0003\u0002\b\u0005\u0005\u0012bAA\u00127\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tQa\u001a:pkBT1!!\r\u001e\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\t\u0005U\u00121\u0006\u0002\u0011\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fa\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\u0011\ty$a\f\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003\u0007\niD\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0003i\u0019G.[3oiF+x\u000e^1NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s!\r\t\u0013\u0011J\u0005\u0004\u0003\u0017J\"AG\"mS\u0016tG/U;pi\u0006lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001\u00044fCR,(/Z\"bG\",\u0007\u0003BA\u0004\u0003#J1!a\u0015\u001c\u0005U1\u0015N\\1mSj,GMR3biV\u0014XmQ1dQ\u0016\fQ\u0003Z=oC6L7mQ8oM&<\u0007*\u00198eY\u0016\u00148\u000f\u0005\u0004F\u00033\"\u0015QL\u0005\u0004\u00037r%aA'baB!\u0011qAA0\u0013\r\t\tg\u0007\u0002\u000e\u0007>tg-[4IC:$G.\u001a:\u0015)\u0005\u0015\u0014qMA5\u0003W\ni'a\u001c\u0002r\u0005M\u0014QOA<!\t\tS\u0001C\u0004\u0002\u0004=\u0001\r!!\u0002\t\u000f\u00055q\u00021\u0001\u0002\u0010!9\u0011QC\bA\u0002\u0005]\u0001bBA\u000f\u001f\u0001\u0007\u0011q\u0004\u0005\b\u0003Ky\u0001\u0019AA\u0014\u0011\u001d\t9d\u0004a\u0001\u0003sAq!!\u0012\u0010\u0001\u0004\t9\u0005C\u0004\u0002N=\u0001\r!a\u0014\t\u000f\u0005Us\u00021\u0001\u0002XU\tA.A\u0005ce>\\WM]%eA\u0005iqLZ5sgR\u0004VO\u00197jg\",\"!!!\u0011\u0007\u0015\n\u0019)C\u0002\u0002\u0006\u001a\u0012qAQ8pY\u0016\fg.A\t`M&\u00148\u000f\u001e)vE2L7\u000f[0%KF$B!a#\u0002\u0012B\u0019Q%!$\n\u0007\u0005=eE\u0001\u0003V]&$\b\"CAJ'\u0005\u0005\t\u0019AAA\u0003\rAH%M\u0001\u000f?\u001aL'o\u001d;Qk\nd\u0017n\u001d5!\u0003\u001d\u0001XO\u00197jg\"$b!a#\u0002\u001c\u0006u\u0005\"B+\u0016\u0001\u00041\u0006\"\u0002)\u0016\u0001\u0004\t\u0016AE5oSRL\u0017\r\\5{K6\u000bg.Y4feN$\"!a#\u0002A\u0019Lg.[:i\u0013:LG/[1mSjLgn\u001a*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0005\u0003\u0017\u000b9\u000bC\u0003Q/\u0001\u0007\u0011\u000b")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final FinalizedFeatureCache featureCache;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final int brokerId;
    private boolean _firstPublish;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<UnifiedLog> logs) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, newTopicsImage, logs);
    }

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    @Override
    public void publish(MetadataDelta delta, MetadataImage newImage) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        try {
            try {
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                this.metadataCache.setImage(newImage);
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    this.featureCache.update(featuresDelta, highestOffsetAndEpoch.offset);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$5(this, newImage, delta, topicsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable)configsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$18(this, newImage, configsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                    this.clientQuotaMetadataManager.update(clientQuotasDelta);
                    return BoxedUnit.UNIT;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Error publishing broker metadata at ").append(highestOffsetAndEpoch).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw t;
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    private void initializeManagers() {
        this.logManager.startup(this.metadataCache.getAllTopics());
        this.replicaManager.startup();
        this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
        if (strayPartitions.nonEmpty()) {
            this.replicaManager.deleteStrayReplicas(strayPartitions);
        }
        this.replicaManager.startHighWatermarkCheckPointThread();
    }

    public static final /* synthetic */ void $anonfun$publish$7(BrokerMetadataPublisher $this, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> $this.groupCoordinator.onResignation(topicPartition.partition(), (Option<Object>)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> $this.groupCoordinator.onElection(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> $this.groupCoordinator.onResignation(topicPartition.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$publish$12(BrokerMetadataPublisher $this, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> $this.txnCoordinator.onResignation(topicPartition.partition(), (Option<Object>)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> $this.txnCoordinator.onElection(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> $this.txnCoordinator.onResignation(topicPartition.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$publish$5(BrokerMetadataPublisher $this, MetadataImage newImage$1, MetadataDelta delta$2, TopicsDelta topicsDelta) {
        $this.replicaManager.applyDelta(topicsDelta, newImage$1);
        if (topicsDelta.topicWasDeleted("__consumer_offsets")) {
            topicsDelta.image().getTopic("__consumer_offsets").partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    $this.groupCoordinator.onResignation(Predef$.MODULE$.Integer2int((Integer)entry.getKey()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
        BrokerMetadataPublisher$.MODULE$.getTopicDelta("__consumer_offsets", newImage$1, delta$2).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$publish$7($this, topicDelta);
            return BoxedUnit.UNIT;
        });
        if (topicsDelta.topicWasDeleted("__transaction_state")) {
            topicsDelta.image().getTopic("__transaction_state").partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    $this.txnCoordinator.onResignation(Predef$.MODULE$.Integer2int((Integer)entry.getKey()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
        BrokerMetadataPublisher$.MODULE$.getTopicDelta("__transaction_state", newImage$1, delta$2).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$publish$12($this, topicDelta);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
        topicsDelta.deletedTopicIds().forEach(id2 -> {
            TopicImage topicImage = topicsDelta.image().getTopic(id2);
            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
        });
        if (deletedTopicPartitions.nonEmpty()) {
            $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
        }
    }

    public static final /* synthetic */ void $anonfun$publish$20(BrokerMetadataPublisher $this, MetadataImage newImage$1, ConfigResource configResource$1, String t) {
        String string;
        Properties newProperties = newImage$1.configs().configProperties(configResource$1);
        String string2 = configResource$1.name();
        switch (string2 == null ? 0 : string2.hashCode()) {
            case 0: {
                if ("".equals(string2)) {
                    string = ConfigEntityName$.MODULE$.Default();
                    break;
                }
            }
            default: {
                string = string2;
            }
        }
        ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)t)).processConfigChanges(string, newProperties);
    }

    public static final /* synthetic */ void $anonfun$publish$18(BrokerMetadataPublisher $this, MetadataImage newImage$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(configResource -> {
            ConfigResource.Type type = configResource.type();
            Object object = ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : (ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : None$.MODULE$);
            object.foreach((Function1 & Serializable)t -> {
                BrokerMetadataPublisher.$anonfun$publish$20($this, newImage$1, configResource, t);
                return BoxedUnit.UNIT;
            });
        });
    }

    public BrokerMetadataPublisher(KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, FinalizedFeatureCache featureCache, Map<String, ConfigHandler> dynamicConfigHandlers) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.featureCache = featureCache;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
    }
}

