/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.LogSegment;
import kafka.log.LogSegments$;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001\u0002\u0015*\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u0019A\u0006\u0001)A\u0005\u0011\")\u0011\f\u0001C\u00015\")Q\r\u0001C\u00015\")q\r\u0001C\u0001Q\")A\u000e\u0001C\u0001[\")A\u000f\u0001C\u0001k\")q\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001k\")\u0011\u0010\u0001C\u0001u\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002F\u0001!\t!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!$\u0001\t\u0003\ty\tC\u0004\u0002\u0016\u0002!\t!a&\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006\u0002CAU\u0001\u0011\u0005\u0011&a+\t\u000f\u0005=\u0006\u0001\"\u0001\u0002 \"9\u00111\u0017\u0001\u0005\u0002\u0005\u0015\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!a2\u0001\t\u0003\tImB\u0004\u0002V&B\t!a6\u0007\r!J\u0003\u0012AAm\u0011\u0019\tE\u0005\"\u0001\u0002\\\"9\u00111\u0019\u0013\u0005\u0002\u0005u\u0007bBAqI\u0011\u0005\u00111\u001d\u0002\f\u0019><7+Z4nK:$8O\u0003\u0002+W\u0005\u0019An\\4\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u00028\u007f5\t\u0001H\u0003\u0002:u\u000511m\\7n_:T!\u0001L\u001e\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0005\u0003\u0001b\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003\u0007\u0016\u0003\"\u0001\u0012\u0001\u000e\u0003%BQ!\u000e\u0002A\u0002Y\n\u0001b]3h[\u0016tGo]\u000b\u0002\u0011B!\u0011\n\u0015*V\u001b\u0005Q%BA&M\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001b:\u000bA!\u001e;jY*\tq*\u0001\u0003kCZ\f\u0017BA)K\u0005Y\u0019uN\\2veJ,g\u000e\u001e(bm&<\u0017M\u00197f\u001b\u0006\u0004\bC\u0001\u0019T\u0013\t!\u0016G\u0001\u0003M_:<\u0007C\u0001#W\u0013\t9\u0016F\u0001\u0006M_\u001e\u001cVmZ7f]R\f\u0011b]3h[\u0016tGo\u001d\u0011\u0002\u000f%\u001cX)\u001c9usV\t1\f\u0005\u000219&\u0011Q,\r\u0002\b\u0005>|G.Z1oQ\t)q\f\u0005\u0002aG6\t\u0011M\u0003\u0002cW\u0005)Q\u000f^5mg&\u0011A-\u0019\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0017\u0001\u00038p]\u0016k\u0007\u000f^=)\u0005\u0019y\u0016aA1eIR\u0011Q+\u001b\u0005\u0006U\u001e\u0001\r!V\u0001\bg\u0016<W.\u001a8uQ\t9q,\u0001\u0004sK6|g/\u001a\u000b\u0003]F\u0004\"\u0001M8\n\u0005A\f$\u0001B+oSRDQA\u001d\u0005A\u0002I\u000baa\u001c4gg\u0016$\bF\u0001\u0005`\u0003\u0015\u0019G.Z1s)\u0005q\u0007FA\u0005`\u0003\u0015\u0019Gn\\:f\u00035\u0019Gn\\:f\u0011\u0006tG\r\\3sg\u0006yQ\u000f\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000f\u0006\u0002ow\")A\u0010\u0004a\u0001{\u0006\u0019A-\u001b:\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tAT\u0001\u0003S>L1!!\u0002\u0000\u0005\u00111\u0015\u000e\\3\u0002!9,XNY3s\u001f\u001a\u001cVmZ7f]R\u001cXCAA\u0006!\r\u0001\u0014QB\u0005\u0004\u0003\u001f\t$aA%oi\"\u0012QbX\u0001\fE\u0006\u001cXm\u00144gg\u0016$8/\u0006\u0002\u0002\u0018A)\u0011\u0011DA\u0015%:!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011[\u00051AH]8pizJ\u0011AM\u0005\u0004\u0003O\t\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003W\tiC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t9#M\u0001\tG>tG/Y5ogR\u00191,a\r\t\u000bI|\u0001\u0019\u0001*)\u0005=y\u0016aA4fiR!\u00111HA!!\u0011\u0001\u0014QH+\n\u0007\u0005}\u0012G\u0001\u0004PaRLwN\u001c\u0005\u0006eB\u0001\rA\u0015\u0015\u0003!}\u000baA^1mk\u0016\u001cXCAA%!\u0015\tI\"!\u000bV)\u0019\tI%!\u0014\u0002R!1\u0011q\n\nA\u0002I\u000bAA\u001a:p[\"1\u00111\u000b\nA\u0002I\u000b!\u0001^8\u000219|g.Q2uSZ,Gj\\4TK\u001elWM\u001c;t\rJ|W\u000e\u0006\u0003\u0002J\u0005e\u0003BBA('\u0001\u0007!+\u0001\u0006gY>|'/\u00128uef$B!a\u0018\u0002rA)\u0001'!\u0010\u0002bA1\u00111MA6%VsA!!\u001a\u0002h5\tA*C\u0002\u0002j1\u000b1!T1q\u0013\u0011\ti'a\u001c\u0003\u000b\u0015sGO]=\u000b\u0007\u0005%D\nC\u0003s)\u0001\u0007!\u000b\u000b\u0002\u0015?\u0006aa\r\\8peN+w-\\3oiR!\u00111HA=\u0011\u0015\u0011X\u00031\u0001SQ\t)r,\u0001\u0006m_^,'/\u00128uef$B!a\u0018\u0002\u0002\")!O\u0006a\u0001%\"\u0012acX\u0001\rY><XM]*fO6,g\u000e\u001e\u000b\u0005\u0003w\tI\tC\u0003s/\u0001\u0007!\u000b\u000b\u0002\u0018?\u0006Y\u0001.[4iKJ,e\u000e\u001e:z)\u0011\ty&!%\t\u000bID\u0002\u0019\u0001*)\u0005ay\u0016!\u00045jO\",'oU3h[\u0016tG\u000f\u0006\u0003\u0002<\u0005e\u0005\"\u0002:\u001a\u0001\u0004\u0011\u0006FA\r`\u0003)1\u0017N]:u\u000b:$(/_\u000b\u0003\u0003?B#AG0\u0002\u0019\u0019L'o\u001d;TK\u001elWM\u001c;\u0016\u0005\u0005m\u0002FA\u000e`\u0003Y1\u0017N]:u'\u0016<W.\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$XCAAW!\u0011\u0001\u0014Q\b*\u0002\u00131\f7\u000f^#oiJL\bFA\u000f`\u0003-a\u0017m\u001d;TK\u001elWM\u001c;)\u0005yy\u0016A\u00045jO\",'oU3h[\u0016tGo\u001d\u000b\u0005\u0003\u0013\nY\f\u0003\u0004\u0002>~\u0001\rAU\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018!D1di&4XmU3h[\u0016tG/F\u0001V\u0003-\u0019\u0018N_3J]\nKH/Z:\u0016\u0003I\u000baAZ5mi\u0016\u0014H\u0003BA%\u0003\u0017Dq!!4#\u0001\u0004\ty-A\u0005qe\u0016$\u0017nY1uKB)\u0001'!5V7&\u0019\u00111[\u0019\u0003\u0013\u0019+hn\u0019;j_:\f\u0014a\u0003'pON+w-\\3oiN\u0004\"\u0001\u0012\u0013\u0014\u0005\u0011zCCAAl)\r\u0011\u0016q\u001c\u0005\u0007\r\u001a\u0002\r!!\u0013\u0002C\u001d,GOR5sgR\u0014\u0015\r^2i)&lWm\u001d;b[B4uN]*fO6,g\u000e^:\u0015\t\u0005]\u0011Q\u001d\u0005\u0007\r\u001e\u0002\r!!\u0013")
public class LogSegments {
    private final TopicPartition topicPartition;
    private final ConcurrentNavigableMap<Object, LogSegment> segments;

    public static Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
        return LogSegments$.MODULE$.getFirstBatchTimestampForSegments(segments);
    }

    private ConcurrentNavigableMap<Object, LogSegment> segments() {
        return this.segments;
    }

    public boolean isEmpty() {
        return this.segments().isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public LogSegment add(LogSegment segment) {
        return this.segments().put(BoxesRunTime.boxToLong((long)segment.baseOffset()), segment);
    }

    public void remove(long offset) {
        this.segments().remove(BoxesRunTime.boxToLong((long)offset));
    }

    public void clear() {
        this.segments().clear();
    }

    public void close() {
        this.values().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public void closeHandlers() {
        this.values().foreach((Function1 & Serializable)x$2 -> {
            x$2.closeHandlers();
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        this.values().foreach((Function1 & Serializable)x$3 -> {
            x$3.updateParentDir(dir);
            return BoxedUnit.UNIT;
        });
    }

    public int numberOfSegments() {
        return this.segments().size();
    }

    public Iterable<Object> baseOffsets() {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(this.segments().values()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.baseOffset()));
    }

    public boolean contains(long offset) {
        return this.segments().containsKey(BoxesRunTime.boxToLong((long)offset));
    }

    public Option<LogSegment> get(long offset) {
        return Option$.MODULE$.apply(this.segments().get(BoxesRunTime.boxToLong((long)offset)));
    }

    public Iterable<LogSegment> values() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.segments().values()).asScala();
    }

    public Iterable<LogSegment> values(long from, long to) {
        if (from == to) {
            return package$.MODULE$.List().empty();
        }
        if (to < from) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(50).append("Invalid log segment range: requested segments in ").append(this.topicPartition).append(" ").toString()).append(new StringBuilder(48).append("from offset ").append(from).append(" which is greater than limit offset ").append(to).toString()).toString());
        }
        ConcurrentNavigableMap view = (ConcurrentNavigableMap)Option$.MODULE$.apply(this.segments().floorKey(BoxesRunTime.boxToLong((long)from))).map((Function1 & Serializable)floor -> LogSegments.$anonfun$values$1(this, to, BoxesRunTime.unboxToLong((Object)floor))).getOrElse((Function0 & Serializable)() -> this.segments().headMap((Object)BoxesRunTime.boxToLong((long)to)));
        return CollectionConverters$.MODULE$.CollectionHasAsScala(view.values()).asScala();
    }

    public Iterable<LogSegment> nonActiveLogSegmentsFrom(long from) {
        LogSegment activeSegment = (LogSegment)this.lastSegment().get();
        if (from > activeSegment.baseOffset()) {
            return (Iterable)package$.MODULE$.Seq().empty();
        }
        return this.values(from, activeSegment.baseOffset());
    }

    private Option<Map.Entry<Object, LogSegment>> floorEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().floorEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> floorSegment(long offset) {
        return this.floorEntry(offset).map((Function1 & Serializable)x$5 -> (LogSegment)x$5.getValue());
    }

    private Option<Map.Entry<Object, LogSegment>> lowerEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().lowerEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> lowerSegment(long offset) {
        return this.lowerEntry(offset).map((Function1 & Serializable)x$6 -> (LogSegment)x$6.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> higherEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().higherEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> higherSegment(long offset) {
        return this.higherEntry(offset).map((Function1 & Serializable)x$7 -> (LogSegment)x$7.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> firstEntry() {
        return Option$.MODULE$.apply(this.segments().firstEntry());
    }

    public Option<LogSegment> firstSegment() {
        return this.firstEntry().map((Function1 & Serializable)x$8 -> (LogSegment)x$8.getValue());
    }

    public Option<Object> firstSegmentBaseOffset() {
        return this.firstSegment().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset()));
    }

    public Option<Map.Entry<Object, LogSegment>> lastEntry() {
        return Option$.MODULE$.apply(this.segments().lastEntry());
    }

    public Option<LogSegment> lastSegment() {
        return this.lastEntry().map((Function1 & Serializable)x$10 -> (LogSegment)x$10.getValue());
    }

    public Iterable<LogSegment> higherSegments(long baseOffset) {
        java.util.Map view = (java.util.Map)Option$.MODULE$.apply(this.segments().higherKey(BoxesRunTime.boxToLong((long)baseOffset))).map((Function1 & Serializable)higherOffset -> LogSegments.$anonfun$higherSegments$1(this, BoxesRunTime.unboxToLong((Object)higherOffset))).getOrElse((Function0 & Serializable)() -> CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava());
        return CollectionConverters$.MODULE$.CollectionHasAsScala(view.values()).asScala();
    }

    public LogSegment activeSegment() {
        return (LogSegment)this.lastSegment().get();
    }

    public long sizeInBytes() {
        return LogSegments$.MODULE$.sizeInBytes(this.values());
    }

    public Iterable<LogSegment> filter(Function1<LogSegment, Object> predicate) {
        return (Iterable)this.values().filter(predicate);
    }

    public static final /* synthetic */ ConcurrentNavigableMap $anonfun$values$1(LogSegments $this, long to$1, long floor) {
        return $this.segments().subMap((Object)BoxesRunTime.boxToLong((long)floor), (Object)BoxesRunTime.boxToLong((long)to$1));
    }

    public static final /* synthetic */ ConcurrentNavigableMap $anonfun$higherSegments$1(LogSegments $this, long higherOffset) {
        return $this.segments().tailMap((Object)BoxesRunTime.boxToLong((long)higherOffset), true);
    }

    public LogSegments(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
        this.segments = new ConcurrentSkipListMap<Object, LogSegment>();
    }
}

