/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.DelegationTokenCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DelegationTokenCommand$
implements Logging {
    public static final DelegationTokenCommand$ MODULE$ = new DelegationTokenCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        DelegationTokenCommand.DelegationTokenCommandOptions opts = new DelegationTokenCommand.DelegationTokenCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to create, renew, expire, or describe delegation tokens.");
        if (Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.renewOpt(), opts.expiryOpt(), opts.describeOpt()})).count(arg_0 -> DelegationTokenCommand$.$anonfun$main$1$adapted(opts.options(), arg_0)) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --create, --renew, --expire or --describe");
        }
        opts.checkArgs();
        Admin adminClient = this.createAdminClient(opts);
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.renewOpt())) {
                    this.renewToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.expiryOpt())) {
                    this.expireToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeToken(adminClient, opts);
                }
            }
            catch (Throwable e) {
                String println_x = new StringBuilder(49).append("Error while executing delegation token command : ").append(e.getMessage()).toString();
                Console$.MODULE$.println((Object)println_x);
                Object var6_6 = null;
                if (this.logger().underlying().isErrorEnabled()) {
                    String string;
                    String string2 = string = Utils.stackTrace((Throwable)e);
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var7_8 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            adminClient.close();
            throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
        }
        adminClient.close();
        throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
    }

    public DelegationToken createToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        LinkedList linkedList;
        Option<java.util.List<KafkaPrincipal>> option = this.getPrincipals(opts, opts.renewPrincipalsOpt());
        if (option == null) {
            throw null;
        }
        Option<java.util.List<KafkaPrincipal>> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            LinkedList linkedList2;
            LinkedList linkedList3 = linkedList2 = new LinkedList();
            linkedList2 = null;
            linkedList = linkedList3;
        } else {
            linkedList = getOrElse_this.get();
        }
        LinkedList linkedList4 = linkedList;
        Object var6_3 = null;
        linkedList = null;
        java.util.List renewerPrincipals = linkedList4;
        long l = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.maxLifeTimeOpt()));
        String println_x = new StringBuilder(71).append("Calling create token operation with renewers :").append(renewerPrincipals).append(" , max-life-time-period :").append(l).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var10_8 = null;
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions().maxlifeTimeMs(l).renewers(renewerPrincipals);
        DelegationToken token = (DelegationToken)adminClient.createDelegationToken(createDelegationTokenOptions).delegationToken().get();
        String println_x2 = StringOps$.MODULE$.format$extension("Created delegation token with tokenId : %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{token.tokenInfo().tokenId()}));
        Console$.MODULE$.println((Object)println_x2);
        Object var11_11 = null;
        this.printToken((List<DelegationToken>)new .colon.colon((Object)token, (List)Nil$.MODULE$));
        return token;
    }

    public void printToken(List<DelegationToken> tokens) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String print_x = StringOps$.MODULE$.format$extension("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"}));
        Console$.MODULE$.print((Object)print_x);
        Object var4_3 = null;
        if (tokens == null) {
            throw null;
        }
        List foreach_these = tokens;
        while (!foreach_these.isEmpty()) {
            DelegationToken delegationToken = (DelegationToken)foreach_these.head();
            DelegationTokenCommand$.$anonfun$printToken$1(dateFormat, delegationToken);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private Option<java.util.List<KafkaPrincipal>> getPrincipals(DelegationTokenCommand.DelegationTokenCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(principalOptionSpec)) {
            return new Some((Object)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)opts.options().valuesOf(principalOptionSpec)).asScala().map((Function1 & Serializable)s -> SecurityUtils.parseKafkaPrincipal((String)s.trim()))).toList()).asJava());
        }
        return None$.MODULE$;
    }

    public long renewToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long l = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.renewTimePeriodOpt()));
        String println_x = new StringBuilder(63).append("Calling renew token operation with hmac :").append(hmac).append(" , renew-time-period :").append(l).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var8_5 = null;
        Long expiryTimeStamp = (Long)adminClient.renewDelegationToken(Base64.getDecoder().decode(hmac), new RenewDelegationTokenOptions().renewTimePeriodMs(l)).expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String println_x2 = StringOps$.MODULE$.format$extension("Completed renew operation. New expiry date : %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(expiryTimeStamp)}));
        Console$.MODULE$.println((Object)println_x2);
        Object var9_8 = null;
        return BoxesRunTime.unboxToLong((Object)expiryTimeStamp);
    }

    public long expireToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long l = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.expiryTimePeriodOpt()));
        String println_x = new StringBuilder(66).append("Calling expire token operation with hmac :").append(hmac).append(" , expire-time-period : ").append(l).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var8_5 = null;
        Long expiryTimeStamp = (Long)adminClient.expireDelegationToken(Base64.getDecoder().decode(hmac), new ExpireDelegationTokenOptions().expiryTimePeriodMs(l)).expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String println_x2 = StringOps$.MODULE$.format$extension("Completed expire operation. New expiry date : %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(expiryTimeStamp)}));
        Console$.MODULE$.println((Object)println_x2);
        Object var9_8 = null;
        return BoxesRunTime.unboxToLong((Object)expiryTimeStamp);
    }

    public List<DelegationToken> describeToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Option<java.util.List<KafkaPrincipal>> ownerPrincipals = this.getPrincipals(opts, opts.ownerPrincipalsOpt());
        if (ownerPrincipals.isEmpty()) {
            String println_x = "Calling describe token operation for current user.";
            Console$.MODULE$.println((Object)println_x);
            Object var8_4 = null;
        } else {
            String println_x = new StringBuilder(45).append("Calling describe token operation for owners :").append(ownerPrincipals.get()).toString();
            Console$.MODULE$.println((Object)println_x);
            Object var9_5 = null;
        }
        .eq.colon.eq orNull_ev = $less$colon$less$.MODULE$.refl();
        Object object = ownerPrincipals.isEmpty() ? orNull_ev.apply(null) : ownerPrincipals.get();
        Object object2 = object;
        Object var6_6 = null;
        object = null;
        DescribeDelegationTokenResult describeResult = adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners((java.util.List)object2));
        List tokens = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((java.util.List)describeResult.delegationTokens().get())).asScala().toList();
        Object[] objectArray = new Object[1];
        if (tokens == null) {
            throw null;
        }
        objectArray[0] = SeqOps.size$((SeqOps)tokens);
        String println_x = StringOps$.MODULE$.format$extension("Total number of tokens : %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        Console$.MODULE$.println((Object)println_x);
        Object var10_10 = null;
        this.printToken((List<DelegationToken>)tokens);
        return tokens;
    }

    private Admin createAdminClient(DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Properties props = Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null);
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ String $anonfun$main$2(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ LinkedList $anonfun$createToken$1() {
        return new LinkedList();
    }

    public static final /* synthetic */ void $anonfun$printToken$1(SimpleDateFormat dateFormat$1, DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        String print_x = StringOps$.MODULE$.format$extension("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tokenInfo.tokenId(), token.hmacAsBase64String(), tokenInfo.owner(), tokenInfo.renewersAsString(), dateFormat$1.format(tokenInfo.issueTimestamp()), dateFormat$1.format(tokenInfo.expiryTimestamp()), dateFormat$1.format(tokenInfo.maxTimestamp())}));
        Console$.MODULE$.print((Object)print_x);
        Object var3_3 = null;
        Console$.MODULE$.println();
    }

    private DelegationTokenCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }

    public static final /* synthetic */ Object $anonfun$printToken$1$adapted(SimpleDateFormat dateFormat$1, DelegationToken token) {
        DelegationTokenCommand$.$anonfun$printToken$1(dateFormat$1, token);
        return BoxedUnit.UNIT;
    }
}

