/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rEs!\u0002(P\u0011\u0003!f!\u0002,P\u0011\u00039\u0006\"\u00020\u0002\t\u0003y\u0006\u0002\u00031\u0002\u0005\u0004%\taT1\t\r)\f\u0001\u0015!\u0003c\u0011\u0015Y\u0017\u0001\"\u0001m\u0011\u0019y\u0018\u0001\"\u0003\u0002\u0002!9\u00111C\u0001\u0005\n\u0005U\u0001\u0002CA\r\u0003\u0011\u0005q*a\u0007\t\u0011\u0005%\u0014\u0001\"\u0001P\u0003W2!\"a1\u0002!\u0003\r\n!UAc\u0011\u001d\tIM\u0003D\u0001\u0003\u00174aAa\u0004\u0002\t\tE\u0001B\u0003B\u0010\u0019\t\u0005\t\u0015!\u0003\u0003\"!Q!Q\u0006\u0007\u0003\u0002\u0003\u0006IAa\f\t\rycA\u0011\u0001B\u0019\u0011\u001d\tI\r\u0004C!\u0005sAqAa\u0011\u0002\t\u0013\u0011)\u0005C\u0004\u0003n\u0005!IAa\u001c\u0007\r\u0005m\u0014\u0001AA?\u0011\u0019q6\u0003\"\u0001\u0002\u0000!I\u0011\u0011Q\nC\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003\u001b\u001b\u0002\u0015!\u0003\u0002\u0006\"I\u0011qR\nC\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003#\u001b\u0002\u0015!\u0003\u0002\u0006\"I\u00111S\nC\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003+\u001b\u0002\u0015!\u0003\u0002\u0006\"9\u0011qS\n\u0005\u0002\u0005e\u0005bBAS'\u0011\u0005\u0011q\u0015\u0005\b\u0003c\u001bB\u0011AAZ\u0011\u001d\tyl\u0005C\u0001\u0003\u00034aAa\"\u0002\t\t%\u0005B\u00020 \t\u0003\u0011i\tC\u0004\u0002J~!\tE!%\u0007\r\te\u0015\u0001\u0002BN\u0011\u0019q&\u0005\"\u0001\u0003\u001e\"9\u0011\u0011\u001a\u0012\u0005B\t\u0005fA\u0002BS\u0003\u0011\u00119\u000b\u0003\u0004_K\u0011\u0005!\u0011\u0016\u0005\n\u0005[+#\u0019!C\u0001\u0005_C\u0001B!0&A\u0003%!\u0011\u0017\u0005\b\u0003\u0013,C\u0011\tB`\r\u0019\u0011\u0019-\u0001\u0003\u0003F\"Q\u0011O\u000bB\u0001B\u0003%!Oa5\t\rySC\u0011\u0001Bk\u0011%\u0011YN\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0003l*\u0002\u000b\u0011\u0002Bp\u0011%\u0011iO\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0003p*\u0002\u000b\u0011\u0002Bp\u0011%\u0011\tP\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0003t*\u0002\u000b\u0011\u0002Bp\u0011%\u0011)P\u000bb\u0001\n\u0003\u00119\u0010\u0003\u0005\u0003\u0000*\u0002\u000b\u0011\u0002B}\u0011%\u0019\tA\u000bb\u0001\n\u0003\u0019\u0019\u0001\u0003\u0005\u0004\u000e)\u0002\u000b\u0011BB\u0003\u0011%\u0019yA\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0004\u0012)\u0002\u000b\u0011\u0002Bp\u0011%\u0019\u0019B\u000bb\u0001\n\u0003\u0019)\u0002\u0003\u0005\u0004\u001a)\u0002\u000b\u0011BB\f\u0011%\u0019YB\u000bb\u0001\n\u0003\u0019)\u0002\u0003\u0005\u0004\u001e)\u0002\u000b\u0011BB\f\u0011%\u0019yB\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0004\")\u0002\u000b\u0011\u0002Bp\u0011%\u0019\u0019C\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0004&)\u0002\u000b\u0011\u0002Bp\u0011%\u00199C\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0004*)\u0002\u000b\u0011\u0002Bp\u0011%\u0019YC\u000bb\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0004.)\u0002\u000b\u0011\u0002Bp\u0011\u001d\u0019yC\u000bC\u0001\u0007cA!ba\u0011+\u0011\u000b\u0007I\u0011AB#\u0011)\u0011YG\u000bEC\u0002\u0013\u00051Q\t\u0005\u000b\u0005'R\u0003R1A\u0005\u0002\r\u0015\u0003BCA\u0016U!\u0015\r\u0011\"\u0001\u0004F!Q\u0011\u0011\u0005\u0016\t\u0006\u0004%\ta!\u0012\t\u0015\r\u001d#\u0006#b\u0001\n\u0003\u0019I\u0005\u0003\u0006\u0002b)B)\u0019!C\u0001\u0007\u001bBqaa\u0014+\t\u0003\t\t-A\bEk6\u0004Hj\\4TK\u001elWM\u001c;t\u0015\t\u0001\u0016+A\u0003u_>d7OC\u0001S\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!V\u0001\u000e\u0003=\u0013q\u0002R;na2{wmU3h[\u0016tGo]\n\u0003\u0003a\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001U\u00031\u0011VmY8sI&sG-\u001a8u+\u0005\u0011\u0007CA2i\u001b\u0005!'BA3g\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u001bI+7m\u001c:e\u0013:$WM\u001c;!\u0003\u0011i\u0017-\u001b8\u0015\u00055\u0004\bCA-o\u0013\ty'L\u0001\u0003V]&$\b\"B9\u0006\u0001\u0004\u0011\u0018\u0001B1sON\u00042!W:v\u0013\t!(LA\u0003BeJ\f\u0017\u0010\u0005\u0002w{:\u0011qo\u001f\t\u0003qjk\u0011!\u001f\u0006\u0003uN\u000ba\u0001\u0010:p_Rt\u0014B\u0001?[\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N \u0006\u0003yj\u000bA\u0002Z;naRCh.\u00138eKb$2!\\A\u0002\u0011\u001d\t)A\u0002a\u0001\u0003\u000f\tAAZ5mKB!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0019\f!![8\n\t\u0005E\u00111\u0002\u0002\u0005\r&dW-\u0001\fek6\u0004\bK]8ek\u000e,'/\u00133T]\u0006\u00048\u000f[8u)\ri\u0017q\u0003\u0005\b\u0003\u000b9\u0001\u0019AA\u0004\u0003%!W/\u001c9J]\u0012,\u0007\u0010F\u0006n\u0003;\ty\"!\u000b\u0002.\u0005}\u0003bBA\u0003\u0011\u0001\u0007\u0011q\u0001\u0005\b\u0003CA\u0001\u0019AA\u0012\u0003=Ig\u000eZ3y'\u0006t\u0017\u000e^=P]2L\bcA-\u0002&%\u0019\u0011q\u0005.\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0006\u0005A\u0002\u0005\r\u0012A\u0003<fe&4\u0017p\u00148ms\"9\u0011q\u0006\u0005A\u0002\u0005E\u0012AG7jg6\u000bGo\u00195fg\u001a{'/\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\bcBA\u001a\u0003{)\u0018\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u00059Q.\u001e;bE2,'bAA\u001e5\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0004\u001b\u0006\u0004\bCBA\"\u0003\u001b\n\u0019F\u0004\u0003\u0002F\u0005%cb\u0001=\u0002H%\t1,C\u0002\u0002Li\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0005E#\u0001\u0002'jgRT1!a\u0013[!\u001dI\u0016QKA-\u00033J1!a\u0016[\u0005\u0019!V\u000f\u001d7feA\u0019\u0011,a\u0017\n\u0007\u0005u#L\u0001\u0003M_:<\u0007bBA1\u0011\u0001\u0007\u00111M\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f!\rI\u0016QM\u0005\u0004\u0003OR&aA%oi\u0006iA-^7q)&lW-\u00138eKb$\u0012\"\\A7\u0003_\n\t(a\u001d\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b!9\u0011\u0011E\u0005A\u0002\u0005\r\u0002bBA\u0016\u0013\u0001\u0007\u00111\u0005\u0005\b\u0003kJ\u0001\u0019AA<\u0003M!\u0018.\\3J]\u0012,\u0007\u0010R;na\u0016\u0013(o\u001c:t!\r\tIhE\u0007\u0002\u0003\t\u0019B+[7f\u0013:$W\r\u001f#v[B,%O]8sgN\u00111\u0003\u0017\u000b\u0003\u0003o\na$\\5t\u001b\u0006$8\r[3t\r>\u0014H+[7f\u0013:$W\r\u001f$jY\u0016\u001cX*\u00199\u0016\u0005\u0005\u0015\u0005cBA\u001a\u0003{)\u0018q\u0011\t\u0007\u0003g\tI)a\u0015\n\t\u0005-\u0015Q\u0007\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\u0010nSNl\u0015\r^2iKN4uN\u001d+j[\u0016Le\u000eZ3y\r&dWm]'ba\u0002\n1c\\;u\u001f\u001a|%\u000fZ3s)&lWm\u001d;b[B\fAc\\;u\u001f\u001a|%\u000fZ3s)&lWm\u001d;b[B\u0004\u0013!F:iC2dwn^(gMN,GOT8u\r>,h\u000eZ\u0001\u0017g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8eA\u00059\"/Z2pe\u0012l\u0015n]7bi\u000eDG+[7f\u0013:$W\r\u001f\u000b\b[\u0006m\u0015QTAQ\u0011\u001d\t)a\u0007a\u0001\u0003\u000fAq!a(\u001c\u0001\u0004\tI&\u0001\bj]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\t\u000f\u0005\r6\u00041\u0001\u0002Z\u0005aAn\\4US6,7\u000f^1na\u0006q\"/Z2pe\u0012|U\u000f^(g\u001fJ$WM]%oI\u0016DH+[7fgR\fW\u000e\u001d\u000b\b[\u0006%\u00161VAW\u0011\u001d\t)\u0001\ba\u0001\u0003\u000fAq!a(\u001d\u0001\u0004\tI\u0006C\u0004\u00020r\u0001\r!!\u0017\u0002%A\u0014XM^%oI\u0016DH+[7fgR\fW\u000e]\u0001\u001ce\u0016\u001cwN\u001d3TQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3\u0015\u000f5\f),a.\u0002<\"9\u0011QA\u000fA\u0002\u0005\u001d\u0001bBA];\u0001\u0007\u0011\u0011L\u0001\fS:$W\r_(gMN,G\u000fC\u0004\u0002>v\u0001\r!!\u0017\u0002\u00131|wm\u00144gg\u0016$\u0018a\u00039sS:$XI\u001d:peN$\u0012!\u001c\u0002\u000e\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\r\u0005\u001d\u0017\u0011\\Ax'\tQ\u0001,A\u0003qCJ\u001cX\r\u0006\u0003\u0002N\u0006M\bcB-\u0002V\u0005=\u00171\u001e\t\u00063\u0006E\u0017Q[\u0005\u0004\u0003'T&AB(qi&|g\u000e\u0005\u0003\u0002X\u0006eG\u0002\u0001\u0003\b\u00037T!\u0019AAo\u0005\u0005Y\u0015\u0003BAp\u0003K\u00042!WAq\u0013\r\t\u0019O\u0017\u0002\b\u001d>$\b.\u001b8h!\rI\u0016q]\u0005\u0004\u0003ST&aA!osB)\u0011,!5\u0002nB!\u0011q[Ax\t\u001d\t\tP\u0003b\u0001\u0003;\u0014\u0011A\u0016\u0005\b\u0003k\\\u0001\u0019AA|\u0003\u0019\u0011XmY8sIB!\u0011\u0011 B\u0006\u001b\t\tYP\u0003\u0003\u0002v\u0006u(\u0002BA\u0000\u0005\u0003\taaY8n[>t'b\u0001*\u0003\u0004)!!Q\u0001B\u0004\u0003\u0019\t\u0007/Y2iK*\u0011!\u0011B\u0001\u0004_J<\u0017\u0002\u0002B\u0007\u0003w\u0014aAU3d_J$'\u0001\u0006#fG>$WM]'fgN\fw-\u001a)beN,'/\u0006\u0004\u0003\u0014\te!QD\n\u0005\u0019a\u0013)\u0002E\u0004\u0002z)\u00119Ba\u0007\u0011\t\u0005]'\u0011\u0004\u0003\b\u00037d!\u0019AAo!\u0011\t9N!\b\u0005\u000f\u0005EHB1\u0001\u0002^\u0006Q1.Z=EK\u000e|G-\u001a:\u0011\r\t\r\"\u0011\u0006B\f\u001b\t\u0011)CC\u0002\u0003(E\u000b!b]3sS\u0006d\u0017N_3s\u0013\u0011\u0011YC!\n\u0003\u000f\u0011+7m\u001c3fe\u0006aa/\u00197vK\u0012+7m\u001c3feB1!1\u0005B\u0015\u00057!bAa\r\u00036\t]\u0002cBA=\u0019\t]!1\u0004\u0005\b\u0005?y\u0001\u0019\u0001B\u0011\u0011\u001d\u0011ic\u0004a\u0001\u0005_!BAa\u000f\u0003BA9\u0011,!\u0016\u0003>\t}\u0002#B-\u0002R\n]\u0001#B-\u0002R\nm\u0001bBA{!\u0001\u0007\u0011q_\u0001\bIVl\u0007\u000fT8h)5i'q\tB%\u0005\u001b\u0012\tF!\u0016\u0003j!9\u0011QA\tA\u0002\u0005\u001d\u0001b\u0002B&#\u0001\u0007\u00111E\u0001\u000eaJLg\u000e^\"p]R,g\u000e^:\t\u000f\t=\u0013\u00031\u0001\u00022\u0005\tcn\u001c8D_:\u001cXmY;uSZ,\u0007+Y5sg\u001a{'\u000fT8h\r&dWm]'ba\"9!1K\tA\u0002\u0005\r\u0012aD5t\t\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8\t\u000f\t]\u0013\u00031\u0001\u0003Z\u00051\u0001/\u0019:tKJ\u0004dAa\u0017\u0003`\t\u0015\u0004cBA=\u0015\tu#1\r\t\u0005\u0003/\u0014y\u0006\u0002\u0007\u0003b\tU\u0013\u0011!A\u0001\u0006\u0003\tiNA\u0002`IE\u0002B!a6\u0003f\u0011a!q\rB+\u0003\u0003\u0005\tQ!\u0001\u0002^\n\u0019q\f\n\u001a\t\u000f\t-\u0014\u00031\u0001\u0002$\u0005\u00112o[5q%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0003=\u0001(/\u001b8u\u0005\u0006$8\r\u001b'fm\u0016dG#B7\u0003r\t\r\u0005b\u0002B:%\u0001\u0007!QO\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0005o\u0012iH\u0004\u0003\u0002z\ne\u0014\u0002\u0002B>\u0003w\f!CR5mK2{w-\u00138qkR\u001cFO]3b[&!!q\u0010BA\u0005Y1\u0015\u000e\\3DQ\u0006tg.\u001a7SK\u000e|'\u000f\u001a\"bi\u000eD'\u0002\u0002B>\u0003wDqA!\"\u0013\u0001\u0004\tI&A\tbG\u000e,X.\u001e7bi&4XMQ=uKN\u0014Ac\u00144gg\u0016$8/T3tg\u0006<W\rU1sg\u0016\u00148\u0003B\u0010Y\u0005\u0017\u0003R!!\u001f\u000bkV$\"Aa$\u0011\u0007\u0005et\u0004\u0006\u0003\u0003\u0014\n]\u0005cB-\u0002V\tU%Q\u0013\t\u00053\u0006EW\u000fC\u0004\u0002v\u0006\u0002\r!a>\u00037Q\u0013\u0018M\\:bGRLwN\u001c'pO6+7o]1hKB\u000b'o]3s'\u0011\u0011\u0003La#\u0015\u0005\t}\u0005cAA=EQ!!1\u0013BR\u0011\u001d\t)\u0010\na\u0001\u0003o\u0014qd\u00117vgR,'/T3uC\u0012\fG/\u0019'pO6+7o]1hKB\u000b'o]3s'\u0011)\u0003La#\u0015\u0005\t-\u0006cAA=K\u0005\u0019R.\u001a;bI\u0006$\u0018MU3d_J$7+\u001a:eKV\u0011!\u0011\u0017\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*!!q\u0017B\u0001\u0003!iW\r^1eCR\f\u0017\u0002\u0002B^\u0005k\u00131#T3uC\u0012\fG/\u0019*fG>\u0014HmU3sI\u0016\fA#\\3uC\u0012\fG/\u0019*fG>\u0014HmU3sI\u0016\u0004C\u0003\u0002BJ\u0005\u0003Dq!!>*\u0001\u0004\t9P\u0001\fEk6\u0004Hj\\4TK\u001elWM\u001c;t\u001fB$\u0018n\u001c8t'\rQ#q\u0019\t\u0005\u0005\u0013\u0014y-\u0004\u0002\u0003L*\u0019!QZ)\u0002\u000bU$\u0018\u000e\\:\n\t\tE'1\u001a\u0002\u0016\u0007>lW.\u00198e\t\u00164\u0017-\u001e7u\u001fB$\u0018n\u001c8t\u0013\r\t(q\u001a\u000b\u0005\u0005/\u0014I\u000eE\u0002\u0002z)BQ!\u001d\u0017A\u0002I\f\u0001\u0002\u001d:j]R|\u0005\u000f^\u000b\u0003\u0005?\u0004BA!9\u0003h6\u0011!1\u001d\u0006\u0003\u0005K\f!B[8qiNLW\u000e\u001d7f\u0013\u0011\u0011IOa9\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'/A\u0005qe&tGo\u00149uA\u0005Ia/\u001a:jMf|\u0005\u000f^\u0001\u000bm\u0016\u0014\u0018NZ=PaR\u0004\u0013AD5oI\u0016D8+\u00198jif|\u0005\u000f^\u0001\u0010S:$W\r_*b]&$\u0018p\u00149uA\u0005Aa-\u001b7fg>\u0003H/\u0006\u0002\u0003zB)!\u0011\u001dB~k&!!Q Br\u0005m\t%oZ;nK:$\u0018iY2faRLgnZ(qi&|gn\u00159fG\u0006Ia-\u001b7fg>\u0003H\u000fI\u0001\u0012[\u0006DX*Z:tC\u001e,7+\u001b>f\u001fB$XCAB\u0003!\u0019\u0011\tOa?\u0004\bA\u00191m!\u0003\n\u0007\r-AMA\u0004J]R,w-\u001a:\u0002%5\f\u00070T3tg\u0006<WmU5{K>\u0003H\u000fI\u0001\u0011I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\f\u0011\u0003Z3fa&#XM]1uS>tw\n\u001d;!\u0003=1\u0018\r\\;f\t\u0016\u001cw\u000eZ3s\u001fB$XCAB\f!\u0015\u0011\tOa?c\u0003A1\u0018\r\\;f\t\u0016\u001cw\u000eZ3s\u001fB$\b%A\u0007lKf$UmY8eKJ|\u0005\u000f^\u0001\u000fW\u0016LH)Z2pI\u0016\u0014x\n\u001d;!\u0003)ygMZ:fiN|\u0005\u000f^\u0001\f_\u001a47/\u001a;t\u001fB$\b%A\tue\u0006t7/Y2uS>tGj\\4PaR\f!\u0003\u001e:b]N\f7\r^5p]2{wm\u00149uA\u0005\u00112\r\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00149u\u0003M\u0019G.^:uKJlU\r^1eCR\fw\n\u001d;!\u0003U\u00198.\u001b9SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PaR\fac]6jaJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fI\u0001\u000e[\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\u0005\rM\u0002GBB\u001b\u0007s\u0019y\u0004E\u0004\u0002z)\u00199d!\u0010\u0011\t\u0005]7\u0011\b\u0003\f\u0007w)\u0015\u0011!A\u0001\u0006\u0003\tiNA\u0002`IM\u0002B!a6\u0004@\u0011Y1\u0011I#\u0002\u0002\u0003\u0005)\u0011AAo\u0005\ryF\u0005N\u0001\u0013g\"|W\u000f\u001c3Qe&tG\u000fR1uC2{w-\u0006\u0002\u0002$\u0005)a-\u001b7fgV\u001111\n\t\u00043N\u0014WCAA2\u0003%\u0019\u0007.Z2l\u0003J<7\u000f")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private final OptionSpecBuilder clusterMetadataOpt = this.parser().accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
        private final OptionSpecBuilder skipRecordMetadataOpt = this.parser().accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options().has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has((OptionSpec)this.clusterMetadataOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options().has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

