/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.ZkAdminManager;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014AAC\u0006\u0001!!IQ\u0003\u0001B\u0001B\u0003%a\u0003\b\u0005\t;\u0001\u0011\t\u0011)A\u0005=!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015Y\u0006\u0001\"\u0011[\u0011\u0015a\u0006\u0001\"\u0003^\u0005M!U\r\\1zK\u0012$U\r\\3uKR{\u0007/[2t\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\f\u0013\t!2B\u0001\tEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]\u00069A-\u001a7bs6\u001b\bCA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"\u0001\u0002'p]\u001eL!!F\n\u0002\u001d\u0011,G.\u001a;f\u001b\u0016$\u0018\rZ1uCB\u0019qD\t\u0013\u000e\u0003\u0001R!!\t\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002$A\t\u00191+Z9\u0011\u0005I)\u0013B\u0001\u0014\f\u0005M!U\r\\3uKR{\u0007/[2NKR\fG-\u0019;b\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s!\t\u0011\u0012&\u0003\u0002+\u0017\tq!l[!e[&tW*\u00198bO\u0016\u0014\u0018\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u00119Rf\f&\n\u00059B\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011y\u0002GM\u001f\n\u0005E\u0002#aA'baB\u00111G\u000f\b\u0003ia\u0002\"!\u000e\r\u000e\u0003YR!aN\b\u0002\rq\u0012xn\u001c;?\u0013\tI\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d\u0019!\tq\u0004*D\u0001@\u0015\t\u0001\u0015)\u0001\u0005qe>$xnY8m\u0015\t\u00115)\u0001\u0004d_6lwN\u001c\u0006\u0003\u001d\u0011S!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO&\u0011\u0011j\u0010\u0002\u0007\u000bJ\u0014xN]:\u0011\u0005]Y\u0015B\u0001'\u0019\u0005\u0011)f.\u001b;\u0002\rqJg.\u001b;?)\u0015y\u0005+\u0015*T!\t\u0011\u0002\u0001C\u0003\u0016\u000b\u0001\u0007a\u0003C\u0003\u001e\u000b\u0001\u0007a\u0004C\u0003(\u000b\u0001\u0007\u0001\u0006C\u0003,\u000b\u0001\u0007A&A\u0006uef\u001cu.\u001c9mKR,G#\u0001,\u0011\u0005]9\u0016B\u0001-\u0019\u0005\u001d\u0011un\u001c7fC:\f!b\u001c8D_6\u0004H.\u001a;f)\u0005Q\u0015\u0001D8o\u000bb\u0004\u0018N]1uS>t\u0017a\u0003;pa&\u001cW\t_5tiN$\"A\u00160\t\u000b}K\u0001\u0019\u0001\u001a\u0002\u000bQ|\u0007/[2")
public class DelayedDeleteTopics
extends DelayedOperation {
    private final Seq<DeleteTopicMetadata> deleteMetadata;
    private final ZkAdminManager adminManager;
    private final Function1<Map<String, Errors>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Trying to complete operation for ").append($this.deleteMetadata).toString());
        int existingTopics = this.deleteMetadata.count((Function1 & java.io.Serializable & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)DelayedDeleteTopics.$anonfun$tryComplete$2(this, metadata)));
        if (existingTopics == 0) {
            this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "All topics have been deleted or have errors, completing the delayed operation");
            return this.forceComplete();
        }
        this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append(existingTopics).append(" topics still exist, not completing the delayed operation").toString());
        return false;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(25).append("Completing operation for ").append($this.deleteMetadata).toString());
        scala.collection.immutable.Map results = ((TraversableOnce)this.deleteMetadata.map((Function1 & java.io.Serializable & Serializable)metadata -> {
            Errors errors = metadata.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null) && this.topicExists(metadata.topic())) {
                return new Tuple2((Object)metadata.topic(), (Object)Errors.REQUEST_TIMED_OUT);
            }
            return new Tuple2((Object)metadata.topic(), (Object)metadata.error());
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private boolean topicExists(String topic) {
        return this.adminManager.metadataCache().contains(topic);
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(DelayedDeleteTopics $this, DeleteTopicMetadata metadata) {
        Errors errors = metadata.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null) && $this.topicExists(metadata.topic());
    }

    public DelayedDeleteTopics(long delayMs, Seq<DeleteTopicMetadata> deleteMetadata, ZkAdminManager adminManager, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        this.deleteMetadata = deleteMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

