/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.Snapshots;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class KafkaMetadataLog$ {
    public static KafkaMetadataLog$ MODULE$;

    static {
        new KafkaMetadataLog$();
    }

    public KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(config.maxBatchSizeInBytes()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), BoxesRunTime.boxToInteger((int)config.logSegmentBytes()));
        props.put(LogConfig$.MODULE$.SegmentMsProp(), BoxesRunTime.boxToLong((long)config.logSegmentMillis()));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.FileDeleteDelayMs()));
        LogConfig$.MODULE$.validateValues(props);
        LogConfig defaultLogConfig = new LogConfig(props, LogConfig$.MODULE$.apply$default$2());
        if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
            throw new InvalidConfigurationException(new StringBuilder(18).append("Cannot set ").append(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp()).append(" below ").append(config.logSegmentMinBytes()).toString());
        }
        UnifiedLog log = UnifiedLog$.MODULE$.apply(dataDir, defaultLogConfig, 0L, 0L, scheduler, new BrokerTopicStats(), time, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, new LogDirFailureChannel(5), false, (Option<Uuid>)new Some((Object)topicId), true);
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log), topicPartition, config);
        if (config.logSegmentMinBytes() != 0x800000 && metadataLog.logger().underlying().isErrorEnabled()) {
            metadataLog.logger().underlying().error(metadataLog.msgWithLogIdent(KafkaMetadataLog$.$anonfun$apply$1()));
        }
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> recoverSnapshots(UnifiedLog log) {
        void var2_2;
        TreeMap snapshots = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        try (DirectoryStream<Path> filesInDir = Files.newDirectoryStream(log.dir().toPath());){
            filesInDir.forEach(path -> Snapshots.parse((Path)path).ifPresent(snapshotPath -> {
                if (snapshotPath.partial || snapshotPath.deleted || snapshotPath.snapshotId.offset < log.logStartOffset()) {
                    Files.deleteIfExists(snapshotPath.path);
                    return;
                }
                snapshots.put((Object)snapshotPath.snapshotId, (Object)None$.MODULE$);
            }));
        }
        return var2_2;
    }

    public Function0<BoxedUnit> kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(Path logDir, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, Logging logging) {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> expiredSnapshots.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$2(logging, logDir, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$apply$1() {
        return new StringBuilder(132).append("Overriding ").append(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()).append(" is only supported for testing. Setting ").append("this value too low may lead to an inability to write batches of metadata records.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(Logging logging$1, Path logDir$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
        ((Option)x0$1._2()).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close(), logging$1, CoreUtils$.MODULE$.swallow$default$3());
            return BoxedUnit.UNIT;
        });
        boolean bl = Snapshots.deleteIfExists((Path)logDir$1, (OffsetAndEpoch)snapshotId);
        return bl;
    }

    private KafkaMetadataLog$() {
        MODULE$ = this;
    }
}

