/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkMetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015c\u0001\u0002'N\u0001QC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006S\u0002!\tA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019a\b\u0001)A\u0005a\"9Q\u0010\u0001a\u0001\n\u0013q\b\"\u0003B2\u0001\u0001\u0007I\u0011\u0002B3\u0011\u001d\u0011y\u0007\u0001Q!\n}D\u0011B!\u001f\u0001\u0005\u0004%IAa\u001f\t\u0011\t%\u0005\u0001)A\u0005\u0005{BqAa#\u0001\t\u0013\u0011i\tC\u0004\u0003.\u0002!IAa,\t\u000f\t\r\b\u0001\"\u0003\u0003f\"9!Q\u001e\u0001\u0005\n\t=\bb\u0002B}\u0001\u0011\u0005!1 \u0005\n\u00073\u0001\u0011\u0013!C\u0001\u00077A\u0011ba\b\u0001#\u0003%\taa\u0007\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91\u0011\u0006\u0001\u0005\u0002\r-\u0002bBB\u0018\u0001\u0011\u00051\u0011\u0007\u0005\b\u0007s\u0001A\u0011IB\u001e\u0011\u001d\u0019i\u0004\u0001C!\u0007\u007fAqa!\u000f\u0001\t\u0013\u0019i\u0005C\u0004\u0004R\u0001!Iaa\u0015\t\u000f\re\u0003\u0001\"\u0001\u0004\\!91q\f\u0001\u0005B\r\u0005\u0004bBB3\u0001\u0011\u00053q\r\u0005\b\u0007o\u0002A\u0011IB=\u0011\u001d\u0019y\b\u0001C!\u0007\u0003Cqaa\"\u0001\t\u0003\u0019I\tC\u0004\u0004\u000e\u0002!\taa$\t\u000f\r]\u0005\u0001\"\u0003\u0004\u001a\"91q\u0015\u0001\u0005\u0002\r%\u0006bBBY\u0001\u0011\u000511\u0017\u0005\b\u0007o\u0003A\u0011AB]\u0011\u001d\u0019\t\r\u0001C\u0001\u0007\u0007Dqa!4\u0001\t\u0003\ty\tC\u0004\u0004P\u0002!\ta!5\t\u000f\r}\u0007\u0001\"\u0001\u0004b\"91\u0011 \u0001\u0005\u0002\rm\bbBB}\u0001\u0011\u00051q \u0005\b\t\u0007\u0001A\u0011\u0002C\u0003\r\u0019\t\u0019\u0001\u0001!\u0002\u0006!Q\u00111\u0003\u0016\u0003\u0016\u0004%\t!!\u0006\t\u0015\u0005]$F!E!\u0002\u0013\t9\u0002\u0003\u0006\u0002z)\u0012)\u001a!C\u0001\u0003wB!\"a#+\u0005#\u0005\u000b\u0011BA?\u0011)\tiI\u000bBK\u0002\u0013\u0005\u0011q\u0012\u0005\u000b\u0003/S#\u0011#Q\u0001\n\u0005E\u0005BCAMU\tU\r\u0011\"\u0001\u0002\u001c\"Q\u00111\u0016\u0016\u0003\u0012\u0003\u0006I!!(\t\u0015\u00055&F!f\u0001\n\u0003\ty\u000b\u0003\u0006\u0002L*\u0012\t\u0012)A\u0005\u0003cCa!\u001b\u0016\u0005\u0002\u00055\u0007\"CAmU\t\u0007I\u0011AAn\u0011!\tyN\u000bQ\u0001\n\u0005u\u0007\"CAqU\u0005\u0005I\u0011AAr\u0011%\tyOKI\u0001\n\u0003\t\t\u0010C\u0005\u0003\b)\n\n\u0011\"\u0001\u0003\n!I!Q\u0002\u0016\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005'Q\u0013\u0013!C\u0001\u0005+A\u0011B!\u0007+#\u0003%\tAa\u0007\t\u0013\t}!&!A\u0005B\t\u0005\u0002\"\u0003B\u0017U\u0005\u0005I\u0011\u0001B\u0018\u0011%\u0011\tDKA\u0001\n\u0003\u0011\u0019\u0004C\u0005\u0003@)\n\t\u0011\"\u0011\u0003B!I!\u0011\n\u0016\u0002\u0002\u0013\u0005!1\n\u0005\n\u0005+R\u0013\u0011!C!\u0005/B\u0011B!\u0017+\u0003\u0003%\tEa\u0017\t\u0013\tu#&!A\u0005B\t}s!\u0003C\n\u0001\u0005\u0005\t\u0012\u0001C\u000b\r%\t\u0019\u0001AA\u0001\u0012\u0003!9\u0002\u0003\u0004j\u000f\u0012\u0005AQ\u0005\u0005\n\u00053:\u0015\u0011!C#\u00057B\u0011\u0002b\nH\u0003\u0003%\t\t\"\u000b\t\u0013\u0011Ur)!A\u0005\u0002\u0012]\"a\u0004.l\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u000b\u00059{\u0015\u0001C7fi\u0006$\u0017\r^1\u000b\u0005A\u000b\u0016AB:feZ,'OC\u0001S\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A+\\?B\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n1\u0011I\\=SK\u001a\u0004\"\u0001X/\u000e\u0003=K!AX(\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f!\t\u00017-D\u0001b\u0015\t\u0011\u0017+A\u0003vi&d7/\u0003\u0002eC\n9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0011\u0005Y;\u0017B\u00015X\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-l\u0007C\u00017\u0001\u001b\u0005i\u0005\"B3\u0003\u0001\u00041\u0017!\u00069beRLG/[8o\u001b\u0016$\u0018\rZ1uC2{7m[\u000b\u0002aB\u0011\u0011O_\u0007\u0002e*\u00111\u000f^\u0001\u0006Y>\u001c7n\u001d\u0006\u0003kZ\f!bY8oGV\u0014(/\u001a8u\u0015\t9\b0\u0001\u0003vi&d'\"A=\u0002\t)\fg/Y\u0005\u0003wJ\u0014aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u0017a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2lA\u0005\u0001R.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^\u000b\u0002\u007fB\u0019\u0011\u0011\u0001\u0016\u000e\u0003\u0001\u0011\u0001#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0014\r)*\u0016qAA\u0007!\r1\u0016\u0011B\u0005\u0004\u0003\u00179&a\u0002)s_\u0012,8\r\u001e\t\u0004-\u0006=\u0011bAA\t/\na1+\u001a:jC2L'0\u00192mK\u0006y\u0001/\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002\u0018AA\u0011\u0011DA\u0012\u0003O\ti$\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u001diW\u000f^1cY\u0016T1!!\tX\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\tYBA\u0005B]f\u0014VMZ'baB!\u0011\u0011FA\u001c\u001d\u0011\tY#a\r\u0011\u0007\u00055r+\u0004\u0002\u00020)\u0019\u0011\u0011G*\u0002\rq\u0012xn\u001c;?\u0013\r\t)dV\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Ur\u000b\u0005\u0004\u0002\u001a\u0005}\u00121I\u0005\u0005\u0003\u0003\nYBA\u0004M_:<W*\u00199\u0011\t\u0005\u0015\u0013\u0011\u000f\b\u0005\u0003\u000f\nYG\u0004\u0003\u0002J\u0005\u0015d\u0002BA&\u0003?rA!!\u0014\u0002\\9!\u0011qJA+\u001d\u0011\ti#!\u0015\n\u0005\u0005M\u0013aA8sO&!\u0011qKA-\u0003\u0019\t\u0007/Y2iK*\u0011\u00111K\u0005\u0004%\u0006u#\u0002BA,\u00033JA!!\u0019\u0002d\u000511m\\7n_:T1AUA/\u0013\u0011\t9'!\u001b\u0002\u000f5,7o]1hK*!\u0011\u0011MA2\u0013\u0011\ti'a\u001c\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0003O\nI'\u0003\u0003\u0002t\u0005U$\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003[\ny'\u0001\tqCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005AAo\u001c9jG&#7/\u0006\u0002\u0002~AA\u0011\u0011FA@\u0003O\t\u0019)\u0003\u0003\u0002\u0002\u0006m\"aA'baB!\u0011QQAD\u001b\t\tI'\u0003\u0003\u0002\n\u0006%$\u0001B+vS\u0012\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0005\u0005E\u0005\u0003\u0002,\u0002\u0014\u001aL1!!&X\u0005\u0019y\u0005\u000f^5p]\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\nA\"\u00197jm\u0016\u0014%o\\6feN,\"!!(\u0011\r\u0005e\u0011qHAP!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS#\u000691\r\\;ti\u0016\u0014\u0018\u0002BAU\u0003G\u0013aA\u0011:pW\u0016\u0014\u0018!D1mSZ,'I]8lKJ\u001c\b%\u0001\u0006bY&4XMT8eKN,\"!!-\u0011\r\u0005e\u0011qHAZ!!\t),a.\u0002:\u0006\u0015WBAA\u0010\u0013\u0011\t\t)a\b\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{SA!a0\u0002j\u00059a.\u001a;x_J\\\u0017\u0002BAb\u0003{\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016\u0004B!!\"\u0002H&!\u0011\u0011ZA5\u0005\u0011qu\u000eZ3\u0002\u0017\u0005d\u0017N^3O_\u0012,7\u000f\t\u000b\f\u007f\u0006=\u0017\u0011[Aj\u0003+\f9\u000eC\u0004\u0002\u0014U\u0002\r!a\u0006\t\u000f\u0005eT\u00071\u0001\u0002~!9\u0011QR\u001bA\u0002\u0005E\u0005bBAMk\u0001\u0007\u0011Q\u0014\u0005\b\u0003[+\u0004\u0019AAY\u0003)!x\u000e]5d\u001d\u0006lWm]\u000b\u0003\u0003;\u0004\u0002\"!\u000b\u0002\u0000\u0005\r\u0015qE\u0001\fi>\u0004\u0018n\u0019(b[\u0016\u001c\b%\u0001\u0003d_BLHcC@\u0002f\u0006\u001d\u0018\u0011^Av\u0003[D\u0011\"a\u00059!\u0003\u0005\r!a\u0006\t\u0013\u0005e\u0004\b%AA\u0002\u0005u\u0004\"CAGqA\u0005\t\u0019AAI\u0011%\tI\n\u000fI\u0001\u0002\u0004\ti\nC\u0005\u0002.b\u0002\n\u00111\u0001\u00022\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAzU\u0011\t9\"!>,\u0005\u0005]\b\u0003BA}\u0005\u0007i!!a?\u000b\t\u0005u\u0018q`\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0001X\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000b\tYPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\f)\"\u0011QPA{\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u0005+\t\u0005E\u0015Q_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119B\u000b\u0003\u0002\u001e\u0006U\u0018AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005;QC!!-\u0002v\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\t\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQ1A!\u000by\u0003\u0011a\u0017M\\4\n\t\u0005e\"qE\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002M\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u001b\u0005w\u00012A\u0016B\u001c\u0013\r\u0011Id\u0016\u0002\u0004\u0003:L\b\u0002\u0003B\u001f\u0001\u0006\u0005\t\u0019\u00014\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0005\u0005\u0004\u00026\n\u0015#QG\u0005\u0005\u0005\u000f\nyB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B'\u0005'\u00022A\u0016B(\u0013\r\u0011\tf\u0016\u0002\b\u0005>|G.Z1o\u0011%\u0011iDQA\u0001\u0002\u0004\u0011)$\u0001\u0005iCND7i\u001c3f)\u00051\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\r\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003N\t\u0005\u0004\"\u0003B\u001f\u000b\u0006\u0005\t\u0019\u0001B\u001b\u0003QiW\r^1eCR\f7K\\1qg\"|Go\u0018\u0013fcR!!q\rB7!\r1&\u0011N\u0005\u0004\u0005W:&\u0001B+oSRD\u0001B!\u0010\u0007\u0003\u0003\u0005\ra`\u0001\u0012[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R\u0004\u0003fA\u0004\u0003tA\u0019aK!\u001e\n\u0007\t]tK\u0001\u0005w_2\fG/\u001b7f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0005{\u0002BAa \u0003\u00066\u0011!\u0011\u0011\u0006\u0004\u0005\u0007\u000b\u0016AC2p]R\u0014x\u000e\u001c7fe&!!q\u0011BA\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b%\u0001\rnCf\u0014WMR5mi\u0016\u0014\u0018\t\\5wKJ+\u0007\u000f\\5dCN$\"Ba$\u0003\u001e\n\u0005&Q\u0015BU!\u0019\u0011\tJa%\u0003\u00186\ta/C\u0002\u0003\u0016Z\u0014A\u0001T5tiB!!Q\u0005BM\u0013\u0011\u0011YJa\n\u0003\u000f%sG/Z4fe\"1!q\u0014\u0006A\u0002}\f\u0001b\u001d8baNDw\u000e\u001e\u0005\b\u0005GS\u0001\u0019\u0001BH\u0003\u001d\u0011'o\\6feNDqAa*\u000b\u0001\u0004\tI,\u0001\u0007mSN$XM\\3s\u001d\u0006lW\rC\u0004\u0003,*\u0001\rA!\u0014\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8NKR\fG-\u0019;b)1\u0011\tLa5\u0003V\ne'1\u001cBp!\u00151\u00161\u0013BZ!\u0019\u0011)La0\u0003F:!!q\u0017B^\u001d\u0011\tiC!/\n\u0003aK1A!0X\u0003\u001d\u0001\u0018mY6bO\u0016LAA!1\u0003D\nA\u0011\n^3sC\ndWMC\u0002\u0003>^\u0003BAa2\u0003N:!\u0011q\tBe\u0013\u0011\u0011Y-a\u001c\u0002)5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011yM!5\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0005\u0017\fy\u0007\u0003\u0004\u0003 .\u0001\ra \u0005\b\u0005/\\\u0001\u0019AA\u0014\u0003\u0015!x\u000e]5d\u0011\u001d\u00119k\u0003a\u0001\u0003sCqA!8\f\u0001\u0004\u0011i%A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bb\u0002Bq\u0017\u0001\u0007!QJ\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\tiCN\fE.\u001b<f\u000b:$\u0007o\\5oiRA!Q\nBt\u0005S\u0014Y\u000f\u0003\u0004\u0003 2\u0001\ra \u0005\u0006K2\u0001\rA\u001a\u0005\b\u0005Oc\u0001\u0019AA]\u0003A9W\r^!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u0003r\nM(Q\u001fB|!\u00151\u00161SAc\u0011\u0019\u0011y*\u0004a\u0001\u007f\")Q-\u0004a\u0001M\"9!qU\u0007A\u0002\u0005e\u0016\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011ip!\u0003\u0004\u0014\rU1q\u0003\t\u0007\u0003k\u0013ypa\u0001\n\t\r\u0005\u0011q\u0004\u0002\u0004'\u0016\f\b\u0003\u0002Bd\u0007\u000bIAaa\u0002\u0003R\n)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c\u0007bBB\u0006\u001d\u0001\u00071QB\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005U6qBA\u0014\u0013\u0011\u0019\t\"a\b\u0003\u0007M+G\u000fC\u0004\u0003(:\u0001\r!!/\t\u0013\tug\u0002%AA\u0002\t5\u0003\"\u0003Bq\u001dA\u0005\t\u0019\u0001B'\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iB\u000b\u0003\u0003N\u0005U\u0018AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"\u0014a\u0004;pa&\u001cg*Y7fgR{\u0017\nZ:\u0015\u0005\r\u0015\u0002\u0003\u0003BI\u0007O\t9#a!\n\u0007\u0005\u0005e/A\bu_BL7-\u00133t)>t\u0015-\\3t)\t\u0019i\u0003\u0005\u0005\u0003\u0012\u000e\u001d\u00121QA\u0014\u0003-!x\u000e]5d\u0013\u0012LeNZ8\u0015\u0005\rM\u0002c\u0002,\u00046\r\u00152QF\u0005\u0004\u0007o9&A\u0002+va2,''\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0004\u000e\u0005\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\u0019\te!\u0013\u0011\r\u0005U6qBB\"!\u0011\t)i!\u0012\n\t\r\u001d\u0013\u0011\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0019Y%\u0006a\u0001\u0003O\t\u0011\u0002^8qS\u000et\u0015-\\3\u0015\t\r51q\n\u0005\u0007\u0005?3\u0002\u0019A@\u0002!\u001d,G/\u00117m!\u0006\u0014H/\u001b;j_:\u001cH\u0003BB+\u0007/\u0002\u0002\"!\u000b\u0002\u0000\r\r\u00131\t\u0005\u0007\u0005?;\u0002\u0019A@\u0002)\u001d,GOT8o\u000bbL7\u000f^5oOR{\u0007/[2t)\u0011\u0019ia!\u0018\t\u000f\r-\u0001\u00041\u0001\u0004\u000e\u0005q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003\u0002B'\u0007GBQ!Z\rA\u0002\u0019\fqbZ3u\u00032Lg/\u001a\"s_.,'o\u001d\u000b\u0003\u0007S\u0002bA!.\u0003@\u000e-\u0004\u0003BB7\u0007gj!aa\u001c\u000b\u0007\rE\u0014+A\u0003bI6Lg.\u0003\u0003\u0004v\r=$A\u0004\"s_.,'/T3uC\u0012\fG/Y\u0001\u0013O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$W\r\u0006\u0004\u0003r\u000em4Q\u0010\u0005\u0006Kn\u0001\rA\u001a\u0005\b\u0005O[\u0002\u0019AA]\u0003M9W\r^!mSZ,'I]8lKJtu\u000eZ3t)\u0011\u0019\u0019i!\"\u0011\r\tU&qXAc\u0011\u001d\u00119\u000b\ba\u0001\u0003s\u000b!bZ3u)>\u0004\u0018nY%e)\u0011\t\u0019ia#\t\u000f\r-S\u00041\u0001\u0002(\u0005aq-\u001a;U_BL7MT1nKR!1\u0011SBJ!\u00151\u00161SA\u0014\u0011\u001d\u0019)J\ba\u0001\u0003\u0007\u000bq\u0001^8qS\u000eLE-\u0001\rbI\u0012|%/\u00169eCR,\u0007+\u0019:uSRLwN\\%oM>$\"Ba\u001a\u0004\u001c\u000eu5qTBR\u0011\u001d\t\u0019b\ba\u0001\u0003/AqAa6 \u0001\u0004\t9\u0003\u0003\u0004\u0004\"~\u0001\rAZ\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0004&~\u0001\r!a\u0011\u0002\u0013M$\u0018\r^3J]\u001a|\u0017\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0019Yk!,\u00040B)a+a%\u0002D!9!q\u001b\u0011A\u0002\u0005\u001d\u0002BBBQA\u0001\u0007a-A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003#\u001b)\fC\u0004\u0003X\u0006\u0002\r!a\n\u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\tE81XB_\u0007\u007fCqAa6#\u0001\u0004\t9\u0003\u0003\u0004\u0004\"\n\u0002\rA\u001a\u0005\b\u0005O\u0013\u0003\u0019AA]\u0003q9W\r\u001e)beRLG/[8o%\u0016\u0004H.[2b\u000b:$\u0007o\\5oiN$ba!2\u0004H\u000e-\u0007cBA\u0015\u0003\u007f2\u0017Q\u0019\u0005\b\u0007\u0013\u001c\u0003\u0019AB\"\u0003\t!\b\u000fC\u0004\u0003(\u000e\u0002\r!!/\u0002\u001f\u001d,GoQ8oiJ|G\u000e\\3s\u0013\u0012\f!cZ3u\u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uCR111[Bm\u0007;\u0004B!!\"\u0004V&!1q[A5\u0005\u001d\u0019E.^:uKJDqaa7&\u0001\u0004\t9#A\u0005dYV\u001cH/\u001a:JI\"9!qU\u0013A\u0002\u0005e\u0016AD;qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0007\u0007G\u001c)o!;\u0011\r\u0005U&q`B\"\u0011\u0019\u00199O\na\u0001M\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012Dqaa;'\u0001\u0004\u0019i/A\u000bva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0011\t\r=8Q_\u0007\u0003\u0007cTAaa=\u0002j\u0005A!/Z9vKN$8/\u0003\u0003\u0004x\u000eE(!F+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^\u0001\tG>tG/Y5ogR!!QJB\u007f\u0011\u001d\u00119n\na\u0001\u0003O!BA!\u0014\u0005\u0002!91\u0011\u001a\u0015A\u0002\r\r\u0013a\u0005:f[>4X\rU1si&$\u0018n\u001c8J]\u001a|GC\u0003B'\t\u000f!I\u0001b\u0004\u0005\u0012!9\u00111C\u0015A\u0002\u0005]\u0001bBA=S\u0001\u0007A1\u0002\t\t\u00033!i!a\n\u0002\u0004&!\u0011\u0011QA\u000e\u0011\u001d\u00119.\u000ba\u0001\u0003OAaa!)*\u0001\u00041\u0017\u0001E'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u!\r\t\taR\n\u0006\u000f\u0012e\u0011Q\u0002\t\u0010\t7!\t#a\u0006\u0002~\u0005E\u0015QTAY\u007f6\u0011AQ\u0004\u0006\u0004\t?9\u0016a\u0002:v]RLW.Z\u0005\u0005\tG!iBA\tBEN$(/Y2u\rVt7\r^5p]V\"\"\u0001\"\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017}$Y\u0003\"\f\u00050\u0011EB1\u0007\u0005\b\u0003'Q\u0005\u0019AA\f\u0011\u001d\tIH\u0013a\u0001\u0003{Bq!!$K\u0001\u0004\t\t\nC\u0004\u0002\u001a*\u0003\r!!(\t\u000f\u00055&\n1\u0001\u00022\u00069QO\\1qa2LH\u0003\u0002C\u001d\t\u0003\u0002RAVAJ\tw\u0001RB\u0016C\u001f\u0003/\ti(!%\u0002\u001e\u0006E\u0016b\u0001C /\n1A+\u001e9mKVB\u0001\u0002b\u0011L\u0003\u0003\u0005\ra`\u0001\u0004q\u0012\u0002\u0004")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(scala.math.package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(brokers).asScala()).foreach((Function1 & Serializable & scala.Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError(null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List offlineReplicas = partitionState.offlineReplicas();
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(isr).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.metadataSnapshot().topicIds()).asJava());
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.metadataSnapshot().topicNames()).asJava());
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return new Tuple2(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(snapshot.topicIds()).asJava()), Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(snapshot.topicNames()).asJava()));
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((TraversableOnce)((MapLike)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(topicName, p.partitionIndex()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return topics.diff((GenSet)this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Option$.MODULE$.option2Iterable(x$5.getNode(listenerName)), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)this.metadataSnapshot().topicIds().getOrElse((Object)topicName, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return this.metadataSnapshot().topicNames().get((Object)topicId);
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.get((long)tp.partition())).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long id = x0$1._1$mcJ$sp();
            Map nodesByListener = (Map)x0$1._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(nodesByListener.get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node)));
            return iterable;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$9(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.partitionMetadataLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable & scala.Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Uuid uuid = (Uuid)x0$1._2();
        Uuid uuid2 = Uuid.ZERO_UUID;
        boolean bl = uuid == null ? uuid2 != null : !uuid.equals(uuid2);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$10(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((TraversableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        void var10_10;
        void var9_9;
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), CollectionConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map topicIds = Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        Tuple2 tuple2 = ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest$1.topicStates()).asScala()).map((Function1 & Serializable & scala.Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()), Buffer$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer newTopicIds = (Buffer)tuple2._1();
        Buffer newZeroIds = (Buffer)tuple2._2();
        void newTopicIds2 = var9_9;
        var10_10.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String zeroIdTopic = (String)x0$2._1();
            Option option = topicIds.remove((Object)zeroIdTopic);
            return option;
        });
        topicIds.$plus$plus$eq((TraversableOnce)newTopicIds2.toMap(Predef$.MODULE$.$conforms()));
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$10(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            };
            Map<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods($this.metadataSnapshot().partitionStates());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable & scala.Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public ZkMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        private final scala.collection.immutable.Map<Uuid, String> topicNames;
        public final /* synthetic */ ZkMetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public scala.collection.immutable.Map<Uuid, String> topicNames() {
            return this.topicNames;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$2() {
            return this.topicIds();
        }

        public Option<Object> copy$default$3() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$4() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$5() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicIds();
                }
                case 2: {
                    return this.controllerId();
                }
                case 3: {
                    return this.aliveBrokers();
                }
                case 4: {
                    return this.aliveNodes();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$metadata$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.topicNames = (scala.collection.immutable.Map)topicIds.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Uuid topicId = (Uuid)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)topicId, (Object)topicName);
                return tuple2;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        }
    }
}

