/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.RaftReplicaManager;
import kafka.server.RequestHandlerHelper$;
import kafka.server.metadata.BrokerMetadataListener$;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBroker$;
import kafka.server.metadata.MetadataImage;
import kafka.server.metadata.MetadataImageBuilder;
import kafka.server.metadata.MetadataPartition;
import kafka.server.metadata.MetadataPartition$;
import kafka.server.metadata.RaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.QuotaRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metalog.MetaLogLeader;
import org.apache.kafka.metalog.MetaLogListener;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\tmx!\u0002\u001f>\u0011\u0003!e!\u0002$>\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005b\u0002)\u0002\u0005\u0004%\t!\u0015\u0005\u00075\u0006\u0001\u000b\u0011\u0002*\t\u000fm\u000b!\u0019!C\u0001#\"1A,\u0001Q\u0001\nI3AAR\u001f\u0001;\"A!o\u0002B\u0001B\u0003%1\u000f\u0003\u0005w\u000f\t\u0005\t\u0015!\u0003x\u0011%yxA!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\b\u001d\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\u0004\b\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\t\tc\u0002B\u0001B\u0003%\u00111\u0005\u0005\u000b\u0003W9!\u0011!Q\u0001\n\u00055\u0002BCA\u001d\u000f\t\u0005\t\u0015!\u0003\u0002<!Q\u0011QK\u0004\u0003\u0002\u0003\u0006I!a\u0016\t\r9;A\u0011AA/\u0011%\t\u0019h\u0002b\u0001\n\u0013\t)\b\u0003\u0005\u0002~\u001d\u0001\u000b\u0011BA<\u0011%\tyh\u0002b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\u0010\u001e\u0001\u000b\u0011BAB\u0011%\t\tj\u0002b\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002,\u001e\u0001\u000b\u0011BAK\u0011%\tik\u0002b\u0001\n\u0013\t\u0019\n\u0003\u0005\u00020\u001e\u0001\u000b\u0011BAK\u0011%\t\tl\u0002a\u0001\n\u0013\t\u0019\fC\u0005\u0002<\u001e\u0001\r\u0011\"\u0003\u0002>\"A\u0011\u0011Z\u0004!B\u0013\t)\fC\u0005\u0002T\u001e\u0011\r\u0011\"\u0001\u0002V\"A\u00111]\u0004!\u0002\u0013\t9\u000eC\u0004\u0002f\u001e!\t!a:\t\u000f\u0005%x\u0001\"\u0011\u0002l\"A!QB\u0004\u0005\u0002u\u0012yA\u0002\u0004\u0003\u0016\u001d\u0001!q\u0003\u0005\u000b\u0003_\u0014#\u0011!Q\u0001\n\u0005U\u0006BCAzE\t\u0005\t\u0015!\u0003\u0002v\"1aJ\tC\u0001\u0005OAqA!\r#\t\u0003\u0012\u0019\u0004C\u0004\u00036\u001d!IAa\u000e\t\u000f\t%s\u0001\"\u0001\u0003L!9!1L\u0004\u0005\u0002\tu\u0003b\u0002B5\u000f\u0011\u0005!1\u000e\u0005\b\u0005o:A\u0011\u0001B=\u0011\u001d\u0011)i\u0002C\u0001\u0005\u000fCqA!%\b\t\u0003\u0011\u0019\nC\u0004\u0003 \u001e!\tA!)\t\u000f\t5v\u0001\"\u0001\u00030\"9!1X\u0004\u0005\u0002\tu\u0006b\u0002Be\u000f\u0011\u0005!1\u001a\u0004\u0007\u0005/<\u0001A!7\t\u0015\tm'G!A!\u0002\u0013\u0011i\u000e\u0003\u0004Oe\u0011\u0005!1\u001d\u0005\b\u0005c\u0011D\u0011\tB\u001a\u0011\u001d\u0011Io\u0002C!\u0005W4aAa<\b\u0001\tE\bB\u0002(8\t\u0003\u0011\u0019\u0010C\u0004\u00032]\"\tEa\r\t\u000f\t]x\u0001\"\u0011\u00034!9!\u0011`\u0004\u0005\u0002\tM\u0012A\u0006\"s_.,'/T3uC\u0012\fG/\u0019'jgR,g.\u001a:\u000b\u0005yz\u0014\u0001C7fi\u0006$\u0017\r^1\u000b\u0005\u0001\u000b\u0015AB:feZ,'OC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!R\u0001\u000e\u0003u\u0012aC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM]\n\u0003\u0003!\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001E\u0003uiU\r^1eCR\f')\u0019;dQB\u0013xnY3tg&tw\rV5nKV\u001bX#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u00027b]\u001eT\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z)\n11\u000b\u001e:j]\u001e\fa$T3uC\u0012\fG/\u0019\"bi\u000eD\u0007K]8dKN\u001c\u0018N\\4US6,Wk\u001d\u0011\u0002%5+G/\u00193bi\u0006\u0014\u0015\r^2i'&TXm]\u0001\u0014\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195TSj,7\u000fI\n\u0005\u000fy\u000bG\u000e\u0005\u0002T?&\u0011\u0001\r\u0016\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\tTW\"A2\u000b\u0005\u0011,\u0017aB7fi\u0006dwn\u001a\u0006\u0003\u0005\u001aT!a\u001a5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0017aA8sO&\u00111n\u0019\u0002\u0010\u001b\u0016$\u0018\rT8h\u0019&\u001cH/\u001a8feB\u0011Q\u000e]\u0007\u0002]*\u0011q.Q\u0001\b[\u0016$(/[2t\u0013\t\thNA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003\u0013RL!!\u001e&\u0003\u0007%sG/\u0001\u0003uS6,\u0007C\u0001=~\u001b\u0005I(B\u0001>|\u0003\u0015)H/\u001b7t\u0015\taX-\u0001\u0004d_6lwN\\\u0005\u0003}f\u0014A\u0001V5nK\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u00042!RA\u0002\u0013\r\t)!\u0010\u0002\u0012%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017\u0001E2p]\u001aLwMU3q_NLGo\u001c:z!\r)\u00151B\u0005\u0004\u0003\u001bi$AF\"bG\",GmQ8oM&<'+\u001a9pg&$xN]=\u0002!\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0006OJ|W\u000f\u001d\u0006\u0004\u00037\t\u0015aC2p_J$\u0017N\\1u_JLA!a\b\u0002\u0016\t\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\t)#a\n\u000e\u0003}J1!!\u000b@\u0005I\u0011\u0016M\u001a;SKBd\u0017nY1NC:\fw-\u001a:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB!\u0011qFA\u001b\u001b\t\t\tD\u0003\u0003\u00024\u0005e\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:LA!a\u000e\u00022\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB)\u0011*!\u0010\u0002B%\u0019\u0011q\b&\u0003\r=\u0003H/[8o!\u0011\t\u0019%!\u0015\u000f\t\u0005\u0015\u0013Q\n\t\u0004\u0003\u000fRUBAA%\u0015\r\tYeQ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=#*\u0001\u0004Qe\u0016$WMZ\u0005\u00043\u0006M#bAA(\u0015\u0006\u00112\r\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s!\r)\u0015\u0011L\u0005\u0004\u00037j$AG\"mS\u0016tG/U;pi\u0006lU\r^1eCR\fW*\u00198bO\u0016\u0014H\u0003FA0\u0003C\n\u0019'!\u001a\u0002h\u0005%\u00141NA7\u0003_\n\t\b\u0005\u0002F\u000f!)!/\u0005a\u0001g\")a/\u0005a\u0001o\"1q0\u0005a\u0001\u0003\u0003Aq!a\u0002\u0012\u0001\u0004\tI\u0001C\u0004\u0002\u0010E\u0001\r!!\u0005\t\u000f\u0005\u0005\u0012\u00031\u0001\u0002$!9\u00111F\tA\u0002\u00055\u0002bBA\u001d#\u0001\u0007\u00111\b\u0005\b\u0003+\n\u0002\u0019AA,\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003o\u00022\u0001_A=\u0013\r\tY(\u001f\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n1\u0001\\8h+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI\t[\u0001\u0006g24GG[\u0005\u0005\u0003\u001b\u000b9I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\fcCR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\rS5tiV\u0011\u0011Q\u0013\t\u0005\u0003/\u000b9+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\u0011\u0019wN]3\u000b\u0007=\fyJ\u0003\u0003\u0002\"\u0006\r\u0016AB=b[6,'O\u0003\u0002\u0002&\u0006\u00191m\\7\n\t\u0005%\u0016\u0011\u0014\u0002\n\u0011&\u001cHo\\4sC6\f\u0001DY1uG\"\u0004&o\\2fgNLgn\u001a+j[\u0016D\u0015n\u001d;!\u0003UiW\r^1eCR\f')\u0019;dQNK'0\u001a%jgR\fa#\\3uC\u0012\fG/\u0019\"bi\u000eD7+\u001b>f\u0011&\u001cH\u000fI\u0001\u0017?\"Lw\r[3ti6+G/\u00193bi\u0006|eMZ:fiV\u0011\u0011Q\u0017\t\u0004\u0013\u0006]\u0016bAA]\u0015\n!Aj\u001c8h\u0003iy\u0006.[4iKN$X*\u001a;bI\u0006$\u0018m\u00144gg\u0016$x\fJ3r)\u0011\ty,!2\u0011\u0007%\u000b\t-C\u0002\u0002D*\u0013A!\u00168ji\"I\u0011qY\u000e\u0002\u0002\u0003\u0007\u0011QW\u0001\u0004q\u0012\n\u0014aF0iS\u001eDWm\u001d;NKR\fG-\u0019;b\u001f\u001a47/\u001a;!Q\ra\u0012Q\u001a\t\u0004\u0013\u0006=\u0017bAAi\u0015\nAao\u001c7bi&dW-\u0001\u0006fm\u0016tG/U;fk\u0016,\"!a6\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037T1!!8f\u0003\u0015\tX/Z;f\u0013\u0011\t\t/a7\u0003\u001f-\u000bgm[1Fm\u0016tG/U;fk\u0016\f1\"\u001a<f]R\fV/Z;fA\u0005)\u0002.[4iKN$X*\u001a;bI\u0006$\u0018m\u00144gg\u0016$HCAA[\u00035A\u0017M\u001c3mK\u000e{W.\\5ugR1\u0011qXAw\u0003cDq!a<!\u0001\u0004\t),\u0001\u0006mCN$xJ\u001a4tKRDq!a=!\u0001\u0004\t)0A\u0004sK\u000e|'\u000fZ:\u0011\r\u0005]\u0018Q B\u0001\u001b\t\tIPC\u0002\u0002|Z\u000bA!\u001e;jY&!\u0011q`A}\u0005\u0011a\u0015n\u001d;\u0011\t\t\r!\u0011B\u0007\u0003\u0005\u000bQ1Aa\u0002|\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\u0006\u0005\u000b\u0011!\"\u00119j\u001b\u0016\u001c8/Y4f\u0003-)\u00070Z2D_6l\u0017\u000e^:\u0015\r\u0005}&\u0011\u0003B\n\u0011\u001d\ty/\ta\u0001\u0003kCq!a=\"\u0001\u0004\t)P\u0001\nIC:$G.Z\"p[6LGo]#wK:$8c\u0001\u0012\u0003\u001aA!!1\u0004B\u0011\u001d\u0011\tIN!\b\n\t\t}\u00111\\\u0001\u000b\u000bZ,g\u000e^)vKV,\u0017\u0002\u0002B\u0012\u0005K\u00111CR1jYV\u0014X\rT8hO&tw-\u0012<f]RTAAa\b\u0002\\R1!\u0011\u0006B\u0017\u0005_\u00012Aa\u000b#\u001b\u00059\u0001bBAxK\u0001\u0007\u0011Q\u0017\u0005\b\u0003g,\u0003\u0019AA{\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u007f\u000bQ\u0002[1oI2,W*Z:tC\u001e,G\u0003CA`\u0005s\u0011\u0019Ea\u0012\t\u000f\tmr\u00051\u0001\u0003>\u0005a\u0011.\\1hK\n+\u0018\u000e\u001c3feB\u0019QIa\u0010\n\u0007\t\u0005SH\u0001\u000bNKR\fG-\u0019;b\u00136\fw-\u001a\"vS2$WM\u001d\u0005\b\u0005\u000b:\u0003\u0019\u0001B\u0001\u0003\u0019\u0011XmY8sI\"9\u0011q^\u0014A\u0002\u0005U\u0016A\u00075b]\u0012dWMU3hSN$XM\u001d\"s_.,'OU3d_J$GCBA`\u0005\u001b\u0012y\u0005C\u0004\u0003<!\u0002\rA!\u0010\t\u000f\t\u0015\u0003\u00061\u0001\u0003RA!!1\u000bB,\u001b\t\u0011)F\u0003\u0002?w&!!\u0011\fB+\u0005Q\u0011VmZ5ti\u0016\u0014(I]8lKJ\u0014VmY8sI\u0006a\u0002.\u00198eY\u0016,fN]3hSN$XM\u001d\"s_.,'OU3d_J$GCBA`\u0005?\u0012\t\u0007C\u0004\u0003<%\u0002\rA!\u0010\t\u000f\t\u0015\u0013\u00061\u0001\u0003dA!!1\u000bB3\u0013\u0011\u00119G!\u0016\u0003-Us'/Z4jgR,'O\u0011:pW\u0016\u0014(+Z2pe\u0012\f\u0011\u0003[1oI2,Gk\u001c9jGJ+7m\u001c:e)\u0019\tyL!\u001c\u0003p!9!1\b\u0016A\u0002\tu\u0002b\u0002B#U\u0001\u0007!\u0011\u000f\t\u0005\u0005'\u0012\u0019(\u0003\u0003\u0003v\tU#a\u0003+pa&\u001c'+Z2pe\u0012\fQ\u0003[1oI2,\u0007+\u0019:uSRLwN\u001c*fG>\u0014H\r\u0006\u0004\u0002@\nm$Q\u0010\u0005\b\u0005wY\u0003\u0019\u0001B\u001f\u0011\u001d\u0011)e\u000ba\u0001\u0005\u007f\u0002BAa\u0015\u0003\u0002&!!1\u0011B+\u0005=\u0001\u0016M\u001d;ji&|gNU3d_J$\u0017A\u00055b]\u0012dWmQ8oM&<'+Z2pe\u0012$B!a0\u0003\n\"9!Q\t\u0017A\u0002\t-\u0005\u0003\u0002B*\u0005\u001bKAAa$\u0003V\ta1i\u001c8gS\u001e\u0014VmY8sI\u0006Y\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn\u00115b]\u001e,'+Z2pe\u0012$b!a0\u0003\u0016\n]\u0005b\u0002B\u001e[\u0001\u0007!Q\b\u0005\b\u0005\u000bj\u0003\u0019\u0001BM!\u0011\u0011\u0019Fa'\n\t\tu%Q\u000b\u0002\u0016!\u0006\u0014H/\u001b;j_:\u001c\u0005.\u00198hKJ+7m\u001c:e\u0003]A\u0017M\u001c3mK\u001a+gnY3Ce>\\WM\u001d*fG>\u0014H\r\u0006\u0004\u0002@\n\r&Q\u0015\u0005\b\u0005wq\u0003\u0019\u0001B\u001f\u0011\u001d\u0011)E\fa\u0001\u0005O\u0003BAa\u0015\u0003*&!!1\u0016B+\u0005E1UM\\2f\u0005J|7.\u001a:SK\u000e|'\u000fZ\u0001\u001aQ\u0006tG\r\\3V]\u001a,gnY3Ce>\\WM\u001d*fG>\u0014H\r\u0006\u0004\u0002@\nE&1\u0017\u0005\b\u0005wy\u0003\u0019\u0001B\u001f\u0011\u001d\u0011)e\fa\u0001\u0005k\u0003BAa\u0015\u00038&!!\u0011\u0018B+\u0005M)fNZ3oG\u0016\u0014%o\\6feJ+7m\u001c:e\u0003]A\u0017M\u001c3mKJ+Wn\u001c<f)>\u0004\u0018n\u0019*fG>\u0014H\r\u0006\u0004\u0002@\n}&\u0011\u0019\u0005\b\u0005w\u0001\u0004\u0019\u0001B\u001f\u0011\u001d\u0011)\u0005\ra\u0001\u0005\u0007\u0004BAa\u0015\u0003F&!!q\u0019B+\u0005E\u0011V-\\8wKR{\u0007/[2SK\u000e|'\u000fZ\u0001\u0012Q\u0006tG\r\\3Rk>$\u0018MU3d_J$GCBA`\u0005\u001b\u0014y\rC\u0004\u0003<E\u0002\rA!\u0010\t\u000f\t\u0015\u0013\u00071\u0001\u0003RB!!1\u000bBj\u0013\u0011\u0011)N!\u0016\u0003\u0017E+x\u000e^1SK\u000e|'\u000f\u001a\u0002\u0015\u0011\u0006tG\r\\3OK^dU-\u00193fe\u00163XM\u001c;\u0014\u0007I\u0012I\"\u0001\u0004mK\u0006$WM\u001d\t\u0004E\n}\u0017b\u0001BqG\niQ*\u001a;b\u0019><G*Z1eKJ$BA!:\u0003hB\u0019!1\u0006\u001a\t\u000f\tmG\u00071\u0001\u0003^\u0006y\u0001.\u00198eY\u0016tUm\u001e'fC\u0012,'\u000f\u0006\u0003\u0002@\n5\bb\u0002Bnm\u0001\u0007!Q\u001c\u0002\u000e'\",H\u000fZ8x]\u00163XM\u001c;\u0014\u0007]\u0012I\u0002\u0006\u0002\u0003vB\u0019!1F\u001c\u0002\u001b\t,w-\u001b8TQV$Hm\\<o\u0003\u0015\u0019Gn\\:f\u0001")
public class BrokerMetadataListener
implements MetaLogListener,
KafkaMetricsGroup {
    public final int kafka$server$metadata$BrokerMetadataListener$$brokerId;
    public final Time kafka$server$metadata$BrokerMetadataListener$$time;
    public final RaftMetadataCache kafka$server$metadata$BrokerMetadataListener$$metadataCache;
    private final CachedConfigRepository configRepository;
    public final GroupCoordinator kafka$server$metadata$BrokerMetadataListener$$groupCoordinator;
    public final RaftReplicaManager kafka$server$metadata$BrokerMetadataListener$$replicaManager;
    public final TransactionCoordinator kafka$server$metadata$BrokerMetadataListener$$txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaManager;
    private final LogContext logContext;
    private final Logger kafka$server$metadata$BrokerMetadataListener$$log;
    private final Histogram kafka$server$metadata$BrokerMetadataListener$$batchProcessingTimeHist;
    private final Histogram kafka$server$metadata$BrokerMetadataListener$$metadataBatchSizeHist;
    private volatile long kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset;
    private final KafkaEventQueue eventQueue;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String MetadataBatchSizes() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchSizes();
    }

    public static String MetadataBatchProcessingTimeUs() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void handleRenounce(long x$1) {
        super.handleRenounce(x$1);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Logger kafka$server$metadata$BrokerMetadataListener$$log() {
        return this.kafka$server$metadata$BrokerMetadataListener$$log;
    }

    public Histogram kafka$server$metadata$BrokerMetadataListener$$batchProcessingTimeHist() {
        return this.kafka$server$metadata$BrokerMetadataListener$$batchProcessingTimeHist;
    }

    public Histogram kafka$server$metadata$BrokerMetadataListener$$metadataBatchSizeHist() {
        return this.kafka$server$metadata$BrokerMetadataListener$$metadataBatchSizeHist;
    }

    private long kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public long highestMetadataOffset() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset();
    }

    public void handleCommits(long lastOffset, List<ApiMessage> records) {
        this.eventQueue().append((EventQueue.Event)new HandleCommitsEvent(this, lastOffset, records));
    }

    public void execCommits(long lastOffset, List<ApiMessage> records) {
        new HandleCommitsEvent(this, lastOffset, records).run();
    }

    public void kafka$server$metadata$BrokerMetadataListener$$handleMessage(MetadataImageBuilder imageBuilder, ApiMessage record, long lastOffset) {
        MetadataRecordType metadataRecordType;
        try {
            metadataRecordType = MetadataRecordType.fromId((short)record.apiKey());
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder(57).append("Unknown metadata record type ").append(record.apiKey()).append(" in batch ending at offset ").append(lastOffset).append(".").toString());
        }
        MetadataRecordType recordType = metadataRecordType;
        if (record instanceof RegisterBrokerRecord) {
            RegisterBrokerRecord registerBrokerRecord = (RegisterBrokerRecord)record;
            this.handleRegisterBrokerRecord(imageBuilder, registerBrokerRecord);
            return;
        }
        if (record instanceof UnregisterBrokerRecord) {
            UnregisterBrokerRecord unregisterBrokerRecord = (UnregisterBrokerRecord)record;
            this.handleUnregisterBrokerRecord(imageBuilder, unregisterBrokerRecord);
            return;
        }
        if (record instanceof FenceBrokerRecord) {
            FenceBrokerRecord fenceBrokerRecord = (FenceBrokerRecord)record;
            this.handleFenceBrokerRecord(imageBuilder, fenceBrokerRecord);
            return;
        }
        if (record instanceof UnfenceBrokerRecord) {
            UnfenceBrokerRecord unfenceBrokerRecord = (UnfenceBrokerRecord)record;
            this.handleUnfenceBrokerRecord(imageBuilder, unfenceBrokerRecord);
            return;
        }
        if (record instanceof TopicRecord) {
            TopicRecord topicRecord = (TopicRecord)record;
            this.handleTopicRecord(imageBuilder, topicRecord);
            return;
        }
        if (record instanceof PartitionRecord) {
            PartitionRecord partitionRecord = (PartitionRecord)record;
            this.handlePartitionRecord(imageBuilder, partitionRecord);
            return;
        }
        if (record instanceof PartitionChangeRecord) {
            PartitionChangeRecord partitionChangeRecord = (PartitionChangeRecord)record;
            this.handlePartitionChangeRecord(imageBuilder, partitionChangeRecord);
            return;
        }
        if (record instanceof RemoveTopicRecord) {
            RemoveTopicRecord removeTopicRecord = (RemoveTopicRecord)record;
            this.handleRemoveTopicRecord(imageBuilder, removeTopicRecord);
            return;
        }
        if (record instanceof ConfigRecord) {
            ConfigRecord configRecord = (ConfigRecord)record;
            this.handleConfigRecord(configRecord);
            return;
        }
        if (record instanceof QuotaRecord) {
            QuotaRecord quotaRecord = (QuotaRecord)record;
            this.handleQuotaRecord(imageBuilder, quotaRecord);
            return;
        }
        throw new RuntimeException(new StringBuilder(28).append("Unhandled record ").append(record).append(" with type ").append(recordType).toString());
    }

    public void handleRegisterBrokerRecord(MetadataImageBuilder imageBuilder, RegisterBrokerRecord record) {
        MetadataBroker broker = MetadataBroker$.MODULE$.apply(record);
        imageBuilder.brokersBuilder().add(broker);
    }

    public void handleUnregisterBrokerRecord(MetadataImageBuilder imageBuilder, UnregisterBrokerRecord record) {
        imageBuilder.brokersBuilder().remove(record.brokerId());
    }

    public void handleTopicRecord(MetadataImageBuilder imageBuilder, TopicRecord record) {
        imageBuilder.partitionsBuilder().addUuidMapping(record.name(), record.topicId());
    }

    public void handlePartitionRecord(MetadataImageBuilder imageBuilder, PartitionRecord record) {
        Option<String> option = imageBuilder.topicIdToName(record.topicId());
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException(new StringBuilder(31).append("Unable to locate topic with ID ").append(record.topicId()).toString());
        }
        if (option instanceof Some) {
            String name = (String)((Some)option).value();
            MetadataPartition partition = MetadataPartition$.MODULE$.apply(name, record);
            imageBuilder.partitionsBuilder().set(partition);
            return;
        }
        throw new MatchError(option);
    }

    public void handleConfigRecord(ConfigRecord record) {
        ConfigResource.Type t;
        ConfigResource.Type type = t = ConfigResource.Type.forId((byte)record.resourceType());
        ConfigResource.Type type2 = ConfigResource.Type.UNKNOWN;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new RuntimeException(new StringBuilder(42).append("Unable to understand config resource type ").append((Object)record.resourceType()).toString());
        }
        ConfigResource resource = new ConfigResource(t, record.resourceName());
        this.configRepository.setConfig(resource, record.name(), record.value());
    }

    public void handlePartitionChangeRecord(MetadataImageBuilder imageBuilder, PartitionChangeRecord record) {
        imageBuilder.partitionsBuilder().handleChange(record);
    }

    public void handleFenceBrokerRecord(MetadataImageBuilder imageBuilder, FenceBrokerRecord record) {
        imageBuilder.brokersBuilder().changeFencing(record.id(), true);
    }

    public void handleUnfenceBrokerRecord(MetadataImageBuilder imageBuilder, UnfenceBrokerRecord record) {
        imageBuilder.brokersBuilder().changeFencing(record.id(), false);
    }

    public void handleRemoveTopicRecord(MetadataImageBuilder imageBuilder, RemoveTopicRecord record) {
        Option<String> option = imageBuilder.topicIdToName(record.topicId());
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException(new StringBuilder(31).append("Unable to locate topic with ID ").append(record.topicId()).toString());
        }
        if (option instanceof Some) {
            String topicName = (String)((Some)option).value();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Processing deletion of topic ").append(topicName).append(" with id ").append(record.topicId()).toString());
            Iterable<MetadataPartition> removedPartitions = imageBuilder.partitionsBuilder().removeTopicById(record.topicId());
            this.kafka$server$metadata$BrokerMetadataListener$$groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)((TraversableOnce)removedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toTopicPartition(), Iterable$.MODULE$.canBuildFrom())).toSeq());
            this.configRepository.remove(new ConfigResource(ConfigResource.Type.TOPIC, topicName));
            return;
        }
        throw new MatchError(option);
    }

    public void handleQuotaRecord(MetadataImageBuilder imageBuilder, QuotaRecord record) {
        this.clientQuotaManager.handleQuotaRecord(record);
    }

    public void handleNewLeader(MetaLogLeader leader) {
        this.eventQueue().append((EventQueue.Event)new HandleNewLeaderEvent(this, leader));
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown", (EventQueue.Event)new ShutdownEvent());
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    public BrokerMetadataListener(int brokerId, Time time, RaftMetadataCache metadataCache, CachedConfigRepository configRepository, GroupCoordinator groupCoordinator, RaftReplicaManager replicaManager, TransactionCoordinator txnCoordinator, Option<String> threadNamePrefix, ClientQuotaMetadataManager clientQuotaManager) {
        this.kafka$server$metadata$BrokerMetadataListener$$brokerId = brokerId;
        this.kafka$server$metadata$BrokerMetadataListener$$time = time;
        this.kafka$server$metadata$BrokerMetadataListener$$metadataCache = metadataCache;
        this.configRepository = configRepository;
        this.kafka$server$metadata$BrokerMetadataListener$$groupCoordinator = groupCoordinator;
        this.kafka$server$metadata$BrokerMetadataListener$$replicaManager = replicaManager;
        this.kafka$server$metadata$BrokerMetadataListener$$txnCoordinator = txnCoordinator;
        this.clientQuotaManager = clientQuotaManager;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logContext = new LogContext(new StringBuilder(29).append("[BrokerMetadataListener id=").append(brokerId).append("] ").toString());
        this.kafka$server$metadata$BrokerMetadataListener$$log = this.logContext().logger(BrokerMetadataListener.class);
        this.logIdent_$eq(this.logContext().logPrefix());
        this.kafka$server$metadata$BrokerMetadataListener$$batchProcessingTimeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this.kafka$server$metadata$BrokerMetadataListener$$metadataBatchSizeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this.kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset = -1L;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), (String)threadNamePrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public class HandleCommitsEvent
    extends EventQueue.FailureLoggingEvent {
        private final long lastOffset;
        private final List<ApiMessage> records;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public void run() {
            if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Metadata batch ").append($this.lastOffset).append(": handling ").append($this.records.size()).append(" record(s).").toString());
            }
            MetadataImageBuilder imageBuilder = new MetadataImageBuilder(this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$brokerId, this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$log(), this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$metadataCache.currentImage());
            long startNs = this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$time.nanoseconds();
            IntRef index = IntRef.create((int)0);
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$metadataBatchSizeHist().update(this.records.size());
            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.records.iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                HandleCommitsEvent.$anonfun$run$2(this, index, imageBuilder, record);
                return BoxedUnit.UNIT;
            });
            if (imageBuilder.hasChanges()) {
                MetadataImage newImage = imageBuilder.build();
                if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isTraceEnabled()) {
                    this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Metadata batch ").append($this.lastOffset).append(": creating new metadata image ").append(newImage).toString());
                } else if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                    this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Metadata batch ").append($this.lastOffset).append(": creating new metadata image").toString());
                }
                this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$metadataCache.image(newImage);
            } else if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Metadata batch ").append($this.lastOffset).append(": no new metadata image required.").toString());
            }
            if (imageBuilder.hasPartitionChanges()) {
                if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                    this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Metadata batch ").append($this.lastOffset).append(": applying partition changes").toString());
                }
                this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$replicaManager.handleMetadataRecords(imageBuilder, this.lastOffset, (Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
                    RequestHandlerHelper$.MODULE$.onLeadershipChange(this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$groupCoordinator, this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$txnCoordinator, (Iterable<Partition>)x$1, (Iterable<Partition>)x$2);
                    return BoxedUnit.UNIT;
                });
            } else if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Metadata batch ").append($this.lastOffset).append(": no partition changes found.").toString());
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_highestMetadataOffset_$eq(this.lastOffset);
            long endNs = this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$time.nanoseconds();
            long deltaUs = TimeUnit.MICROSECONDS.convert(endNs - startNs, TimeUnit.NANOSECONDS);
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Metadata batch ").append($this.lastOffset).append(": advanced highest metadata offset in ").append(deltaUs).append(" ").append("microseconds.").toString());
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$batchProcessingTimeHist().update(deltaUs);
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(HandleCommitsEvent $this, IntRef index$1, MetadataImageBuilder imageBuilder$1, ApiMessage record) {
            try {
                if ($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isTraceEnabled()) {
                    $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Metadata batch %d: processing [%d/%d]: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.lastOffset), BoxesRunTime.boxToInteger((int)(index$1.elem + 1)), BoxesRunTime.boxToInteger((int)$this.records.size()), record.toString()})));
                }
                $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$handleMessage(imageBuilder$1, record, $this.lastOffset);
            }
            catch (Exception e) {
                $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Unable to handle record ").append(index$1.elem).append(" in batch ").append("ending at offset ").append($this.lastOffset).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
            ++index$1.elem;
        }

        public HandleCommitsEvent(BrokerMetadataListener $outer, long lastOffset, List<ApiMessage> records) {
            this.lastOffset = lastOffset;
            this.records = records;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class HandleNewLeaderEvent
    extends EventQueue.FailureLoggingEvent {
        private final MetaLogLeader leader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public void run() {
            MetadataImageBuilder imageBuilder = new MetadataImageBuilder(this.kafka$server$metadata$BrokerMetadataListener$HandleNewLeaderEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$brokerId, this.kafka$server$metadata$BrokerMetadataListener$HandleNewLeaderEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$log(), this.kafka$server$metadata$BrokerMetadataListener$HandleNewLeaderEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$metadataCache.currentImage());
            if (this.leader.nodeId() < 0) {
                imageBuilder.controllerId((Option<Object>)None$.MODULE$);
            } else {
                imageBuilder.controllerId((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.leader.nodeId())));
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleNewLeaderEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$metadataCache.image(imageBuilder.build());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleNewLeaderEvent$$$outer() {
            return this.$outer;
        }

        public HandleNewLeaderEvent(BrokerMetadataListener $outer, MetaLogLeader leader) {
            this.leader = leader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class ShutdownEvent
    extends EventQueue.FailureLoggingEvent {
        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer() {
            return BrokerMetadataListener.this;
        }

        public ShutdownEvent() {
            if (BrokerMetadataListener.this == null) {
                throw null;
            }
            super(BrokerMetadataListener.this.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }
}

